/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.desktop.statistics.api.StatisticsModelUI;
import org.gephi.project.api.Workspace;
import org.gephi.statistics.api.StatisticsController;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.openide.util.Lookup;

public class StatisticsModelUIImpl
implements StatisticsModelUI {
    private final Workspace workspace;
    private final List<StatisticsUI> invisibleList;
    private final Map<StatisticsUI, String> resultMap;
    private final List<Statistics> runningList;
    private final List<ChangeListener> listeners;

    public StatisticsModelUIImpl(Workspace workspace) {
        this.workspace = workspace;
        this.runningList = Collections.synchronizedList(new ArrayList());
        this.invisibleList = new ArrayList<StatisticsUI>();
        this.resultMap = new HashMap<StatisticsUI, String>();
        this.listeners = new ArrayList<ChangeListener>();
    }

    public void addResult(StatisticsUI ui) {
        if (this.resultMap.containsKey(ui) && ui.getValue() == null) {
            this.resultMap.remove(ui);
        } else {
            this.resultMap.put(ui, ui.getValue());
        }
        this.fireChangeEvent();
    }

    @Override
    public String getResult(StatisticsUI statisticsUI) {
        return this.resultMap.get(statisticsUI);
    }

    @Override
    public String getReport(Class<? extends Statistics> statistics) {
        StatisticsController controller = (StatisticsController)Lookup.getDefault().lookup(StatisticsController.class);
        return controller.getModel(this.workspace).getReport(statistics);
    }

    @Override
    public boolean isStatisticsUIVisible(StatisticsUI statisticsUI) {
        return !this.invisibleList.contains(statisticsUI);
    }

    @Override
    public boolean isRunning(StatisticsUI statisticsUI) {
        for (Statistics s : this.runningList.toArray(new Statistics[0])) {
            if (!statisticsUI.getStatisticsClass().equals(s.getClass())) continue;
            return true;
        }
        return false;
    }

    public void setRunning(Statistics statistics, boolean running) {
        if (!running) {
            if (this.runningList.remove(statistics)) {
                this.fireChangeEvent();
            }
        } else if (!this.runningList.contains(statistics)) {
            this.runningList.add(statistics);
            this.fireChangeEvent();
        }
    }

    @Override
    public Statistics getRunning(StatisticsUI statisticsUI) {
        for (Statistics s : this.runningList.toArray(new Statistics[0])) {
            if (!statisticsUI.getStatisticsClass().equals(s)) continue;
            return s;
        }
        return null;
    }

    public void setVisible(StatisticsUI statisticsUI, boolean visible) {
        if (visible) {
            if (this.invisibleList.remove(statisticsUI)) {
                this.fireChangeEvent();
            }
        } else if (!this.invisibleList.contains(statisticsUI)) {
            this.invisibleList.add(statisticsUI);
            this.fireChangeEvent();
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.add(changeListener);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(evt);
        }
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("results");
        for (Map.Entry<StatisticsUI, String> entry : this.resultMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            writer.writeStartElement("result");
            writer.writeAttribute("class", entry.getKey().getClass().getName());
            writer.writeAttribute("value", entry.getValue());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void readXML(XMLStreamReader reader) throws XMLStreamException {
        Collection uis = Lookup.getDefault().lookupAll(StatisticsUI.class);
        boolean end = false;
        block4: while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!"result".equalsIgnoreCase(name)) break;
                    String classStr = reader.getAttributeValue(null, "class");
                    StatisticsUI resultUI = null;
                    for (StatisticsUI ui : uis) {
                        if (!ui.getClass().getName().equals(classStr)) continue;
                        resultUI = ui;
                    }
                    if (resultUI == null) continue block4;
                    String value = reader.getAttributeValue(null, "value");
                    this.resultMap.put(resultUI, value);
                    break;
                }
                case 2: {
                    if (!"statisticsmodelui".equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }
}

