/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.ctreber.acearth.projection;

import ext.plantuml.com.ctreber.acearth.util.Coordinate;
import ext.plantuml.com.ctreber.acearth.util.Point2D;
import ext.plantuml.com.ctreber.acearth.util.Point3D;
import ext.plantuml.com.ctreber.acearth.util.Toolkit;

public abstract class Projection {
    int fImageHeight;
    int fImageWidth;
    private double fXOffset;
    private double fYOffset;
    private int fShiftX;
    private int fShiftY;
    double fScale;
    private Coordinate fViewPos;
    private double fViewRotation;
    double fViewMagnification;
    private double fCosLat;
    private double fSinLat;
    private double fCosLon;
    private double fSinLon;
    private double fCosRot;
    private double fSinRot;

    public void initTransformTable() {
        this.fCosLat = Math.cos(Toolkit.degsToRads(this.fViewPos.getLat()));
        this.fSinLat = Math.sin(Toolkit.degsToRads(this.fViewPos.getLat()));
        this.fCosLon = Math.cos(Toolkit.degsToRads(this.fViewPos.getLong()));
        this.fSinLon = Math.sin(Toolkit.degsToRads(this.fViewPos.getLong()));
        this.fCosRot = Math.cos(Toolkit.degsToRads(this.fViewRotation));
        this.fSinRot = Math.sin(Toolkit.degsToRads(this.fViewRotation));
        this.fXOffset = (double)this.fImageWidth / 2.0 + (double)this.fShiftX;
        this.fYOffset = (double)this.fImageHeight / 2.0 + (double)this.fShiftY;
        this.setScale();
    }

    protected abstract void setScale();

    public abstract double projectY(double var1);

    public abstract double inverseProjectY(double var1);

    protected abstract double projectX(double var1, double var3);

    public abstract double inverseProjectX(double var1);

    public abstract boolean isVisible(Point3D var1);

    public boolean isWithinImage(Point2D pPoint) {
        return pPoint.getX() >= 0.0 && pPoint.getX() < (double)this.fImageWidth && pPoint.getY() >= 0.0 && pPoint.getY() < (double)this.fImageHeight;
    }

    public abstract Coordinate getLocation(int var1, int var2);

    public Point2D project2D(Point3D pPoint) {
        return new Point2D(this.projectX(pPoint.getX(), pPoint.getZ()), this.projectY(pPoint.getY()));
    }

    public Point2D finalize(Point2D pPoint) {
        return new Point2D(this.finalizeX(pPoint.getX()), this.finalizeY(pPoint.getY()));
    }

    public double finalizeX(double pX) {
        return this.fXOffset + this.fScale * pX;
    }

    public double finalizeY(double pY) {
        return this.fYOffset - this.fScale * pY;
    }

    public double inverseFinalizeX(double x) {
        return (x - this.fXOffset) / this.fScale;
    }

    public double inverseFinalizeY(double y) {
        return (this.fYOffset - y) / this.fScale;
    }

    public Point3D rotate(Point3D pPoint) {
        double lX = pPoint.getX();
        double lY = pPoint.getY();
        double lZ = pPoint.getZ();
        double _c_ = this.fCosLon;
        double _s_ = this.fSinLon;
        double _t_ = _c_ * lX - _s_ * lZ;
        lZ = _s_ * lX + _c_ * lZ;
        lX = _t_;
        _c_ = this.fCosLat;
        _s_ = this.fSinLat;
        _t_ = _c_ * lY - _s_ * lZ;
        lZ = _s_ * lY + _c_ * lZ;
        lY = _t_;
        _c_ = this.fCosRot;
        _s_ = this.fSinRot;
        _t_ = _c_ * lX - _s_ * lY;
        lY = _s_ * lX + _c_ * lY;
        lX = _t_;
        return new Point3D(lX, lY, lZ);
    }

    public Point3D rotateReverse(Point3D pPoint) {
        double fCosLat = Math.cos(Toolkit.degsToRads(-this.fViewPos.getLat()));
        double fSinLat = Math.sin(Toolkit.degsToRads(-this.fViewPos.getLat()));
        double fCosLon = Math.cos(Toolkit.degsToRads(-this.fViewPos.getLong()));
        double fSinLon = Math.sin(Toolkit.degsToRads(-this.fViewPos.getLong()));
        double fCosRot = Math.cos(Toolkit.degsToRads(-this.fViewRotation));
        double fSinRot = Math.sin(Toolkit.degsToRads(-this.fViewRotation));
        double lX = pPoint.getX();
        double lY = pPoint.getY();
        double lZ = pPoint.getZ();
        double lCosFac = fCosRot;
        double lSinFac = fSinRot;
        double lTmp = lCosFac * lX - lSinFac * lY;
        lY = lSinFac * lX + lCosFac * lY;
        lX = lTmp;
        lCosFac = fCosLat;
        lSinFac = fSinLat;
        lTmp = lCosFac * lY - lSinFac * lZ;
        lZ = lSinFac * lY + lCosFac * lZ;
        lY = lTmp;
        lCosFac = fCosLon;
        lSinFac = fSinLon;
        lTmp = lCosFac * lX - lSinFac * lZ;
        lZ = lSinFac * lX + lCosFac * lZ;
        lX = lTmp;
        return new Point3D(lX, lY, lZ);
    }

    public double getScale() {
        return this.fScale;
    }

    public Coordinate getViewPos() {
        return this.fViewPos;
    }

    public void setViewMagnification(double pViewMagnification) {
        this.fViewMagnification = pViewMagnification;
        this.setScale();
    }

    public void setViewPos(Coordinate pViewPos) {
        this.fViewPos = pViewPos;
    }

    public void setShiftX(int pX) {
        this.fShiftX = pX;
    }

    public void setShiftY(int pY) {
        this.fShiftY = pY;
    }

    public void setViewRotation(double pViewRotation) {
        this.fViewRotation = pViewRotation;
    }

    public void setImageWidth(int pImageWidth) {
        this.fImageWidth = pImageWidth;
    }

    public void setImageHeight(int pImageHeight) {
        this.fImageHeight = pImageHeight;
    }
}

