/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.PlayerAnalog;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandAnalog
extends SingleLineCommand2<TimingDiagram> {
    public CommandAnalog() {
        super(CommandAnalog.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandAnalog.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("COMPACT", "(compact)"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("analog"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("FULL", "[%g]([^%g]+)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("between"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("START", "(-?[0-9]*\\.?[0-9]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("and"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("END", "(-?[0-9]*\\.?[0-9]+)"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([\\p{L}0-9_.@]+)"), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        String compact = arg.get("COMPACT", 0);
        String code = arg.get("CODE", 0);
        String full = arg.get("FULL", 0);
        PlayerAnalog player = diagram.createAnalog(code, full, compact != null);
        String start = arg.get("START", 0);
        String end = arg.get("END", 0);
        if (start != null && end != null) {
            player.setStartEnd(Double.parseDouble(start), Double.parseDouble(end));
        }
        return CommandExecutionResult.ok();
    }
}

