/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class ExtendedAccessLogValve
extends AccessLogValve {
    private static final Log log = LogFactory.getLog(ExtendedAccessLogValve.class);
    protected static final String extendedAccessLogInfo = "org.apache.catalina.valves.ExtendedAccessLogValve/2.1";

    @Override
    public String getInfo() {
        return extendedAccessLogInfo;
    }

    static String wrap(Object object) {
        String string;
        if (object == null || "-".equals(object)) {
            return "-";
        }
        try {
            string = object.toString();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            return "-";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('\"');
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(34, n);
            if (n2 == -1) {
                stringBuilder.append(string.substring(n));
                n = string.length();
                continue;
            }
            stringBuilder.append(string.substring(n, n2 + 1));
            stringBuilder.append('\"');
            n = n2 + 1;
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    @Override
    protected synchronized void open() {
        super.open();
        if (this.currentLogFile.length() == 0L) {
            this.writer.println("#Fields: " + this.pattern);
            this.writer.println("#Version: 2.0");
            this.writer.println("#Software: " + ServerInfo.getServerInfo());
        }
    }

    @Override
    protected AccessLogValve.AccessLogElement[] createLogElements() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("decodePattern, pattern =" + this.pattern));
        }
        ArrayList<AccessLogValve.AccessLogElement> arrayList = new ArrayList<AccessLogValve.AccessLogElement>();
        PatternTokenizer patternTokenizer = new PatternTokenizer(this.pattern);
        try {
            patternTokenizer.getWhiteSpaces();
            if (patternTokenizer.isEnded()) {
                log.info((Object)"pattern was just empty or whitespace");
                return null;
            }
            String string = patternTokenizer.getToken();
            while (string != null) {
                AccessLogValve.AccessLogElement accessLogElement;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("token = " + string));
                }
                if ((accessLogElement = this.getLogElement(string, patternTokenizer)) == null) break;
                arrayList.add(accessLogElement);
                String string2 = patternTokenizer.getWhiteSpaces();
                if (string2.length() > 0) {
                    arrayList.add(new AccessLogValve.StringElement(string2));
                }
                if (patternTokenizer.isEnded()) break;
                string = patternTokenizer.getToken();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("finished decoding with element size of: " + arrayList.size()));
            }
            return arrayList.toArray(new AccessLogValve.AccessLogElement[0]);
        }
        catch (IOException iOException) {
            log.error((Object)"parse error", (Throwable)iOException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AccessLogValve.AccessLogElement getLogElement(String string, PatternTokenizer patternTokenizer) throws IOException {
        if ("date".equals(string)) {
            return new DateElement();
        }
        if ("time".equals(string)) {
            if (!patternTokenizer.hasSubToken()) return new TimeElement();
            String string2 = patternTokenizer.getToken();
            if ("taken".equals(string2)) {
                return new AccessLogValve.ElapsedTimeElement(false);
            }
        } else {
            if ("bytes".equals(string)) {
                return new AccessLogValve.ByteSentElement(true);
            }
            if ("cached".equals(string)) {
                return new AccessLogValve.StringElement("-");
            }
            if ("c".equals(string)) {
                String string3 = patternTokenizer.getToken();
                if ("ip".equals(string3)) {
                    return new AccessLogValve.RemoteAddrElement();
                }
                if ("dns".equals(string3)) {
                    return new AccessLogValve.HostElement();
                }
            } else if ("s".equals(string)) {
                String string4 = patternTokenizer.getToken();
                if ("ip".equals(string4)) {
                    return new AccessLogValve.LocalAddrElement();
                }
                if ("dns".equals(string4)) {
                    return new AccessLogValve.AccessLogElement(){

                        @Override
                        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                            String string;
                            try {
                                string = InetAddress.getLocalHost().getHostName();
                            }
                            catch (Throwable throwable) {
                                ExceptionUtils.handleThrowable((Throwable)throwable);
                                string = "localhost";
                            }
                            stringBuilder.append(string);
                        }
                    };
                }
            } else {
                if ("cs".equals(string)) {
                    return this.getClientToServerElement(patternTokenizer);
                }
                if ("sc".equals(string)) {
                    return this.getServerToClientElement(patternTokenizer);
                }
                if ("sr".equals(string) || "rs".equals(string)) {
                    return this.getProxyElement(patternTokenizer);
                }
                if ("x".equals(string)) {
                    return this.getXParameterElement(patternTokenizer);
                }
            }
        }
        log.error((Object)("unable to decode with rest of chars starting: " + string));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AccessLogValve.AccessLogElement getClientToServerElement(PatternTokenizer patternTokenizer) throws IOException {
        if (patternTokenizer.hasSubToken()) {
            String string = patternTokenizer.getToken();
            if ("method".equals(string)) {
                return new AccessLogValve.MethodElement();
            }
            if ("uri".equals(string)) {
                if (!patternTokenizer.hasSubToken()) return new AccessLogValve.AccessLogElement(){

                    @Override
                    public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                        String string = request.getQueryString();
                        if (string == null) {
                            stringBuilder.append(request.getRequestURI());
                        } else {
                            stringBuilder.append(request.getRequestURI());
                            stringBuilder.append('?');
                            stringBuilder.append(request.getQueryString());
                        }
                    }
                };
                string = patternTokenizer.getToken();
                if ("stem".equals(string)) {
                    return new AccessLogValve.RequestURIElement();
                }
                if ("query".equals(string)) {
                    return new AccessLogValve.AccessLogElement(){

                        @Override
                        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                            String string = request.getQueryString();
                            if (string != null) {
                                stringBuilder.append(string);
                            } else {
                                stringBuilder.append('-');
                            }
                        }
                    };
                }
            }
        } else if (patternTokenizer.hasParameter()) {
            String string = patternTokenizer.getParameter();
            if (string != null) return new RequestHeaderElement(string);
            log.error((Object)"No closing ) found for in decode");
            return null;
        }
        log.error((Object)("The next characters couldn't be decoded: " + patternTokenizer.getRemains()));
        return null;
    }

    protected AccessLogValve.AccessLogElement getServerToClientElement(PatternTokenizer patternTokenizer) throws IOException {
        if (patternTokenizer.hasSubToken()) {
            String string = patternTokenizer.getToken();
            if ("status".equals(string)) {
                return new AccessLogValve.HttpStatusCodeElement();
            }
            if ("comment".equals(string)) {
                return new AccessLogValve.StringElement("?");
            }
        } else if (patternTokenizer.hasParameter()) {
            String string = patternTokenizer.getParameter();
            if (string == null) {
                log.error((Object)"No closing ) found for in decode");
                return null;
            }
            return new ResponseHeaderElement(string);
        }
        log.error((Object)("The next characters couldn't be decoded: " + patternTokenizer.getRemains()));
        return null;
    }

    protected AccessLogValve.AccessLogElement getProxyElement(PatternTokenizer patternTokenizer) throws IOException {
        String string = null;
        if (patternTokenizer.hasSubToken()) {
            patternTokenizer.getToken();
            return new AccessLogValve.StringElement("-");
        }
        if (patternTokenizer.hasParameter()) {
            patternTokenizer.getParameter();
            return new AccessLogValve.StringElement("-");
        }
        log.error((Object)("The next characters couldn't be decoded: " + string));
        return null;
    }

    protected AccessLogValve.AccessLogElement getXParameterElement(PatternTokenizer patternTokenizer) throws IOException {
        if (!patternTokenizer.hasSubToken()) {
            log.error((Object)"x param in wrong format. Needs to be 'x-#(...)' read the docs!");
            return null;
        }
        String string = patternTokenizer.getToken();
        if ("threadname".equals(string)) {
            return new AccessLogValve.ThreadNameElement();
        }
        if (!patternTokenizer.hasParameter()) {
            log.error((Object)"x param in wrong format. Needs to be 'x-#(...)' read the docs!");
            return null;
        }
        String string2 = patternTokenizer.getParameter();
        if (string2 == null) {
            log.error((Object)"No closing ) found for in decode");
            return null;
        }
        if ("A".equals(string)) {
            return new ServletContextElement(string2);
        }
        if ("C".equals(string)) {
            return new CookieElement(string2);
        }
        if ("R".equals(string)) {
            return new RequestAttributeElement(string2);
        }
        if ("S".equals(string)) {
            return new SessionAttributeElement(string2);
        }
        if ("H".equals(string)) {
            return this.getServletRequestElement(string2);
        }
        if ("P".equals(string)) {
            return new RequestParameterElement(string2);
        }
        if ("O".equals(string)) {
            return new ResponseAllHeaderElement(string2);
        }
        log.error((Object)("x param for servlet request, couldn't decode value: " + string));
        return null;
    }

    protected AccessLogValve.AccessLogElement getServletRequestElement(String string) {
        if ("authType".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap(request.getAuthType()));
                }
            };
        }
        if ("remoteUser".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap(request.getRemoteUser()));
                }
            };
        }
        if ("requestedSessionId".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap(request.getRequestedSessionId()));
                }
            };
        }
        if ("requestedSessionIdFromCookie".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap("" + request.isRequestedSessionIdFromCookie()));
                }
            };
        }
        if ("requestedSessionIdValid".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap("" + request.isRequestedSessionIdValid()));
                }
            };
        }
        if ("contentLength".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap("" + request.getContentLength()));
                }
            };
        }
        if ("characterEncoding".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap(request.getCharacterEncoding()));
                }
            };
        }
        if ("locale".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap(request.getLocale()));
                }
            };
        }
        if ("protocol".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap(request.getProtocol()));
                }
            };
        }
        if ("scheme".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(request.getScheme());
                }
            };
        }
        if ("secure".equals(string)) {
            return new AccessLogValve.AccessLogElement(){

                @Override
                public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
                    stringBuilder.append(ExtendedAccessLogValve.wrap("" + request.isSecure()));
                }
            };
        }
        log.error((Object)("x param for servlet request, couldn't decode value: " + string));
        return null;
    }

    private static class ElementTimestampStruct {
        private final Date currentTimestamp = new Date(0L);
        private final SimpleDateFormat currentTimestampFormat;
        private String currentTimestampString;

        ElementTimestampStruct(String string) {
            this.currentTimestampFormat = new SimpleDateFormat(string, Locale.US);
            this.currentTimestampFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    protected static class PatternTokenizer {
        private StringReader sr = null;
        private StringBuilder buf = new StringBuilder();
        private boolean ended = false;
        private boolean subToken;
        private boolean parameter;

        public PatternTokenizer(String string) {
            this.sr = new StringReader(string);
        }

        public boolean hasSubToken() {
            return this.subToken;
        }

        public boolean hasParameter() {
            return this.parameter;
        }

        public String getToken() throws IOException {
            if (this.ended) {
                return null;
            }
            String string = null;
            this.subToken = false;
            this.parameter = false;
            int n = this.sr.read();
            while (n != -1) {
                switch (n) {
                    case 32: {
                        string = this.buf.toString();
                        this.buf = new StringBuilder();
                        this.buf.append((char)n);
                        return string;
                    }
                    case 45: {
                        string = this.buf.toString();
                        this.buf = new StringBuilder();
                        this.subToken = true;
                        return string;
                    }
                    case 40: {
                        string = this.buf.toString();
                        this.buf = new StringBuilder();
                        this.parameter = true;
                        return string;
                    }
                    case 41: {
                        string = this.buf.toString();
                        this.buf = new StringBuilder();
                        break;
                    }
                    default: {
                        this.buf.append((char)n);
                    }
                }
                n = this.sr.read();
            }
            this.ended = true;
            if (this.buf.length() != 0) {
                return this.buf.toString();
            }
            return null;
        }

        public String getParameter() throws IOException {
            if (!this.parameter) {
                return null;
            }
            this.parameter = false;
            int n = this.sr.read();
            while (n != -1) {
                if (n == 41) {
                    String string = this.buf.toString();
                    this.buf = new StringBuilder();
                    return string;
                }
                this.buf.append((char)n);
                n = this.sr.read();
            }
            return null;
        }

        public String getWhiteSpaces() throws IOException {
            if (this.isEnded()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.buf.length() > 0) {
                stringBuilder.append((CharSequence)this.buf);
                this.buf = new StringBuilder();
            }
            int n = this.sr.read();
            while (Character.isWhitespace((char)n)) {
                stringBuilder.append((char)n);
                n = this.sr.read();
            }
            if (n == -1) {
                this.ended = true;
            } else {
                this.buf.append((char)n);
            }
            return stringBuilder.toString();
        }

        public boolean isEnded() {
            return this.ended;
        }

        public String getRemains() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.sr.read();
            while (n != -1) {
                stringBuilder.append((char)n);
                n = this.sr.read();
            }
            return stringBuilder.toString();
        }
    }

    protected static class RequestParameterElement
    implements AccessLogValve.AccessLogElement {
        private final String parameter;

        public RequestParameterElement(String string) {
            this.parameter = string;
        }

        private String urlEncode(String string) {
            if (null == string || string.length() == 0) {
                return null;
            }
            try {
                return URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            stringBuilder.append(ExtendedAccessLogValve.wrap(this.urlEncode(request.getParameter(this.parameter))));
        }
    }

    protected static class SessionAttributeElement
    implements AccessLogValve.AccessLogElement {
        private final String attribute;

        public SessionAttributeElement(String string) {
            this.attribute = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            HttpSession httpSession = null;
            if (request != null && (httpSession = request.getSession(false)) != null) {
                stringBuilder.append(ExtendedAccessLogValve.wrap(httpSession.getAttribute(this.attribute)));
            }
        }
    }

    protected static class RequestAttributeElement
    implements AccessLogValve.AccessLogElement {
        private final String attribute;

        public RequestAttributeElement(String string) {
            this.attribute = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            stringBuilder.append(ExtendedAccessLogValve.wrap(request.getAttribute(this.attribute)));
        }
    }

    protected static class ResponseAllHeaderElement
    implements AccessLogValve.AccessLogElement {
        private final String header;

        public ResponseAllHeaderElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (null != response) {
                Iterator<String> iterator = response.getHeaders(this.header).iterator();
                if (iterator.hasNext()) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    boolean bl = true;
                    while (iterator.hasNext()) {
                        if (bl) {
                            bl = false;
                        } else {
                            stringBuilder2.append(",");
                        }
                        stringBuilder2.append(iterator.next());
                    }
                    stringBuilder.append(ExtendedAccessLogValve.wrap(stringBuilder2.toString()));
                }
                return;
            }
            stringBuilder.append("-");
        }
    }

    protected static class CookieElement
    implements AccessLogValve.AccessLogElement {
        private final String name;

        public CookieElement(String string) {
            this.name = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            Cookie[] cookieArray = request.getCookies();
            for (int i = 0; cookieArray != null && i < cookieArray.length; ++i) {
                if (!this.name.equals(cookieArray[i].getName())) continue;
                stringBuilder.append(ExtendedAccessLogValve.wrap(cookieArray[i].getValue()));
            }
        }
    }

    protected static class ServletContextElement
    implements AccessLogValve.AccessLogElement {
        private final String attribute;

        public ServletContextElement(String string) {
            this.attribute = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            stringBuilder.append(ExtendedAccessLogValve.wrap(request.getContext().getServletContext().getAttribute(this.attribute)));
        }
    }

    protected static class ResponseHeaderElement
    implements AccessLogValve.AccessLogElement {
        private final String header;

        public ResponseHeaderElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            stringBuilder.append(ExtendedAccessLogValve.wrap(response.getHeader(this.header)));
        }
    }

    protected static class RequestHeaderElement
    implements AccessLogValve.AccessLogElement {
        private final String header;

        public RequestHeaderElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            stringBuilder.append(ExtendedAccessLogValve.wrap(request.getHeader(this.header)));
        }
    }

    protected static class TimeElement
    implements AccessLogValve.AccessLogElement {
        private static final long INTERVAL = 1000L;
        private static final ThreadLocal<ElementTimestampStruct> currentTime = new ThreadLocal<ElementTimestampStruct>(){

            @Override
            protected ElementTimestampStruct initialValue() {
                return new ElementTimestampStruct("HH:mm:ss");
            }
        };

        protected TimeElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            ElementTimestampStruct elementTimestampStruct = currentTime.get();
            long l2 = elementTimestampStruct.currentTimestamp.getTime();
            if (date.getTime() > l2 + 1000L - 1L || date.getTime() < l2) {
                elementTimestampStruct.currentTimestamp.setTime(date.getTime() - date.getTime() % 1000L);
                elementTimestampStruct.currentTimestampString = elementTimestampStruct.currentTimestampFormat.format(elementTimestampStruct.currentTimestamp);
            }
            stringBuilder.append(elementTimestampStruct.currentTimestampString);
        }
    }

    protected static class DateElement
    implements AccessLogValve.AccessLogElement {
        private static final long INTERVAL = 86400000L;
        private static final ThreadLocal<ElementTimestampStruct> currentDate = new ThreadLocal<ElementTimestampStruct>(){

            @Override
            protected ElementTimestampStruct initialValue() {
                return new ElementTimestampStruct("yyyy-MM-dd");
            }
        };

        protected DateElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            ElementTimestampStruct elementTimestampStruct = currentDate.get();
            long l2 = elementTimestampStruct.currentTimestamp.getTime();
            if (date.getTime() > l2 + 86400000L - 1L || date.getTime() < l2) {
                elementTimestampStruct.currentTimestamp.setTime(date.getTime() - date.getTime() % 86400000L);
                elementTimestampStruct.currentTimestampString = elementTimestampStruct.currentTimestampFormat.format(elementTimestampStruct.currentTimestamp);
            }
            stringBuilder.append(elementTimestampStruct.currentTimestampString);
        }
    }
}

