/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpProcessor
extends AbstractAjpProcessor<Socket> {
    private static final Log log = LogFactory.getLog(AjpProcessor.class);
    protected InputStream input;
    protected OutputStream output;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpProcessor(int n, JIoEndpoint jIoEndpoint) {
        super(n, jIoEndpoint);
        this.response.setOutputBuffer(new AbstractAjpProcessor.SocketOutputBuffer());
    }

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socketWrapper) throws IOException {
        RequestInfo requestInfo = this.request.getRequestProcessor();
        requestInfo.setStage(1);
        this.socketWrapper = socketWrapper;
        this.input = socketWrapper.getSocket().getInputStream();
        this.output = socketWrapper.getSocket().getOutputStream();
        int n = -1;
        if (this.keepAliveTimeout > 0) {
            n = socketWrapper.getSocket().getSoTimeout();
        }
        boolean bl = false;
        while (!this.getErrorState().isError() && !this.endpoint.isPaused()) {
            try {
                byte by;
                if (this.keepAliveTimeout > 0) {
                    socketWrapper.getSocket().setSoTimeout(this.keepAliveTimeout);
                }
                if (!this.readMessage(this.requestHeaderMessage)) break;
                if (this.keepAliveTimeout > 0) {
                    socketWrapper.getSocket().setSoTimeout(n);
                }
                if ((by = this.requestHeaderMessage.getByte()) == 10) {
                    if (this.endpoint.isPaused()) {
                        this.recycle(true);
                        break;
                    }
                    bl = true;
                    try {
                        this.output.write(pongMessageArray);
                    }
                    catch (IOException iOException) {
                        this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                    }
                    continue;
                }
                if (by != 2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unexpected message: " + by));
                    }
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    break;
                }
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                break;
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                log.debug((Object)sm.getString("ajpprocessor.header.error"), throwable);
                this.response.setStatus(400);
                this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            if (!this.getErrorState().isError()) {
                requestInfo.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    log.debug((Object)sm.getString("ajpprocessor.request.prepare"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (!this.getErrorState().isError() && !bl && this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            bl = false;
            if (!this.getErrorState().isError()) {
                try {
                    requestInfo.setStage(3);
                    this.adapter.service(this.request, this.response);
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, interruptedIOException);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    log.error((Object)sm.getString("ajpprocessor.request.process"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (this.isAsync() && !this.getErrorState().isError()) break;
            if (!this.finished && this.getErrorState().isIoAllowed()) {
                try {
                    this.finish();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    this.setErrorState(ErrorState.CLOSE_NOW, throwable);
                }
            }
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            requestInfo.setStage(6);
            this.recycle(false);
        }
        requestInfo.setStage(7);
        if (this.isAsync() && !this.getErrorState().isError() && !this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.input = null;
        this.output = null;
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    public void recycle(boolean bl) {
        super.recycle(bl);
        if (bl) {
            this.input = null;
            this.output = null;
        }
    }

    @Override
    protected void actionInternal(ActionCode actionCode, Object object) {
        switch (actionCode) {
            case ASYNC_COMPLETE: {
                if (!this.asyncStateMachine.asyncComplete()) break;
                ((JIoEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (object == null) {
                    return;
                }
                long l = (Long)object;
                this.socketWrapper.setTimeout(l);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                ((JIoEndpoint)this.endpoint).processSocketAsync(this.socketWrapper, SocketStatus.OPEN_READ);
            }
        }
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    protected void output(byte[] byArray, int n, int n2) throws IOException {
        this.output.write(byArray, n, n2);
    }

    protected boolean read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.input.read(byArray, i + n, n2 - i);
            if (n3 > 0) {
                continue;
            }
            throw new IOException(sm.getString("ajpprocessor.failedread"));
        }
        return true;
    }

    @Override
    public boolean receive() throws IOException {
        this.first = false;
        this.bodyMessage.reset();
        if (!this.readMessage(this.bodyMessage)) {
            return false;
        }
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int n = this.bodyMessage.peekInt();
        if (n == 0) {
            return false;
        }
        this.bodyMessage.getBodyBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    protected boolean readMessage(AjpMessage ajpMessage) throws IOException {
        byte[] byArray = ajpMessage.getBuffer();
        int n = ajpMessage.getHeaderLength();
        this.read(byArray, 0, n);
        int n2 = ajpMessage.processHeader(true);
        if (n2 < 0) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 > byArray.length) {
            String string = sm.getString("ajpprocessor.header.tooLong", new Object[]{n2, byArray.length});
            this.getLog().error((Object)string);
            throw new IllegalArgumentException(string);
        }
        this.read(byArray, n, n2);
        return true;
    }
}

