/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.JavaTypeFilter;

public class ProfilingSettings {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.Bundle");
    static final String DEFAULT_PROFILING_SETTINGS_NAME = bundle.getString("ProfilingSettings_DefaultProfilingSettingsName");
    private static final String UNKNOWN_PROFILING_SETTINGS_NAME = bundle.getString("ProfilingSettings_UnknownProfilingSettingsName");
    public static final int PROFILE_MONITOR = 1;
    public static final int PROFILE_MEMORY_ALLOCATIONS = 2;
    public static final int PROFILE_MEMORY_LIVENESS = 4;
    public static final int PROFILE_CPU_ENTIRE = 8;
    public static final int PROFILE_CPU_PART = 16;
    public static final int PROFILE_CPU_STOPWATCH = 32;
    public static final int PROFILE_CPU_SAMPLING = 64;
    public static final int PROFILE_MEMORY_SAMPLING = 128;
    public static final int PROFILE_CPU_JDBC = 256;
    public static final boolean QUICK_FILTER_INCLUSIVE = true;
    public static final boolean QUICK_FILTER_EXCLUSIVE = false;
    public static final String LINES_PREFIX = "[lines]";
    public static final String PROP_OVERRIDE_GLOBAL_SETTINGS = "profiler.settings.override";
    public static final String PROP_WORKING_DIR = "profiler.settings.override.working.dir";
    public static final String PROP_JVM_ARGS = "profiler.settings.override.jvm.args";
    public static final String PROP_JAVA_PLATFORM = "profiler.settings.override.java.platform";
    public static final String PROP_IS_PRESET = "profiler.settigns.ispreset";
    public static final String PROP_SETTINGS_NAME = "profiler.settings.settings.name";
    public static final String PROP_PROFILING_TYPE = "profiler.settings.profiling.type";
    public static final String PROP_THREADS_MONITORING_ENABLED = "profiler.settings.threads.monitoring.enabled";
    public static final String PROP_LOCKCONTENTION_MONITORING_ENABLED = "profiler.settings.lockcontention.monitoring.enabled";
    public static final String PROP_THREADS_SAMPLING_ENABLED = "profiler.settings.threads.sampling.enabled";
    public static final String PROP_CPU_PROFILING_TYPE = "profiler.settings.cpu.profiling.type";
    public static final String PROP_EXCLUDE_WAIT_TIME = "profiler.settings.cpu.exclude.wait.time";
    public static final String PROP_INSTR_SCHEME = "profiler.settings.instr.scheme";
    public static final String PROP_THREAD_CPU_TIMER_ON = "profiler.settings.thread.cpu.timer.on";
    public static final String PROP_INSTRUMENT_GETTER_SETTER_METHODS = "profiler.settings.istrument.getter.setter.methods";
    public static final String PROP_INSTRUMENT_EMPTY_METHODS = "profiler.settings.instrument.empty.methods";
    public static final String PROP_INSTRUMENT_METHOD_INVOKE = "profiler.settings.instrument.method.invoke";
    public static final String PROP_INSTRUMENT_SPAWNED_THREADS = "profiler.settings.instrument.spawned.threads";
    public static final String PROP_N_PROFILED_THREADS_LIMIT = "profiler.settings.n.profiled.threads.limit";
    public static final String PROP_STACK_DEPTH_LIMIT = "profiler.settings.stack.depth.limit";
    public static final String PROP_SORT_RESULTS_BY_THREAD_CPU_TIME = "profiler.settings.sort.results.by.thread.cpu.time";
    public static final String PROP_SAMPLING_INTERVAL = "profiler.settings.sampling.interval";
    public static final String PROP_INSTRUMENTATION_ROOT_METHODS_SIZE = "profiler.settings.instrumentation.root.methods.size";
    public static final String PROP_INSTRUMENTATION_ROOT_METHODS_PREFIX = "profiler.settings.istrumentation.root.methods-";
    public static final String PROP_INSTRUMENTATION_MARKER_METHODS_SIZE = "profiler.settings.instrumentation.marker.methods.size";
    public static final String PROP_INSTRUMENTATION_MARKER_METHODS_PREFIX = "profiler.settings.istrumentation.marker.methods-";
    public static final String PROP_FRAGMENT_SELECTION = "profiler.settings.fragment.selection";
    public static final String PROP_CODE_REGION_CPU_RES_BUF_SIZE = "profiler.settings.code.region.cpu.res.buf.size";
    public static final String PROP_RUN_GC_ON_GET_RESULTS_IN_MEMORY_PROFILING = "profiler.settings.run.gc.on.get.results.in.memory.profiling";
    public static final String PROP_OBJ_ALLOC_STACK_SAMPLING_INTERVAL = "profiler.settings.obj.alloc.stack.sampling.interval";
    public static final String PROP_OBJ_ALLOC_STACK_SAMPLING_DEPTH = "profiler.settings.obj.alloc.stack.sampling.depth";
    public static final String PROP_INSTR_FILTER = "profiler.settings.instrumentation.filter.";
    public static final String PROP_PROFILE_UNDERLYING_FRAMEWORK = "profiler.settings.profile.underlying.framework";
    public static final String PROP_PROFILING_POINTS_ENABLED = "profiler.settings.profilingpoints.enabled";
    public static final String PROP_QUICK_FILTER = "profiler.settings.cpu.quick.filter";
    public static final String PROP_SAMPLING_FREQUENCY = "profiler.settings.cpu.sampling.frequency";
    private ClientUtils.SourceCodeSelection fragmentSelection = null;
    private List instrumentationMarkerMethods = new ArrayList();
    private List instrumentationRootMethods = new ArrayList();
    private GenericFilter instrumentationFilter = new GenericFilter();
    private String jvmArgs = "";
    private String platformName = null;
    private String settingsName = DEFAULT_PROFILING_SETTINGS_NAME;
    private String workingDir = "";
    private boolean excludeWaitTime = true;
    private boolean instrumentEmptyMethods = false;
    private boolean instrumentGetterSetterMethods = false;
    private boolean instrumentMethodInvoke = true;
    private boolean instrumentSpawnedThreads = false;
    private boolean isPreset = false;
    private boolean overrideGlobalSettings = false;
    private boolean profileUnderlyingFramework = false;
    private boolean runGCOnGetResultsInMemoryProfiling = true;
    private boolean sortResultsByThreadCPUTime = false;
    private boolean threadCPUTimerOn = true;
    private boolean threadsMonitoringEnabled = false;
    private boolean lockContentionMonitoringEnabled = false;
    private boolean threadsSamplingEnabled = true;
    private boolean useProfilingPoints = true;
    private int allocStackTraceLimit = 0;
    private int allocTrackEvery = 10;
    private int codeRegionCPUResBufSize = 1000;
    private int cpuProfilingType = 0;
    private int instrScheme = 1;
    private int nProfiledThreadsLimit = 32;
    private int stackDepthLimit = Integer.MAX_VALUE;
    private int profilingType = 1;
    private int samplingInterval = -10;
    private int samplingFrequency = 10;

    public ProfilingSettings() {
    }

    public ProfilingSettings(String string) {
        this.settingsName = string;
    }

    public static boolean isCPUSettings(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return false;
        }
        return ProfilingSettings.isCPUSettings(profilingSettings.getProfilingType());
    }

    public static boolean isCPUSettings(int n) {
        return n == 8 || n == 16 || n == 32 || n == 64;
    }

    public static boolean isJDBCSettings(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return false;
        }
        return ProfilingSettings.isJDBCSettings(profilingSettings.getProfilingType());
    }

    public static boolean isJDBCSettings(int n) {
        return n == 256;
    }

    public static boolean isMemorySettings(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return false;
        }
        return ProfilingSettings.isMemorySettings(profilingSettings.getProfilingType());
    }

    public static boolean isMemorySettings(int n) {
        return n == 2 || n == 4 || n == 128;
    }

    public static boolean isMonitorSettings(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return false;
        }
        return ProfilingSettings.isMonitorSettings(profilingSettings.getProfilingType());
    }

    public static boolean isMonitorSettings(int n) {
        return n == 1;
    }

    public void setAllocStackTraceLimit(int n) {
        this.allocStackTraceLimit = n;
    }

    public int getAllocStackTraceLimit() {
        return this.allocStackTraceLimit;
    }

    public void setAllocTrackEvery(int n) {
        this.allocTrackEvery = n;
    }

    public int getAllocTrackEvery() {
        return this.allocTrackEvery;
    }

    public void setCPUProfilingType(int n) {
        this.cpuProfilingType = n;
    }

    public int getCPUProfilingType() {
        return this.cpuProfilingType;
    }

    public void setCodeFragmentSelection(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.fragmentSelection = sourceCodeSelection;
    }

    public ClientUtils.SourceCodeSelection getCodeFragmentSelection() {
        return this.fragmentSelection;
    }

    public void setCodeRegionCPUResBufSize(int n) {
        this.codeRegionCPUResBufSize = n;
    }

    public int getCodeRegionCPUResBufSize() {
        return this.codeRegionCPUResBufSize;
    }

    public void setExcludeWaitTime(boolean bl) {
        this.excludeWaitTime = bl;
    }

    public boolean getExcludeWaitTime() {
        return this.excludeWaitTime;
    }

    public void setInstrScheme(int n) {
        this.instrScheme = n;
    }

    public int getInstrScheme() {
        return this.instrScheme;
    }

    public void setInstrumentEmptyMethods(boolean bl) {
        this.instrumentEmptyMethods = bl;
    }

    public boolean getInstrumentEmptyMethods() {
        return this.instrumentEmptyMethods;
    }

    public void setInstrumentGetterSetterMethods(boolean bl) {
        this.instrumentGetterSetterMethods = bl;
    }

    public boolean getInstrumentGetterSetterMethods() {
        return this.instrumentGetterSetterMethods;
    }

    public void setInstrumentMethodInvoke(boolean bl) {
        this.instrumentMethodInvoke = bl;
    }

    public boolean getInstrumentMethodInvoke() {
        return this.instrumentMethodInvoke;
    }

    public void setInstrumentSpawnedThreads(boolean bl) {
        this.instrumentSpawnedThreads = bl;
    }

    public boolean getInstrumentSpawnedThreads() {
        return this.instrumentSpawnedThreads;
    }

    public void setInstrumentationMarkerMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.instrumentationMarkerMethods.clear();
        for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = sourceCodeSelectionArray[i];
            if (!sourceCodeSelection.isMarkerMethod()) continue;
            this.instrumentationMarkerMethods.add(sourceCodeSelection);
        }
    }

    public ClientUtils.SourceCodeSelection[] getInstrumentationMarkerMethods() {
        return this.instrumentationMarkerMethods.toArray(new ClientUtils.SourceCodeSelection[0]);
    }

    public ClientUtils.SourceCodeSelection[] getInstrumentationMethods() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.instrumentationRootMethods);
        hashSet.addAll(this.instrumentationMarkerMethods);
        return hashSet.toArray(new ClientUtils.SourceCodeSelection[0]);
    }

    public void setInstrumentationRootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.instrumentationRootMethods.clear();
        for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = sourceCodeSelectionArray[i];
            if (sourceCodeSelection.isMarkerMethod()) continue;
            this.instrumentationRootMethods.add(sourceCodeSelection);
        }
    }

    public ClientUtils.SourceCodeSelection[] getInstrumentationRootMethods() {
        return this.instrumentationRootMethods.toArray(new ClientUtils.SourceCodeSelection[0]);
    }

    public void setSamplingFrequency(int n) {
        this.samplingFrequency = n;
    }

    public int getSamplingFrequency() {
        return this.samplingFrequency;
    }

    public void setIsPreset(boolean bl) {
        this.isPreset = bl;
    }

    public void setJVMArgs(String string) {
        this.jvmArgs = string;
    }

    public String getJVMArgs() {
        return this.jvmArgs;
    }

    public void setJavaPlatformName(String string) {
        this.platformName = string;
    }

    public String getJavaPlatformName() {
        return this.platformName;
    }

    public void setNProfiledThreadsLimit(int n) {
        this.nProfiledThreadsLimit = n;
    }

    public int getNProfiledThreadsLimit() {
        return this.nProfiledThreadsLimit;
    }

    public void setStackDepthLimit(int n) {
        this.stackDepthLimit = n;
    }

    public int getStackDepthLimit() {
        return this.stackDepthLimit;
    }

    public void setOverrideGlobalSettings(boolean bl) {
        this.overrideGlobalSettings = bl;
    }

    public boolean getOverrideGlobalSettings() {
        return this.overrideGlobalSettings;
    }

    public boolean isPreset() {
        return this.isPreset;
    }

    public void setProfileUnderlyingFramework(boolean bl) {
        this.profileUnderlyingFramework = bl;
    }

    public boolean getProfileUnderlyingFramework() {
        return this.profileUnderlyingFramework;
    }

    public void setProfilingType(int n) {
        this.profilingType = n;
    }

    public int getProfilingType() {
        return this.profilingType;
    }

    public void setRunGCOnGetResultsInMemoryProfiling(boolean bl) {
        this.runGCOnGetResultsInMemoryProfiling = bl;
    }

    public boolean getRunGCOnGetResultsInMemoryProfiling() {
        return this.runGCOnGetResultsInMemoryProfiling;
    }

    public void setSamplingInterval(int n) {
        this.samplingInterval = n;
    }

    public int getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setInstrumentationFilter(GenericFilter genericFilter) {
        this.instrumentationFilter = genericFilter;
    }

    public GenericFilter getInstrumentationFilter() {
        return this.instrumentationFilter;
    }

    public void setSettingsName(String string) {
        this.settingsName = string;
    }

    public String getSettingsName() {
        return this.settingsName;
    }

    public void setSortResultsByThreadCPUTime(boolean bl) {
        this.sortResultsByThreadCPUTime = bl;
    }

    public boolean getSortResultsByThreadCPUTime() {
        return this.sortResultsByThreadCPUTime;
    }

    public void setThreadCPUTimerOn(boolean bl) {
        this.threadCPUTimerOn = bl;
    }

    public boolean getThreadCPUTimerOn() {
        return this.threadCPUTimerOn;
    }

    public void setThreadsMonitoringEnabled(boolean bl) {
        this.threadsMonitoringEnabled = bl;
    }

    public boolean getThreadsMonitoringEnabled() {
        return this.threadsMonitoringEnabled;
    }

    public void setLockContentionMonitoringEnabled(boolean bl) {
        this.lockContentionMonitoringEnabled = bl;
    }

    public boolean getLockContentionMonitoringEnabled() {
        return this.lockContentionMonitoringEnabled;
    }

    public void setThreadsSamplingEnabled(boolean bl) {
        this.threadsSamplingEnabled = bl;
    }

    public boolean getThreadsSamplingEnabled() {
        return this.threadsSamplingEnabled;
    }

    public void setUseProfilingPoints(boolean bl) {
        this.useProfilingPoints = bl;
    }

    public void setWorkingDir(String string) {
        this.workingDir = string;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void addRootMethod(String string, String string2, String string3) {
        ClientUtils.SourceCodeSelection sourceCodeSelection = new ClientUtils.SourceCodeSelection(string, string2, string3);
        if (!this.instrumentationRootMethods.contains(sourceCodeSelection)) {
            this.instrumentationRootMethods.add(sourceCodeSelection);
        }
    }

    public void addRootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
            if (this.instrumentationRootMethods.contains(sourceCodeSelectionArray[i])) continue;
            this.instrumentationRootMethods.add(sourceCodeSelectionArray[i]);
        }
    }

    public void applySettings(ProfilerEngineSettings profilerEngineSettings) {
        if (this.getOverrideGlobalSettings()) {
            profilerEngineSettings.setWorkingDir(this.getWorkingDir());
            profilerEngineSettings.setJVMArgs(this.getJVMArgs());
            if (this.getJavaPlatformName() != null) {
                profilerEngineSettings.setTargetJVMExeFile(Profiler.getDefault().getPlatformJavaFile(this.getJavaPlatformName()));
                profilerEngineSettings.setTargetJDKVersionString(Profiler.getDefault().getPlatformJDKVersion(this.getJavaPlatformName()));
                profilerEngineSettings.setSystemArchitecture(Profiler.getDefault().getPlatformArchitecture(this.getJavaPlatformName()));
            }
        }
        profilerEngineSettings.setExcludeWaitTime(this.getExcludeWaitTime());
        profilerEngineSettings.setCPUProfilingType(this.getCPUProfilingType());
        profilerEngineSettings.setInstrScheme(this.getInstrScheme());
        profilerEngineSettings.setAbsoluteTimerOn(true);
        profilerEngineSettings.setThreadCPUTimerOn(this.getThreadCPUTimerOn());
        profilerEngineSettings.setInstrumentGetterSetterMethods(this.getInstrumentGetterSetterMethods());
        profilerEngineSettings.setInstrumentEmptyMethods(this.getInstrumentEmptyMethods());
        profilerEngineSettings.setInstrumentMethodInvoke(this.getInstrumentMethodInvoke());
        profilerEngineSettings.setInstrumentSpawnedThreads(this.getInstrumentSpawnedThreads());
        profilerEngineSettings.setThreadsMonitoringEnabled(this.getThreadsMonitoringEnabled());
        profilerEngineSettings.setLockContentionMonitoringEnabled(this.getLockContentionMonitoringEnabled());
        profilerEngineSettings.setThreadsSamplingEnabled(this.getThreadsSamplingEnabled());
        if (this.getNProfiledThreadsLimit() > 0) {
            profilerEngineSettings.setNProfiledThreadsLimit(this.getNProfiledThreadsLimit());
        } else {
            profilerEngineSettings.setNProfiledThreadsLimit(Integer.MAX_VALUE);
        }
        profilerEngineSettings.setStackDepthLimit(this.getStackDepthLimit());
        profilerEngineSettings.setSortResultsByThreadCPUTime(this.getSortResultsByThreadCPUTime());
        profilerEngineSettings.setSamplingInterval(this.getSamplingInterval());
        profilerEngineSettings.setSamplingFrequency(this.getSamplingFrequency());
        profilerEngineSettings.setCodeRegionCPUResBufSize(this.getCodeRegionCPUResBufSize());
        profilerEngineSettings.setRunGCOnGetResultsInMemoryProfiling(this.getRunGCOnGetResultsInMemoryProfiling());
        profilerEngineSettings.setAllocTrackEvery(this.getAllocTrackEvery());
        profilerEngineSettings.setAllocStackTraceLimit(this.getAllocStackTraceLimit());
        profilerEngineSettings.setInstrumentationRootMethods(this.getInstrumentationMethods());
        profilerEngineSettings.setInstrumentationFilter(this.instrumentationFilter);
    }

    public void copySettingsInto(ProfilingSettings profilingSettings) {
        profilingSettings.setProfilingType(this.getProfilingType());
        profilingSettings.setOverrideGlobalSettings(this.getOverrideGlobalSettings());
        profilingSettings.setWorkingDir(this.getWorkingDir());
        profilingSettings.setJVMArgs(this.getJVMArgs());
        profilingSettings.setJavaPlatformName(this.getJavaPlatformName());
        profilingSettings.setThreadsMonitoringEnabled(this.getThreadsMonitoringEnabled());
        profilingSettings.setLockContentionMonitoringEnabled(this.getLockContentionMonitoringEnabled());
        profilingSettings.setThreadsSamplingEnabled(this.getThreadsSamplingEnabled());
        profilingSettings.setUseProfilingPoints(this.useProfilingPoints());
        profilingSettings.setExcludeWaitTime(this.getExcludeWaitTime());
        profilingSettings.setCPUProfilingType(this.getCPUProfilingType());
        profilingSettings.setInstrScheme(this.getInstrScheme());
        profilingSettings.setThreadCPUTimerOn(this.getThreadCPUTimerOn());
        profilingSettings.setInstrumentGetterSetterMethods(this.getInstrumentGetterSetterMethods());
        profilingSettings.setInstrumentEmptyMethods(this.getInstrumentEmptyMethods());
        profilingSettings.setInstrumentMethodInvoke(this.getInstrumentMethodInvoke());
        profilingSettings.setInstrumentSpawnedThreads(this.getInstrumentSpawnedThreads());
        profilingSettings.setNProfiledThreadsLimit(this.getNProfiledThreadsLimit());
        profilingSettings.setStackDepthLimit(this.getStackDepthLimit());
        profilingSettings.setSortResultsByThreadCPUTime(this.getSortResultsByThreadCPUTime());
        profilingSettings.setSamplingInterval(this.getSamplingInterval());
        profilingSettings.setSamplingFrequency(this.getSamplingFrequency());
        profilingSettings.setInstrumentationRootMethods(this.getInstrumentationRootMethods());
        profilingSettings.setCodeFragmentSelection(this.getCodeFragmentSelection());
        profilingSettings.setCodeRegionCPUResBufSize(this.getCodeRegionCPUResBufSize());
        profilingSettings.setRunGCOnGetResultsInMemoryProfiling(this.getRunGCOnGetResultsInMemoryProfiling());
        profilingSettings.setAllocTrackEvery(this.getAllocTrackEvery());
        profilingSettings.setAllocStackTraceLimit(this.getAllocStackTraceLimit());
        profilingSettings.setInstrumentationFilter(this.getInstrumentationFilter());
        profilingSettings.setProfileUnderlyingFramework(this.getProfileUnderlyingFramework());
    }

    public String debug() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("isPreset: ").append(this.isPreset());
        stringBuffer.append('\n');
        stringBuffer.append("name: ").append(this.getSettingsName());
        stringBuffer.append('\n');
        stringBuffer.append("profilingType: ").append(this.getProfilingType());
        stringBuffer.append('\n');
        stringBuffer.append("overrideGlobalSettings: ").append(this.getOverrideGlobalSettings());
        stringBuffer.append('\n');
        stringBuffer.append("workingDir: ").append(this.getWorkingDir());
        stringBuffer.append('\n');
        stringBuffer.append("jvmArgs: ").append(this.getJVMArgs());
        stringBuffer.append('\n');
        stringBuffer.append("javaPlatform: ").append(this.getJavaPlatformName() == null ? "<project>" : this.getJavaPlatformName());
        stringBuffer.append('\n');
        stringBuffer.append("threadsMonitoringEnabled: ").append(this.getThreadsMonitoringEnabled());
        stringBuffer.append('\n');
        stringBuffer.append("lockContentionMonitoringEnabled: ").append(this.getLockContentionMonitoringEnabled());
        stringBuffer.append('\n');
        stringBuffer.append("threadsSamplingEnabled: ").append(this.getThreadsSamplingEnabled());
        stringBuffer.append('\n');
        stringBuffer.append("useProfilingPoints: ").append(this.useProfilingPoints());
        stringBuffer.append('\n');
        stringBuffer.append("excludeWaitTime: ").append(this.getExcludeWaitTime());
        stringBuffer.append('\n');
        stringBuffer.append("cpuProfilingType: ").append(this.getCPUProfilingType());
        stringBuffer.append('\n');
        stringBuffer.append("instrScheme: ").append(this.getInstrScheme());
        stringBuffer.append('\n');
        stringBuffer.append("threadCPUTimerOn: ").append(this.getThreadCPUTimerOn());
        stringBuffer.append('\n');
        stringBuffer.append("instrumentGetterSetterMethods: ").append(this.getInstrumentGetterSetterMethods());
        stringBuffer.append('\n');
        stringBuffer.append("instrumentEmptyMethods: ").append(this.getInstrumentEmptyMethods());
        stringBuffer.append('\n');
        stringBuffer.append("instrumentMethodInvoke: ").append(this.getInstrumentMethodInvoke());
        stringBuffer.append('\n');
        stringBuffer.append("instrumentSpawnedThreads: ").append(this.getInstrumentSpawnedThreads());
        stringBuffer.append('\n');
        stringBuffer.append("nProfiledThreadsLimit: ").append(this.getNProfiledThreadsLimit());
        stringBuffer.append('\n');
        stringBuffer.append("stackDepthLimit: ").append(this.getStackDepthLimit());
        stringBuffer.append('\n');
        stringBuffer.append("sortResultsByThreadCPUTime: ").append(this.getSortResultsByThreadCPUTime());
        stringBuffer.append('\n');
        stringBuffer.append("samplingInterval: ").append(this.getSamplingInterval());
        stringBuffer.append('\n');
        stringBuffer.append("samplingFrequency: ").append(this.getSamplingFrequency());
        stringBuffer.append('\n');
        stringBuffer.append("instrumentationRootMethods: ").append(this.instrumentationRootMethods);
        stringBuffer.append('\n');
        stringBuffer.append("codeFragmentSelection: ").append(this.getCodeFragmentSelection());
        stringBuffer.append('\n');
        stringBuffer.append("codeRegionCPUResBufSize: ").append(this.getCodeRegionCPUResBufSize());
        stringBuffer.append('\n');
        stringBuffer.append("runGCOnGetResultsInMemoryProfiling: ").append(this.getRunGCOnGetResultsInMemoryProfiling());
        stringBuffer.append('\n');
        stringBuffer.append("allocTrackEvery: ").append(this.getAllocTrackEvery());
        stringBuffer.append('\n');
        stringBuffer.append("allocStackTraceLimit: ").append(this.getAllocStackTraceLimit());
        stringBuffer.append('\n');
        stringBuffer.append("selectedInstrFilter: ").append(this.getInstrumentationFilter());
        stringBuffer.append('\n');
        stringBuffer.append("profileUnderlyingFramework: ").append(this.getProfileUnderlyingFramework());
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public void load(Map map) {
        this.load(map, "");
    }

    public void load(Map map, String string) {
        int n;
        int n2;
        this.setIsPreset(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_IS_PRESET, "false")));
        this.setSettingsName(ProfilingSettings.getProperty(map, string + PROP_SETTINGS_NAME, UNKNOWN_PROFILING_SETTINGS_NAME));
        this.setProfilingType(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_PROFILING_TYPE, "8")));
        this.setOverrideGlobalSettings(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_OVERRIDE_GLOBAL_SETTINGS, "false")));
        this.setWorkingDir(ProfilingSettings.getProperty(map, string + PROP_WORKING_DIR, ""));
        this.setJVMArgs(ProfilingSettings.getProperty(map, string + PROP_JVM_ARGS, ""));
        this.setJavaPlatformName(ProfilingSettings.getProperty(map, string + PROP_JAVA_PLATFORM, null));
        this.setThreadsMonitoringEnabled(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_THREADS_MONITORING_ENABLED, "false")));
        this.setLockContentionMonitoringEnabled(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_LOCKCONTENTION_MONITORING_ENABLED, "false")));
        this.setThreadsSamplingEnabled(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_THREADS_SAMPLING_ENABLED, "true")));
        this.setExcludeWaitTime(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_EXCLUDE_WAIT_TIME, "false")));
        this.setCPUProfilingType(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_CPU_PROFILING_TYPE, "0")));
        this.setInstrScheme(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_INSTR_SCHEME, "1")));
        this.setThreadCPUTimerOn(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_THREAD_CPU_TIMER_ON, "false")));
        this.setInstrumentGetterSetterMethods(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_INSTRUMENT_GETTER_SETTER_METHODS, "false")));
        this.setInstrumentEmptyMethods(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_INSTRUMENT_EMPTY_METHODS, "false")));
        this.setInstrumentMethodInvoke(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_INSTRUMENT_METHOD_INVOKE, "true")));
        this.setInstrumentSpawnedThreads(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_INSTRUMENT_SPAWNED_THREADS, "false")));
        this.setNProfiledThreadsLimit(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_N_PROFILED_THREADS_LIMIT, "32")));
        this.setStackDepthLimit(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_STACK_DEPTH_LIMIT, String.valueOf(Integer.MAX_VALUE))));
        this.setSortResultsByThreadCPUTime(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_SORT_RESULTS_BY_THREAD_CPU_TIME, "false")));
        this.setProfileUnderlyingFramework(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_PROFILE_UNDERLYING_FRAMEWORK, "false")));
        this.setSamplingFrequency(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_SAMPLING_FREQUENCY, "10")));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        try {
            this.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(properties, string + PROP_INSTR_FILTER));
        }
        catch (GenericFilter.InvalidFilterIdException invalidFilterIdException) {
            if ("profiler.simple.filter".equals(ProfilingSettings.getProperty(map, string + "profiler.settings.instrumentation.filter.selectedprofiler.filter.type", null))) {
                String string2 = ProfilingSettings.getProperty(map, string + "profiler.settings.instrumentation.filter.selectedprofiler.simple.filter.value", "");
                n2 = Integer.parseInt(ProfilingSettings.getProperty(map, string + "profiler.settings.instrumentation.filter.selectedprofiler.simple.filter.type", "0"));
                if (n2 == 1 || n2 == 3) {
                    this.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(string2, 20));
                } else if (n2 == 2 || n2 == 4) {
                    this.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(string2, 10));
                } else {
                    this.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(string2, 0));
                }
            }
            this.setInstrumentationFilter(new GenericFilter("#fallback#", "", 0));
        }
        this.setSamplingInterval(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_SAMPLING_INTERVAL, "10")));
        int n3 = Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_INSTRUMENTATION_ROOT_METHODS_SIZE, "0"));
        for (n = 0; n < n3; ++n) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = ClientUtils.stringToSelection((String)ProfilingSettings.getProperty(map, string + PROP_INSTRUMENTATION_ROOT_METHODS_PREFIX + n, null));
            if (sourceCodeSelection == null) continue;
            this.instrumentationRootMethods.add(sourceCodeSelection);
        }
        n = Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_INSTRUMENTATION_MARKER_METHODS_SIZE, "0"));
        for (n2 = 0; n2 < n; ++n2) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = ClientUtils.stringToSelection((String)ProfilingSettings.getProperty(map, string + PROP_INSTRUMENTATION_MARKER_METHODS_PREFIX + n2, null));
            if (sourceCodeSelection == null) continue;
            sourceCodeSelection.setMarkerMethod(true);
            this.instrumentationMarkerMethods.add(sourceCodeSelection);
        }
        this.setCodeFragmentSelection(ClientUtils.stringToSelection((String)ProfilingSettings.getProperty(map, string + PROP_FRAGMENT_SELECTION, "")));
        this.setCodeRegionCPUResBufSize(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_CODE_REGION_CPU_RES_BUF_SIZE, "1000")));
        this.setRunGCOnGetResultsInMemoryProfiling(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_RUN_GC_ON_GET_RESULTS_IN_MEMORY_PROFILING, "true")));
        this.setAllocTrackEvery(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_OBJ_ALLOC_STACK_SAMPLING_INTERVAL, "10")));
        this.setAllocStackTraceLimit(Integer.parseInt(ProfilingSettings.getProperty(map, string + PROP_OBJ_ALLOC_STACK_SAMPLING_DEPTH, "-5")));
        this.setUseProfilingPoints(Boolean.valueOf(ProfilingSettings.getProperty(map, string + PROP_PROFILING_POINTS_ENABLED, "false")));
    }

    public static void saveRootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray, Map map) {
        map.put(PROP_INSTRUMENTATION_ROOT_METHODS_SIZE, Integer.toString(sourceCodeSelectionArray.length));
        for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
            map.put(PROP_INSTRUMENTATION_ROOT_METHODS_PREFIX + i, ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)sourceCodeSelectionArray[i]));
        }
    }

    public void store(Map map) {
        this.store(map, "");
    }

    public void store(Map map, String string) {
        int n;
        map.put(string + PROP_IS_PRESET, Boolean.toString(this.isPreset()));
        map.put(string + PROP_SETTINGS_NAME, this.getSettingsName());
        map.put(string + PROP_PROFILING_TYPE, Integer.toString(this.getProfilingType()));
        map.put(string + PROP_OVERRIDE_GLOBAL_SETTINGS, Boolean.toString(this.getOverrideGlobalSettings()));
        map.put(string + PROP_WORKING_DIR, this.getWorkingDir());
        map.put(string + PROP_JVM_ARGS, this.getJVMArgs());
        if (this.getJavaPlatformName() != null) {
            map.put(string + PROP_JAVA_PLATFORM, this.getJavaPlatformName());
        }
        map.put(string + PROP_THREADS_MONITORING_ENABLED, Boolean.toString(this.getThreadsMonitoringEnabled()));
        map.put(string + PROP_LOCKCONTENTION_MONITORING_ENABLED, Boolean.toString(this.getLockContentionMonitoringEnabled()));
        map.put(string + PROP_THREADS_SAMPLING_ENABLED, Boolean.toString(this.getThreadsSamplingEnabled()));
        map.put(string + PROP_EXCLUDE_WAIT_TIME, Boolean.toString(this.getExcludeWaitTime()));
        map.put(string + PROP_CPU_PROFILING_TYPE, Integer.toString(this.getCPUProfilingType()));
        map.put(string + PROP_INSTR_SCHEME, Integer.toString(this.getInstrScheme()));
        map.put(string + PROP_THREAD_CPU_TIMER_ON, Boolean.toString(this.getThreadCPUTimerOn()));
        map.put(string + PROP_INSTRUMENT_GETTER_SETTER_METHODS, Boolean.toString(this.getInstrumentGetterSetterMethods()));
        map.put(string + PROP_INSTRUMENT_EMPTY_METHODS, Boolean.toString(this.getInstrumentEmptyMethods()));
        map.put(string + PROP_INSTRUMENT_METHOD_INVOKE, Boolean.toString(this.getInstrumentMethodInvoke()));
        map.put(string + PROP_INSTRUMENT_SPAWNED_THREADS, Boolean.toString(this.getInstrumentSpawnedThreads()));
        map.put(string + PROP_N_PROFILED_THREADS_LIMIT, Integer.toString(this.getNProfiledThreadsLimit()));
        map.put(string + PROP_STACK_DEPTH_LIMIT, Integer.toString(this.getStackDepthLimit()));
        map.put(string + PROP_SORT_RESULTS_BY_THREAD_CPU_TIME, Boolean.toString(this.getSortResultsByThreadCPUTime()));
        map.put(string + PROP_SAMPLING_FREQUENCY, Integer.toString(this.getSamplingFrequency()));
        if (this.instrumentationFilter != null) {
            Properties properties = new Properties();
            this.instrumentationFilter.store(properties, string + PROP_INSTR_FILTER);
            map.putAll(properties);
        } else {
            map.remove(string + PROP_INSTR_FILTER);
        }
        map.put(string + PROP_PROFILE_UNDERLYING_FRAMEWORK, Boolean.toString(this.getProfileUnderlyingFramework()));
        map.put(string + PROP_SAMPLING_INTERVAL, Integer.toString(this.getSamplingInterval()));
        map.put(string + PROP_INSTRUMENTATION_ROOT_METHODS_SIZE, Integer.toString(this.instrumentationRootMethods.size()));
        for (n = 0; n < this.instrumentationRootMethods.size(); ++n) {
            map.put(string + PROP_INSTRUMENTATION_ROOT_METHODS_PREFIX + n, ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)((ClientUtils.SourceCodeSelection)this.instrumentationRootMethods.get(n))));
        }
        map.put(string + PROP_INSTRUMENTATION_MARKER_METHODS_SIZE, Integer.toString(this.instrumentationMarkerMethods.size()));
        for (n = 0; n < this.instrumentationMarkerMethods.size(); ++n) {
            map.put(string + PROP_INSTRUMENTATION_MARKER_METHODS_PREFIX + n, ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)((ClientUtils.SourceCodeSelection)this.instrumentationMarkerMethods.get(n))));
        }
        if (this.getCodeFragmentSelection() != null) {
            map.put(string + PROP_FRAGMENT_SELECTION, ClientUtils.selectionToString((ClientUtils.SourceCodeSelection)this.getCodeFragmentSelection()));
        }
        map.put(string + PROP_CODE_REGION_CPU_RES_BUF_SIZE, Integer.toString(this.getCodeRegionCPUResBufSize()));
        map.put(string + PROP_RUN_GC_ON_GET_RESULTS_IN_MEMORY_PROFILING, Boolean.toString(this.getRunGCOnGetResultsInMemoryProfiling()));
        map.put(string + PROP_OBJ_ALLOC_STACK_SAMPLING_INTERVAL, Integer.toString(this.getAllocTrackEvery()));
        map.put(string + PROP_OBJ_ALLOC_STACK_SAMPLING_DEPTH, Integer.toString(this.getAllocStackTraceLimit()));
        map.put(string + PROP_PROFILING_POINTS_ENABLED, Boolean.toString(this.useProfilingPoints()));
    }

    public String toString() {
        return this.getSettingsName();
    }

    public boolean useProfilingPoints() {
        return this.useProfilingPoints;
    }

    static String getProperty(Map map, Object object, String string) {
        Object v = map.get(object);
        return v != null ? (String)v : string;
    }
}

