/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class HeapWalkerUI
extends ProfilerTopComponent {
    private static final byte PERSISTENCE_VERSION_MAJOR = 8;
    private static final byte PERSISTENCE_VERSION_MINOR = 1;
    private static final String HELP_CTX_KEY = "HeapWalker.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("HeapWalker.HelpCtx");
    private HeapWalker heapWalker;

    public HeapWalkerUI() {
        this.setIcon(Icons.getImage((String)"ProfilerIcons.HeapDump"));
        this.getAccessibleContext().setAccessibleDescription(Bundle.HeapWalkerUI_ComponentDescr());
        this.setLayout(new BorderLayout());
    }

    public HeapWalkerUI(HeapWalker heapWalker) {
        this();
        this.initImpl(heapWalker);
    }

    private void initImpl(HeapWalker heapWalker) {
        this.heapWalker = heapWalker;
        this.initDefaults();
        this.initComponents();
    }

    protected Component defaultFocusOwner() {
        return this.heapWalker == null ? this : this.heapWalker.getMainHeapWalker().getPanel();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeByte(8);
        objectOutput.writeByte(1);
        objectOutput.writeUTF(Utilities.toURI((File)this.heapWalker.getHeapDumpFile()).toString());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.add(new JLabel(Bundle.HeapWalkerUI_LoadingProgress(), 0), "Center");
            this.invalidate();
            this.doLayout();
            this.repaint();
            super.readExternal(objectInput);
            objectInput.readByte();
            objectInput.readByte();
            URI uRI = new URI(objectInput.readUTF());
            final File file = Utilities.toFile((URI)uRI);
            new RequestProcessor("HPROF loader for " + this.getName()).post(new Runnable(){

                @Override
                public void run() {
                    try {
                        final HeapWalker heapWalker = new HeapWalker(file);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HeapWalkerUI.this.removeAll();
                                HeapWalkerUI.this.initImpl(heapWalker);
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        HeapWalkerUI.this.handleReadThrowable(throwable);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            this.handleReadThrowable(throwable);
        }
    }

    private void handleReadThrowable(Throwable throwable) {
        ProfilerLogger.info((String)("Restoring heap dump failed: " + throwable.getMessage()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HeapWalkerUI.this.close();
            }
        });
    }

    public int getPersistenceType() {
        return ProfilerIDESettings.getInstance().getReopenHeapDumps() ? 1 : 2;
    }

    protected void componentClosed() {
        if (this.heapWalker == null) {
            return;
        }
        HeapWalkerManager.getDefault().heapWalkerClosed(this.heapWalker);
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    private void initComponents() {
        this.add(this.heapWalker.getMainHeapWalker().getPanel(), "Center");
        this.invalidate();
        this.doLayout();
        this.repaint();
    }

    private void initDefaults() {
        this.setName(this.heapWalker.getName());
        if (this.heapWalker.getHeapDumpFile() != null) {
            this.setToolTipText(this.heapWalker.getHeapDumpFile().getAbsolutePath());
        }
        File file = this.heapWalker.getHeapDumpFile();
        this.putClientProperty("nb.recent.file.path", file);
    }
}

