/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

import java.util.Iterator;

public class ImmutableList
implements Iterable {
    private static final LoadFactor[] distributionMap = new LoadFactor[]{new LoadFactor(2, 3.0f), new LoadFactor(6, 0.3f), new LoadFactor(10, 0.5f), new LoadFactor(50, 0.1f)};
    private final Object slotsGuard = new Object();
    private int[] slotLimits;
    private Object[] storageSlots;
    private float loadFactor = 1.75f;
    private int availableSize;
    private int currentIndex;
    private int currentSlot;
    private int initialSize = 1;
    private int size;
    private int slotCount;
    private int slotInitialSize = 1;

    public ImmutableList() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object object) {
        Object object2 = this.slotsGuard;
        synchronized (object2) {
            this.accomodate(++this.size);
            ((Object[])this.storageSlots[this.currentSlot])[this.currentIndex] = object;
        }
    }

    public void clear() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        Object object = this.slotsGuard;
        synchronized (object) {
            Object[] objectArray = null;
            int n2 = 0;
            for (int i = 0; i < this.slotCount; ++i) {
                if (this.slotLimits[i] > n) {
                    objectArray = (Object[])this.storageSlots[i];
                    break;
                }
                n2 = this.slotLimits[i];
            }
            if (objectArray == null) {
                return null;
            }
            return ((Object[])objectArray)[n - n2];
        }
    }

    public Object get(Object object) {
        for (Object e : this) {
            if (!e.equals(object)) continue;
            return e;
        }
        return null;
    }

    public Iterator iterator() {
        return new InnerIterator();
    }

    public static void main(String[] stringArray) {
        int n;
        ImmutableList immutableList = new ImmutableList();
        for (n = 0; n < 10000; ++n) {
            immutableList.add(n);
        }
        System.out.println("ready");
        for (n = 0; n < 10000; ++n) {
            System.out.println(n + " = " + immutableList.get(n));
        }
        immutableList.clear();
        for (n = 0; n < 100000; ++n) {
            immutableList.add(n);
        }
        System.out.println("ready");
        for (n = 0; n < 100000; ++n) {
            System.out.println(n + " = " + immutableList.get(n));
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accomodate(int n) {
        Object object = this.slotsGuard;
        synchronized (object) {
            if (this.slotCount == 0) {
                this.slotLimits = new int[this.initialSize];
                this.storageSlots = new Object[this.initialSize];
                this.storageSlots[0] = new Object[this.slotInitialSize];
                this.availableSize = this.slotLimits[0] = this.slotInitialSize;
                this.slotCount = 1;
                this.currentSlot = 0;
                this.currentIndex = 0;
                return;
            }
            if (n > this.availableSize) {
                int n2 = (int)((float)this.availableSize * this.findLoadFactor(this.availableSize) + 0.5f);
                n2 = n2 > 0 ? n : 1;
                Object[] objectArray = new Object[n2];
                this.availableSize += n2;
                if (this.slotCount == this.storageSlots.length) {
                    int n3 = (int)((float)this.slotCount * this.loadFactor + 0.5f);
                    Object[] objectArray2 = new Object[n3];
                    int[] nArray = new int[n3];
                    System.arraycopy(this.storageSlots, 0, objectArray2, 0, this.storageSlots.length);
                    System.arraycopy(this.slotLimits, 0, nArray, 0, this.slotLimits.length);
                    this.storageSlots = objectArray2;
                    this.slotLimits = nArray;
                }
                this.currentSlot = this.slotCount;
                this.currentIndex = 0;
                this.storageSlots[this.slotCount] = objectArray;
                this.slotLimits[this.slotCount] = this.availableSize;
                ++this.slotCount;
                return;
            }
            this.currentIndex = this.slotCount > 1 ? n - this.slotLimits[this.slotCount - 2] - 1 : n - 1;
        }
    }

    private float findLoadFactor(int n) {
        for (int i = 0; i < distributionMap.length; ++i) {
            if (ImmutableList.distributionMap[i].upperLimit <= n) continue;
            return ImmutableList.distributionMap[i].factor;
        }
        return 0.01f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Object object = this.slotsGuard;
        synchronized (object) {
            this.storageSlots = null;
            this.slotLimits = null;
            this.slotCount = 0;
            this.size = 0;
        }
    }

    private static final class LoadFactor {
        public static final float DEFAULT_FACTOR = 0.01f;
        public final float factor;
        public final int upperLimit;

        public LoadFactor(int n, float f) {
            this.upperLimit = n;
            this.factor = f;
        }
    }

    private class InnerIterator
    implements Iterator {
        private int counter = 0;

        @Override
        public boolean hasNext() {
            return this.counter < ImmutableList.this.size;
        }

        public Object next() {
            return ImmutableList.this.get(this.counter++);
        }

        @Override
        public void remove() {
        }
    }
}

