/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.ClassNode;
import com.sun.tools.visualvm.heapviewer.java.InstanceNode;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.utils.HeapUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.JavaFrameGCRoot;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;

class JavaThreadsHTML {
    private static final String OPEN_THREADS_URL = "file:/stackframe/";
    private static final int JVMTI_THREAD_STATE_ALIVE = 1;
    private static final int JVMTI_THREAD_STATE_TERMINATED = 2;
    private static final int JVMTI_THREAD_STATE_RUNNABLE = 4;
    private static final int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static final int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static final int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;

    JavaThreadsHTML() {
    }

    static ThreadObjectGCRoot getOOMEThread(Heap heap) {
        Collection roots = heap.getGCRoots();
        for (GCRoot root : roots) {
            ThreadObjectGCRoot threadRoot;
            StackTraceElement[] stackTrace;
            if (!root.getKind().equals("thread object") || (stackTrace = (threadRoot = (ThreadObjectGCRoot)root).getStackTrace()) == null || stackTrace.length < 1) continue;
            StackTraceElement ste = stackTrace[0];
            if (!OutOfMemoryError.class.getName().equals(ste.getClassName()) || !"<init>".equals(ste.getMethodName())) continue;
            return threadRoot;
        }
        return null;
    }

    static HeapViewerNode getNode(URL url, HeapContext context) {
        String urls = url.toString();
        if (HeapUtils.isInstance(urls)) {
            Instance instance = HeapUtils.instanceFromHtml(urls, context.getFragment().getHeap());
            if (instance != null) {
                return new InstanceNode(instance);
            }
            ProfilerDialogs.displayError((String)Bundle.JavaThreadsHTML_CannotResolveInstanceMsg());
        } else if (HeapUtils.isClass(urls)) {
            JavaClass javaClass = HeapUtils.classFromHtml(urls, context.getFragment().getHeap());
            if (javaClass != null) {
                return new ClassNode(javaClass);
            }
            ProfilerDialogs.displayError((String)Bundle.JavaThreadsHTML_CannotResolveClassMsg());
        }
        return null;
    }

    static String getThreads(HeapContext context) {
        boolean gotoSourceAvailable = false;
        StringBuilder sb = new StringBuilder();
        Heap h = context.getFragment().getHeap();
        Collection roots = h.getGCRoots();
        Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = JavaThreadsHTML.computeJavaFrameMap(roots);
        ThreadObjectGCRoot oome = JavaThreadsHTML.getOOMEThread(h);
        JavaClass javaClassClass = h.getJavaClassByName(Class.class.getName());
        sb.append("<pre>");
        for (GCRoot root : roots) {
            if (!root.getKind().equals("thread object")) continue;
            ThreadObjectGCRoot threadRoot = (ThreadObjectGCRoot)root;
            Instance threadInstance = threadRoot.getInstance();
            if (threadInstance != null) {
                String threadName = JavaThreadsHTML.getThreadName(h, threadInstance);
                Boolean daemon = (Boolean)threadInstance.getValueOfField("daemon");
                Integer priority = (Integer)threadInstance.getValueOfField("priority");
                Long threadId = (Long)threadInstance.getValueOfField("tid");
                Integer threadStatus = (Integer)threadInstance.getValueOfField("threadStatus");
                StackTraceElement[] stack = threadRoot.getStackTrace();
                Map<Integer, List<JavaFrameGCRoot>> localsMap = javaFrameMap.get(threadRoot);
                String style = "";
                if (threadRoot.equals(oome)) {
                    style = "style=\"color: #FF0000\"";
                }
                sb.append("&nbsp;&nbsp;<a name=").append(threadInstance.getInstanceId()).append("></a><b ").append(style).append(">");
                sb.append("\"").append(HeapUtils.htmlize(threadName)).append("\"").append(daemon != false ? " daemon" : "").append(" prio=").append(priority);
                if (threadId != null) {
                    sb.append(" tid=").append(threadId);
                }
                if (threadStatus != null) {
                    Thread.State tState = JavaThreadsHTML.toThreadState(threadStatus);
                    sb.append(" ").append((Object)tState);
                }
                sb.append("</b><br>");
                if (stack != null) {
                    for (int i = 0; i < stack.length; ++i) {
                        List<JavaFrameGCRoot> locals;
                        String stackElHref;
                        StackTraceElement stackElement = stack[i];
                        String stackElementText = HeapUtils.htmlize(stackElement.toString());
                        if (gotoSourceAvailable) {
                            String className = stackElement.getClassName();
                            String method = stackElement.getMethodName();
                            int lineNo = stackElement.getLineNumber();
                            String stackUrl = OPEN_THREADS_URL + className + "|" + method + "|" + lineNo;
                            stackElHref = "<a href=\"" + stackUrl + "\">" + stackElementText + "</a>";
                        } else {
                            stackElHref = stackElementText;
                        }
                        sb.append("    at ").append(stackElHref).append("<br>");
                        if (localsMap == null || (locals = localsMap.get(i)) == null) continue;
                        for (JavaFrameGCRoot localVar : locals) {
                            Instance localInstance = localVar.getInstance();
                            if (localInstance != null) {
                                sb.append("       <span style=\"color: #666666\">local variable:</span> ").append(HeapUtils.instanceToHtml(localInstance, false, h, javaClassClass)).append("<br>");
                                continue;
                            }
                            sb.append("      <span style=\"color: #666666\"> unknown local variable</span><br>");
                        }
                    }
                }
            } else {
                sb.append("&nbsp;&nbsp;Unknown thread<br>");
            }
            sb.append("<br>");
        }
        sb.append("</pre>");
        return sb.toString();
    }

    private static String getThreadName(Heap heap, Instance threadInstance) {
        Object threadName = threadInstance.getValueOfField("name");
        if (threadName == null) {
            return "*null*";
        }
        return DetailsSupport.getDetailsString((Instance)((Instance)threadName), (Heap)heap);
    }

    private static Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> computeJavaFrameMap(Collection<GCRoot> roots) {
        HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> javaFrameMap = new HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>>();
        for (GCRoot root : roots) {
            ArrayList<JavaFrameGCRoot> locals;
            if (!"Java frame".equals(root.getKind())) continue;
            JavaFrameGCRoot frameGCroot = (JavaFrameGCRoot)root;
            ThreadObjectGCRoot threadObj = frameGCroot.getThreadGCRoot();
            Integer frameNo = frameGCroot.getFrameNumber();
            HashMap<Integer, ArrayList<JavaFrameGCRoot>> stackMap = (HashMap<Integer, ArrayList<JavaFrameGCRoot>>)javaFrameMap.get(threadObj);
            if (stackMap == null) {
                stackMap = new HashMap<Integer, ArrayList<JavaFrameGCRoot>>();
                javaFrameMap.put(threadObj, stackMap);
            }
            if ((locals = (ArrayList<JavaFrameGCRoot>)stackMap.get(frameNo)) == null) {
                locals = new ArrayList<JavaFrameGCRoot>(2);
                stackMap.put(frameNo, locals);
            }
            locals.add(frameGCroot);
        }
        return javaFrameMap;
    }

    private static Thread.State toThreadState(int threadStatus) {
        if ((threadStatus & 4) != 0) {
            return Thread.State.RUNNABLE;
        }
        if ((threadStatus & 0x400) != 0) {
            return Thread.State.BLOCKED;
        }
        if ((threadStatus & 0x10) != 0) {
            return Thread.State.WAITING;
        }
        if ((threadStatus & 0x20) != 0) {
            return Thread.State.TIMED_WAITING;
        }
        if ((threadStatus & 2) != 0) {
            return Thread.State.TERMINATED;
        }
        if ((threadStatus & 1) == 0) {
            return Thread.State.NEW;
        }
        return Thread.State.RUNNABLE;
    }
}

