/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.editor;

import java.awt.Font;
import java.io.File;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.editor.Shortcuts;
import net.sf.sdedit.editor.plugin.AbstractFileHandler;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.impl.DiagramTextTab;
import net.sf.sdedit.ui.impl.SequenceDiagramTextTab;

public class DiagramFileHandler
extends AbstractFileHandler {
    @Override
    public String[] getFileDescriptions() {
        return new String[]{"Plain sequence diagram files (.sd)", "Sequence diagram files with preferences (.sdx)"};
    }

    @Override
    public String[] getFileTypes() {
        return new String[]{"sd", "sdx"};
    }

    @Override
    public String getOpenActionName() {
        return "&Open diagram...";
    }

    @Override
    public String getOpenDescription() {
        return "Load sequence diagram file(s)";
    }

    @Override
    public String getOpenShortCut() {
        return Shortcuts.getShortcut(4);
    }

    @Override
    public String getSaveActionName() {
        return "&Save sequence diagram";
    }

    @Override
    public String getSaveAsActionName() {
        return "S&ave sequence diagram as";
    }

    @Override
    public String getSaveAsDescription() {
        return "Save sequence diagram as...";
    }

    @Override
    public String getSaveAsShortCut() {
        return Shortcuts.getShortcut(10);
    }

    @Override
    public String getSaveDescription() {
        return "Save the diagram source text";
    }

    @Override
    public String getSaveShortCut() {
        return Shortcuts.getShortcut(9);
    }

    @Override
    public boolean canLoad() {
        return true;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String getOpenID() {
        return "OPEN";
    }

    @Override
    protected DiagramTextTab createTab(Font editorFont, Bean<? extends Configuration> configuration) {
        return new SequenceDiagramTextTab(this.getUI(), editorFont, configuration);
    }

    @Override
    protected boolean isXML(File file) {
        return file.getName().toLowerCase().endsWith("sdx");
    }

    @Override
    protected Bean<? extends Configuration> createNewConfiguration() {
        return ConfigurationManager.createNewDefaultConfiguration(SequenceConfiguration.class);
    }
}

