/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.HeapFragment;
import com.sun.tools.visualvm.heapviewer.java.InstanceNode;
import com.sun.tools.visualvm.heapviewer.java.InstanceReferenceNode;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.ui.UIThresholds;
import com.sun.tools.visualvm.heapviewer.utils.NodesComputer;
import com.sun.tools.visualvm.heapviewer.utils.ProgressIterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.Value;

public class JavaReferencesProvider
extends HeapViewerNode.Provider {
    @Override
    public String getName() {
        return Bundle.JavaReferencesProvider_Name();
    }

    @Override
    public boolean supportsView(Heap heap, String viewID) {
        return viewID.startsWith("java_");
    }

    @Override
    public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
        return parent instanceof InstanceNode && !InstanceNode.Mode.OUTGOING_REFERENCE.equals((Object)((InstanceNode)parent).getMode());
    }

    @Override
    public HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
        return JavaReferencesProvider.getNodes(((InstanceNode)parent).getInstance(), parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
    }

    static HeapViewerNode[] getNodes(Instance instance, HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
        if (instance == null) {
            return null;
        }
        final List<Value> references = JavaReferencesProvider.getReferences(instance);
        NodesComputer<Value> computer = new NodesComputer<Value>(references.size(), UIThresholds.MAX_INSTANCE_REFERENCES){

            @Override
            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            @Override
            protected HeapViewerNode createNode(Value reference) {
                return InstanceReferenceNode.incoming(reference);
            }

            @Override
            protected ProgressIterator<Value> objectsIterator(int index, Progress progress) {
                ListIterator iterator = references.listIterator(index);
                return new ProgressIterator<Value>(iterator, index, false, progress);
            }

            @Override
            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.JavaReferencesProvider_MoreNodes(moreNodesCount);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.JavaReferencesProvider_SamplesContainer(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.JavaReferencesProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    private static List<Value> getReferences(Instance instance) {
        assert (!SwingUtilities.isEventDispatchThread());
        ProgressHandle pHandle = null;
        try {
            pHandle = ProgressHandle.createHandle((String)Bundle.JavaReferencesProvider_References());
            pHandle.setInitialDelay(1000);
            pHandle.start(1000);
            HeapFragment.setProgress(pHandle, 0);
            List list = instance.getReferences();
            return list;
        }
        finally {
            if (pHandle != null) {
                pHandle.finish();
            }
        }
    }
}

