/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk;

import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public class LangDetailsProvider
extends DetailsProvider.Basic {
    private static final String ENUM_MASK = "java.lang.Enum+";
    private static final String STACKTRACE_MASK = "java.lang.StackTraceElement";

    public LangDetailsProvider() {
        super(ENUM_MASK, STACKTRACE_MASK);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        String string2;
        if (ENUM_MASK.equals(string)) {
            String string3 = DetailsUtils.getInstanceFieldString(instance, "name", heap);
            int n = DetailsUtils.getIntFieldValue(instance, "ordinal", -1);
            if (string3 != null) {
                if (n != -1) {
                    return string3 + " (" + n + ")";
                }
                return string3;
            }
        } else if (STACKTRACE_MASK.equals(string) && (string2 = DetailsUtils.getInstanceFieldString(instance, "declaringClass", heap)) != null) {
            String string4 = DetailsUtils.getInstanceFieldString(instance, "methodName", heap);
            String string5 = DetailsUtils.getInstanceFieldString(instance, "fileName", heap);
            int n = DetailsUtils.getIntFieldValue(instance, "lineNumber", -1);
            if (string4 == null) {
                string4 = "Unknown method";
            }
            StackTraceElement stackTraceElement = new StackTraceElement(string2, string4, string5, n);
            return stackTraceElement.toString();
        }
        return null;
    }
}

