/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;

public class SelectionLengthWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        SelectionLengthWidget selectionLengthWidget = new SelectionLengthWidget(view);
        return selectionLengthWidget;
    }

    public static class SelectionLengthWidget
    implements Widget {
        private final SelectionLength selectionLength;
        private final View view;
        private TextArea textArea;

        SelectionLengthWidget(View view) {
            this.view = view;
            this.textArea = view.getTextArea();
            this.selectionLength = new SelectionLength();
            this.selectionLength.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.selectionLength.setBackground(jEdit.getColorProperty("view.status.background"));
            EditBus.addToBus(this);
        }

        @Override
        public JComponent getComponent() {
            return this.selectionLength;
        }

        @Override
        public void update() {
            Selection selection = this.textArea.getSelectionAtOffset(this.textArea.getCaretPosition());
            if (selection == null) {
                this.selectionLength.setText("0");
            } else {
                int n;
                int n2 = selection.getEnd();
                int n3 = selection.getStart();
                if (selection instanceof Selection.Rect) {
                    int n4 = selection.getStartLine();
                    int n5 = selection.getEndLine();
                    JEditTextArea jEditTextArea = this.view.getTextArea();
                    int n6 = jEditTextArea.getLineStartOffset(n4);
                    int n7 = jEditTextArea.getLineStartOffset(n5);
                    int n8 = n5 - n4 + 1;
                    int n9 = n2 - n7 - (n3 - n6);
                    n = n8 * n9;
                } else {
                    n = n2 - n3;
                }
                this.selectionLength.setText(Integer.toString(n));
            }
        }

        @EditBus.EBHandler
        public void handleViewUpdate(ViewUpdate viewUpdate) {
            if (viewUpdate.getView() == this.view && viewUpdate.getWhat() == ViewUpdate.EDIT_PANE_CHANGED) {
                if (this.textArea != null) {
                    this.textArea.removeCaretListener(this.selectionLength);
                }
                this.textArea = this.view.getTextArea();
                if (this.selectionLength.visible) {
                    this.textArea.addCaretListener(this.selectionLength);
                }
            }
        }

        private class SelectionLength
        extends JLabel
        implements CaretListener {
            boolean visible;

            private SelectionLength() {
            }

            @Override
            public void addNotify() {
                super.addNotify();
                this.visible = true;
                SelectionLengthWidget.this.textArea.addCaretListener(this);
            }

            @Override
            public void removeNotify() {
                this.visible = false;
                SelectionLengthWidget.this.textArea.removeCaretListener(this);
                super.removeNotify();
            }

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SelectionLengthWidget.this.update();
            }
        }
    }
}

