/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.options.PluginOptions;
import org.gjt.sp.jedit.pluginmgr.InstallPanel;
import org.gjt.sp.jedit.pluginmgr.ManagePanel;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.ThreadUtilities;

public class PluginManager
extends JFrame {
    private static PluginManager instance;
    private JTabbedPane tabPane;
    private JButton done;
    private JButton mgrOptions;
    private JButton pluginOptions;
    private InstallPanel installer;
    private InstallPanel updater;
    private ManagePanel manager;
    private PluginList pluginList;
    private boolean queuedUpdate;
    private boolean downloadingPluginList;
    private final Frame parent;
    public static final String PROPERTY_PLUGINSET = "plugin-manager.pluginset.path";

    public static PluginManager getInstance() {
        return instance;
    }

    @Override
    public void dispose() {
        instance = null;
        EditBus.removeFromBus(this);
        EditBus.removeFromBus(this.installer);
        super.dispose();
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        if (this.pluginList != null && this.shouldUpdatePluginList()) {
            this.pluginList = null;
            this.updatePluginList();
        }
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pluginUpdate) {
        if (!this.queuedUpdate) {
            SwingUtilities.invokeLater(() -> {
                this.queuedUpdate = false;
                this.manager.update();
            });
            this.queuedUpdate = true;
        }
    }

    public static void showPluginManager(Frame frame) {
        if (instance == null) {
            instance = new PluginManager(frame);
        }
        instance.toFront();
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    PluginList getPluginList() {
        return this.pluginList;
    }

    void pluginRemoved() {
        this.updater.updateModel();
        this.installer.updateModel();
    }

    private PluginManager(Frame frame) {
        super(jEdit.getProperty("plugin-manager.title"));
        this.parent = frame;
        this.init();
    }

    private void init() {
        EditBus.addToBus(this);
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        this.tabPane = new JTabbedPane();
        this.manager = new ManagePanel(this);
        this.tabPane.addTab(jEdit.getProperty("manage-plugins.title"), this.manager);
        this.updater = new InstallPanel(this, true);
        this.tabPane.addTab(jEdit.getProperty("update-plugins.title"), this.updater);
        this.installer = new InstallPanel(this, false);
        this.tabPane.addTab(jEdit.getProperty("install-plugins.title"), this.installer);
        EditBus.addToBus(this.installer);
        jPanel.add("Center", this.tabPane);
        this.tabPane.addChangeListener(new ListUpdater());
        Box box = new Box(0);
        this.mgrOptions = new JButton(jEdit.getProperty("plugin-manager.mgr-options"));
        this.mgrOptions.addActionListener(actionEvent -> new GlobalOptions((Frame)this, "plugin-manager"));
        this.pluginOptions = new JButton(jEdit.getProperty("plugin-manager.plugin-options"));
        this.pluginOptions.addActionListener(actionEvent -> new PluginOptions(this));
        this.done = new JButton(jEdit.getProperty("plugin-manager.done"));
        this.done.addActionListener(actionEvent -> this.ok());
        box.add(Box.createGlue());
        box.add(this.mgrOptions);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.pluginOptions);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.done);
        this.getRootPane().setDefaultButton(this.done);
        jPanel.add("South", box);
        this.setDefaultCloseOperation(2);
        this.setIconImage(GUIUtilities.getPluginIcon());
        this.pack();
        GUIUtilities.loadGeometry(this, this.parent, "plugin-manager");
        GUIUtilities.addSizeSaver(this, this.parent, "plugin-manager");
        this.setVisible(true);
    }

    private boolean shouldUpdatePluginList() {
        return (this.pluginList == null || !this.pluginList.getMirrorId().equals(jEdit.getProperty("plugin-manager.mirror.id"))) && !this.downloadingPluginList;
    }

    private void updatePluginList() {
        if (jEdit.getSettingsDirectory() == null && jEdit.getJEditHome() == null) {
            GUIUtilities.error(this, "no-settings", null);
            return;
        }
        if (!this.shouldUpdatePluginList()) {
            return;
        }
        this.installer.loading();
        this.updater.loading();
        this.pluginList = new PluginList(this::pluginListUpdated);
        ThreadUtilities.runInBackground(this.pluginList);
    }

    public void checkForObsoletePlugins() {
        if (this.pluginList == null || this.pluginList.plugins == null) {
            return;
        }
        for (PluginJAR pluginJAR : jEdit.getPluginJARs()) {
            EditPlugin editPlugin = pluginJAR.getPlugin();
            if (editPlugin == null) continue;
            String string = jEdit.getProperty("plugin." + editPlugin.getClassName() + ".version");
            for (PluginList.Plugin plugin : this.pluginList.plugins) {
                if (!MiscUtilities.pathsEqual(plugin.jar, MiscUtilities.getFileName(pluginJAR.getPath()))) continue;
                PluginList.Branch object = null;
                String string2 = "0";
                for (PluginList.Branch branch : plugin.branches) {
                    if (StandardUtilities.compareStrings(branch.version, string, false) < 0 || StandardUtilities.compareStrings(branch.version, string2, false) < 0) continue;
                    string2 = branch.version;
                    object = branch;
                }
                if (object == null) continue;
                if (object.obsolete) {
                    this.disablePlugin(pluginJAR, plugin.name);
                    continue;
                }
                for (PluginList.Dependency dependency : object.deps) {
                    if (!dependency.what.equals("jedit") || dependency.to == null || StandardUtilities.compareStrings(jEdit.getBuild(), dependency.to, false) <= 0) continue;
                    this.disablePlugin(pluginJAR, plugin.name);
                }
            }
        }
    }

    private void disablePlugin(PluginJAR pluginJAR, String string) {
        Log.log(9, this, "Plugin: " + string + " is not supported on this version of jEdit! ");
        if (!jEdit.getBooleanProperty("plugin-manager.disable-obsolete", true)) {
            return;
        }
        jEdit.removePluginJAR(pluginJAR, false);
        String string2 = MiscUtilities.getFileName(pluginJAR.getPath());
        jEdit.setBooleanProperty("plugin-blacklist." + string2, true);
        jEdit.setBooleanProperty("plugin." + string2 + ".disabled", true);
        jEdit.propertiesChanged();
    }

    private void pluginListUpdated() {
        Component component = this.tabPane.getSelectedComponent();
        if (component == this.installer || component == this.updater) {
            this.installer.updateModel();
            this.updater.updateModel();
        }
        this.checkForObsoletePlugins();
    }

    public void processKeyEvents(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            this.cancel();
            keyEvent.consume();
        }
    }

    class ListUpdater
    implements ChangeListener {
        ListUpdater() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Component component = PluginManager.this.tabPane.getSelectedComponent();
            if (component == PluginManager.this.installer || component == PluginManager.this.updater) {
                PluginManager.this.updatePluginList();
            } else if (component == PluginManager.this.manager) {
                PluginManager.this.manager.update();
            }
        }
    }
}

