/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.table;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableModel;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenDownload;
import mediathek.gui.messages.DownloadQueueRankChangedEvent;
import mediathek.tool.MessageBus;
import mediathek.tool.models.TModel;
import mediathek.tool.models.TModelDownload;
import mediathek.tool.table.ASelectableMVTable;

public class MVDownloadsTable
extends ASelectableMVTable {
    private static final long serialVersionUID = 6933494912098350123L;
    private final Daten daten = Daten.getInstance();

    @Override
    protected void setupTableType() {
        this.maxSpalten = 40;
        this.spaltenAnzeigen = this.getSpaltenEinAus(DatenDownload.spaltenAnzeigen, 40);
        this.indexSpalte = 0;
        this.nrDatenSystem = MVConfig.Configs.SYSTEM_EIGENSCHAFTEN_TABELLE_DOWNLOADS;
        this.iconAnzeigenStr = MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_ICON_ANZEIGEN;
        this.iconKleinStr = MVConfig.Configs.SYSTEM_TAB_DOWNLOAD_ICON_KLEIN;
        this.setupDragnDrop();
        this.setModel(new TModelDownload());
    }

    private void setupDragnDrop() {
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setTransferHandler(new TableRowTransferHandlerDownload(this));
    }

    @Override
    public void resetTabelle() {
        for (int i = 0; i < this.maxSpalten; ++i) {
            this.resetDownloadsTab(i);
        }
        super.resetTabelle();
    }

    private void resetDownloadsTab(int i) {
        this.reihe[i] = i;
        this.breite[i] = 200;
        switch (i) {
            case 0: 
            case 1: {
                this.breite[i] = 75;
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                this.breite[i] = 50;
                break;
            }
            case 5: {
                this.breite[i] = 250;
                break;
            }
            case 2: 
            case 4: {
                this.breite[i] = 150;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                this.breite[i] = 100;
            }
        }
    }

    @Override
    protected void spaltenAusschalten() {
        for (int i = 0; i < this.maxSpalten; ++i) {
            switch (i) {
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    this.breite[i] = 0;
                }
            }
        }
    }

    private class TableRowTransferHandlerDownload
    extends TransferHandler {
        private static final long serialVersionUID = -2351971599010859779L;
        private final DataFlavor localObjectFlavor = new DataFlavor(Integer.class, "Integer Row Index");
        private final JTable table;
        private int[] transferedRows = null;

        public TableRowTransferHandlerDownload(JTable table) {
            this.table = table;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            assert (c.equals(this.table));
            this.transferedRows = this.table.getSelectedRows();
            return new DataHandler(this.table.getSelectedRow(), this.localObjectFlavor.getMimeType());
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            try {
                boolean b = info.getComponent() == this.table && info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
                this.table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
                return b;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            try {
                JTable target = (JTable)info.getComponent();
                JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
                int index = dl.getRow();
                TModel tModel = (TModel)this.table.getModel();
                int max = tModel.getRowCount();
                if (index < 0 || index > max) {
                    index = max;
                }
                target.setCursor(Cursor.getPredefinedCursor(0));
                if (this.transferedRows != null) {
                    this.reorder(index, this.transferedRows);
                    this.transferedRows = null;
                    return true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }

        private void reorder(int index, int[] rowFrom) {
            MVDownloadsTable.this.getSelected();
            TModelDownload tModel = (TModelDownload)MVDownloadsTable.this.getModel();
            for (int i = 0; i < MVDownloadsTable.this.getRowCount(); ++i) {
                DatenDownload d = (DatenDownload)((DefaultTableModel)tModel).getValueAt(MVDownloadsTable.this.convertRowIndexToModel(i), 39);
                if (d == null) continue;
                MVDownloadsTable.this.daten.getListeDownloads().remove(d);
                MVDownloadsTable.this.daten.getListeDownloads().add(d);
            }
            ArrayList<DatenDownload> liste = new ArrayList<DatenDownload>();
            for (int row : rowFrom) {
                if (index > row) {
                    --index;
                }
                DatenDownload d = (DatenDownload)((DefaultTableModel)tModel).getValueAt(MVDownloadsTable.this.convertRowIndexToModel(row), 39);
                liste.add(d);
                MVDownloadsTable.this.daten.getListeDownloads().remove(d);
            }
            MVDownloadsTable.this.daten.getListeDownloads().addAll(index, liste);
            MVDownloadsTable.this.getRowSorter().setSortKeys(null);
            MVDownloadsTable.this.setRowSorter(null);
            MVDownloadsTable.this.setAutoCreateRowSorter(true);
            MVDownloadsTable.this.setSelected();
            MessageBus.getMessageBus().publishAsync(new DownloadQueueRankChangedEvent());
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int act) {
            if (act == 2) {
                this.table.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

