/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage.decompressor;

import java.util.ArrayList;
import java.util.List;

public class SignatureParser {
    private SignatureParser() {
    }

    public static String reconstruct(String formatted, List<String> arguments) {
        int arg_index = 0;
        char[] chars = formatted.toCharArray();
        StringBuilder out = new StringBuilder();
        block3: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            out.append(c);
            switch (c) {
                case 'L': {
                    String pkg = arguments.get(arg_index);
                    if (pkg.length() > 0) {
                        out.append(pkg).append("/");
                    }
                    out.append(arguments.get(++arg_index));
                    ++arg_index;
                    continue block3;
                }
            }
        }
        return out.toString();
    }

    public static ParseResult parseSignatureDescriptor(String str) {
        ParseResult res = new ParseResult();
        char[] chars = str.toCharArray();
        StringBuilder type = null;
        StringBuilder formatted = new StringBuilder();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case ':': 
                case ';': 
                case '<': {
                    if (type != null) {
                        String fullName = type.toString();
                        int endIndex = fullName.lastIndexOf("/");
                        String clazz = fullName;
                        String pkg = "";
                        if (endIndex != -1) {
                            pkg = fullName.substring(0, endIndex);
                            clazz = fullName.substring(endIndex + 1);
                        }
                        res.types.add(pkg);
                        res.types.add(clazz);
                    }
                    formatted.append(c);
                    type = null;
                    continue block4;
                }
                case 'L': {
                    if (type == null) {
                        type = new StringBuilder();
                        formatted.append(c);
                        continue block4;
                    }
                    type.append(c);
                    continue block4;
                }
                default: {
                    if (type == null) {
                        formatted.append(c);
                        continue block4;
                    }
                    type.append(c);
                }
            }
        }
        res.formatted = formatted.toString();
        return res;
    }

    public static class ParseResult {
        public final List<String> types = new ArrayList<String>();
        public String formatted;

        private ParseResult() {
        }
    }
}

