/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.MethodSignatureHandMade;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSignatureUtil {
    public static final TObjectHashingStrategy<MethodSignatureBackedByPsiMethod> METHOD_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<MethodSignatureBackedByPsiMethod>(){

        public int computeHashCode(MethodSignatureBackedByPsiMethod signature2) {
            return signature2.getMethod().hashCode();
        }

        public boolean equals(MethodSignatureBackedByPsiMethod s1, MethodSignatureBackedByPsiMethod s2) {
            return s1.getMethod().equals(s2.getMethod());
        }
    };
    public static final TObjectHashingStrategy<MethodSignature> METHOD_PARAMETERS_ERASURE_EQUALITY = new TObjectHashingStrategy<MethodSignature>(){

        public int computeHashCode(MethodSignature signature2) {
            return signature2.hashCode();
        }

        public boolean equals(MethodSignature method1, MethodSignature method2) {
            return MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2) && MethodSignatureUtil.areErasedParametersEqual(method1, method2);
        }
    };

    private MethodSignatureUtil() {
    }

    public static boolean areOverrideEquivalent(PsiMethod method1, PsiMethod method2) {
        int typeParamsLength2;
        int typeParamsLength1 = method1.getTypeParameters().length;
        return (typeParamsLength1 == (typeParamsLength2 = method2.getTypeParameters().length) || typeParamsLength1 == 0 || typeParamsLength2 == 0) && MethodSignatureUtil.areErasedParametersEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areErasedParametersEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        if (method1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(0);
        }
        if (method2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(1);
        }
        Object[] erased1 = method1 instanceof MethodSignatureBase ? ((MethodSignatureBase)method1).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method1);
        Object[] erased2 = method2 instanceof MethodSignatureBase ? ((MethodSignatureBase)method2).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method2);
        return Arrays.equals(erased1, erased2);
    }

    public static PsiType @NotNull [] calcErasedParameterTypes(@NotNull MethodSignature signature2) {
        PsiType[] parameterTypes;
        if (signature2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(2);
        }
        if ((parameterTypes = signature2.getParameterTypes()).length == 0) {
            if (PsiType.EMPTY_ARRAY == null) {
                MethodSignatureUtil.$$$reportNull$$$0(3);
            }
            return PsiType.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor2 = signature2.getSubstitutor();
        PsiType[] erasedTypes = PsiType.createArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            erasedTypes[i] = TypeConversionUtil.erasure(parameterTypes[i], substitutor2);
        }
        if (erasedTypes == null) {
            MethodSignatureUtil.$$$reportNull$$$0(4);
        }
        return erasedTypes;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor2) {
        if (name == null) {
            MethodSignatureUtil.$$$reportNull$$$0(5);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(6);
        }
        return MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor2, false);
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor2, boolean isConstructor) {
        if (name == null) {
            MethodSignatureUtil.$$$reportNull$$$0(7);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(8);
        }
        return new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor2, isConstructor);
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, PsiType @NotNull [] parameterTypes, PsiTypeParameter @NotNull [] typeParameterList, @NotNull PsiSubstitutor substitutor2) {
        if (name == null) {
            MethodSignatureUtil.$$$reportNull$$$0(9);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(10);
        }
        if (parameterTypes == null) {
            MethodSignatureUtil.$$$reportNull$$$0(11);
        }
        if (typeParameterList == null) {
            MethodSignatureUtil.$$$reportNull$$$0(12);
        }
        return MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor2, false);
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, PsiType @NotNull [] parameterTypes, PsiTypeParameter @NotNull [] typeParameterList, @NotNull PsiSubstitutor substitutor2, boolean isConstructor) {
        if (name == null) {
            MethodSignatureUtil.$$$reportNull$$$0(13);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(14);
        }
        if (parameterTypes == null) {
            MethodSignatureUtil.$$$reportNull$$$0(15);
        }
        if (typeParameterList == null) {
            MethodSignatureUtil.$$$reportNull$$$0(16);
        }
        return new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor2, isConstructor);
    }

    public static boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(17);
        }
        if (method2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(18);
        }
        return MethodSignatureUtil.areSignaturesEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        if (method1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(19);
        }
        if (method2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(20);
        }
        if (method2 == method1) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2)) {
            return false;
        }
        return MethodSignatureUtil.checkSignaturesEqualInner(method1, method2, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method1, method2)) || MethodSignatureUtil.checkSignaturesEqualInner(method2, method1, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method2, method1));
    }

    private static boolean checkSignaturesEqualInner(@NotNull MethodSignature subSignature, @NotNull MethodSignature superSignature, PsiSubstitutor unifyingSubstitutor) {
        if (subSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(21);
        }
        if (superSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(22);
        }
        if (unifyingSubstitutor == null) {
            return false;
        }
        if (!MethodSignatureUtil.areErasedParametersEqual(subSignature, superSignature)) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type2;
            PsiType type1 = unifyingSubstitutor.substitute(subParameterTypes[i]);
            if (Comparing.equal(type1, type2 = unifyingSubstitutor.substitute(superParameterTypes[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean areSignaturesEqualLightweight(@NotNull MethodSignature sig1, @NotNull MethodSignature sig2) {
        PsiType[] parameterTypes2;
        String name2;
        String name1;
        boolean isConstructor2;
        boolean isConstructor1;
        if (sig1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(23);
        }
        if (sig2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(24);
        }
        if ((isConstructor1 = sig1.isConstructor()) != (isConstructor2 = sig2.isConstructor())) {
            return false;
        }
        if (!(isConstructor1 && (sig1 instanceof HierarchicalMethodSignature || sig2 instanceof HierarchicalMethodSignature) || (name1 = sig1.getName()).equals(name2 = sig2.getName()))) {
            return false;
        }
        PsiType[] parameterTypes1 = sig1.getParameterTypes();
        if (parameterTypes1.length != (parameterTypes2 = sig2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < parameterTypes1.length; ++i) {
            PsiType type1 = parameterTypes1[i];
            PsiType type2 = parameterTypes2[i];
            if (type1 instanceof PsiPrimitiveType != type2 instanceof PsiPrimitiveType) {
                return false;
            }
            if (!(type1 instanceof PsiPrimitiveType) || type1.equals(type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperMethod(@NotNull PsiMethod superMethodCandidate, @NotNull PsiMethod derivedMethod) {
        if (superMethodCandidate == null) {
            MethodSignatureUtil.$$$reportNull$$$0(25);
        }
        if (derivedMethod == null) {
            MethodSignatureUtil.$$$reportNull$$$0(26);
        }
        if (superMethodCandidate.hasModifierProperty("private")) {
            return false;
        }
        PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
        PsiClass derivedClass = derivedMethod.getContainingClass();
        if (derivedClass == null || superClassCandidate == null || derivedClass == superClassCandidate) {
            return false;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(superClassCandidate, derivedClass, PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return false;
        }
        MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
        MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.isSubsignature(superSignature, derivedSignature);
    }

    @Nullable
    public static PsiMethod findMethodInSuperClassBySignatureInDerived(@NotNull PsiClass aClass2, @NotNull PsiClass superClass2, @NotNull MethodSignature signature2, boolean checkDeep) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(27);
        }
        if (superClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(28);
        }
        if (signature2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(29);
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass2, aClass2, PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(superClass2, superSubstitutor, signature2, checkDeep);
    }

    @Nullable
    private static PsiMethod doFindMethodInSuperClassBySignatureInDerived(@NotNull PsiClass superClass2, @NotNull PsiSubstitutor superSubstitutor, @NotNull MethodSignature signature2, boolean checkDeep) {
        PsiClass clazz;
        PsiMethod[] methods2;
        if (superClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(30);
        }
        if (superSubstitutor == null) {
            MethodSignatureUtil.$$$reportNull$$$0(31);
        }
        if (signature2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(32);
        }
        String name = signature2.getName();
        for (PsiMethod method : methods2 = superClass2.findMethodsByName(name, false)) {
            if (!MethodSignatureUtil.isSubsignature(method.getSignature(superSubstitutor), signature2)) continue;
            return method;
        }
        if (checkDeep && (clazz = superClass2.getSuperClass()) != null && clazz != superClass2) {
            PsiSubstitutor substitutor1 = TypeConversionUtil.getSuperClassSubstitutor(clazz, superClass2, superSubstitutor);
            return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(clazz, substitutor1, signature2, true);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass2, @NotNull PsiMethod pattenMethod, boolean checkBases) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(33);
        }
        if (pattenMethod == null) {
            MethodSignatureUtil.$$$reportNull$$$0(34);
        }
        return MethodSignatureUtil.findMethodBySignature(aClass2, pattenMethod.getSignature(PsiSubstitutor.EMPTY), checkBases);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass2, @NotNull MethodSignature methodSignature, boolean checkBases) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(35);
        }
        if (methodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(36);
        }
        String name = methodSignature.isConstructor() ? aClass2.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass2.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor2 = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor2);
            if (!methodSignature.equals(foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperSignature(@NotNull PsiClass aClass2, @NotNull MethodSignature methodSignature, boolean checkBases) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(37);
        }
        if (methodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(38);
        }
        String name = methodSignature.isConstructor() ? aClass2.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass2.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor2 = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor2);
            if (!MethodSignatureUtil.isSubsignature(methodSignature, foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperMethod(@NotNull PsiClass aClass2, @NotNull PsiMethod method, boolean checkBases) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(39);
        }
        if (method == null) {
            MethodSignatureUtil.$$$reportNull$$$0(40);
        }
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass2.findMethodsAndTheirSubstitutorsByName(method.getName(), checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            MethodSignature superSignature;
            PsiSubstitutor superSubstitutor;
            PsiMethod candidate2 = (PsiMethod)pair.first;
            PsiSubstitutor substitutor2 = (PsiSubstitutor)pair.second;
            MethodSignature candidateSignature = candidate2.getSignature(substitutor2);
            PsiClass methodClass = method.getContainingClass();
            PsiClass candidateClass = candidate2.getContainingClass();
            if (methodClass == null || candidateClass == null || (superSubstitutor = TypeConversionUtil.getClassSubstitutor(methodClass, candidateClass, substitutor2)) == null || !MethodSignatureUtil.isSubsignature(superSignature = method.getSignature(superSubstitutor), candidateSignature)) continue;
            return candidate2;
        }
        return null;
    }

    public static boolean hasOverloads(@NotNull PsiMethod method) {
        if (method == null) {
            MethodSignatureUtil.$$$reportNull$$$0(41);
        }
        return MethodSignatureUtil.getOverloads(method).length > 1;
    }

    private static PsiMethod @NotNull [] getOverloads(@NotNull PsiMethod method) {
        PsiClass aClass2;
        if (method == null) {
            MethodSignatureUtil.$$$reportNull$$$0(42);
        }
        if ((aClass2 = method.getContainingClass()) == null) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                MethodSignatureUtil.$$$reportNull$$$0(43);
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = aClass2.findMethodsByName(method.getName(), false);
        if (psiMethodArray == null) {
            MethodSignatureUtil.$$$reportNull$$$0(44);
        }
        return psiMethodArray;
    }

    public static boolean areParametersErasureEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(45);
        }
        if (method2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(46);
        }
        if (method1.getParameterList().getParametersCount() != method2.getParameterList().getParametersCount()) {
            return false;
        }
        return MethodSignatureUtil.areSignaturesErasureEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesErasureEqual(@NotNull MethodSignature signature1, @NotNull MethodSignature signature2) {
        if (signature1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(47);
        }
        if (signature2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(48);
        }
        return METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)signature1, (Object)signature2);
    }

    @Nullable
    public static PsiSubstitutor getSuperMethodSignatureSubstitutor(@NotNull MethodSignature methodSignature, @NotNull MethodSignature superMethodSignature) {
        PsiTypeParameter[] superTypeParameters;
        PsiTypeParameter[] methodTypeParameters;
        if (methodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(49);
        }
        if (superMethodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(50);
        }
        if ((methodTypeParameters = methodSignature.getTypeParameters()).length != (superTypeParameters = superMethodSignature.getTypeParameters()).length) {
            return null;
        }
        PsiSubstitutor result2 = superMethodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(methodTypeParameter.getProject());
            result2 = result2.put(superTypeParameters[i], factory2.createType(methodTypeParameter));
        }
        PsiSubstitutor methodSubstitutor = methodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiTypeParameter superTypeParameter = superTypeParameters[i];
            HashSet<PsiType> methodSupers = new HashSet<PsiType>();
            for (PsiClassType methodSuper : methodTypeParameter.getSuperTypes()) {
                methodSupers.add(methodSubstitutor.substitute(methodSuper));
            }
            HashSet<PsiType> superSupers = new HashSet<PsiType>();
            for (PsiClassType superSuper : superTypeParameter.getSuperTypes()) {
                superSupers.add(methodSubstitutor.substitute(result2.substitute(superSuper)));
            }
            methodSupers.remove(PsiType.getJavaLangObject(methodTypeParameter.getManager(), methodTypeParameter.getResolveScope()));
            superSupers.remove(PsiType.getJavaLangObject(superTypeParameter.getManager(), superTypeParameter.getResolveScope()));
            if (methodSupers.equals(superSupers)) continue;
            return null;
        }
        return result2;
    }

    @NotNull
    public static PsiSubstitutor combineSubstitutors(@NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        PsiTypeParameter[] typeParameters2;
        if (substitutor1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(51);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(52);
        }
        if (substitutor1 == PsiSubstitutor.EMPTY) {
            PsiSubstitutor psiSubstitutor = substitutor2;
            if (psiSubstitutor == null) {
                MethodSignatureUtil.$$$reportNull$$$0(53);
            }
            return psiSubstitutor;
        }
        Set<PsiTypeParameter> parameters1 = substitutor1.getSubstitutionMap().keySet();
        for (PsiTypeParameter typeParameter : typeParameters2 = parameters1.toArray(PsiTypeParameter.EMPTY_ARRAY)) {
            PsiClass resolved;
            PsiType type2 = substitutor1.substitute(typeParameter);
            PsiType otherSubstituted = type2 instanceof PsiClassType ? ((resolved = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter ? substitutor2.substitute((PsiTypeParameter)resolved) : substitutor2.substitute(type2)) : substitutor2.substitute(type2);
            substitutor1 = substitutor1.put(typeParameter, otherSubstituted);
        }
        PsiSubstitutor psiSubstitutor = substitutor1;
        if (psiSubstitutor == null) {
            MethodSignatureUtil.$$$reportNull$$$0(54);
        }
        return psiSubstitutor;
    }

    public static PsiMethod @NotNull [] convertMethodSignaturesToMethods(@NotNull List<? extends MethodSignatureBackedByPsiMethod> sameNameMethodList) {
        if (sameNameMethodList == null) {
            MethodSignatureUtil.$$$reportNull$$$0(55);
        }
        PsiMethod[] methods2 = new PsiMethod[sameNameMethodList.size()];
        for (int i = 0; i < sameNameMethodList.size(); ++i) {
            methods2[i] = sameNameMethodList.get(i).getMethod();
        }
        if (methods2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(56);
        }
        return methods2;
    }

    public static boolean isSubsignature(@NotNull MethodSignature superSignature, @NotNull MethodSignature subSignature) {
        if (superSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(57);
        }
        if (subSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(58);
        }
        if (subSignature == superSignature) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(superSignature, subSignature)) {
            return false;
        }
        PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(subSignature, superSignature);
        if (MethodSignatureUtil.checkSignaturesEqualInner(superSignature, subSignature, unifyingSubstitutor)) {
            return true;
        }
        if (subSignature.getTypeParameters().length > 0) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type1 = subParameterTypes[i];
            PsiType type2 = TypeConversionUtil.erasure(superParameterTypes[i], superSignature.getSubstitutor());
            if (Comparing.equal(type1, type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isReturnTypeSubstitutable(MethodSignature d1, MethodSignature d2, PsiType r1, PsiType r2) {
        if (PsiType.VOID.equals(r1)) {
            return PsiType.VOID.equals(r2);
        }
        if (r1 instanceof PsiPrimitiveType) {
            return r1.equals(r2);
        }
        if (r1 instanceof PsiClassType && r2 != null) {
            PsiSubstitutor adaptingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(d2, d1);
            if (adaptingSubstitutor != null && r2.isAssignableFrom(adaptingSubstitutor.substitute(r1))) {
                return true;
            }
            if (!MethodSignatureUtil.areSignaturesEqual(d1, d2)) {
                return r1.equals(TypeConversionUtil.erasure(r2));
            }
        }
        return Comparing.equal(r1, r2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 43: 
            case 44: 
            case 53: 
            case 54: 
            case 56: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 43: 
            case 44: 
            case 53: 
            case 54: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 1: 
            case 18: 
            case 20: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
            case 2: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: 
            case 4: 
            case 43: 
            case 44: 
            case 53: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/MethodSignatureUtil";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterList";
                break;
            }
            case 21: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subSignature";
                break;
            }
            case 22: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignature";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sig1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sig2";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodCandidate";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedMethod";
                break;
            }
            case 27: 
            case 33: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSubstitutor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattenMethod";
                break;
            }
            case 36: 
            case 38: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSignature";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature1";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature2";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignature";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor1";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor2";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameNameMethodList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/MethodSignatureUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcErasedParameterTypes";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloads";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "combineSubstitutors";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMethodSignaturesToMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areErasedParametersEqual";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcErasedParameterTypes";
                break;
            }
            case 3: 
            case 4: 
            case 43: 
            case 44: 
            case 53: 
            case 54: 
            case 56: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createMethodSignature";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesEqual";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkSignaturesEqualInner";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesEqualLightweight";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isSuperMethod";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInSuperClassBySignatureInDerived";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doFindMethodInSuperClassBySignatureInDerived";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySignature";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySuperSignature";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySuperMethod";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasOverloads";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getOverloads";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "areParametersErasureEqual";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesErasureEqual";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMethodSignatureSubstitutor";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "combineSubstitutors";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "convertMethodSignaturesToMethods";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isSubsignature";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 43: 
            case 44: 
            case 53: 
            case 54: 
            case 56: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

