/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirEffectiveVisibility;
import org.jetbrains.kotlin.fir.FirEffectiveVisibilityImpl;
import org.jetbrains.kotlin.fir.FirEffectiveVisibilityImplKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory3;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u000e\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u0002*\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u001e*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002Jk\u0010 \u001a\u00020\u0006\"\n\b\u0000\u0010!\u0018\u0001*\u00020\"\"\b\b\u0001\u0010#*\u00020$*\u00020\u000b2$\u0010%\u001a \u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001e0&2\u0006\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010\"H\u0082\b\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "checkParameterBounds", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkSupertypes", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "findVisibilityExposure", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "Lorg/jetbrains/kotlin/fir/FirEffectiveVisibility;", "getEffectiveVisibility", "reportExposure", "E", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "P", "Lcom/intellij/psi/PsiElement;", "error", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory3;", "restrictingDeclaration", "elementVisibility", "restrictingVisibility", "source", "checkers"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration firMemberDeclaration = declaration2;
        if (firMemberDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration2, reporter, context2);
        } else if (firMemberDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration2, reporter, context2);
        } else if (firMemberDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)((Object)declaration2), reporter, context2);
        } else if (firMemberDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration2, reporter, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        this.checkSupertypes(declaration2, reporter, context2);
        this.checkParameterBounds(declaration2, reporter, context2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypes(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        FirEffectiveVisibility classVisibility = this.getEffectiveVisibility(declaration2, context2);
        if (Intrinsics.areEqual(classVisibility, FirEffectiveVisibilityImpl.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes2 = declaration2.getSuperTypeRefs();
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        for (FirTypeRef supertypeRef : supertypes2) {
            void restrictingVisibility$iv;
            void error$iv;
            void $this$reportExposure$iv;
            void source$iv;
            FirMemberDeclaration restricting;
            FirPureAbstractElement clazz;
            boolean superIsInterface;
            ConeClassLikeType supertype2;
            ConeClassLikeType coneClassLikeType;
            FirPureAbstractElement $this$coneTypeSafe$iv = supertypeRef;
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            Object object = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = object == null ? null : ((FirResolvedTypeRef)object).getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || ($this$coneTypeSafe$iv = FirHelpersKt.toRegularClass(supertype2 = coneClassLikeType, declaration2.getSession())) == null || (superIsInterface = ((FirRegularClass)(clazz = $this$coneTypeSafe$iv)).getClassKind() == ClassKind.INTERFACE) != isInterface || (restricting = this.findVisibilityExposure(supertype2, context2, classVisibility)) == null) continue;
            object = this;
            DiagnosticReporter diagnosticReporter = reporter;
            FirDiagnosticFactory3<FirSourceElement, KtTypeReference, FirEffectiveVisibility, FirMemberDeclaration, FirEffectiveVisibility> firDiagnosticFactory3 = isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS();
            FirEffectiveVisibility firEffectiveVisibility = this.getEffectiveVisibility(restricting, context2);
            FirSourceElement firSourceElement = supertypeRef.getSource();
            firSourceElement = firSourceElement == null ? declaration2.getSource() : firSourceElement;
            boolean $i$f$reportExposure = false;
            void var19_22 = source$iv;
            if (var19_22 == null) continue;
            void var20_23 = var19_22;
            boolean bl2 = false;
            boolean bl3 = false;
            void it$iv = var20_23;
            boolean bl4 = false;
            $this$reportExposure$iv.report((FirDiagnostic)error$iv.on(it$iv, classVisibility, restricting, restrictingVisibility$iv));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkParameterBounds(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        FirEffectiveVisibility classVisibility = this.getEffectiveVisibility(declaration2, context2);
        if (Intrinsics.areEqual(classVisibility, FirEffectiveVisibilityImpl.Local.INSTANCE)) {
            return;
        }
        for (FirTypeParameterRef parameter : declaration2.getTypeParameters()) {
            for (FirTypeRef bound : ((FirTypeParameter)parameter.getSymbol().getFir()).getBounds()) {
                void restrictingVisibility$iv;
                void error$iv;
                void $this$reportExposure$iv;
                void source$iv;
                Object $this$coneType$iv = bound;
                boolean $i$f$getConeType22 = false;
                Object $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeUnsafe22 = false;
                ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                if (coneKotlinType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                FirMemberDeclaration restricting = this.findVisibilityExposure(coneKotlinType, context2, classVisibility);
                if (restricting == null) continue;
                $this$coneType$iv = this;
                DiagnosticReporter $i$f$getConeType22 = reporter;
                $this$coneTypeUnsafe$iv$iv = FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND();
                FirEffectiveVisibility $i$f$coneTypeUnsafe22 = this.getEffectiveVisibility(restricting, context2);
                FirSourceElement firSourceElement = bound.getSource();
                boolean $i$f$reportExposure = false;
                void var16_18 = source$iv;
                if (var16_18 == null) continue;
                void var17_19 = var16_18;
                boolean bl = false;
                boolean bl2 = false;
                void it$iv = var17_19;
                boolean bl3 = false;
                $this$reportExposure$iv.report((FirDiagnostic)error$iv.on(it$iv, classVisibility, restricting, restrictingVisibility$iv));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeAlias(FirTypeAlias declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        FirMemberDeclaration restricting;
        ConeClassLikeType expandedType2 = FirDeclarationUtilKt.getExpandedConeType(declaration2);
        FirEffectiveVisibility typeAliasVisibility = this.getEffectiveVisibility(declaration2, context2);
        if (Intrinsics.areEqual(typeAliasVisibility, FirEffectiveVisibilityImpl.Local.INSTANCE)) {
            return;
        }
        Object object = expandedType2;
        FirMemberDeclaration firMemberDeclaration = restricting = object == null ? null : this.findVisibilityExposure((ConeKotlinType)object, context2, typeAliasVisibility);
        if (restricting != null) {
            void source$iv;
            object = this;
            DiagnosticReporter diagnosticReporter = reporter;
            FirDiagnosticFactory3<FirSourceElement, KtNamedDeclaration, FirEffectiveVisibility, FirMemberDeclaration, FirEffectiveVisibility> firDiagnosticFactory3 = FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE();
            FirEffectiveVisibility firEffectiveVisibility = this.getEffectiveVisibility(restricting, context2);
            FirSourceElement firSourceElement = declaration2.getSource();
            boolean $i$f$reportExposure = false;
            void var13_13 = source$iv;
            if (var13_13 != null) {
                void restrictingVisibility$iv;
                void error$iv;
                void $this$reportExposure$iv;
                void var14_14 = var13_13;
                boolean bl = false;
                boolean bl2 = false;
                void it$iv = var14_14;
                boolean bl3 = false;
                $this$reportExposure$iv.report((FirDiagnostic)error$iv.on(it$iv, typeAliasVisibility, restricting, restrictingVisibility$iv));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunction(FirFunction<?> declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        boolean $i$a$-let-FirExposedVisibilityDeclarationChecker$reportExposure$1$iv22;
        FirValueParameter firValueParameter;
        FirEffectiveVisibility functionVisibility = this.getEffectiveVisibility((FirMemberDeclaration)((Object)declaration2), context2);
        if (Intrinsics.areEqual(functionVisibility, FirEffectiveVisibilityImpl.Local.INSTANCE)) {
            return;
        }
        if (!(declaration2 instanceof FirConstructor)) {
            Object object;
            FirMemberDeclaration restricting;
            Object $this$coneTypeSafe$iv = declaration2.getReturnTypeRef();
            boolean $i$f$coneTypeSafe2 = false;
            boolean bl = false;
            Object object2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = object2 == null ? null : ((FirResolvedTypeRef)object2).getType();
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            FirMemberDeclaration firMemberDeclaration = restricting = (object = coneKotlinType) == null ? null : this.findVisibilityExposure((ConeKotlinType)object, context2, functionVisibility);
            if (restricting != null) {
                void source$iv;
                object = this;
                $this$coneTypeSafe$iv = reporter;
                FirDiagnosticFactory3<FirSourceElement, KtNamedDeclaration, FirEffectiveVisibility, FirMemberDeclaration, FirEffectiveVisibility> $i$f$coneTypeSafe2 = FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE();
                object2 = this.getEffectiveVisibility(restricting, context2);
                FirSourceElement firSourceElement = declaration2.getSource();
                boolean $i$f$reportExposure = false;
                firValueParameter = source$iv;
                if (firValueParameter != null) {
                    void restrictingVisibility$iv;
                    void error$iv;
                    void $this$reportExposure$iv;
                    FirValueParameter firValueParameter2 = firValueParameter;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    FirValueParameter it$iv = firValueParameter2;
                    $i$a$-let-FirExposedVisibilityDeclarationChecker$reportExposure$1$iv22 = false;
                    $this$reportExposure$iv.report((FirDiagnostic)error$iv.on(it$iv, functionVisibility, restricting, restrictingVisibility$iv));
                }
            }
        }
        Iterable $this$forEachIndexed$iv = declaration2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void restrictingVisibility$iv;
            void error$iv;
            void $this$reportExposure$iv;
            void source$iv;
            Object object;
            FirMemberDeclaration restricting;
            void valueParameter;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            firValueParameter = (FirValueParameter)item$iv;
            int i = n;
            boolean bl4 = false;
            if (i >= declaration2.getValueParameters().size()) continue;
            Object $this$coneTypeSafe$iv = valueParameter.getReturnTypeRef();
            boolean $i$f$coneTypeSafe22 = false;
            $i$a$-let-FirExposedVisibilityDeclarationChecker$reportExposure$1$iv22 = false;
            Object $i$a$-let-FirExposedVisibilityDeclarationChecker$reportExposure$1$iv22 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = $i$a$-let-FirExposedVisibilityDeclarationChecker$reportExposure$1$iv22 == null ? null : ((FirResolvedTypeRef)$i$a$-let-FirExposedVisibilityDeclarationChecker$reportExposure$1$iv22).getType();
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            if ((restricting = (object = coneKotlinType) == null ? null : this.findVisibilityExposure((ConeKotlinType)object, context2, functionVisibility)) == null) continue;
            object = this;
            $this$coneTypeSafe$iv = reporter;
            FirDiagnosticFactory3<FirSourceElement, KtParameter, FirEffectiveVisibility, FirMemberDeclaration, FirEffectiveVisibility> $i$f$coneTypeSafe22 = FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE();
            $i$a$-let-FirExposedVisibilityDeclarationChecker$reportExposure$1$iv22 = this.getEffectiveVisibility(restricting, context2);
            FirSourceElement firSourceElement = valueParameter.getSource();
            boolean $i$f$reportExposure = false;
            void var22_33 = source$iv;
            if (var22_33 == null) continue;
            void var23_34 = var22_33;
            boolean bl5 = false;
            boolean bl6 = false;
            void it$iv = var23_34;
            boolean bl7 = false;
            $this$reportExposure$iv.report((FirDiagnostic)error$iv.on(it$iv, functionVisibility, restricting, restrictingVisibility$iv));
        }
        this.checkMemberReceiver(declaration2.getReceiverTypeRef(), declaration2 instanceof FirCallableMemberDeclaration ? (FirCallableMemberDeclaration)((Object)declaration2) : null, reporter, context2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkProperty(FirProperty declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object object;
        FirMemberDeclaration restricting;
        FirEffectiveVisibility propertyVisibility = this.getEffectiveVisibility(declaration2, context2);
        if (Intrinsics.areEqual(propertyVisibility, FirEffectiveVisibilityImpl.Local.INSTANCE)) {
            return;
        }
        Object $this$coneTypeSafe$iv = declaration2.getReturnTypeRef();
        boolean $i$f$coneTypeSafe2 = false;
        boolean bl = false;
        Object object2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = object2 == null ? null : ((FirResolvedTypeRef)object2).getType();
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        FirMemberDeclaration firMemberDeclaration = restricting = (object = coneKotlinType) == null ? null : this.findVisibilityExposure((ConeKotlinType)object, context2, propertyVisibility);
        if (restricting != null) {
            void source$iv;
            object = this;
            $this$coneTypeSafe$iv = reporter;
            FirDiagnosticFactory3<FirSourceElement, KtNamedDeclaration, FirEffectiveVisibility, FirMemberDeclaration, FirEffectiveVisibility> $i$f$coneTypeSafe2 = FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE();
            object2 = this.getEffectiveVisibility(restricting, context2);
            FirSourceElement firSourceElement = declaration2.getSource();
            boolean $i$f$reportExposure = false;
            void var12_14 = source$iv;
            if (var12_14 != null) {
                void restrictingVisibility$iv;
                void error$iv;
                void $this$reportExposure$iv;
                void var13_15 = var12_14;
                boolean bl2 = false;
                boolean bl3 = false;
                void it$iv = var13_15;
                boolean bl4 = false;
                $this$reportExposure$iv.report((FirDiagnostic)error$iv.on(it$iv, propertyVisibility, restricting, restrictingVisibility$iv));
            }
        }
        this.checkMemberReceiver(declaration2.getReceiverTypeRef(), declaration2, reporter, context2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableMemberDeclaration<?> memberDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        FirTypeRef $this$coneType$iv = typeRef;
        boolean $i$f$getConeType = false;
        Object $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe2 = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeKotlinType receiverParameterType = coneKotlinType;
        FirEffectiveVisibility memberVisibility = this.getEffectiveVisibility(memberDeclaration, context2);
        if (Intrinsics.areEqual(memberVisibility, FirEffectiveVisibilityImpl.Local.INSTANCE)) {
            return;
        }
        FirMemberDeclaration restricting = this.findVisibilityExposure(receiverParameterType, context2, memberVisibility);
        if (restricting != null) {
            void source$iv;
            $this$coneTypeUnsafe$iv$iv = this;
            DiagnosticReporter $i$f$coneTypeUnsafe2 = reporter;
            FirDiagnosticFactory3<FirSourceElement, KtTypeReference, FirEffectiveVisibility, FirMemberDeclaration, FirEffectiveVisibility> firDiagnosticFactory3 = FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE();
            FirEffectiveVisibility firEffectiveVisibility = this.getEffectiveVisibility(restricting, context2);
            FirSourceElement firSourceElement = typeRef.getSource();
            boolean $i$f$reportExposure = false;
            void var14_16 = source$iv;
            if (var14_16 != null) {
                void restrictingVisibility$iv;
                void error$iv;
                void $this$reportExposure$iv;
                void var15_17 = var14_16;
                boolean bl = false;
                boolean bl2 = false;
                void it$iv = var15_17;
                boolean bl3 = false;
                $this$reportExposure$iv.report((FirDiagnostic)error$iv.on(it$iv, memberVisibility, restricting, restrictingVisibility$iv));
            }
        }
    }

    private final FirMemberDeclaration findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, FirEffectiveVisibility base) {
        Object object;
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = $this$findVisibilityExposure instanceof ConeClassLikeType ? (ConeClassLikeType)$this$findVisibilityExposure : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol == null) {
            object = null;
        } else {
            FirClassLikeSymbol<?> firClassLikeSymbol2 = firClassLikeSymbol;
            boolean bl = false;
            boolean bl2 = false;
            FirClassLikeSymbol<?> firSymbol = firClassLikeSymbol2;
            boolean bl3 = false;
            PhaseUtilsKt.ensureResolved((AbstractFirBasedSymbol)firSymbol, FirResolvePhase.Companion.getDECLARATIONS(), context2.getSession());
            object = (FirClassLikeDeclaration)firSymbol.getFir();
        }
        Object object2 = object;
        if (object2 == null) {
            return null;
        }
        Object fir = object2;
        if (fir instanceof FirMemberDeclaration) {
            object2 = this.getEffectiveVisibility((FirMemberDeclaration)fir, context2).relation(base);
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    return (FirMemberDeclaration)fir;
                }
            }
        }
        object2 = type2.getTypeArguments();
        int n = 0;
        int n2 = ((ConeTypeProjection[])object2).length;
        while (n < n2) {
            FirMemberDeclaration firMemberDeclaration;
            ConeClassLikeType coneClassLikeType3;
            Object it = object2[n];
            ++n;
            Object $this$safeAs$iv = it;
            boolean $i$f$safeAs = false;
            Object object3 = $this$safeAs$iv;
            if (!(object3 instanceof ConeClassLikeType)) {
                object3 = null;
            }
            if ((coneClassLikeType3 = (ConeClassLikeType)object3) == null || (firMemberDeclaration = this.findVisibilityExposure(coneClassLikeType3, context2, base)) == null) continue;
            FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration;
            boolean bl = false;
            boolean bl4 = false;
            FirMemberDeclaration it2 = firMemberDeclaration2;
            boolean bl5 = false;
            return it2;
        }
        return null;
    }

    public final /* synthetic */ void reportExposure(DiagnosticReporter $this$reportExposure, FirDiagnosticFactory3 error, FirMemberDeclaration restrictingDeclaration, FirEffectiveVisibility elementVisibility, FirEffectiveVisibility restrictingVisibility, FirSourceElement source) {
        boolean $i$f$reportExposure = false;
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            Intrinsics.reifiedOperationMarker(1, "E");
            $this$reportExposure.report((FirDiagnostic)error.on(it, elementVisibility, restrictingDeclaration, restrictingVisibility));
        }
    }

    private final FirEffectiveVisibility getEffectiveVisibility(FirMemberDeclaration $this$getEffectiveVisibility, CheckerContext context2) {
        return FirEffectiveVisibilityImplKt.getEffectiveVisibility($this$getEffectiveVisibility, context2.getSession(), context2.getContainingDeclarations(), context2.getSessionHolder().getScopeSession());
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirEffectiveVisibility.Permissiveness.values().length];
            nArray[FirEffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            nArray[FirEffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

