/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.fir.analysis.diagnostics.AbstractFirDiagnosticFactory;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderer;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderers;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDefaultErrorMessages;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DefaultErrorMessages$Extension;", "()V", "getMap", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap;", "Companion", "checkers"})
public final class FirDefaultErrorMessages
implements DefaultErrorMessages.Extension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FirDiagnosticFactoryToRendererMap MAP;

    @Override
    @NotNull
    public DiagnosticFactoryToRendererMap getMap() {
        return Companion.getMAP().getPsiDiagnosticMap();
    }

    static {
        FirDiagnosticFactoryToRendererMap firDiagnosticFactoryToRendererMap = new FirDiagnosticFactoryToRendererMap("FIR");
        boolean bl = false;
        boolean bl2 = false;
        FirDiagnosticFactoryToRendererMap map = firDiagnosticFactoryToRendererMap;
        boolean bl3 = false;
        map.put(FirErrors.INSTANCE.getSYNTAX(), "Syntax error");
        map.put(FirErrors.INSTANCE.getOTHER_ERROR(), "Unknown (other) error");
        map.put(FirErrors.INSTANCE.getILLEGAL_CONST_EXPRESSION(), "Illegal const expression");
        map.put(FirErrors.INSTANCE.getILLEGAL_UNDERSCORE(), "Illegal underscore");
        map.put(FirErrors.INSTANCE.getBREAK_OR_CONTINUE_OUTSIDE_A_LOOP(), "'break' and 'continue' are only allowed inside a loop");
        map.put(FirErrors.INSTANCE.getNOT_A_LOOP_LABEL(), "The label does not denote a loop");
        map.put(FirErrors.INSTANCE.getVARIABLE_EXPECTED(), "Variable expected");
        map.put(FirErrors.INSTANCE.getRETURN_NOT_ALLOWED(), "'return' is not allowed here");
        map.put(FirErrors.INSTANCE.getDELEGATION_IN_INTERFACE(), "Interfaces cannot use delegation");
        map.put(FirErrors.INSTANCE.getHIDDEN(), "Symbol {0} is invisible", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getUNRESOLVED_REFERENCE(), "Unresolved reference: {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getNULLABLE_STRING());
        map.put(FirErrors.INSTANCE.getUNRESOLVED_LABEL(), "Unresolved label");
        map.put(FirErrors.INSTANCE.getDESERIALIZATION_ERROR(), "Deserialization error");
        map.put(FirErrors.INSTANCE.getERROR_FROM_JAVA_RESOLUTION(), "Java resolution error");
        map.put(FirErrors.INSTANCE.getNO_THIS(), "'this' is not defined in this context");
        map.put(FirErrors.INSTANCE.getSUPER_IS_NOT_AN_EXPRESSION(), "Super cannot be a callee");
        map.put(FirErrors.INSTANCE.getSUPER_NOT_AVAILABLE(), "No supertypes are accessible in this context");
        map.put(FirErrors.INSTANCE.getABSTRACT_SUPER_CALL(), "Abstract member cannot be accessed directly");
        map.put(FirErrors.INSTANCE.getINSTANCE_ACCESS_BEFORE_SUPER_CALL(), "Cannot access ''{0}'' before superclass constructor has been called", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETER_AS_SUPERTYPE(), "Type parameter as supertype");
        map.put(FirErrors.INSTANCE.getENUM_AS_SUPERTYPE(), "Enum as supertype");
        map.put(FirErrors.INSTANCE.getRECURSION_IN_SUPERTYPES(), "Recursion in supertypes");
        map.put(FirErrors.INSTANCE.getNOT_A_SUPERTYPE(), "Not an immediate supertype");
        map.put(FirErrors.INSTANCE.getSUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE(), "Superclass is not accessible from interface");
        map.put(FirErrors.INSTANCE.getQUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE(), "Explicitly qualified supertype is extended by another supertype ''{0}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_INTERFACE(), "Interfaces cannot initialize supertypes");
        map.put(FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), "An interface cannot inherit from a class");
        map.put(FirErrors.INSTANCE.getCLASS_IN_SUPERTYPE_FOR_ENUM(), "Enum class cannot inherit from classes");
        map.put(FirErrors.INSTANCE.getSEALED_SUPERTYPE(), "This type is sealed, so it can be inherited by only its own nested classes or objects");
        map.put(FirErrors.INSTANCE.getSEALED_SUPERTYPE_IN_LOCAL_CLASS(), "Local class cannot extend a sealed class");
        map.put(FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), "Constructors are not allowed for objects");
        map.put(FirErrors.INSTANCE.getCONSTRUCTOR_IN_INTERFACE(), "An interface may not have a constructor");
        map.put(FirErrors.INSTANCE.getNON_PRIVATE_CONSTRUCTOR_IN_ENUM(), "Constructor must be private in enum class");
        map.put(FirErrors.INSTANCE.getNON_PRIVATE_CONSTRUCTOR_IN_SEALED(), "Constructor must be private in sealed class");
        map.put(FirErrors.INSTANCE.getCYCLIC_CONSTRUCTOR_DELEGATION_CALL(), "There's a cycle in the delegation calls chain");
        map.put(FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED(), "Primary constructor call expected");
        map.put(FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR(), "Supertype initialization is impossible without primary constructor");
        map.put(FirErrors.INSTANCE.getDELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR(), "Call to super is not allowed in enum constructor");
        map.put(FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_REQUIRED_FOR_DATA_CLASS(), "Primary constructor required for data class");
        map.put(FirErrors.INSTANCE.getEXPLICIT_DELEGATION_CALL_REQUIRED(), "Explicit 'this' or 'super' call is required. There is no constructor in superclass that can be called without arguments");
        map.put(FirErrors.INSTANCE.getSEALED_CLASS_CONSTRUCTOR_CALL(), "Sealed types cannot be instantiated");
        map.put(FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER(), "Members are not allowed in annotation class");
        map.put(FirErrors.INSTANCE.getANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT(), "Default value of annotation parameter must be a compile-time constant");
        map.put(FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR(), "Annotation class cannot be local");
        map.put(FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER(), "'val' keyword is missing on annotation parameter");
        map.put(FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER(), "An annotation parameter cannot be nullable");
        map.put(FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), "Invalid type of annotation member");
        map.put(FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER(), "An annotation parameter cannot be 'var'");
        map.put(FirErrors.INSTANCE.getNOT_AN_ANNOTATION_CLASS(), "Illegal annotation class: {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getNULLABLE_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), "{0} typealias exposes {2} in expanded type ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), "{0} function exposes its {2} return type ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), "{0} member exposes its {2} receiver type ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), "{0} property exposes its {2} type ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), "{0} function exposes its {2} parameter type ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE(), "{0} sub-interface exposes its {2} supertype ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), "{0} subclass exposes its {2} supertype ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), "{0} generic exposes its {2} parameter bound type ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_INFIX_MODIFIER(), "''infix'' modifier is inapplicable on this function: {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getREPEATED_MODIFIER(), "Repeated ''{0}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), "Modifier ''{0}'' is redundant because ''{1}'' is present", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), "Modifier ''{0}'' is deprecated in presence of ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), "Modifier ''{0}'' is incompatible with ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getNONE_APPLICABLE(), "None of the following functions are applicable: {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_CANDIDATE(), "Inapplicable candidate(s): {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER(), "''lateinit'' modifier {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getAMBIGUITY(), "Ambiguity between candidates: {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS());
        map.put(FirErrors.INSTANCE.getASSIGN_OPERATOR_AMBIGUITY(), "Ambiguity between assign operator candidates: {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS());
        map.put(FirErrors.INSTANCE.getTYPE_MISMATCH(), "Type mismatch: inferred type is {1} but {0} was expected", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getRECURSION_IN_IMPLICIT_TYPES(), "Recursion in implicit types");
        map.put(FirErrors.INSTANCE.getINFERENCE_ERROR(), "Inference error");
        map.put(FirErrors.INSTANCE.getPROJECTION_ON_NON_CLASS_TYPE_ARGUMENT(), "Projections are not allowed on type arguments of functions and properties");
        map.put(FirErrors.INSTANCE.getUPPER_BOUND_VIOLATED(), "Type argument is not within its bounds: should be subtype of ''{0}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getTYPE_ARGUMENTS_NOT_ALLOWED(), "Type arguments are not allowed for type parameters");
        map.put(FirErrors.INSTANCE.getWRONG_NUMBER_OF_TYPE_ARGUMENTS(), "{0,choice,0#No type arguments|1#One type argument|1<{0,number,integer} type arguments} expected for {1}", null, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getNO_TYPE_FOR_TYPE_PARAMETER(), "There're no types suitable for this type parameter");
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_OBJECT(), "Type parameters are not allowed for objects");
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_ENUM(), "Enum class cannot have type parameters");
        map.put(FirErrors.INSTANCE.getCONFLICTING_PROJECTION(), "Projection is conflicting with variance of the corresponding type parameter of {0}. Remove the projection or replace it with ''*''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getVARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED(), "Variance annotations are only allowed for type parameters of classes and interfaces");
        map.put(FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), "Return type of ''{0}'' is not a subtype of the return type of the overridden member ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), "Type of ''{0}'' is not a subtype of the overridden property ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), "Type of ''{0}'' doesn''t match the type of the overridden var-property ''{1}''", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getMANY_COMPANION_OBJECTS(), "Only one companion object is allowed per class");
        map.put(FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), "Conflicting overloads: {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getREDECLARATION(), "Conflicting declarations: {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getANY_METHOD_IMPLEMENTED_IN_INTERFACE(), "An interface may not implement a method of 'Any'");
        map.put(FirErrors.INSTANCE.getLOCAL_OBJECT_NOT_ALLOWED(), "Named object ''{0}'' is a singleton and cannot be local. Try to use anonymous object instead", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getLOCAL_INTERFACE_NOT_ALLOWED(), "''{0}'' is an interface so it cannot be local. Try to use anonymous object or abstract class instead", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getUNINITIALIZED_VARIABLE(), "{0} must be initialized before access", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getPROPERTY_NAME());
        map.put(FirErrors.INSTANCE.getWRONG_INVOCATION_KIND(), "{2} wrong invocation kind: given {3} case, but {4} case is possible", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getLEAKED_IN_PLACE_LAMBDA(), "Leaked in-place lambda: {2}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getWRONG_IMPLIES_CONDITION(), "Wrong implies condition");
        map.put(FirErrors.INSTANCE.getREDUNDANT_VISIBILITY_MODIFIER(), "Redundant visibility modifier");
        map.put(FirErrors.INSTANCE.getREDUNDANT_MODALITY_MODIFIER(), "Redundant modality modifier");
        map.put(FirErrors.INSTANCE.getREDUNDANT_RETURN_UNIT_TYPE(), "Redundant return 'unit' type");
        map.put(FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_TYPE(), "Redundant explicit type");
        map.put(FirErrors.INSTANCE.getREDUNDANT_SINGLE_EXPRESSION_STRING_TEMPLATE(), "Redundant string template");
        map.put(FirErrors.INSTANCE.getCAN_BE_VAL(), "'var' can be 'val'");
        map.put(FirErrors.INSTANCE.getCAN_BE_REPLACED_WITH_OPERATOR_ASSIGNMENT(), "Assignment can be replaced with operator assignment");
        map.put(FirErrors.INSTANCE.getREDUNDANT_CALL_OF_CONVERSION_METHOD(), "Redundant call of conversion method");
        map.put(FirErrors.INSTANCE.getARRAY_EQUALITY_OPERATOR_CAN_BE_REPLACED_WITH_EQUALS(), "Replace '==' with 'Arrays.equals'");
        map.put(FirErrors.INSTANCE.getEMPTY_RANGE(), "Range is empty");
        map.put(FirErrors.INSTANCE.getREDUNDANT_SETTER_PARAMETER_TYPE(), "Redundant setter parameter type");
        map.put(FirErrors.INSTANCE.getUNUSED_VARIABLE(), "Variable is unused");
        map.put(FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ(), "Assigned value is never read");
        map.put(FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT(), "Initializer is redundant");
        map.put(FirErrors.INSTANCE.getVARIABLE_NEVER_READ(), "Variable is never read");
        MAP = firDiagnosticFactoryToRendererMap;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDefaultErrorMessages$Companion;", "", "()V", "MAP", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactoryToRendererMap;", "getMAP", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactoryToRendererMap;", "getRendererForDiagnostic", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticRenderer;", "diagnostic", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirDiagnosticRenderer<?> getRendererForDiagnostic(@NotNull FirDiagnostic<?> diagnostic) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            AbstractFirDiagnosticFactory<?, ?, ?> factory2 = diagnostic.getFactory();
            FirDiagnosticRenderer<?> firDiagnosticRenderer = this.getMAP().get(factory2);
            return firDiagnosticRenderer == null ? factory2.getFirRenderer() : firDiagnosticRenderer;
        }

        @NotNull
        public final FirDiagnosticFactoryToRendererMap getMAP() {
            return MAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

