/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.latest;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.ivy.core.IvyContext;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.plugins.latest.ArtifactInfo;
import org.jetbrains.kotlin.org.apache.ivy.plugins.latest.ComparatorLatestStrategy;
import org.jetbrains.kotlin.org.apache.ivy.plugins.version.VersionMatcher;

public class LatestRevisionStrategy
extends ComparatorLatestStrategy {
    private static final Map<String, Integer> DEFAULT_SPECIAL_MEANINGS = new HashMap<String, Integer>();
    private final Comparator<ModuleRevisionId> mridComparator = new MridComparator();
    private final Comparator<ArtifactInfo> artifactInfoComparator = new ArtifactInfoComparator();
    private Map<String, Integer> specialMeanings = null;
    private boolean usedefaultspecialmeanings = true;

    public LatestRevisionStrategy() {
        this.setComparator(this.artifactInfoComparator);
        this.setName("latest-revision");
    }

    public synchronized Map<String, Integer> getSpecialMeanings() {
        if (this.specialMeanings == null) {
            this.specialMeanings = new HashMap<String, Integer>();
            if (this.isUsedefaultspecialmeanings()) {
                this.specialMeanings.putAll(DEFAULT_SPECIAL_MEANINGS);
            }
        }
        return this.specialMeanings;
    }

    public boolean isUsedefaultspecialmeanings() {
        return this.usedefaultspecialmeanings;
    }

    static {
        DEFAULT_SPECIAL_MEANINGS.put("dev", -1);
        DEFAULT_SPECIAL_MEANINGS.put("rc", 1);
        DEFAULT_SPECIAL_MEANINGS.put("final", 2);
    }

    final class ArtifactInfoComparator
    implements Comparator<ArtifactInfo> {
        ArtifactInfoComparator() {
        }

        @Override
        public int compare(ArtifactInfo o1, ArtifactInfo o2) {
            String rev1 = o1.getRevision();
            String rev2 = o2.getRevision();
            VersionMatcher vmatcher = IvyContext.getContext().getSettings().getVersionMatcher();
            ModuleRevisionId mrid1 = ModuleRevisionId.newInstance("", "", rev1);
            ModuleRevisionId mrid2 = ModuleRevisionId.newInstance("", "", rev2);
            if (vmatcher.isDynamic(mrid1)) {
                int c = vmatcher.compare(mrid1, mrid2, LatestRevisionStrategy.this.mridComparator);
                return c >= 0 ? 1 : -1;
            }
            if (vmatcher.isDynamic(mrid2)) {
                int c = vmatcher.compare(mrid2, mrid1, LatestRevisionStrategy.this.mridComparator);
                return c >= 0 ? -1 : 1;
            }
            return LatestRevisionStrategy.this.mridComparator.compare(mrid1, mrid2);
        }
    }

    final class MridComparator
    implements Comparator<ModuleRevisionId> {
        MridComparator() {
        }

        @Override
        public int compare(ModuleRevisionId o1, ModuleRevisionId o2) {
            int i;
            String rev1 = o1.getRevision();
            String rev2 = o2.getRevision();
            rev1 = rev1.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            rev1 = rev1.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            rev2 = rev2.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            rev2 = rev2.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            String[] parts1 = rev1.split("[\\._\\-\\+]");
            String[] parts2 = rev2.split("[\\._\\-\\+]");
            for (i = 0; i < parts1.length && i < parts2.length; ++i) {
                if (parts1[i].equals(parts2[i])) continue;
                boolean is1Number = this.isNumber(parts1[i]);
                boolean is2Number = this.isNumber(parts2[i]);
                if (is1Number && !is2Number) {
                    return 1;
                }
                if (is2Number && !is1Number) {
                    return -1;
                }
                if (is1Number && is2Number) {
                    return Long.valueOf(parts1[i]).compareTo(Long.valueOf(parts2[i]));
                }
                Map<String, Integer> specialMeanings = LatestRevisionStrategy.this.getSpecialMeanings();
                Integer sm1 = specialMeanings.get(parts1[i].toLowerCase(Locale.US));
                Integer sm2 = specialMeanings.get(parts2[i].toLowerCase(Locale.US));
                if (sm1 != null) {
                    if (sm2 == null) {
                        sm2 = new Integer(0);
                    }
                    return sm1.compareTo(sm2);
                }
                if (sm2 != null) {
                    return new Integer(0).compareTo(sm2);
                }
                return parts1[i].compareTo(parts2[i]);
            }
            if (i < parts1.length) {
                return this.isNumber(parts1[i]) ? 1 : -1;
            }
            if (i < parts2.length) {
                return this.isNumber(parts2[i]) ? -1 : 1;
            }
            return 0;
        }

        private boolean isNumber(String str) {
            return str.matches("\\d+");
        }
    }
}

