/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public class CodeSwitcher {
    private static final String ls = System.getProperty("line.separator", "\n");
    private Vector vList = new Vector();
    private Vector vSwitchOn = new Vector();
    private Vector vSwitchOff = new Vector();
    private Vector vSwitches = new Vector();
    private static final int MAX_LINELENGTH = 82;

    public static void main(String[] stringArray) {
        String string;
        CodeSwitcher codeSwitcher = new CodeSwitcher();
        if (stringArray.length == 0) {
            CodeSwitcher.showUsage();
            return;
        }
        File file = null;
        File file2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if (string.startsWith("+")) {
                codeSwitcher.vSwitchOn.addElement(string.substring(1));
                continue;
            }
            if (string.startsWith("--basedir=")) {
                file2 = new File(string.substring("--basedir=".length()));
                continue;
            }
            if (string.startsWith("--pathlist=")) {
                file = new File(string.substring("--pathlist=".length()));
                continue;
            }
            if (string.startsWith("-")) {
                codeSwitcher.vSwitchOff.addElement(string.substring(1));
                continue;
            }
            codeSwitcher.addDir(string);
        }
        if (file2 != null) {
            if (file == null) {
                System.err.println("--basedir= setting ignored, since only used for list files");
            } else if (!file2.isDirectory()) {
                System.err.println("Skipping listfile since basedir '" + file2.getAbsolutePath() + "' is not a directory");
                file = null;
            }
        }
        if (file != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    File file3;
                    int n = string.indexOf(35);
                    String string2 = (n > -1 ? string.substring(0, n) : string).trim();
                    if (string2.length() < 1) continue;
                    File file4 = file3 = file2 == null ? new File(string2) : new File(file2, string2);
                    if (file3.isFile()) {
                        codeSwitcher.addDir(file3);
                        continue;
                    }
                    System.err.println("Skipping non-file '" + string2.trim() + "'");
                }
            }
            catch (Exception exception) {
                System.err.println("Failed to read pathlist file '" + file.getAbsolutePath() + "'");
            }
        }
        if (codeSwitcher.size() < 1) {
            CodeSwitcher.printError("No path specified, or no specified paths qualify");
            CodeSwitcher.showUsage();
        }
        codeSwitcher.process();
        if (codeSwitcher.vSwitchOff.size() == 0 && codeSwitcher.vSwitchOn.size() == 0) {
            codeSwitcher.printSwitches();
        }
    }

    public int size() {
        return this.vList == null ? 0 : this.vList.size();
    }

    static void showUsage() {
        System.out.print("Usage: java CodeSwitcher paths|{--pathlist=listfile} [{+|-}label...] [+][-]\nIf no labels are specified then all used\nlabels in the source code are shown.\nUse +MODE to switch on the things labeld MODE\nUse -MODE to switch off the things labeld MODE\nPath: Any number of path or files may be\nspecified. Use . for the current directory\n(including sub-directories).\nExample: java CodeSwitcher +JAVA2 .\nThis example switches on code labeled JAVA2\nin all *.java files in the current directory\nand all subdirectories.\n");
    }

    CodeSwitcher() {
    }

    void process() {
        int n = this.vList.size();
        for (int i = 0; i < n; ++i) {
            System.out.print(".");
            String string = (String)this.vList.elementAt(i);
            if (this.processFile(string)) continue;
            System.out.println("in file " + string + " !");
        }
        System.out.println("");
    }

    void printSwitches() {
        System.out.println("Used labels:");
        for (int i = 0; i < this.vSwitches.size(); ++i) {
            System.out.println((String)this.vSwitches.elementAt(i));
        }
    }

    void addDir(String string) {
        this.addDir(new File(string));
    }

    void addDir(File file) {
        if (file.isFile() && file.getName().endsWith(".java")) {
            this.vList.addElement(file.getPath());
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                this.addDir(fileArray[i]);
            }
        }
    }

    boolean processFile(String string) {
        File file = new File(string);
        File file2 = new File(string + ".new");
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object;
            String string2;
            int n2;
            Vector vector = CodeSwitcher.getFileLines(file);
            Vector vector2 = new Vector(vector.size());
            for (n2 = 0; n2 < vector.size(); ++n2) {
                vector2.addElement(vector.elementAt(n2));
            }
            for (n2 = 0; n2 < vector.size() && (string2 = (String)vector.elementAt(n2)) != null; ++n2) {
                if (bl2 && (string2.equals("/*") || string2.equals("*/"))) {
                    vector.removeElementAt(n2--);
                    continue;
                }
                if (!string2.startsWith("//#")) continue;
                if (string2.startsWith("//#ifdef ")) {
                    if (n != 0) {
                        CodeSwitcher.printError("'#ifdef' not allowed inside '#ifdef'");
                        return false;
                    }
                    n = 1;
                    object = string2.substring(9);
                    if (this.vSwitchOn.indexOf(object) != -1) {
                        bl2 = true;
                        bl = false;
                    } else if (this.vSwitchOff.indexOf(object) != -1) {
                        bl2 = true;
                        vector.insertElementAt("/*", ++n2);
                        bl = true;
                    }
                    if (this.vSwitches.indexOf(object) != -1) continue;
                    this.vSwitches.addElement(object);
                    continue;
                }
                if (string2.startsWith("//#ifndef ")) {
                    if (n != 0) {
                        CodeSwitcher.printError("'#ifndef' not allowed inside '#ifdef'");
                        return false;
                    }
                    n = 1;
                    object = string2.substring(10);
                    if (this.vSwitchOff.indexOf(object) != -1) {
                        bl2 = true;
                        bl = false;
                    } else if (this.vSwitchOn.indexOf(object) != -1) {
                        bl2 = true;
                        vector.insertElementAt("/*", ++n2);
                        bl = true;
                    }
                    if (this.vSwitches.indexOf(object) != -1) continue;
                    this.vSwitches.addElement(object);
                    continue;
                }
                if (string2.startsWith("//#else")) {
                    if (n != 1) {
                        CodeSwitcher.printError("'#else' without '#ifdef'");
                        return false;
                    }
                    n = 2;
                    if (!bl2) continue;
                    if (bl) {
                        if (vector.elementAt(n2 - 1).equals("")) {
                            vector.insertElementAt("*/", n2 - 1);
                            ++n2;
                        } else {
                            vector.insertElementAt("*/", n2++);
                        }
                        bl = false;
                        continue;
                    }
                    vector.insertElementAt("/*", ++n2);
                    bl = true;
                    continue;
                }
                if (!string2.startsWith("//#endif")) continue;
                if (n == 0) {
                    CodeSwitcher.printError("'#endif' without '#ifdef'");
                    return false;
                }
                n = 0;
                if (bl2 && bl) {
                    if (vector.elementAt(n2 - 1).equals("")) {
                        vector.insertElementAt("*/", n2 - 1);
                        ++n2;
                    } else {
                        vector.insertElementAt("*/", n2++);
                    }
                }
                bl2 = false;
            }
            if (n != 0) {
                CodeSwitcher.printError("'#endif' missing");
                return false;
            }
            n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                if (vector2.elementAt(i).equals(vector.elementAt(i))) continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                return true;
            }
            CodeSwitcher.writeFileLines(vector, file2);
            File file3 = new File(string + ".bak");
            file3.delete();
            file.renameTo(file3);
            object = new File(string);
            file2.renameTo((File)object);
            file3.delete();
            return true;
        }
        catch (Exception exception) {
            CodeSwitcher.printError(exception.toString());
            return false;
        }
    }

    static Vector getFileLines(File file) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        Vector<String> vector = new Vector<String>();
        while ((string = lineNumberReader.readLine()) != null) {
            vector.addElement(string);
        }
        lineNumberReader.close();
        return vector;
    }

    static void writeFileLines(Vector vector, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        for (int i = 0; i < vector.size(); ++i) {
            fileWriter.write((String)vector.elementAt(i));
            fileWriter.write(ls);
        }
        fileWriter.flush();
        fileWriter.close();
    }

    static void printError(String string) {
        System.out.println("");
        System.out.println("ERROR: " + string);
    }
}

