/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record Version(int major, int minor, int patch) {
    private static final Version INVALID_VERSION = new Version(0, 0, 0);
    private static final Logger logger = LogManager.getLogger();

    public static Version fromString(String versionsstring) {
        Version result;
        String[] versions = versionsstring.replaceAll("-SNAPSHOT", "").split("\\.");
        if (versions.length == 3) {
            try {
                result = new Version(Integer.parseInt(versions[0]), Integer.parseInt(versions[1]), Integer.parseInt(versions[2]));
            }
            catch (NumberFormatException ex) {
                logger.error("Fehler beim Parsen der Version: {}", (Object)versionsstring, (Object)ex);
                result = INVALID_VERSION;
            }
        } else {
            result = INVALID_VERSION;
        }
        return result;
    }

    public boolean isInvalid() {
        return this.equals(INVALID_VERSION);
    }

    public boolean isOlderThan(Version other) {
        return other.toNumber() > this.toNumber();
    }

    private int toNumber() {
        return this.major * 100 + this.minor * 10 + this.patch;
    }

    @Override
    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }
}

