/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ImportHandler;
import javax.el.ValueExpression;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.el.ELContextImpl;
import org.apache.jasper.el.ExpressionEvaluatorImpl;
import org.apache.jasper.el.VariableResolverImpl;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.JspContextWrapper;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspSourceImports;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ProtectedFunctionMapper;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;
import org.apache.jasper.security.SecurityUtil;

public class PageContextImpl
extends PageContext {
    private static final JspFactory jspf = JspFactory.getDefaultFactory();
    private BodyContentImpl[] outs = new BodyContentImpl[0];
    private int depth = -1;
    private Servlet servlet;
    private ServletConfig config;
    private ServletContext context;
    private JspApplicationContextImpl applicationContext;
    private String errorPageURL;
    private final transient HashMap<String, Object> attributes = new HashMap(16);
    private transient ServletRequest request;
    private transient ServletResponse response;
    private transient HttpSession session;
    private transient ELContextImpl elContext;
    private boolean isIncluded;
    private transient JspWriter out;
    private transient JspWriterImpl baseOut;

    PageContextImpl() {
    }

    public void initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IOException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.errorPageURL = string;
        this.request = servletRequest;
        this.response = servletResponse;
        this.applicationContext = JspApplicationContextImpl.getInstance(this.context);
        if (servletRequest instanceof HttpServletRequest && bl) {
            this.session = ((HttpServletRequest)servletRequest).getSession();
        }
        if (bl && this.session == null) {
            throw new IllegalStateException("Page needs a session and none is available");
        }
        this.depth = -1;
        if (n == -1) {
            n = 8192;
        }
        if (this.baseOut == null) {
            this.baseOut = new JspWriterImpl(servletResponse, n, bl2);
        } else {
            this.baseOut.init(servletResponse, n, bl2);
        }
        this.out = this.baseOut;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", servletRequest);
        this.setAttribute("javax.servlet.jsp.jspResponse", servletResponse);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
        this.isIncluded = servletRequest.getAttribute("javax.servlet.include.servlet_path") != null;
    }

    public void release() {
        this.out = this.baseOut;
        try {
            if (this.isIncluded) {
                ((JspWriterImpl)this.out).flushBuffer();
            } else {
                ((JspWriterImpl)this.out).flushBuffer();
            }
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException(Localizer.getMessage("jsp.error.flush"), iOException);
            throw illegalStateException;
        }
        finally {
            this.servlet = null;
            this.config = null;
            this.context = null;
            this.applicationContext = null;
            this.elContext = null;
            this.errorPageURL = null;
            this.request = null;
            this.response = null;
            this.depth = -1;
            this.baseOut.recycle();
            this.session = null;
            this.attributes.clear();
            for (BodyContentImpl bodyContentImpl : this.outs) {
                bodyContentImpl.recycle();
            }
        }
    }

    public Object getAttribute(final String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return PageContextImpl.this.doGetAttribute(string);
                }
            });
        }
        return this.doGetAttribute(string);
    }

    private Object doGetAttribute(String string) {
        return this.attributes.get(string);
    }

    public Object getAttribute(final String string, final int n) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return PageContextImpl.this.doGetAttribute(string, n);
                }
            });
        }
        return this.doGetAttribute(string, n);
    }

    private Object doGetAttribute(String string, int n) {
        switch (n) {
            case 1: {
                return this.attributes.get(string);
            }
            case 2: {
                return this.request.getAttribute(string);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                }
                return this.session.getAttribute(string);
            }
            case 4: {
                return this.context.getAttribute(string);
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    public void setAttribute(final String string, final Object object) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PageContextImpl.this.doSetAttribute(string, object);
                    return null;
                }
            });
        } else {
            this.doSetAttribute(string, object);
        }
    }

    private void doSetAttribute(String string, Object object) {
        if (object != null) {
            this.attributes.put(string, object);
        } else {
            this.removeAttribute(string, 1);
        }
    }

    public void setAttribute(final String string, final Object object, final int n) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PageContextImpl.this.doSetAttribute(string, object, n);
                    return null;
                }
            });
        } else {
            this.doSetAttribute(string, object, n);
        }
    }

    private void doSetAttribute(String string, Object object, int n) {
        block8: {
            block7: {
                if (object == null) break block7;
                switch (n) {
                    case 1: {
                        this.attributes.put(string, object);
                        break block8;
                    }
                    case 2: {
                        this.request.setAttribute(string, object);
                        break block8;
                    }
                    case 3: {
                        if (this.session == null) {
                            throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                        }
                        this.session.setAttribute(string, object);
                        break block8;
                    }
                    case 4: {
                        this.context.setAttribute(string, object);
                        break block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid scope");
                    }
                }
            }
            this.removeAttribute(string, n);
        }
    }

    public void removeAttribute(final String string, final int n) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PageContextImpl.this.doRemoveAttribute(string, n);
                    return null;
                }
            });
        } else {
            this.doRemoveAttribute(string, n);
        }
    }

    private void doRemoveAttribute(String string, int n) {
        switch (n) {
            case 1: {
                this.attributes.remove(string);
                break;
            }
            case 2: {
                this.request.removeAttribute(string);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                }
                this.session.removeAttribute(string);
                break;
            }
            case 4: {
                this.context.removeAttribute(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope");
            }
        }
    }

    public int getAttributesScope(final String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    return PageContextImpl.this.doGetAttributeScope(string);
                }
            });
        }
        return this.doGetAttributeScope(string);
    }

    private int doGetAttributeScope(String string) {
        if (this.attributes.get(string) != null) {
            return 1;
        }
        if (this.request.getAttribute(string) != null) {
            return 2;
        }
        if (this.session != null) {
            try {
                if (this.session.getAttribute(string) != null) {
                    return 3;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.context.getAttribute(string) != null) {
            return 4;
        }
        return 0;
    }

    public Object findAttribute(final String string) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (string == null) {
                        throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
                    }
                    return PageContextImpl.this.doFindAttribute(string);
                }
            });
        }
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        return this.doFindAttribute(string);
    }

    private Object doFindAttribute(String string) {
        Object object = this.attributes.get(string);
        if (object != null) {
            return object;
        }
        object = this.request.getAttribute(string);
        if (object != null) {
            return object;
        }
        if (this.session != null) {
            try {
                object = this.session.getAttribute(string);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (object != null) {
                return object;
            }
        }
        return this.context.getAttribute(string);
    }

    public Enumeration<String> getAttributeNamesInScope(final int n) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Enumeration<String>>(){

                @Override
                public Enumeration<String> run() {
                    return PageContextImpl.this.doGetAttributeNamesInScope(n);
                }
            });
        }
        return this.doGetAttributeNamesInScope(n);
    }

    private Enumeration<String> doGetAttributeNamesInScope(int n) {
        switch (n) {
            case 1: {
                return Collections.enumeration(this.attributes.keySet());
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                }
                return this.session.getAttributeNames();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    public void removeAttribute(final String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PageContextImpl.this.doRemoveAttribute(string);
                    return null;
                }
            });
        } else {
            this.doRemoveAttribute(string);
        }
    }

    private void doRemoveAttribute(String string) {
        this.removeAttribute(string, 1);
        this.removeAttribute(string, 2);
        if (this.session != null) {
            try {
                this.removeAttribute(string, 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.removeAttribute(string, 4);
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        Throwable throwable = JspRuntimeLibrary.getThrowable(this.request);
        if (throwable != null && !(throwable instanceof Exception)) {
            throwable = new JspException(throwable);
        }
        return (Exception)throwable;
    }

    public Object getPage() {
        return this.servlet;
    }

    private final String getAbsolutePathRelativeToContext(String string) {
        String string2 = string;
        if (!string2.startsWith("/")) {
            String string3 = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            if (string3 == null) {
                string3 = ((HttpServletRequest)this.request).getServletPath();
            }
            String string4 = string3.substring(0, string3.lastIndexOf(47));
            string2 = string4 + '/' + string2;
        }
        return string2;
    }

    public void include(String string) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, string, this.out, true);
    }

    public void include(final String string, final boolean bl) throws ServletException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        PageContextImpl.this.doInclude(string, bl);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw (ServletException)((Object)exception);
            }
        } else {
            this.doInclude(string, bl);
        }
    }

    private void doInclude(String string, boolean bl) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, string, this.out, bl);
    }

    @Deprecated
    public VariableResolver getVariableResolver() {
        return new VariableResolverImpl(this.getELContext());
    }

    public void forward(final String string) throws ServletException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        PageContextImpl.this.doForward(string);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw (ServletException)((Object)exception);
            }
        } else {
            this.doForward(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doForward(String string) throws ServletException, IOException {
        try {
            this.out.clear();
            this.baseOut.clear();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.attempt_to_clear_flushed_buffer"), iOException);
        }
        while (this.response instanceof ServletResponseWrapperInclude) {
            this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
        }
        String string2 = this.getAbsolutePathRelativeToContext(string);
        String string3 = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
        if (string3 != null) {
            this.request.removeAttribute("javax.servlet.include.servlet_path");
        }
        try {
            this.context.getRequestDispatcher(string2).forward(this.request, this.response);
        }
        finally {
            if (string3 != null) {
                this.request.setAttribute("javax.servlet.include.servlet_path", (Object)string3);
            }
        }
    }

    public BodyContent pushBody() {
        return (BodyContent)this.pushBody(null);
    }

    public JspWriter pushBody(Writer writer) {
        ++this.depth;
        if (this.depth >= this.outs.length) {
            BodyContentImpl[] bodyContentImplArray = new BodyContentImpl[this.depth + 1];
            for (int i = 0; i < this.outs.length; ++i) {
                bodyContentImplArray[i] = this.outs[i];
            }
            bodyContentImplArray[this.depth] = new BodyContentImpl(this.out);
            this.outs = bodyContentImplArray;
        }
        this.outs[this.depth].setWriter(writer);
        this.out = this.outs[this.depth];
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.outs[this.depth];
    }

    public JspWriter popBody() {
        --this.depth;
        this.out = this.depth >= 0 ? this.outs[this.depth] : this.baseOut;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.out;
    }

    @Deprecated
    public ExpressionEvaluator getExpressionEvaluator() {
        return new ExpressionEvaluatorImpl(this.applicationContext.getExpressionFactory());
    }

    public void handlePageException(Exception exception) throws IOException, ServletException {
        this.handlePageException((Throwable)exception);
    }

    public void handlePageException(final Throwable throwable) throws IOException, ServletException {
        if (throwable == null) {
            throw new NullPointerException("null Throwable");
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        PageContextImpl.this.doHandlePageException(throwable);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw (ServletException)((Object)exception);
            }
        } else {
            this.doHandlePageException(throwable);
        }
    }

    private void doHandlePageException(Throwable throwable) throws IOException, ServletException {
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            this.request.setAttribute("javax.servlet.jsp.jspException", (Object)throwable);
            this.request.setAttribute("javax.servlet.error.status_code", (Object)500);
            this.request.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)this.request).getRequestURI());
            this.request.setAttribute("javax.servlet.error.servlet_name", (Object)this.config.getServletName());
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException illegalStateException) {
                this.include(this.errorPageURL);
            }
            Object object = this.request.getAttribute("javax.servlet.error.exception");
            if (object != null && object == throwable) {
                this.request.removeAttribute("javax.servlet.error.exception");
            }
        } else {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            Throwable throwable2 = null;
            if (throwable instanceof JspException || throwable instanceof javax.el.ELException || throwable instanceof ELException) {
                throwable2 = throwable.getCause();
            }
            if (throwable2 != null) {
                throw new ServletException(throwable.getClass().getName() + ": " + throwable.getMessage(), throwable2);
            }
            throw new ServletException(throwable);
        }
        this.request.removeAttribute("javax.servlet.error.status_code");
        this.request.removeAttribute("javax.servlet.error.request_uri");
        this.request.removeAttribute("javax.servlet.error.servlet_name");
        this.request.removeAttribute("javax.servlet.jsp.jspException");
    }

    public static Object proprietaryEvaluate(String string, Class<?> clazz, PageContext pageContext, ProtectedFunctionMapper protectedFunctionMapper) throws javax.el.ELException {
        ExpressionFactory expressionFactory = jspf.getJspApplicationContext(pageContext.getServletContext()).getExpressionFactory();
        ELContext eLContext = pageContext.getELContext();
        ELContextImpl eLContextImpl = eLContext instanceof JspContextWrapper.ELContextWrapper ? (ELContextImpl)((JspContextWrapper.ELContextWrapper)eLContext).getWrappedELContext() : (ELContextImpl)eLContext;
        eLContextImpl.setFunctionMapper(protectedFunctionMapper);
        ValueExpression valueExpression = expressionFactory.createValueExpression(eLContext, string, clazz);
        return valueExpression.getValue(eLContext);
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = this.applicationContext.createELContext((JspContext)this);
            if (this.servlet instanceof JspSourceImports) {
                Object object;
                Object object2;
                ImportHandler importHandler = this.elContext.getImportHandler();
                Set<String> set = ((JspSourceImports)this.servlet).getPackageImports();
                if (set != null) {
                    object2 = set.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        importHandler.importPackage((String)object);
                    }
                }
                if ((object2 = ((JspSourceImports)this.servlet).getClassImports()) != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        importHandler.importClass(string);
                    }
                }
            }
        }
        return this.elContext;
    }
}

