/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.swing.text.Position;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.Log;

class PositionManager {
    boolean iteration;
    private final JEditBuffer buffer;
    private final SortedMap<PosBottomHalf, PosBottomHalf> positions = new TreeMap<PosBottomHalf, PosBottomHalf>();

    public PositionManager(JEditBuffer jEditBuffer) {
        this.buffer = jEditBuffer;
    }

    public synchronized Position createPosition(int n) {
        PosBottomHalf posBottomHalf = new PosBottomHalf(n);
        PosBottomHalf posBottomHalf2 = (PosBottomHalf)this.positions.get(posBottomHalf);
        if (posBottomHalf2 == null) {
            this.positions.put(posBottomHalf, posBottomHalf);
            posBottomHalf2 = posBottomHalf;
        }
        return new PosTopHalf(posBottomHalf2);
    }

    public synchronized void contentInserted(int n, int n2) {
        if (this.positions.isEmpty()) {
            return;
        }
        Iterator<PosBottomHalf> iterator = this.positions.tailMap(new PosBottomHalf(n)).keySet().iterator();
        this.iteration = true;
        while (iterator.hasNext()) {
            iterator.next().contentInserted(n, n2);
        }
        this.iteration = false;
    }

    public synchronized void contentRemoved(int n, int n2) {
        if (this.positions.isEmpty()) {
            return;
        }
        Iterator<PosBottomHalf> iterator = this.positions.tailMap(new PosBottomHalf(n)).keySet().iterator();
        this.iteration = true;
        while (iterator.hasNext()) {
            iterator.next().contentRemoved(n, n2);
        }
        this.iteration = false;
    }

    class PosBottomHalf
    implements Comparable<PosBottomHalf> {
        int offset;
        int ref;

        PosBottomHalf(int n) {
            this.offset = n;
        }

        void ref() {
            ++this.ref;
        }

        void unref() {
            if (--this.ref == 0) {
                PositionManager.this.positions.remove(this);
            }
        }

        void contentInserted(int n, int n2) {
            if (n > this.offset) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.offset += n2;
            this.checkInvariants();
        }

        void contentRemoved(int n, int n2) {
            if (n > this.offset) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.offset = this.offset <= n + n2 ? n : (this.offset -= n2);
            this.checkInvariants();
        }

        public boolean equals(Object object) {
            if (!(object instanceof PosBottomHalf)) {
                return false;
            }
            return ((PosBottomHalf)object).offset == this.offset;
        }

        @Override
        public int compareTo(@Nonnull PosBottomHalf posBottomHalf) {
            if (PositionManager.this.iteration) {
                Log.log(9, this, "Consistency failure");
            }
            return this.offset - posBottomHalf.offset;
        }

        private void checkInvariants() {
            if (this.offset < 0 || this.offset > PositionManager.this.buffer.getLength()) {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    class PosTopHalf
    implements Position {
        final PosBottomHalf bh;

        PosTopHalf(PosBottomHalf posBottomHalf) {
            this.bh = posBottomHalf;
            posBottomHalf.ref();
        }

        @Override
        public int getOffset() {
            return this.bh.offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            PositionManager positionManager = PositionManager.this;
            synchronized (positionManager) {
                this.bh.unref();
            }
        }
    }
}

