/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetListEntry;
import org.openstreetmap.josm.tools.GBC;

public class MultiSelect
extends ComboMultiSelect {
    public short rows;
    protected ConcatenatingJList list;

    @Override
    protected void addToPanelAnchor(JPanel p, String def, boolean presetInitiallyMatches) {
        this.list = new ConcatenatingJList(this.delimiter, this.presetListEntries.toArray(new PresetListEntry[0]));
        this.component = this.list;
        ListCellRenderer<PresetListEntry> renderer = this.getListCellRenderer();
        this.list.setCellRenderer(renderer);
        this.list.setSelectedItem(this.getItemToSelect(def, presetInitiallyMatches, true));
        JScrollPane sp = new JScrollPane(this.list);
        if (this.rows > 0) {
            double height = renderer.getListCellRendererComponent(this.list, new PresetListEntry("x"), 0, false, false).getPreferredSize().getHeight() * (double)this.rows;
            sp.setPreferredSize(new Dimension((int)sp.getPreferredSize().getWidth(), (int)height));
        }
        p.add((Component)sp, GBC.eol().fill(2));
    }

    @Override
    protected Object getSelectedItem() {
        return this.list.getSelectedItem();
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
        if (this.list.isEnabled()) {
            super.addCommands(changedTags);
        }
    }

    private static class ConcatenatingJList
    extends JList<PresetListEntry> {
        private final char delimiter;

        protected ConcatenatingJList(char del, PresetListEntry ... o) {
            super(o);
            this.delimiter = del;
        }

        public void setSelectedItem(Object o) {
            if (o == null) {
                this.clearSelection();
            } else {
                String s = o.toString();
                TreeSet<String> parts = new TreeSet<String>(Arrays.asList(s.split(String.valueOf(this.delimiter), -1)));
                ListModel lm = this.getModel();
                int[] intParts = new int[lm.getSize()];
                int j = 0;
                for (int i = 0; i < lm.getSize(); ++i) {
                    String value = ((PresetListEntry)lm.getElementAt((int)i)).value;
                    if (!parts.contains(value)) continue;
                    intParts[j++] = i;
                    parts.remove(value);
                }
                this.setSelectedIndices(Arrays.copyOf(intParts, j));
                this.setEnabled(parts.isEmpty());
            }
        }

        public String getSelectedItem() {
            ListModel lm = this.getModel();
            int[] si = this.getSelectedIndices();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < si.length; ++i) {
                if (i > 0) {
                    builder.append(this.delimiter);
                }
                builder.append(((PresetListEntry)lm.getElementAt((int)si[i])).value);
            }
            return builder.toString();
        }
    }
}

