/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.memory.AllocTableView;
import org.netbeans.lib.profiler.ui.memory.AllocTreeTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTableView;
import org.netbeans.lib.profiler.ui.memory.LivenessTreeTableView;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.memory.SampledTableView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class SnapshotMemoryView
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String COMPARE_SNAPSHOTS = messages.getString("SnapshotMemoryView_CompareSnapshots");
    private static final String RESET_COMPARE_SNAPSHOTS = messages.getString("SnapshotMemoryView_ResetCompareSnapshots");
    private final MemoryView dataView;
    private int aggregation;
    private final GenericFilter filter;
    private final MemoryResultsSnapshot snapshot;
    private MemoryResultsSnapshot refSnapshot;
    private JToggleButton compareButton;

    public SnapshotMemoryView(MemoryResultsSnapshot memoryResultsSnapshot, GenericFilter genericFilter, Action action, final Action action2, Action action3, ExportUtils.Exportable exportable) {
        this.filter = genericFilter;
        this.snapshot = memoryResultsSnapshot;
        MemoryView.userFormClassNames(memoryResultsSnapshot);
        this.setLayout(new BorderLayout());
        this.dataView = memoryResultsSnapshot instanceof SampledMemoryResultsSnapshot ? new SampledTableView(null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                SnapshotMemoryView.this.populatePopup(this, jPopupMenu, object, sourceCodeSelection);
            }
        } : (memoryResultsSnapshot instanceof AllocMemoryResultsSnapshot ? (memoryResultsSnapshot.containsStacks() ? new AllocTreeTableView(null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                SnapshotMemoryView.this.populatePopup(this, jPopupMenu, object, sourceCodeSelection);
            }
        } : new AllocTableView(null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                SnapshotMemoryView.this.populatePopup(this, jPopupMenu, object, sourceCodeSelection);
            }
        }) : (memoryResultsSnapshot instanceof LivenessMemoryResultsSnapshot ? (memoryResultsSnapshot.containsStacks() ? new LivenessTreeTableView(null, genericFilter == null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                SnapshotMemoryView.this.populatePopup(this, jPopupMenu, object, sourceCodeSelection);
            }
        } : new LivenessTableView(null, genericFilter == null){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (SnapshotMemoryView.this.showSourceSupported()) {
                    SnapshotMemoryView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                SnapshotMemoryView.this.populatePopup(this, jPopupMenu, object, sourceCodeSelection);
            }
        }) : null));
        ProfilerToolbar profilerToolbar = ProfilerToolbar.create(true);
        if (action != null) {
            profilerToolbar.add(action);
        }
        profilerToolbar.add(ExportUtils.exportButton(this, MemoryView.EXPORT_TOOLTIP, this.getExportables(exportable)));
        if (action2 != null) {
            profilerToolbar.addSpace(2);
            profilerToolbar.addSeparator();
            profilerToolbar.addSpace(2);
            Icon icon = (Icon)action2.getValue("SmallIcon");
            this.compareButton = new JToggleButton(icon){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    boolean bl = this.isSelected();
                    if (bl) {
                        action2.actionPerformed(actionEvent);
                        if (SnapshotMemoryView.this.refSnapshot == null) {
                            this.setSelected(false);
                        }
                    } else {
                        SnapshotMemoryView.this.setRefSnapshot(null);
                    }
                    this.setToolTipText(this.isSelected() ? RESET_COMPARE_SNAPSHOTS : COMPARE_SNAPSHOTS);
                }
            };
            this.compareButton.setToolTipText(COMPARE_SNAPSHOTS);
            profilerToolbar.add(this.compareButton);
        }
        if (action3 != null) {
            profilerToolbar.addFiller();
            profilerToolbar.add(action3);
        }
        if (this.dataView != null) {
            this.add((Component)this.dataView, "Center");
        }
        this.add((Component)profilerToolbar.getComponent(), "North");
        this.setAggregation(1);
        this.registerActions();
    }

    private void registerActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotMemoryView.this.dataView.activateFilter();
            }
        });
        actionMap.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotMemoryView.this.dataView.activateSearch();
            }
        });
    }

    public void setRefSnapshot(MemoryResultsSnapshot memoryResultsSnapshot) {
        MemoryView.userFormClassNames(memoryResultsSnapshot);
        this.refSnapshot = memoryResultsSnapshot;
        if (this.compareButton != null && memoryResultsSnapshot != null) {
            this.compareButton.setSelected(true);
            this.compareButton.setToolTipText(RESET_COMPARE_SNAPSHOTS);
        }
        this.setAggregation(this.aggregation);
    }

    protected boolean profileMethodSupported() {
        return true;
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    private void profileMethod(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(sourceCodeSelection);
    }

    private void profileClass(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(sourceCodeSelection.getClassName(), "*", null));
    }

    static boolean isSelectable(ClientUtils.SourceCodeSelection sourceCodeSelection, boolean bl) {
        String string = sourceCodeSelection.getClassName();
        String string2 = sourceCodeSelection.getMethodName();
        if (bl && string2.endsWith("[native]")) {
            return false;
        }
        return !"org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(string) || !"traceVMObjectAlloc".equals(string2);
    }

    private void populatePopup(final DataView dataView, JPopupMenu jPopupMenu, Object object, final ClientUtils.SourceCodeSelection sourceCodeSelection) {
        JMenuItem[] jMenuItemArray;
        if (this.showSourceSupported()) {
            jPopupMenu.add(new JMenuItem(MemoryView.ACTION_GOTOSOURCE){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null && SnapshotMemoryView.this.aggregation != 2);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SnapshotMemoryView.this.showSource(sourceCodeSelection);
                }
            });
            jPopupMenu.addSeparator();
        }
        if (this.profileMethodSupported() && (sourceCodeSelection == null || !"*".equals(sourceCodeSelection.getMethodName()))) {
            jPopupMenu.add(new JMenuItem(MemoryView.ACTION_PROFILE_METHOD){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null && SnapshotMemoryView.isSelectable(sourceCodeSelection, true));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SnapshotMemoryView.this.profileMethod(sourceCodeSelection);
                }
            });
        }
        if (this.profileClassSupported()) {
            jPopupMenu.add(new JMenuItem(MemoryView.ACTION_PROFILE_CLASS){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null && SnapshotMemoryView.this.aggregation != 2 && SnapshotMemoryView.isSelectable(sourceCodeSelection, false));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    SnapshotMemoryView.this.profileClass(sourceCodeSelection);
                }
            });
        }
        if (this.profileMethodSupported() || this.profileClassSupported()) {
            jPopupMenu.addSeparator();
        }
        if ((jMenuItemArray = dataView.createCustomMenuItems(this, object, sourceCodeSelection)) != null) {
            for (JMenuItem jMenuItem : jMenuItemArray) {
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.addSeparator();
        }
        this.customizeNodePopup(dataView, jPopupMenu, object, sourceCodeSelection);
        if (this.snapshot.containsStacks()) {
            final ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)this.dataView.getResultsComponent();
            JMenu jMenu = new JMenu(MemoryView.EXPAND_MENU);
            jPopupMenu.add(jMenu);
            jMenu.add(new JMenuItem(MemoryView.EXPAND_PLAIN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerTreeTable.expandPlainPath(profilerTreeTable.getSelectedRow(), 1);
                }
            });
            jMenu.add(new JMenuItem(MemoryView.EXPAND_TOPMOST_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerTreeTable.expandFirstPath(profilerTreeTable.getSelectedRow());
                }
            });
            jMenu.addSeparator();
            jMenu.add(new JMenuItem(MemoryView.COLLAPSE_CHILDREN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerTreeTable.collapseChildren(profilerTreeTable.getSelectedRow());
                }
            });
            jMenu.add(new JMenuItem(MemoryView.COLLAPSE_ALL_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    profilerTreeTable.collapseAll();
                }
            });
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(dataView.createCopyMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateFilter();
            }
        });
        jPopupMenu.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateSearch();
            }
        });
    }

    protected void customizeNodePopup(DataView dataView, JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
    }

    private void setAggregation(int n) {
        this.aggregation = n;
        if (this.dataView != null) {
            if (this.refSnapshot == null) {
                this.dataView.setData(this.snapshot, this.filter, n);
            } else {
                this.dataView.setData(this.snapshot.createDiff(this.refSnapshot), this.filter, n);
            }
        }
    }

    private ExportUtils.Exportable[] getExportables(final ExportUtils.Exportable exportable) {
        return new ExportUtils.Exportable[]{new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return SnapshotMemoryView.this.refSnapshot == null && exportable.isEnabled();
            }

            @Override
            public String getName() {
                return exportable.getName();
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return exportable.getProviders();
            }
        }, new ExportUtils.Exportable(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public String getName() {
                return MemoryView.EXPORT_OBJECTS;
            }

            @Override
            public ExportUtils.ExportProvider[] getProviders() {
                return SnapshotMemoryView.this.dataView.getExportProviders();
            }
        }};
    }
}

