/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.jcs3.engine.behavior.ICacheListener;
import org.apache.commons.jcs3.engine.behavior.ICacheObserver;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class CacheWatchRepairable
implements ICacheObserver {
    private static final Log log = LogManager.getLog(CacheWatchRepairable.class);
    private ICacheObserver cacheWatch;
    private final ConcurrentMap<String, Set<ICacheListener<?, ?>>> cacheMap = new ConcurrentHashMap();

    public void setCacheWatch(ICacheObserver cacheWatch) {
        this.cacheWatch = cacheWatch;
        for (Map.Entry entry : this.cacheMap.entrySet()) {
            String cacheName = (String)entry.getKey();
            for (ICacheListener listener : (Set)entry.getValue()) {
                try {
                    log.info("Adding listener to cache watch. ICacheListener = {0} | ICacheObserver = {1}", listener, cacheWatch);
                    cacheWatch.addCacheListener(cacheName, listener);
                }
                catch (IOException ex) {
                    log.error("Problem adding listener. ICacheListener = {0} | ICacheObserver = {1}", listener, cacheWatch, ex);
                }
            }
        }
    }

    @Override
    public <K, V> void addCacheListener(String cacheName, ICacheListener<K, V> obj) throws IOException {
        Set listenerSet = this.cacheMap.computeIfAbsent(cacheName, key -> new CopyOnWriteArraySet());
        listenerSet.add(obj);
        log.info("Adding listener to cache watch. ICacheListener = {0} | ICacheObserver = {1} | cacheName = {2}", obj, this.cacheWatch, cacheName);
        this.cacheWatch.addCacheListener(cacheName, obj);
    }

    @Override
    public <K, V> void addCacheListener(ICacheListener<K, V> obj) throws IOException {
        for (Set listenerSet : this.cacheMap.values()) {
            listenerSet.add(obj);
        }
        log.info("Adding listener to cache watch. ICacheListener = {0} | ICacheObserver = {1}", obj, this.cacheWatch);
        this.cacheWatch.addCacheListener(obj);
    }

    @Override
    public <K, V> void removeCacheListener(String cacheName, ICacheListener<K, V> obj) throws IOException {
        log.info("removeCacheListener, cacheName [{0}]", cacheName);
        Set listenerSet = (Set)this.cacheMap.get(cacheName);
        if (listenerSet != null) {
            listenerSet.remove(obj);
        }
        this.cacheWatch.removeCacheListener(cacheName, obj);
    }

    @Override
    public <K, V> void removeCacheListener(ICacheListener<K, V> obj) throws IOException {
        log.info("removeCacheListener, ICacheListener [{0}]", obj);
        for (Set listenerSet : this.cacheMap.values()) {
            log.debug("Before removing [{0}] the listenerSet = {1}", obj, listenerSet);
            listenerSet.remove(obj);
        }
        this.cacheWatch.removeCacheListener(obj);
    }
}

