/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;

public class ChangesetCacheManagerModel
extends AbstractTableModel
implements ChangesetCacheListener {
    public static final String CHANGESET_IN_DETAIL_VIEW_PROP = ChangesetCacheManagerModel.class.getName() + ".changesetInDetailView";
    private final transient List<Changeset> data = new ArrayList<Changeset>();
    private final DefaultListSelectionModel selectionModel;
    private transient Changeset changesetInDetailView;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public ChangesetCacheManagerModel(DefaultListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void setChangesetInDetailView(Changeset cs) {
        Changeset oldValue = this.changesetInDetailView;
        this.changesetInDetailView = cs;
        if (oldValue != cs) {
            this.support.firePropertyChange(CHANGESET_IN_DETAIL_VIEW_PROP, oldValue, this.changesetInDetailView);
        }
    }

    public boolean hasSelectedChangesets() {
        return this.selectionModel.getMinSelectionIndex() >= 0;
    }

    public List<Changeset> getSelectedChangesets() {
        ArrayList<Changeset> ret = new ArrayList<Changeset>();
        for (int i = 0; i < this.data.size(); ++i) {
            Changeset cs = this.data.get(i);
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ret.add(cs);
        }
        return ret;
    }

    public Set<Integer> getSelectedChangesetIds() {
        return this.getSelectedChangesets().stream().map(Changeset::getId).collect(Collectors.toSet());
    }

    public void setSelectedChangesets(Collection<Changeset> selected) {
        GuiHelper.runInEDTAndWait(() -> TableHelper.setSelectedIndices(this.selectionModel, selected != null ? selected.stream().mapToInt(this.data::indexOf) : IntStream.empty()));
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Changeset getValueAt(int row, int column) {
        return this.data.get(row);
    }

    public void init() {
        ChangesetCache cc = ChangesetCache.getInstance();
        List<Changeset> selected = this.getSelectedChangesets();
        this.data.clear();
        this.data.addAll(cc.getChangesets());
        this.sort();
        this.fireTableDataChanged();
        this.setSelectedChangesets(selected);
        cc.addChangesetCacheListener(this);
    }

    public void tearDown() {
        ChangesetCache.getInstance().removeChangesetCacheListener(this);
    }

    public DefaultListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void sort() {
        this.data.sort(Comparator.comparingInt(Changeset::getId).reversed());
    }

    @Override
    public void changesetCacheUpdated(ChangesetCacheEvent event) {
        List<Changeset> selected = this.getSelectedChangesets();
        this.data.addAll(event.getAddedChangesets());
        this.data.removeAll(event.getRemovedChangesets());
        for (Changeset cs : event.getUpdatedChangesets()) {
            Changeset mine;
            int idx = this.data.indexOf(cs);
            if (idx < 0 || (mine = this.data.get(idx)) == cs) continue;
            mine.mergeFrom(cs);
        }
        GuiHelper.runInEDT(() -> {
            this.sort();
            this.fireTableDataChanged();
            this.setSelectedChangesets(selected);
        });
    }
}

