/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBox;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.mindmap.Finger;
import net.sourceforge.plantuml.mindmap.Idea;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.mindmap.SymetricalTee;
import net.sourceforge.plantuml.mindmap.SymetricalTeePositioned;
import net.sourceforge.plantuml.mindmap.Tetris;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FingerImpl
implements Finger,
UDrawable {
    private final Display label;
    private final HColor backColor;
    private final String stereotype;
    private final ISkinParam skinParam;
    private final StyleBuilder styleBuilder;
    private final IdeaShape shape;
    private final Direction direction;
    private final int level;
    private boolean drawPhalanx = true;
    private double marginLeft = 10.0;
    private double marginRight = 10.0;
    private double marginTop = 10.0;
    private double marginBottom = 10.0;
    private final List<FingerImpl> nail = new ArrayList<FingerImpl>();
    private Tetris tetris = null;

    private StyleSignature getDefaultStyleDefinitionNode() {
        String depth = SName.depth(this.level);
        if (this.level == 0) {
            return StyleSignature.of(SName.root, SName.element, SName.mindmapDiagram, SName.node, SName.rootNode).add(this.stereotype).add(depth);
        }
        if (this.nail.size() == 0) {
            return StyleSignature.of(SName.root, SName.element, SName.mindmapDiagram, SName.node, SName.leafNode).add(this.stereotype).add(depth);
        }
        return StyleSignature.of(SName.root, SName.element, SName.mindmapDiagram, SName.node).add(this.stereotype).add(depth);
    }

    public StyleSignature getDefaultStyleDefinitionArrow() {
        String depth = SName.depth(this.level);
        return StyleSignature.of(SName.root, SName.element, SName.mindmapDiagram, SName.arrow).add(this.stereotype).add(depth);
    }

    public static FingerImpl build(Idea idea, ISkinParam skinParam, Direction direction) {
        FingerImpl result = new FingerImpl(idea.getStyleBuilder(), idea.getBackColor(), idea.getLabel(), skinParam, idea.getShape(), direction, idea.getLevel(), idea.getStereotype());
        for (Idea child : idea.getChildren()) {
            result.addInNail(FingerImpl.build(child, skinParam, direction));
        }
        return result;
    }

    public void addInNail(FingerImpl child) {
        this.nail.add(child);
    }

    private FingerImpl(StyleBuilder styleBuilder, HColor backColor, Display label, ISkinParam skinParam, IdeaShape shape, Direction direction, int level, String stereotype) {
        this.backColor = backColor;
        this.stereotype = stereotype;
        this.level = level;
        this.label = label;
        this.skinParam = skinParam;
        this.shape = shape;
        this.styleBuilder = styleBuilder;
        this.direction = direction;
        Style styleNode = this.getDefaultStyleDefinitionNode().getMergedStyle(styleBuilder);
        this.marginLeft = styleNode.getMargin().getLeft();
        this.marginRight = styleNode.getMargin().getRight();
        this.marginTop = styleNode.getMargin().getTop();
        this.marginBottom = styleNode.getMargin().getBottom();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        TextBlock phalanx = this.getPhalanx();
        Dimension2D dimPhalanx = phalanx.calculateDimension(stringBounder);
        if (this.drawPhalanx) {
            double posY = -this.getPhalanxThickness(stringBounder) / 2.0;
            double posX = this.direction == Direction.RIGHT ? 0.0 : -dimPhalanx.getWidth();
            phalanx.drawU(ug.apply(new UTranslate(posX, posY)));
        }
        Point2D.Double p1 = new Point2D.Double(this.direction == Direction.RIGHT ? dimPhalanx.getWidth() : -dimPhalanx.getWidth(), 0.0);
        for (int i = 0; i < this.nail.size(); ++i) {
            FingerImpl child = this.nail.get(i);
            SymetricalTeePositioned stp = this.tetris(stringBounder).getElements().get(i);
            double x = this.direction == Direction.RIGHT ? dimPhalanx.getWidth() + this.getX12() : -dimPhalanx.getWidth() - this.getX12();
            Point2D.Double p2 = new Point2D.Double(x, stp.getY());
            child.drawU(ug.apply(new UTranslate(p2)));
            this.drawLine(ug.apply(this.getLinkColor()).apply(this.getUStroke()), p1, p2);
        }
    }

    private HColor getLinkColor() {
        Style styleArrow = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.styleBuilder);
        return styleArrow.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
    }

    private UStroke getUStroke() {
        Style styleArrow = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.styleBuilder);
        return styleArrow.getStroke();
    }

    private void drawLine(UGraphic ug, Point2D p1, Point2D p2) {
        UPath path = new UPath();
        double delta1 = this.direction == Direction.RIGHT ? 10.0 : -10.0;
        double delta2 = this.direction == Direction.RIGHT ? 25.0 : -25.0;
        path.moveTo(p1);
        path.lineTo(p1.getX() + delta1, p1.getY());
        path.cubicTo(p1.getX() + delta2, p1.getY(), p2.getX() - delta2, p2.getY(), p2.getX() - delta1, p2.getY());
        path.lineTo(p2);
        ug.draw(path);
    }

    private Tetris tetris(StringBounder stringBounder) {
        if (this.tetris == null) {
            this.tetris = new Tetris(this.label.toString());
            for (FingerImpl child : this.nail) {
                this.tetris.add(child.asSymetricalTee(stringBounder));
            }
            this.tetris.balance();
        }
        return this.tetris;
    }

    private SymetricalTee asSymetricalTee(StringBounder stringBounder) {
        double thickness1 = this.getPhalanxThickness(stringBounder);
        double elongation1 = this.getPhalanxElongation(stringBounder);
        if (this.nail.size() == 0) {
            return new SymetricalTee(thickness1, elongation1, 0.0, 0.0);
        }
        double thickness2 = this.getNailThickness(stringBounder);
        double elongation2 = this.getNailElongation(stringBounder);
        return new SymetricalTee(thickness1, elongation1 + this.getX1(), thickness2, this.getX2() + elongation2);
    }

    private double getX1() {
        return this.marginLeft;
    }

    private double getX2() {
        return this.marginRight + 30.0;
    }

    public double getX12() {
        return this.getX1() + this.getX2();
    }

    @Override
    public double getPhalanxThickness(StringBounder stringBounder) {
        return this.getPhalanx().calculateDimension(stringBounder).getHeight();
    }

    @Override
    public double getPhalanxElongation(StringBounder stringBounder) {
        return this.getPhalanx().calculateDimension(stringBounder).getWidth();
    }

    private TextBlock getPhalanx() {
        if (!this.drawPhalanx) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        if (this.shape == IdeaShape.BOX) {
            SkinParamColors foo = new SkinParamColors(this.skinParam, Colors.empty().add(ColorType.BACK, this.backColor));
            FtileBox box = FtileBox.createMindMap(this.styleBuilder, foo, this.label, this.getDefaultStyleDefinitionNode());
            return TextBlockUtils.withMargin(box, 0.0, 0.0, this.marginTop, this.marginBottom);
        }
        assert (this.shape == IdeaShape.NONE);
        Style styleNode = this.getDefaultStyleDefinitionNode().getMergedStyle(this.styleBuilder);
        TextBlock text = this.label.create(styleNode.getFontConfiguration(this.skinParam.getIHtmlColorSet()), HorizontalAlignment.LEFT, this.skinParam);
        if (this.direction == Direction.RIGHT) {
            return TextBlockUtils.withMargin(text, 3.0, 0.0, 1.0, 1.0);
        }
        return TextBlockUtils.withMargin(text, 0.0, 3.0, 1.0, 1.0);
    }

    @Override
    public double getNailThickness(StringBounder stringBounder) {
        return this.tetris(stringBounder).getHeight();
    }

    @Override
    public double getNailElongation(StringBounder stringBounder) {
        return this.tetris(stringBounder).getWidth();
    }

    @Override
    public double getFullThickness(StringBounder stringBounder) {
        double thickness1 = this.getPhalanxThickness(stringBounder);
        double thickness2 = this.getNailThickness(stringBounder);
        return Math.max(thickness1, thickness2);
    }

    @Override
    public double getFullElongation(StringBounder stringBounder) {
        return this.getPhalanxElongation(stringBounder) + this.getNailElongation(stringBounder);
    }

    @Override
    public void doNotDrawFirstPhalanx() {
        this.drawPhalanx = false;
    }
}

