/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class OWLAxiomChange
extends OWLOntologyChange {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLAxiom axiom;

    public OWLAxiomChange(@Nonnull OWLOntology ont, @Nonnull OWLAxiom axiom) {
        super(ont);
        this.axiom = OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return this.axiom.getSignature();
    }

    @Override
    public boolean isAxiomChange() {
        return true;
    }

    @Override
    public boolean isImportChange() {
        return false;
    }

    @Override
    @Nonnull
    public OWLAxiom getAxiom() {
        return OWLAPIPreconditions.verifyNotNull(this.axiom);
    }
}

