/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;

public abstract class InstanceNode
extends AbstractHeapWalkerNode
implements HeapWalkerInstanceNode {
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    HeapWalkerNode loopTo;
    private Instance instance;
    private String name;
    private String details;

    public InstanceNode(Instance instance, String string, HeapWalkerNode heapWalkerNode) {
        this(instance, string, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
    }

    public InstanceNode(Instance instance, String string, HeapWalkerNode heapWalkerNode, int n) {
        super(heapWalkerNode, n);
        this.instance = instance;
        this.name = string;
        this.loopTo = this.computeLoopTo();
    }

    @Override
    public abstract boolean isArray();

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public boolean isLeaf() {
        return !this.hasInstance() || this.isLoop();
    }

    @Override
    public boolean isLoop() {
        return this.getLoopTo() != null;
    }

    @Override
    public HeapWalkerNode getLoopTo() {
        return this.loopTo;
    }

    @Override
    public boolean hasInstance() {
        return this.instance != null;
    }

    @Override
    public String getDetails() {
        if (!this.hasInstance()) {
            return null;
        }
        if (this.details == null) {
            this.details = "";
            this.computeDetails();
        }
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getReferences() {
        if (this.hasInstance()) {
            List list;
            ChangeListener changeListener;
            block6: {
                ProgressHandle progressHandle = null;
                changeListener = null;
                try {
                    progressHandle = ProgressHandle.createHandle((String)Bundle.InstanceNode_References());
                    progressHandle.setInitialDelay(200);
                    progressHandle.start(1000);
                    changeListener = InstanceNode.setProgress(progressHandle);
                    list = this.getInstance().getReferences();
                    if (progressHandle == null) break block6;
                }
                catch (Throwable throwable) {
                    if (progressHandle != null) {
                        progressHandle.finish();
                    }
                    if (changeListener != null) {
                        HeapProgress.getProgress().removeChangeListener(changeListener);
                    }
                    throw throwable;
                }
                progressHandle.finish();
            }
            if (changeListener != null) {
                HeapProgress.getProgress().removeChangeListener(changeListener);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    protected HeapWalkerNode computeLoopTo() {
        if (this.hasInstance()) {
            for (HeapWalkerNode heapWalkerNode = this.getParent(); heapWalkerNode != null && heapWalkerNode instanceof HeapWalkerInstanceNode; heapWalkerNode = heapWalkerNode.getParent()) {
                if (!((HeapWalkerInstanceNode)((Object)heapWalkerNode)).getInstance().equals(this.instance)) continue;
                return heapWalkerNode;
            }
        }
        return null;
    }

    @Override
    protected String computeName() {
        if (this.isLoop()) {
            return this.name + " " + Bundle.InstanceNode_LoopToString(BrowserUtils.getFullNodeName(this.getLoopTo()));
        }
        return this.name;
    }

    @Override
    protected String computeType() {
        if (!this.hasInstance()) {
            return "<object>";
        }
        return this.instance.getJavaClass().getName();
    }

    @Override
    protected String computeValue() {
        if (!this.hasInstance()) {
            return "null";
        }
        return "#" + this.instance.getInstanceNumber();
    }

    protected void computeDetails() {
        HeapWalkerNode heapWalkerNode = BrowserUtils.getRoot(this);
        if (heapWalkerNode instanceof RootNode) {
            final RootNode rootNode = (RootNode)((Object)heapWalkerNode);
            BrowserUtils.performTask(new Runnable(){

                @Override
                public void run() {
                    final String string = rootNode.getDetails(InstanceNode.this.instance);
                    if (string != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                InstanceNode.this.details = string;
                                rootNode.repaintView();
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    protected String computeSize() {
        if (this.hasInstance()) {
            return numberFormat.format(this.instance.getSize());
        }
        return "-";
    }

    @Override
    protected String computeRetainedSize() {
        if (this.hasInstance()) {
            return numberFormat.format(this.instance.getRetainedSize());
        }
        return "-";
    }

    protected ImageIcon processLoopIcon(ImageIcon imageIcon) {
        if (!this.isLoop()) {
            return imageIcon;
        }
        return BrowserUtils.createLoopIcon(imageIcon);
    }

    private static ChangeListener setProgress(final ProgressHandle progressHandle) {
        final BoundedRangeModel boundedRangeModel = HeapProgress.getProgress();
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                progressHandle.progress(boundedRangeModel.getValue());
            }
        };
        boundedRangeModel.addChangeListener(changeListener);
        return changeListener;
    }

    @Override
    public Object getNodeID() {
        return this.instance;
    }
}

