/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bugreport;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.bugreport.DebugTextDisplay;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.bugreport.BugReportSender;

public class DefaultBugReportSendingHandler
implements BugReportSender.BugReportSendingHandler {
    @Override
    public String sendingBugReport(String bugUrl, String statusText) {
        return OpenBrowser.displayUrl(bugUrl);
    }

    @Override
    public void failed(String errorMessage, String statusText) {
        SwingUtilities.invokeLater(() -> {
            JPanel errorPanel = new JPanel(new GridBagLayout());
            errorPanel.add((Component)new JMultilineLabel(I18n.tr("Opening the bug report failed. Please report manually using this website:", new Object[0])), GBC.eol().fill(2));
            errorPanel.add((Component)new UrlLabel(Config.getUrls().getJOSMWebsite() + "/newticket", 2), GBC.eop().insets(8, 0, 0, 0));
            errorPanel.add(new DebugTextDisplay(statusText));
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), errorPanel, I18n.tr("You have encountered a bug in JOSM", new Object[0]), 0);
        });
    }
}

