/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.core.resolve;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Configuration;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.IvyNode;

public class IvyNodeCallers {
    private Map<String, Map<ModuleRevisionId, Caller>> callersByRootConf = new HashMap<String, Map<ModuleRevisionId, Caller>>();
    private Map<ModuleId, IvyNode> allCallers = new HashMap<ModuleId, IvyNode>();
    private IvyNode node;

    public IvyNodeCallers(IvyNode node) {
        this.node = node;
    }

    public void addCaller(String rootModuleConf, IvyNode callerNode, String callerConf, String requestedConf, String[] dependencyConfs, DependencyDescriptor dd) {
        Caller caller;
        ModuleDescriptor md = callerNode.getDescriptor();
        ModuleRevisionId mrid = callerNode.getResolvedId();
        if (mrid.getModuleId().equals(this.node.getId().getModuleId())) {
            throw new IllegalArgumentException("a module is not authorized to depend on itself: " + this.node.getId());
        }
        Map<ModuleRevisionId, Caller> callers = this.callersByRootConf.get(rootModuleConf);
        if (callers == null) {
            callers = new HashMap<ModuleRevisionId, Caller>();
            this.callersByRootConf.put(rootModuleConf, callers);
        }
        if ((caller = callers.get(mrid)) == null) {
            caller = new Caller(md, mrid, dd, callerNode.canExclude(rootModuleConf));
            callers.put(mrid, caller);
        }
        caller.addConfiguration(requestedConf, dependencyConfs);
        IvyNode parent = callerNode.getRealNode();
        for (ModuleId mid : parent.getAllCallersModuleIds()) {
            this.allCallers.put(mid, parent);
        }
        this.allCallers.put(mrid.getModuleId(), callerNode);
    }

    public Caller[] getCallers(String rootModuleConf) {
        Map<ModuleRevisionId, Caller> callers = this.callersByRootConf.get(rootModuleConf);
        if (callers == null) {
            return new Caller[0];
        }
        return callers.values().toArray(new Caller[callers.values().size()]);
    }

    private Set<Caller> getCallersByMrid(String rootModuleConf, ModuleRevisionId mrid) {
        Map<ModuleRevisionId, Caller> callers = this.callersByRootConf.get(rootModuleConf);
        if (callers == null) {
            return Collections.emptySet();
        }
        HashSet<Caller> mridCallers = new HashSet<Caller>();
        for (Caller caller : callers.values()) {
            if (!caller.getAskedDependencyId().equals(mrid)) continue;
            mridCallers.add(caller);
        }
        return mridCallers;
    }

    public Caller[] getAllRealCallers() {
        HashSet<Caller> all = new HashSet<Caller>();
        for (Map<ModuleRevisionId, Caller> callers : this.callersByRootConf.values()) {
            for (Caller c : callers.values()) {
                if (!c.isRealCaller()) continue;
                all.add(c);
            }
        }
        return all.toArray(new Caller[all.size()]);
    }

    public Collection<ModuleId> getAllCallersModuleIds() {
        return this.allCallers.keySet();
    }

    void updateFrom(IvyNodeCallers callers, String rootModuleConf, boolean real) {
        Map<ModuleRevisionId, Caller> nodecallers = callers.callersByRootConf.get(rootModuleConf);
        if (nodecallers != null) {
            Map<ModuleRevisionId, Caller> thiscallers = this.callersByRootConf.get(rootModuleConf);
            if (thiscallers == null) {
                thiscallers = new HashMap<ModuleRevisionId, Caller>();
                this.callersByRootConf.put(rootModuleConf, thiscallers);
            }
            for (Caller caller : nodecallers.values()) {
                if (thiscallers.containsKey(caller.getModuleRevisionId())) continue;
                if (!real) {
                    caller.setRealCaller(false);
                }
                thiscallers.put(caller.getModuleRevisionId(), caller);
            }
        }
    }

    public IvyNode getDirectCallerFor(ModuleId from) {
        return this.allCallers.get(from);
    }

    boolean doesCallersExclude(String rootModuleConf, Artifact artifact) {
        return this.doesCallersExclude(rootModuleConf, artifact, new ArrayDeque<IvyNode>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesCallersExclude(String rootModuleConf, Artifact artifact, Deque<IvyNode> callersStack) {
        callersStack.push(this.node);
        try {
            Set<Caller> callers = this.getCallersByMrid(rootModuleConf, this.node.getId());
            if (callers.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean allInconclusive = true;
            String[] moduleConfs = new String[]{rootModuleConf};
            block6: for (Caller caller : callers) {
                for (IvyNode descendant : callersStack) {
                    if (!this.node.directlyExcludes(this.node.getDescriptor(), moduleConfs, caller.getDependencyDescriptor(), DefaultArtifact.newIvyArtifact(descendant.getId(), null))) continue;
                    allInconclusive = false;
                    continue block6;
                }
                if (!caller.canExclude()) {
                    boolean bl = false;
                    return bl;
                }
                Boolean doesExclude = this.node.doesExclude(caller.getModuleDescriptor(), rootModuleConf, caller.getCallerConfigurations(), caller.getDependencyDescriptor(), artifact, callersStack);
                if (doesExclude == null) continue;
                if (!doesExclude.booleanValue()) {
                    boolean bl = false;
                    return bl;
                }
                allInconclusive = false;
            }
            boolean bl = !allInconclusive;
            return bl;
        }
        finally {
            callersStack.pop();
        }
    }

    public static class Caller {
        private ModuleDescriptor md;
        private ModuleRevisionId mrid;
        private Map<String, String[]> confs = new HashMap<String, String[]>();
        private DependencyDescriptor dd;
        private boolean callerCanExclude;
        private boolean real = true;

        public Caller(ModuleDescriptor md, ModuleRevisionId mrid, DependencyDescriptor dd, boolean callerCanExclude) {
            this.md = md;
            this.mrid = mrid;
            this.dd = dd;
            this.callerCanExclude = callerCanExclude;
        }

        public void addConfiguration(String callerConf, String[] dependencyConfs) {
            String[] confExtends;
            this.updateConfs(callerConf, dependencyConfs);
            Configuration conf = this.md.getConfiguration(callerConf);
            if (conf != null && (confExtends = conf.getExtends()) != null) {
                for (String confExtend : confExtends) {
                    this.addConfiguration(confExtend, dependencyConfs);
                }
            }
        }

        private void updateConfs(String callerConf, String[] dependencyConfs) {
            String[] prevDepConfs = this.confs.get(callerConf);
            if (prevDepConfs != null) {
                HashSet<String> newDepConfs = new HashSet<String>(Arrays.asList(prevDepConfs));
                newDepConfs.addAll(Arrays.asList(dependencyConfs));
                this.confs.put(callerConf, newDepConfs.toArray(new String[newDepConfs.size()]));
            } else {
                this.confs.put(callerConf, dependencyConfs);
            }
        }

        public String[] getCallerConfigurations() {
            return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
        }

        public ModuleRevisionId getModuleRevisionId() {
            return this.mrid;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Caller)) {
                return false;
            }
            Caller other = (Caller)obj;
            return other.confs.equals(this.confs) && this.mrid.equals(other.mrid);
        }

        public int hashCode() {
            int hash = 31;
            hash = hash * 13 + this.confs.hashCode();
            hash = hash * 13 + this.mrid.hashCode();
            return hash;
        }

        public String toString() {
            return this.mrid.toString();
        }

        public ModuleRevisionId getAskedDependencyId() {
            return this.dd.getDependencyRevisionId();
        }

        public ModuleDescriptor getModuleDescriptor() {
            return this.md;
        }

        public boolean canExclude() {
            return this.callerCanExclude || this.md.canExclude() || this.dd.canExclude();
        }

        public DependencyDescriptor getDependencyDescriptor() {
            return this.dd;
        }

        public void setRealCaller(boolean b) {
            this.real = b;
        }

        public boolean isRealCaller() {
            return this.real;
        }
    }
}

