import { StateEvent } from "./RoomEvent";
/**
 * The types of membership that are valid in Matrix.
 * @category Matrix event info
 * @see MembershipEventContent
 */
export declare type Membership = "join" | "leave" | "ban" | "invite";
/**
 * The content definition for m.room.member events
 * @category Matrix event contents
 * @see MembershipEvent
 */
export interface MembershipEventContent {
    avatar_url?: string;
    displayname?: string;
    membership: Membership;
    is_direct?: boolean;
    unsigned?: any;
    third_party_invite?: {
        display_name: string;
        signed: any;
    };
}
/**
 * Represents an m.room.member state event
 * @category Matrix events
 */
export declare class MembershipEvent extends StateEvent<MembershipEventContent> {
    constructor(event: any);
    /**
     * The user ID the membership affects.
     */
    get membershipFor(): string;
    /**
     * The user's membership.
     */
    get membership(): Membership;
}
