/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.util;

import gnu.mail.util.QPOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class QOutputStream
extends QPOutputStream {
    private static final int SPACE = 32;
    private static final int UNDERSCORE = 95;
    private static String TEXT_SPECIALS = "=_?";
    private static String WORD_SPECIALS = "=_?\"#$%&'(),.:;<>@[\\]^`{|}~";
    private String specials;

    public QOutputStream(OutputStream out, boolean word) {
        super(out, Integer.MAX_VALUE);
        this.specials = word ? WORD_SPECIALS : TEXT_SPECIALS;
    }

    @Override
    public void write(int c) throws IOException {
        if ((c &= 0xFF) == 32) {
            this.output(95, false);
        } else if (c < 32 || c >= 127 || this.specials.indexOf(c) >= 0) {
            this.output(c, true);
        } else {
            this.output(c, false);
        }
    }

    public static int encodedLength(byte[] bytes, boolean word) {
        int len = 0;
        String specials = word ? WORD_SPECIALS : TEXT_SPECIALS;
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            if (c < 32 || c >= 127 || specials.indexOf(c) >= 0) {
                len += 3;
                continue;
            }
            ++len;
        }
        return len;
    }
}

