/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELException;
import javax.el.FunctionMapper;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.ELParserTreeConstants;
import org.apache.el.parser.SimpleNode;
import org.apache.el.util.MessageFactory;

public final class AstFunction
extends SimpleNode {
    protected String localName = "";
    protected String prefix = "";

    public AstFunction(int n) {
        super(n);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getOutputName() {
        if (this.prefix == null) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Class<?> getType(EvaluationContext evaluationContext) throws ELException {
        FunctionMapper functionMapper = evaluationContext.getFunctionMapper();
        if (functionMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method method = functionMapper.resolveFunction(this.prefix, this.localName);
        if (method == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        return method.getReturnType();
    }

    @Override
    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        Object[] objectArray;
        FunctionMapper functionMapper = evaluationContext.getFunctionMapper();
        if (functionMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method method = functionMapper.resolveFunction(this.prefix, this.localName);
        if (method == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray2 = null;
        Object object = null;
        int n = this.jjtGetNumChildren();
        int n2 = classArray.length;
        if (n == 0 && n2 == 1 && method.isVarArgs()) {
            objectArray2 = new Object[]{null};
        } else if (n > 0) {
            objectArray2 = new Object[n2];
            try {
                for (int i = 0; i < n2; ++i) {
                    if (method.isVarArgs() && i == n2 - 1) {
                        if (n < n2) {
                            objectArray2[i] = new Object[]{null};
                        } else if (n == n2 && classArray[i].isArray()) {
                            objectArray2[i] = this.jjtGetChild(i).getValue(evaluationContext);
                        } else {
                            objectArray = new Object[n - n2 + 1];
                            Class<?> clazz = classArray[i].getComponentType();
                            for (int j = i; j < n; ++j) {
                                objectArray[j - i] = this.jjtGetChild(j).getValue(evaluationContext);
                                objectArray[j - i] = AstFunction.coerceToType(objectArray[j - i], clazz);
                            }
                            objectArray2[i] = objectArray;
                        }
                    } else {
                        objectArray2[i] = this.jjtGetChild(i).getValue(evaluationContext);
                    }
                    objectArray2[i] = AstFunction.coerceToType(objectArray2[i], classArray[i]);
                }
            }
            catch (ELException eLException) {
                throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)eLException);
            }
        }
        try {
            object = method.invoke(null, objectArray2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            objectArray = invocationTargetException.getCause();
            if (objectArray instanceof ThreadDeath) {
                throw (ThreadDeath)objectArray;
            }
            if (objectArray instanceof VirtualMachineError) {
                throw (VirtualMachineError)objectArray;
            }
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)objectArray);
        }
        return object;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public String toString() {
        return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.getOutputName() + "]";
    }
}

