/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.tomcat.util.res.StringManager;

@Deprecated
public abstract class MessageInbound
extends StreamInbound {
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.websocket");
    private int byteBufferMaxSize = 0x200000;
    private int charBufferMaxSize = 0x200000;
    private ByteBuffer bb = ByteBuffer.allocate(8192);
    private CharBuffer cb = CharBuffer.allocate(8192);

    @Override
    protected final void onBinaryData(InputStream inputStream) throws IOException {
        int n = 0;
        while (n > -1) {
            this.bb.position(this.bb.position() + n);
            if (this.bb.remaining() == 0) {
                this.resizeByteBuffer();
            }
            n = inputStream.read(this.bb.array(), this.bb.position(), this.bb.remaining());
        }
        this.bb.flip();
        this.onBinaryMessage(this.bb);
        this.bb.clear();
    }

    @Override
    protected final void onTextData(Reader reader) throws IOException {
        int n = 0;
        while (n > -1) {
            this.cb.position(this.cb.position() + n);
            if (this.cb.remaining() == 0) {
                this.resizeCharBuffer();
            }
            n = reader.read(this.cb.array(), this.cb.position(), this.cb.remaining());
        }
        this.cb.flip();
        this.onTextMessage(this.cb);
        this.cb.clear();
    }

    private void resizeByteBuffer() throws IOException {
        int n = this.getByteBufferMaxSize();
        if (this.bb.limit() >= n) {
            throw new IOException(sm.getString("message.bufferTooSmall"));
        }
        long l = this.bb.limit() * 2;
        if (l > (long)n) {
            l = n;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)l);
        this.bb.rewind();
        byteBuffer.put(this.bb);
        this.bb = byteBuffer;
    }

    private void resizeCharBuffer() throws IOException {
        int n = this.getCharBufferMaxSize();
        if (this.cb.limit() >= n) {
            throw new IOException(sm.getString("message.bufferTooSmall"));
        }
        long l = this.cb.limit() * 2;
        if (l > (long)n) {
            l = n;
        }
        CharBuffer charBuffer = CharBuffer.allocate((int)l);
        this.cb.rewind();
        charBuffer.put(this.cb);
        this.cb = charBuffer;
    }

    public final int getByteBufferMaxSize() {
        return this.byteBufferMaxSize;
    }

    public final void setByteBufferMaxSize(int n) {
        this.byteBufferMaxSize = n;
    }

    public final int getCharBufferMaxSize() {
        return this.charBufferMaxSize;
    }

    public final void setCharBufferMaxSize(int n) {
        this.charBufferMaxSize = n;
    }

    protected abstract void onBinaryMessage(ByteBuffer var1) throws IOException;

    protected abstract void onTextMessage(CharBuffer var1) throws IOException;
}

