/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.naming.StringManager;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.ImmutableNameNotFoundException;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.naming.resources.ResourceCache;

public class ProxyDirContext
implements DirContext {
    public static final String CONTEXT = "context";
    public static final String HOST = "host";
    protected static final NameNotFoundException NOT_FOUND_EXCEPTION = new ImmutableNameNotFoundException();
    protected ProxyDirContext proxy = this;
    protected Hashtable<String, String> env;
    protected static final StringManager sm = StringManager.getManager("org.apache.naming.resources");
    protected DirContext dirContext;
    protected String vPath = null;
    protected String hostName;
    protected String contextName;
    protected String contextPath;
    protected String cacheClassName = "org.apache.naming.resources.ResourceCache";
    protected ResourceCache cache = null;
    protected int cacheTTL = 5000;
    protected int cacheObjectMaxSize = 512;
    protected String[] nonCacheable = new String[]{"/WEB-INF/lib/", "/WEB-INF/classes/"};

    public ProxyDirContext(Hashtable<String, String> hashtable, DirContext dirContext) {
        BaseDirContext baseDirContext;
        this.env = hashtable;
        this.dirContext = dirContext;
        if (dirContext instanceof BaseDirContext && (baseDirContext = (BaseDirContext)dirContext).isCached()) {
            try {
                this.cache = (ResourceCache)Class.forName(this.cacheClassName).newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(sm.getString("resources.invalidCache", this.cacheClassName), exception);
            }
            this.cache.setCacheMaxSize(baseDirContext.getCacheMaxSize());
            this.cacheTTL = baseDirContext.getCacheTTL();
            this.cacheObjectMaxSize = baseDirContext.getCacheObjectMaxSize();
            if (this.cacheObjectMaxSize > baseDirContext.getCacheMaxSize() / 20) {
                this.cacheObjectMaxSize = baseDirContext.getCacheMaxSize() / 20;
            }
        }
        this.hostName = hashtable.get(HOST);
        this.contextName = hashtable.get(CONTEXT);
        int n = this.contextName.indexOf(35);
        this.contextPath = n == -1 ? this.contextName : this.contextName.substring(0, n);
    }

    public ResourceCache getCache() {
        return this.cache;
    }

    @Deprecated
    public DirContext getDirContext() {
        return this.dirContext;
    }

    @Deprecated
    public String getDocBase() {
        if (this.dirContext instanceof BaseDirContext) {
            return ((BaseDirContext)this.dirContext).getDocBase();
        }
        return "";
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        CacheEntry cacheEntry = this.cacheLookup(name.toString());
        if (cacheEntry != null) {
            if (!cacheEntry.exists) {
                throw NOT_FOUND_EXCEPTION;
            }
            if (cacheEntry.resource != null) {
                return cacheEntry.resource;
            }
            return cacheEntry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(name));
        if (object instanceof InputStream) {
            return new Resource((InputStream)object);
        }
        return object;
    }

    @Override
    public Object lookup(String string) throws NamingException {
        CacheEntry cacheEntry = this.cacheLookup(string);
        if (cacheEntry != null) {
            if (!cacheEntry.exists) {
                throw NOT_FOUND_EXCEPTION;
            }
            if (cacheEntry.resource != null) {
                return cacheEntry.resource;
            }
            return cacheEntry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(string));
        if (object instanceof InputStream) {
            return new Resource((InputStream)object);
        }
        if (object instanceof DirContext) {
            return object;
        }
        if (object instanceof Resource) {
            return object;
        }
        return new Resource(new ByteArrayInputStream(object.toString().getBytes(Charset.defaultCharset())));
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.dirContext.bind(this.parseName(name), object);
        this.cacheUnload(name.toString());
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.dirContext.bind(this.parseName(string), object);
        this.cacheUnload(string);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.dirContext.rebind(this.parseName(name), object);
        this.cacheUnload(name.toString());
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.dirContext.rebind(this.parseName(string), object);
        this.cacheUnload(string);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.dirContext.unbind(this.parseName(name));
        this.cacheUnload(name.toString());
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.dirContext.unbind(this.parseName(string));
        this.cacheUnload(string);
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.dirContext.rename(this.parseName(name), this.parseName(name2));
        this.cacheUnload(name.toString());
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.dirContext.rename(this.parseName(string), this.parseName(string2));
        this.cacheUnload(string);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.dirContext.list(this.parseName(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.dirContext.list(this.parseName(string));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.dirContext.listBindings(this.parseName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.dirContext.listBindings(this.parseName(string));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.dirContext.destroySubcontext(this.parseName(name));
        this.cacheUnload(name.toString());
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.dirContext.destroySubcontext(this.parseName(string));
        this.cacheUnload(string);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Context context = this.dirContext.createSubcontext(this.parseName(name));
        this.cacheUnload(name.toString());
        return context;
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        Context context = this.dirContext.createSubcontext(this.parseName(string));
        this.cacheUnload(string);
        return context;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.dirContext.lookupLink(this.parseName(name));
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.dirContext.lookupLink(this.parseName(string));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.dirContext.getNameParser(this.parseName(name));
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.dirContext.getNameParser(this.parseName(string));
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        return name3.addAll(name);
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return string2 + "/" + string;
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.dirContext.addToEnvironment(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        return this.dirContext.removeFromEnvironment(string);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.dirContext.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        this.dirContext.close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.dirContext.getNameInNamespace();
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        CacheEntry cacheEntry = this.cacheLookup(name.toString());
        if (cacheEntry != null) {
            if (!cacheEntry.exists) {
                throw NOT_FOUND_EXCEPTION;
            }
            return cacheEntry.attributes;
        }
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name));
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public Attributes getAttributes(String string) throws NamingException {
        CacheEntry cacheEntry = this.cacheLookup(string);
        if (cacheEntry != null) {
            if (!cacheEntry.exists) {
                throw NOT_FOUND_EXCEPTION;
            }
            return cacheEntry.attributes;
        }
        Attributes attributes = this.dirContext.getAttributes(this.parseName(string));
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name), stringArray);
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        Attributes attributes = this.dirContext.getAttributes(this.parseName(string), stringArray);
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), n, attributes);
        this.cacheUnload(name.toString());
    }

    @Override
    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(string), n, attributes);
        this.cacheUnload(string);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), modificationItemArray);
        this.cacheUnload(name.toString());
    }

    @Override
    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(string), modificationItemArray);
        this.cacheUnload(string);
    }

    @Override
    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.dirContext.bind(this.parseName(name), object, attributes);
        this.cacheUnload(name.toString());
    }

    @Override
    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        this.dirContext.bind(this.parseName(string), object, attributes);
        this.cacheUnload(string);
    }

    @Override
    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.dirContext.rebind(this.parseName(name), object, attributes);
        this.cacheUnload(name.toString());
    }

    @Override
    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        this.dirContext.rebind(this.parseName(string), object, attributes);
        this.cacheUnload(string);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        DirContext dirContext = this.dirContext.createSubcontext(this.parseName(name), attributes);
        this.cacheUnload(name.toString());
        return dirContext;
    }

    @Override
    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        DirContext dirContext = this.dirContext.createSubcontext(this.parseName(string), attributes);
        this.cacheUnload(string);
        return dirContext;
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return this.dirContext.getSchema(this.parseName(name));
    }

    @Override
    public DirContext getSchema(String string) throws NamingException {
        return this.dirContext.getSchema(this.parseName(string));
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.parseName(name));
    }

    @Override
    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.parseName(string));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        return this.dirContext.search(this.parseName(name), attributes, stringArray);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        return this.dirContext.search(this.parseName(string), attributes, stringArray);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes) throws NamingException {
        return this.dirContext.search(this.parseName(name), attributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes) throws NamingException {
        return this.dirContext.search(this.parseName(string), attributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, SearchControls searchControls) throws NamingException {
        return this.dirContext.search(this.parseName(name), string, searchControls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, SearchControls searchControls) throws NamingException {
        return this.dirContext.search(this.parseName(string), string2, searchControls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.dirContext.search(this.parseName(name), string, objectArray, searchControls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.dirContext.search(this.parseName(string), string2, objectArray, searchControls);
    }

    public CacheEntry lookupCache(String string) {
        CacheEntry cacheEntry = this.cacheLookup(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            cacheEntry.name = string;
            try {
                Object object = this.dirContext.lookup(this.parseName(string));
                if (object instanceof InputStream) {
                    cacheEntry.resource = new Resource((InputStream)object);
                } else if (object instanceof DirContext) {
                    cacheEntry.context = (DirContext)object;
                } else {
                    cacheEntry.resource = object instanceof Resource ? (Resource)object : new Resource(new ByteArrayInputStream(object.toString().getBytes(Charset.defaultCharset())));
                }
                Attributes attributes = this.dirContext.getAttributes(this.parseName(string));
                if (!(attributes instanceof ResourceAttributes)) {
                    attributes = new ResourceAttributes(attributes);
                }
                cacheEntry.attributes = (ResourceAttributes)attributes;
            }
            catch (NamingException namingException) {
                cacheEntry.exists = false;
            }
        }
        return cacheEntry;
    }

    protected String parseName(String string) throws NamingException {
        return string;
    }

    protected Name parseName(Name name) throws NamingException {
        return name;
    }

    protected CacheEntry cacheLookup(String string) {
        if (this.cache == null) {
            return null;
        }
        String string2 = string == null ? "" : string;
        for (int i = 0; i < this.nonCacheable.length; ++i) {
            if (!string2.startsWith(this.nonCacheable[i])) continue;
            return null;
        }
        CacheEntry cacheEntry = this.cache.lookup(string2);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            cacheEntry.name = string2;
            this.cacheLoad(cacheEntry);
        } else {
            if (!this.validate(cacheEntry)) {
                if (!this.revalidate(cacheEntry)) {
                    this.cacheUnload(cacheEntry.name);
                    return null;
                }
                cacheEntry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
            }
            ++cacheEntry.accessCount;
        }
        return cacheEntry;
    }

    protected boolean validate(CacheEntry cacheEntry) {
        return (!cacheEntry.exists || cacheEntry.context != null || cacheEntry.resource != null && cacheEntry.resource.getContent() != null) && System.currentTimeMillis() < cacheEntry.timestamp;
    }

    protected boolean revalidate(CacheEntry cacheEntry) {
        if (!cacheEntry.exists) {
            return false;
        }
        if (cacheEntry.attributes == null) {
            return false;
        }
        long l = cacheEntry.attributes.getLastModified();
        long l2 = cacheEntry.attributes.getContentLength();
        if (l <= 0L) {
            return false;
        }
        try {
            Attributes attributes = this.dirContext.getAttributes(cacheEntry.name);
            ResourceAttributes resourceAttributes = null;
            resourceAttributes = !(attributes instanceof ResourceAttributes) ? new ResourceAttributes(attributes) : (ResourceAttributes)attributes;
            long l3 = resourceAttributes.getLastModified();
            long l4 = resourceAttributes.getContentLength();
            return l == l3 && l2 == l4;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheLoad(CacheEntry cacheEntry) {
        Object object;
        String string = cacheEntry.name;
        boolean bl = true;
        if (cacheEntry.attributes == null) {
            try {
                object = this.dirContext.getAttributes(string);
                cacheEntry.attributes = !(object instanceof ResourceAttributes) ? new ResourceAttributes((Attributes)object) : (ResourceAttributes)object;
            }
            catch (NamingException namingException) {
                bl = false;
            }
        }
        if (bl && cacheEntry.resource == null && cacheEntry.context == null) {
            try {
                object = this.dirContext.lookup(string);
                if (object instanceof InputStream) {
                    cacheEntry.resource = new Resource((InputStream)object);
                } else if (object instanceof DirContext) {
                    cacheEntry.context = (DirContext)object;
                } else {
                    cacheEntry.resource = object instanceof Resource ? (Resource)object : new Resource(new ByteArrayInputStream(object.toString().getBytes(Charset.defaultCharset())));
                }
            }
            catch (NamingException namingException) {
                bl = false;
            }
        }
        if (bl && cacheEntry.resource != null && cacheEntry.resource.getContent() == null && cacheEntry.attributes.getContentLength() >= 0L && cacheEntry.attributes.getContentLength() < (long)(this.cacheObjectMaxSize * 1024)) {
            int n = (int)cacheEntry.attributes.getContentLength();
            cacheEntry.size = (int)((long)cacheEntry.size + cacheEntry.attributes.getContentLength() / 1024L);
            InputStream inputStream = null;
            try {
                int n2;
                inputStream = cacheEntry.resource.streamContent();
                byte[] byArray = new byte[n];
                for (int i = 0; i < n && (n2 = inputStream.read(byArray, i, n - i)) >= 0; i += n2) {
                }
                cacheEntry.resource.setContent(byArray);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        cacheEntry.exists = bl;
        cacheEntry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
        object = this.cache;
        synchronized (object) {
            if (this.cache.lookup(string) == null && this.cache.allocate(cacheEntry.size)) {
                this.cache.load(cacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cacheUnload(String string) {
        if (this.cache == null) {
            return false;
        }
        String string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : string + "/";
        ResourceCache resourceCache = this.cache;
        synchronized (resourceCache) {
            boolean bl = this.cache.unload(string);
            this.cache.unload(string2);
            return bl;
        }
    }
}

