/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.ELParser;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageDataImpl;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.el.ELContextImpl;
import org.xml.sax.Attributes;

class Validator {
    Validator() {
    }

    public static void validateDirectives(Compiler compiler, Node.Nodes nodes) throws JasperException {
        nodes.visit(new DirectiveVisitor(compiler));
    }

    public static void validateExDirectives(Compiler compiler, Node.Nodes nodes) throws JasperException {
        PageInfo pageInfo = compiler.getPageInfo();
        String string = pageInfo.getContentType();
        if (string == null || string.indexOf("charset=") < 0) {
            boolean bl = nodes.getRoot().isXmlSyntax();
            String string2 = string == null ? (bl ? "text/xml" : "text/html") : string;
            String string3 = null;
            if (bl) {
                string3 = "UTF-8";
            } else if (!nodes.getRoot().isDefaultPageEncoding()) {
                string3 = nodes.getRoot().getPageEncoding();
            }
            if (string3 != null) {
                pageInfo.setContentType(string2 + ";charset=" + string3);
            } else {
                pageInfo.setContentType(string2);
            }
        }
        nodes.visit(new ValidateVisitor(compiler));
        Validator.validateXmlView(new PageDataImpl(nodes, compiler), compiler);
        nodes.visit(new TagExtraInfoVisitor(compiler));
    }

    private static void validateXmlView(PageData pageData, Compiler compiler) throws JasperException {
        StringBuilder stringBuilder = null;
        ErrorDispatcher errorDispatcher = compiler.getErrorDispatcher();
        for (TagLibraryInfo tagLibraryInfo : compiler.getPageInfo().getTaglibs()) {
            TagLibraryInfoImpl tagLibraryInfoImpl;
            ValidationMessage[] validationMessageArray;
            if (!(tagLibraryInfo instanceof TagLibraryInfoImpl) || (validationMessageArray = (tagLibraryInfoImpl = (TagLibraryInfoImpl)tagLibraryInfo).validate(pageData)) == null || validationMessageArray.length == 0) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("<h3>");
            stringBuilder.append(Localizer.getMessage("jsp.error.tlv.invalid.page", tagLibraryInfoImpl.getShortName(), compiler.getPageInfo().getJspFile()));
            stringBuilder.append("</h3>");
            for (ValidationMessage validationMessage : validationMessageArray) {
                if (validationMessage == null) continue;
                stringBuilder.append("<p>");
                stringBuilder.append(validationMessage.getId());
                stringBuilder.append(": ");
                stringBuilder.append(validationMessage.getMessage());
                stringBuilder.append("</p>");
            }
        }
        if (stringBuilder != null) {
            errorDispatcher.jspError(stringBuilder.toString());
        }
    }

    protected static String xmlEscape(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\"' || c > '>' || c != '<' && c != '>' && c != '\'' && c != '&' && c != '\"') continue;
            StringBuilder stringBuilder = new StringBuilder((int)((double)n * 1.2));
            stringBuilder.append(string, 0, i);
            int n2 = i + 1;
            for (int j = i; j < n; ++j) {
                c = string.charAt(j);
                if (c < '\"' || c > '>') continue;
                if (c == '<') {
                    if (j > n2) {
                        stringBuilder.append(string, n2, j);
                    }
                    stringBuilder.append("&lt;");
                    n2 = j + 1;
                    continue;
                }
                if (c == '>') {
                    if (j > n2) {
                        stringBuilder.append(string, n2, j);
                    }
                    stringBuilder.append("&gt;");
                    n2 = j + 1;
                    continue;
                }
                if (c == '\'') {
                    if (j > n2) {
                        stringBuilder.append(string, n2, j);
                    }
                    stringBuilder.append("&#039;");
                    n2 = j + 1;
                    continue;
                }
                if (c == '&') {
                    if (j > n2) {
                        stringBuilder.append(string, n2, j);
                    }
                    stringBuilder.append("&amp;");
                    n2 = j + 1;
                    continue;
                }
                if (c != '\"') continue;
                if (j > n2) {
                    stringBuilder.append(string, n2, j);
                }
                stringBuilder.append("&#034;");
                n2 = j + 1;
            }
            if (n2 < n) {
                stringBuilder.append(string, n2, n);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    static class TagExtraInfoVisitor
    extends Node.Visitor {
        private ErrorDispatcher err;

        TagExtraInfoVisitor(Compiler compiler) {
            this.err = compiler.getErrorDispatcher();
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            ValidationMessage[] validationMessageArray;
            TagInfo tagInfo = customTag.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError(customTag, "jsp.error.missing.tagInfo", customTag.getQName());
            }
            if ((validationMessageArray = tagInfo.validate(customTag.getTagData())) != null && validationMessageArray.length != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<h3>");
                stringBuilder.append(Localizer.getMessage("jsp.error.tei.invalid.attributes", customTag.getQName()));
                stringBuilder.append("</h3>");
                for (ValidationMessage validationMessage : validationMessageArray) {
                    stringBuilder.append("<p>");
                    if (validationMessage.getId() != null) {
                        stringBuilder.append(validationMessage.getId());
                        stringBuilder.append(": ");
                    }
                    stringBuilder.append(validationMessage.getMessage());
                    stringBuilder.append("</p>");
                }
                this.err.jspError(customTag, stringBuilder.toString());
            }
            this.visitBody(customTag);
        }
    }

    static class ValidateVisitor
    extends Node.Visitor {
        private static final Pattern METHOD_NAME_PATTERN = Pattern.compile(".*[ \t\n\r]+(.+?)[ \t\n\r]*\\(.*", 32);
        private final PageInfo pageInfo;
        private ErrorDispatcher err;
        private ClassLoader loader;
        private final StringBuilder buf = new StringBuilder(32);
        private static final JspUtil.ValidAttribute[] jspRootAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("xsi:schemaLocation"), new JspUtil.ValidAttribute("version", true)};
        private static final JspUtil.ValidAttribute[] includeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("file", true)};
        private static final JspUtil.ValidAttribute[] taglibDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("uri"), new JspUtil.ValidAttribute("tagdir"), new JspUtil.ValidAttribute("prefix", true)};
        private static final JspUtil.ValidAttribute[] includeActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true), new JspUtil.ValidAttribute("flush")};
        private static final JspUtil.ValidAttribute[] paramActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("value", true)};
        private static final JspUtil.ValidAttribute[] forwardActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true)};
        private static final JspUtil.ValidAttribute[] getPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true)};
        private static final JspUtil.ValidAttribute[] setPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true), new JspUtil.ValidAttribute("value", false), new JspUtil.ValidAttribute("param")};
        private static final JspUtil.ValidAttribute[] useBeanAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("id", true), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("class"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("beanName", false)};
        private static final JspUtil.ValidAttribute[] plugInAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("type", true), new JspUtil.ValidAttribute("code", true), new JspUtil.ValidAttribute("codebase"), new JspUtil.ValidAttribute("align"), new JspUtil.ValidAttribute("archive"), new JspUtil.ValidAttribute("height", false), new JspUtil.ValidAttribute("hspace"), new JspUtil.ValidAttribute("jreversion"), new JspUtil.ValidAttribute("name"), new JspUtil.ValidAttribute("vspace"), new JspUtil.ValidAttribute("width", false), new JspUtil.ValidAttribute("nspluginurl"), new JspUtil.ValidAttribute("iepluginurl")};
        private static final JspUtil.ValidAttribute[] attributeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("trim"), new JspUtil.ValidAttribute("omit")};
        private static final JspUtil.ValidAttribute[] invokeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("fragment", true), new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] doBodyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] jspOutputAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("omit-xml-declaration"), new JspUtil.ValidAttribute("doctype-root-element"), new JspUtil.ValidAttribute("doctype-public"), new JspUtil.ValidAttribute("doctype-system")};
        private final ExpressionFactory expressionFactory;

        ValidateVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
            this.loader = compiler.getCompilationContext().getClassLoader();
            this.expressionFactory = JspFactory.getDefaultFactory().getJspApplicationContext(compiler.getCompilationContext().getServletContext()).getExpressionFactory();
        }

        @Override
        public void visit(Node.JspRoot jspRoot) throws JasperException {
            JspUtil.checkAttributes("Jsp:root", jspRoot, jspRootAttrs, this.err);
            String string = jspRoot.getTextAttribute("version");
            if (!(string.equals("1.2") || string.equals("2.0") || string.equals("2.1") || string.equals("2.2"))) {
                this.err.jspError(jspRoot, "jsp.error.jsproot.version.invalid", string);
            }
            this.visitBody(jspRoot);
        }

        @Override
        public void visit(Node.IncludeDirective includeDirective) throws JasperException {
            JspUtil.checkAttributes("Include directive", includeDirective, includeDirectiveAttrs, this.err);
            this.visitBody(includeDirective);
        }

        @Override
        public void visit(Node.TaglibDirective taglibDirective) throws JasperException {
            JspUtil.checkAttributes("Taglib directive", taglibDirective, taglibDirectiveAttrs, this.err);
            String string = taglibDirective.getAttributeValue("uri");
            String string2 = taglibDirective.getAttributeValue("tagdir");
            if (string == null && string2 == null) {
                this.err.jspError(taglibDirective, "jsp.error.taglibDirective.missing.location");
            }
            if (string != null && string2 != null) {
                this.err.jspError(taglibDirective, "jsp.error.taglibDirective.both_uri_and_tagdir");
            }
        }

        @Override
        public void visit(Node.ParamAction paramAction) throws JasperException {
            JspUtil.checkAttributes("Param action", paramAction, paramActionAttrs, this.err);
            this.throwErrorIfExpression(paramAction, "name", "jsp:param");
            paramAction.setValue(this.getJspAttribute(null, "value", null, null, paramAction.getAttributeValue("value"), paramAction, null, false));
            this.visitBody(paramAction);
        }

        @Override
        public void visit(Node.ParamsAction paramsAction) throws JasperException {
            Node.Nodes nodes = paramsAction.getBody();
            if (nodes == null) {
                this.err.jspError(paramsAction, "jsp.error.params.emptyBody");
            }
            this.visitBody(paramsAction);
        }

        @Override
        public void visit(Node.IncludeAction includeAction) throws JasperException {
            JspUtil.checkAttributes("Include action", includeAction, includeActionAttrs, this.err);
            includeAction.setPage(this.getJspAttribute(null, "page", null, null, includeAction.getAttributeValue("page"), includeAction, null, false));
            this.visitBody(includeAction);
        }

        @Override
        public void visit(Node.ForwardAction forwardAction) throws JasperException {
            JspUtil.checkAttributes("Forward", forwardAction, forwardActionAttrs, this.err);
            forwardAction.setPage(this.getJspAttribute(null, "page", null, null, forwardAction.getAttributeValue("page"), forwardAction, null, false));
            this.visitBody(forwardAction);
        }

        @Override
        public void visit(Node.GetProperty getProperty) throws JasperException {
            JspUtil.checkAttributes("GetProperty", getProperty, getPropertyAttrs, this.err);
        }

        @Override
        public void visit(Node.SetProperty setProperty) throws JasperException {
            boolean bl;
            JspUtil.checkAttributes("SetProperty", setProperty, setPropertyAttrs, this.err);
            String string = setProperty.getTextAttribute("property");
            String string2 = setProperty.getTextAttribute("param");
            String string3 = setProperty.getAttributeValue("value");
            setProperty.setValue(this.getJspAttribute(null, "value", null, null, string3, setProperty, null, false));
            boolean bl2 = bl = setProperty.getValue() != null;
            if ("*".equals(string)) {
                if (string2 != null || bl) {
                    this.err.jspError(setProperty, "jsp.error.setProperty.invalid");
                }
            } else if (string2 != null && bl) {
                this.err.jspError(setProperty, "jsp.error.setProperty.invalid");
            }
            this.visitBody(setProperty);
        }

        @Override
        public void visit(Node.UseBean useBean) throws JasperException {
            JspUtil.checkAttributes("UseBean", useBean, useBeanAttrs, this.err);
            String string = useBean.getTextAttribute("id");
            String string2 = useBean.getTextAttribute("scope");
            JspUtil.checkScope(string2, useBean, this.err);
            String string3 = useBean.getTextAttribute("class");
            String string4 = useBean.getTextAttribute("type");
            BeanRepository beanRepository = this.pageInfo.getBeanRepository();
            if (string3 == null && string4 == null) {
                this.err.jspError(useBean, "jsp.error.usebean.missingType");
            }
            if (beanRepository.checkVariable(string)) {
                this.err.jspError(useBean, "jsp.error.usebean.duplicate");
            }
            if ("session".equals(string2) && !this.pageInfo.isSession()) {
                this.err.jspError(useBean, "jsp.error.usebean.noSession");
            }
            Node.JspAttribute jspAttribute = this.getJspAttribute(null, "beanName", null, null, useBean.getAttributeValue("beanName"), useBean, null, false);
            useBean.setBeanName(jspAttribute);
            if (string3 != null && jspAttribute != null) {
                this.err.jspError(useBean, "jsp.error.usebean.notBoth");
            }
            if (string3 == null) {
                string3 = string4;
            }
            beanRepository.addBean(useBean, string, string3, string2);
            this.visitBody(useBean);
        }

        @Override
        public void visit(Node.PlugIn plugIn) throws JasperException {
            JspUtil.checkAttributes("Plugin", plugIn, plugInAttrs, this.err);
            this.throwErrorIfExpression(plugIn, "type", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "code", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "codebase", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "align", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "archive", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "hspace", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "jreversion", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "name", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "vspace", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "nspluginurl", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "iepluginurl", "jsp:plugin");
            String string = plugIn.getTextAttribute("type");
            if (string == null) {
                this.err.jspError(plugIn, "jsp.error.plugin.notype");
            }
            if (!string.equals("bean") && !string.equals("applet")) {
                this.err.jspError(plugIn, "jsp.error.plugin.badtype");
            }
            if (plugIn.getTextAttribute("code") == null) {
                this.err.jspError(plugIn, "jsp.error.plugin.nocode");
            }
            Node.JspAttribute jspAttribute = this.getJspAttribute(null, "width", null, null, plugIn.getAttributeValue("width"), plugIn, null, false);
            plugIn.setWidth(jspAttribute);
            Node.JspAttribute jspAttribute2 = this.getJspAttribute(null, "height", null, null, plugIn.getAttributeValue("height"), plugIn, null, false);
            plugIn.setHeight(jspAttribute2);
            this.visitBody(plugIn);
        }

        @Override
        public void visit(Node.NamedAttribute namedAttribute) throws JasperException {
            JspUtil.checkAttributes("Attribute", namedAttribute, attributeAttrs, this.err);
            namedAttribute.setOmit(this.getJspAttribute(null, "omit", null, null, namedAttribute.getAttributeValue("omit"), namedAttribute, null, false));
            this.visitBody(namedAttribute);
        }

        @Override
        public void visit(Node.JspBody jspBody) throws JasperException {
            this.visitBody(jspBody);
        }

        @Override
        public void visit(Node.Declaration declaration) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(declaration.getStart(), "jsp.error.no.scriptlets");
            }
        }

        @Override
        public void visit(Node.Expression expression) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(expression.getStart(), "jsp.error.no.scriptlets");
            }
        }

        @Override
        public void visit(Node.Scriptlet scriptlet) throws JasperException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(scriptlet.getStart(), "jsp.error.no.scriptlets");
            }
        }

        @Override
        public void visit(Node.ELExpression eLExpression) throws JasperException {
            if (this.pageInfo.isELIgnored()) {
                return;
            }
            if (eLExpression.getType() == '#') {
                if (!this.pageInfo.isDeferredSyntaxAllowedAsLiteral()) {
                    this.err.jspError(eLExpression, "jsp.error.el.template.deferred");
                } else {
                    return;
                }
            }
            StringBuilder stringBuilder = this.getBuffer();
            stringBuilder.append(eLExpression.getType()).append('{').append(eLExpression.getText()).append('}');
            ELNode.Nodes nodes = ELParser.parse(stringBuilder.toString(), this.pageInfo.isDeferredSyntaxAllowedAsLiteral());
            this.prepareExpression(nodes, eLExpression, stringBuilder.toString());
            eLExpression.setEL(nodes);
        }

        @Override
        public void visit(Node.UninterpretedTag uninterpretedTag) throws JasperException {
            Attributes attributes;
            if (uninterpretedTag.getNamedAttributeNodes().size() != 0) {
                this.err.jspError(uninterpretedTag, "jsp.error.namedAttribute.invalidUse");
            }
            if ((attributes = uninterpretedTag.getAttributes()) != null) {
                int n = attributes.getLength();
                Node.JspAttribute[] jspAttributeArray = new Node.JspAttribute[n];
                for (int i = 0; i < n; ++i) {
                    String string = attributes.getValue(i);
                    if (!this.pageInfo.isDeferredSyntaxAllowedAsLiteral() && this.containsDeferredSyntax(string)) {
                        this.err.jspError(uninterpretedTag, "jsp.error.el.template.deferred");
                    }
                    jspAttributeArray[i] = this.getJspAttribute(null, attributes.getQName(i), attributes.getURI(i), attributes.getLocalName(i), string, uninterpretedTag, null, false);
                }
                uninterpretedTag.setJspAttributes(jspAttributeArray);
            }
            this.visitBody(uninterpretedTag);
        }

        private boolean containsDeferredSyntax(String string) {
            if (string == null) {
                return false;
            }
            int n = string.length();
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '#' && i + 1 < n && string.charAt(i + 1) == '{' && !bl) {
                    return true;
                }
                bl = c == '\\';
            }
            return false;
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            Node.NamedAttribute namedAttribute;
            String string;
            Object object2;
            TagInfo tagInfo = customTag.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError(customTag, "jsp.error.missing.tagInfo", customTag.getQName());
            }
            if (customTag.implementsSimpleTag() && tagInfo.getBodyContent().equalsIgnoreCase("JSP")) {
                this.err.jspError(customTag, "jsp.error.simpletag.badbodycontent", tagInfo.getTagClassName());
            }
            if (tagInfo.hasDynamicAttributes() && !customTag.implementsDynamicAttributes()) {
                this.err.jspError(customTag, "jsp.error.dynamic.attributes.not.implemented", customTag.getQName());
            }
            TagAttributeInfo[] tagAttributeInfoArray = tagInfo.getAttributes();
            String string2 = customTag.getURI();
            Attributes attributes = customTag.getAttributes();
            int n = attributes == null ? 0 : attributes.getLength();
            for (Object object2 : tagAttributeInfoArray) {
                string = null;
                if (attributes != null && (string = attributes.getValue(object2.getName())) == null) {
                    string = attributes.getValue(string2, object2.getName());
                }
                namedAttribute = customTag.getNamedAttributeNode(object2.getName());
                if (object2.isRequired() && string == null && namedAttribute == null) {
                    this.err.jspError((Node)customTag, "jsp.error.missing_attribute", object2.getName(), customTag.getLocalName());
                }
                if (string == null || namedAttribute == null) continue;
                this.err.jspError(customTag, "jsp.error.duplicate.name.jspattribute", object2.getName());
            }
            Node.Nodes nodes = customTag.getNamedAttributeNodes();
            int n2 = nodes.size() + n;
            Node.JspAttribute[] jspAttributeArray = null;
            if (n2 > 0) {
                jspAttributeArray = new Node.JspAttribute[n2];
            }
            object2 = new Hashtable(n);
            this.checkXmlAttributes(customTag, jspAttributeArray, (Hashtable<String, Object>)object2);
            this.checkNamedAttributes(customTag, jspAttributeArray, n, (Hashtable<String, Object>)object2);
            string = new TagData((Hashtable)object2);
            namedAttribute = tagInfo.getTagExtraInfo();
            if (namedAttribute != null && namedAttribute.getVariableInfo((TagData)string) != null && namedAttribute.getVariableInfo((TagData)string).length > 0 && tagInfo.getTagVariableInfos().length > 0) {
                this.err.jspError("jsp.error.non_null_tei_and_var_subelems", customTag.getQName());
            }
            customTag.setTagData((TagData)string);
            customTag.setJspAttributes(jspAttributeArray);
            this.visitBody(customTag);
        }

        @Override
        public void visit(Node.JspElement jspElement) throws JasperException {
            int n;
            Attributes attributes = jspElement.getAttributes();
            if (attributes == null) {
                this.err.jspError(jspElement, "jsp.error.jspelement.missing.name");
            }
            int n2 = attributes.getLength();
            Node.Nodes nodes = jspElement.getNamedAttributeNodes();
            int n3 = n2 - 1 + nodes.size();
            Node.JspAttribute[] jspAttributeArray = new Node.JspAttribute[n3];
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                if ("name".equals(attributes.getLocalName(n))) {
                    jspElement.setNameAttribute(this.getJspAttribute(null, attributes.getQName(n), attributes.getURI(n), attributes.getLocalName(n), attributes.getValue(n), jspElement, null, false));
                    continue;
                }
                if (n4 >= n3) continue;
                jspAttributeArray[n4++] = this.getJspAttribute(null, attributes.getQName(n), attributes.getURI(n), attributes.getLocalName(n), attributes.getValue(n), jspElement, null, false);
            }
            if (jspElement.getNameAttribute() == null) {
                this.err.jspError(jspElement, "jsp.error.jspelement.missing.name");
            }
            for (n = 0; n < nodes.size(); ++n) {
                Node.NamedAttribute namedAttribute = (Node.NamedAttribute)nodes.getNode(n);
                jspAttributeArray[n4++] = new Node.JspAttribute(namedAttribute, null, false);
            }
            jspElement.setJspAttributes(jspAttributeArray);
            this.visitBody(jspElement);
        }

        @Override
        public void visit(Node.JspOutput jspOutput) throws JasperException {
            JspUtil.checkAttributes("jsp:output", jspOutput, jspOutputAttrs, this.err);
            if (jspOutput.getBody() != null) {
                this.err.jspError(jspOutput, "jsp.error.jspoutput.nonemptybody");
            }
            String string = jspOutput.getAttributeValue("omit-xml-declaration");
            String string2 = jspOutput.getAttributeValue("doctype-root-element");
            String string3 = jspOutput.getAttributeValue("doctype-public");
            String string4 = jspOutput.getAttributeValue("doctype-system");
            String string5 = this.pageInfo.getOmitXmlDecl();
            String string6 = this.pageInfo.getDoctypeName();
            String string7 = this.pageInfo.getDoctypePublic();
            String string8 = this.pageInfo.getDoctypeSystem();
            if (string != null && string5 != null && !string.equals(string5)) {
                this.err.jspError(jspOutput, "jsp.error.jspoutput.conflict", "omit-xml-declaration", string5, string);
            }
            if (string2 != null && string6 != null && !string2.equals(string6)) {
                this.err.jspError(jspOutput, "jsp.error.jspoutput.conflict", "doctype-root-element", string6, string2);
            }
            if (string3 != null && string7 != null && !string3.equals(string7)) {
                this.err.jspError(jspOutput, "jsp.error.jspoutput.conflict", "doctype-public", string7, string3);
            }
            if (string4 != null && string8 != null && !string4.equals(string8)) {
                this.err.jspError(jspOutput, "jsp.error.jspoutput.conflict", "doctype-system", string8, string4);
            }
            if (string2 == null && string4 != null || string2 != null && string4 == null) {
                this.err.jspError(jspOutput, "jsp.error.jspoutput.doctypenamesystem");
            }
            if (string3 != null && string4 == null) {
                this.err.jspError(jspOutput, "jsp.error.jspoutput.doctypepublicsystem");
            }
            if (string != null) {
                this.pageInfo.setOmitXmlDecl(string);
            }
            if (string2 != null) {
                this.pageInfo.setDoctypeName(string2);
            }
            if (string4 != null) {
                this.pageInfo.setDoctypeSystem(string4);
            }
            if (string3 != null) {
                this.pageInfo.setDoctypePublic(string3);
            }
        }

        @Override
        public void visit(Node.InvokeAction invokeAction) throws JasperException {
            JspUtil.checkAttributes("Invoke", invokeAction, invokeAttrs, this.err);
            String string = invokeAction.getTextAttribute("scope");
            JspUtil.checkScope(string, invokeAction, this.err);
            String string2 = invokeAction.getTextAttribute("var");
            String string3 = invokeAction.getTextAttribute("varReader");
            if (string != null && string2 == null && string3 == null) {
                this.err.jspError(invokeAction, "jsp.error.missing_var_or_varReader");
            }
            if (string2 != null && string3 != null) {
                this.err.jspError(invokeAction, "jsp.error.var_and_varReader");
            }
        }

        @Override
        public void visit(Node.DoBodyAction doBodyAction) throws JasperException {
            JspUtil.checkAttributes("DoBody", doBodyAction, doBodyAttrs, this.err);
            String string = doBodyAction.getTextAttribute("scope");
            JspUtil.checkScope(string, doBodyAction, this.err);
            String string2 = doBodyAction.getTextAttribute("var");
            String string3 = doBodyAction.getTextAttribute("varReader");
            if (string != null && string2 == null && string3 == null) {
                this.err.jspError(doBodyAction, "jsp.error.missing_var_or_varReader");
            }
            if (string2 != null && string3 != null) {
                this.err.jspError(doBodyAction, "jsp.error.var_and_varReader");
            }
        }

        private void checkXmlAttributes(Node.CustomTag customTag, Node.JspAttribute[] jspAttributeArray, Hashtable<String, Object> hashtable) throws JasperException {
            TagInfo tagInfo = customTag.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError(customTag, "jsp.error.missing.tagInfo", customTag.getQName());
            }
            TagAttributeInfo[] tagAttributeInfoArray = tagInfo.getAttributes();
            Attributes attributes = customTag.getAttributes();
            for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
                Iterator<ELNode> iterator;
                boolean bl;
                Object object;
                boolean bl2 = false;
                boolean bl3 = customTag.getRoot().isXmlSyntax() && attributes.getValue(i).startsWith("%=") || !customTag.getRoot().isXmlSyntax() && attributes.getValue(i).startsWith("<%=");
                boolean bl4 = false;
                boolean bl5 = false;
                double d = Double.parseDouble(tagInfo.getTagLibrary().getRequiredVersion());
                boolean bl6 = this.pageInfo.isDeferredSyntaxAllowedAsLiteral() || d < 2.1;
                String string = attributes.getValue(i);
                ELNode.Nodes nodes = null;
                if (!bl3 && !this.pageInfo.isELIgnored()) {
                    nodes = ELParser.parse(string, bl6);
                    Iterator<ELNode> iterator2 = nodes.iterator();
                    while (iterator2.hasNext()) {
                        object = iterator2.next();
                        if (!(object instanceof ELNode.Root)) continue;
                        if (((ELNode.Root)object).getType() == '$') {
                            if (bl4 && bl5) {
                                this.err.jspError(customTag, "jsp.error.attribute.deferredmix");
                            }
                            bl4 = true;
                            continue;
                        }
                        if (((ELNode.Root)object).getType() != '#') continue;
                        if (bl4 && !bl5) {
                            this.err.jspError(customTag, "jsp.error.attribute.deferredmix");
                        }
                        bl4 = true;
                        bl5 = true;
                    }
                }
                boolean bl7 = bl = bl3 || bl4;
                object = !bl4 && nodes != null ? ((iterator = nodes.iterator()).hasNext() ? ((ELNode.Text)iterator.next()).getText() : "") : string;
                for (int j = 0; tagAttributeInfoArray != null && j < tagAttributeInfoArray.length; ++j) {
                    if (!attributes.getLocalName(i).equals(tagAttributeInfoArray[j].getName()) || attributes.getURI(i) != null && attributes.getURI(i).length() != 0 && !attributes.getURI(i).equals(customTag.getURI())) continue;
                    TagAttributeInfo tagAttributeInfo = tagAttributeInfoArray[j];
                    if (tagAttributeInfo.canBeRequestTime() || tagAttributeInfo.isDeferredMethod() || tagAttributeInfo.isDeferredValue()) {
                        if (!bl) {
                            Object object2;
                            String string2 = null;
                            if (tagAttributeInfo.isDeferredMethod()) {
                                object2 = tagAttributeInfo.getMethodSignature();
                                if (object2 != null) {
                                    int n = ((String)(object2 = ((String)object2).trim())).indexOf(32);
                                    if (n > 0) {
                                        string2 = ((String)object2).substring(0, n).trim();
                                    }
                                } else {
                                    string2 = "java.lang.Object";
                                }
                                if ("void".equals(string2)) {
                                    this.err.jspError(customTag, "jsp.error.literal_with_void", tagAttributeInfo.getName());
                                }
                            }
                            if (tagAttributeInfo.isDeferredValue()) {
                                string2 = tagAttributeInfo.getExpectedTypeName();
                            }
                            if (string2 != null) {
                                object2 = String.class;
                                try {
                                    object2 = JspUtil.toClass(string2, this.loader);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    this.err.jspError((Node)customTag, "jsp.error.unknown_attribute_type", tagAttributeInfo.getName(), string2);
                                }
                                if (String.class.equals(object2) || object2 == Long.TYPE || object2 == Double.TYPE || object2 == Byte.TYPE || object2 == Short.TYPE || object2 == Integer.TYPE || object2 == Float.TYPE || Number.class.isAssignableFrom((Class<?>)object2) || Character.class.equals(object2) || Character.TYPE == object2 || Boolean.class.equals(object2) || Boolean.TYPE == object2 || ((Class)object2).isEnum()) {
                                    try {
                                        this.expressionFactory.coerceToType(object, object2);
                                    }
                                    catch (Exception exception) {
                                        this.err.jspError(customTag, "jsp.error.coerce_to_type", tagAttributeInfo.getName(), string2, (String)object);
                                    }
                                }
                            }
                            jspAttributeArray[i] = new Node.JspAttribute(tagAttributeInfo, attributes.getQName(i), attributes.getURI(i), attributes.getLocalName(i), (String)object, false, null, false);
                        } else {
                            if (bl5 && !tagAttributeInfo.isDeferredMethod() && !tagAttributeInfo.isDeferredValue()) {
                                this.err.jspError(customTag, "jsp.error.attribute.custom.non_rt_with_expr", tagAttributeInfo.getName());
                            }
                            if (!bl5 && !tagAttributeInfo.canBeRequestTime()) {
                                this.err.jspError(customTag, "jsp.error.attribute.custom.non_rt_with_expr", tagAttributeInfo.getName());
                            }
                            jspAttributeArray[i] = this.getJspAttribute(tagAttributeInfo, attributes.getQName(i), attributes.getURI(i), attributes.getLocalName(i), string, customTag, nodes, false);
                        }
                    } else {
                        if (bl) {
                            this.err.jspError(customTag, "jsp.error.attribute.custom.non_rt_with_expr", tagAttributeInfo.getName());
                        }
                        jspAttributeArray[i] = new Node.JspAttribute(tagAttributeInfo, attributes.getQName(i), attributes.getURI(i), attributes.getLocalName(i), (String)object, false, null, false);
                    }
                    if (bl) {
                        hashtable.put(attributes.getQName(i), TagData.REQUEST_TIME_VALUE);
                    } else {
                        hashtable.put(attributes.getQName(i), object);
                    }
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                if (tagInfo.hasDynamicAttributes()) {
                    jspAttributeArray[i] = this.getJspAttribute(null, attributes.getQName(i), attributes.getURI(i), attributes.getLocalName(i), string, customTag, nodes, true);
                    continue;
                }
                this.err.jspError((Node)customTag, "jsp.error.bad_attribute", attributes.getQName(i), customTag.getLocalName());
            }
        }

        private void checkNamedAttributes(Node.CustomTag customTag, Node.JspAttribute[] jspAttributeArray, int n, Hashtable<String, Object> hashtable) throws JasperException {
            TagInfo tagInfo = customTag.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError(customTag, "jsp.error.missing.tagInfo", customTag.getQName());
            }
            TagAttributeInfo[] tagAttributeInfoArray = tagInfo.getAttributes();
            Node.Nodes nodes = customTag.getNamedAttributeNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                Node.NamedAttribute namedAttribute = (Node.NamedAttribute)nodes.getNode(i);
                boolean bl = false;
                for (TagAttributeInfo tagAttributeInfo : tagAttributeInfoArray) {
                    String string = namedAttribute.getPrefix();
                    if (!namedAttribute.getLocalName().equals(tagAttributeInfo.getName()) || string != null && string.length() != 0 && !string.equals(customTag.getPrefix())) continue;
                    jspAttributeArray[n + i] = new Node.JspAttribute(namedAttribute, tagAttributeInfo, false);
                    NamedAttributeVisitor namedAttributeVisitor = null;
                    if (namedAttribute.getBody() != null) {
                        namedAttributeVisitor = new NamedAttributeVisitor();
                        namedAttribute.getBody().visit(namedAttributeVisitor);
                    }
                    if (namedAttributeVisitor != null && namedAttributeVisitor.hasDynamicContent()) {
                        hashtable.put(namedAttribute.getName(), TagData.REQUEST_TIME_VALUE);
                    } else {
                        hashtable.put(namedAttribute.getName(), namedAttribute.getText());
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (tagInfo.hasDynamicAttributes()) {
                    jspAttributeArray[n + i] = new Node.JspAttribute(namedAttribute, null, true);
                    continue;
                }
                this.err.jspError((Node)customTag, "jsp.error.bad_attribute", namedAttribute.getName(), customTag.getLocalName());
            }
        }

        private Node.JspAttribute getJspAttribute(TagAttributeInfo tagAttributeInfo, String string, String string2, String string3, String string4, Node node, ELNode.Nodes nodes, boolean bl) throws JasperException {
            Node.JspAttribute jspAttribute = null;
            if (string4 != null) {
                if (node.getRoot().isXmlSyntax() && string4.startsWith("%=")) {
                    jspAttribute = new Node.JspAttribute(tagAttributeInfo, string, string2, string3, string4.substring(2, string4.length() - 1), true, null, bl);
                } else if (!node.getRoot().isXmlSyntax() && string4.startsWith("<%=")) {
                    jspAttribute = new Node.JspAttribute(tagAttributeInfo, string, string2, string3, string4.substring(3, string4.length() - 2), true, null, bl);
                } else {
                    Object object;
                    if (!this.pageInfo.isELIgnored()) {
                        if (nodes == null) {
                            nodes = ELParser.parse(string4, this.pageInfo.isDeferredSyntaxAllowedAsLiteral());
                        }
                        if (nodes.containsEL()) {
                            this.validateFunctions(nodes, node);
                        } else {
                            object = nodes.iterator();
                            string4 = object.hasNext() ? ((ELNode.Text)object.next()).getText() : "";
                            nodes = null;
                        }
                    }
                    if (node instanceof Node.UninterpretedTag && node.getRoot().isXmlSyntax()) {
                        if (nodes != null) {
                            object = new XmlEscapeNonELVisitor(this.pageInfo.isDeferredSyntaxAllowedAsLiteral());
                            nodes.visit((ELNode.Visitor)object);
                            string4 = ((ELParser.TextBuilder)object).getText();
                        } else {
                            string4 = Validator.xmlEscape(string4);
                        }
                    }
                    jspAttribute = new Node.JspAttribute(tagAttributeInfo, string, string2, string3, string4, false, nodes, bl);
                    if (nodes != null) {
                        object = new ELContextImpl();
                        ((ELContextImpl)((Object)object)).setFunctionMapper(this.getFunctionMapper(nodes));
                        try {
                            jspAttribute.validateEL(this.pageInfo.getExpressionFactory(), (ELContext)object);
                        }
                        catch (ELException eLException) {
                            this.err.jspError(node.getStart(), "jsp.error.invalid.expression", string4, eLException.toString());
                        }
                    }
                }
            } else {
                Node.NamedAttribute namedAttribute = node.getNamedAttributeNode(string);
                if (namedAttribute != null) {
                    jspAttribute = new Node.JspAttribute(namedAttribute, tagAttributeInfo, bl);
                }
            }
            return jspAttribute;
        }

        private StringBuilder getBuffer() {
            this.buf.setLength(0);
            return this.buf;
        }

        private boolean isExpression(Node node, String string, boolean bl) {
            boolean bl2 = node.getRoot().isXmlSyntax() && string.startsWith("%=") || !node.getRoot().isXmlSyntax() && string.startsWith("<%=");
            boolean bl3 = false;
            if (!bl2 && !this.pageInfo.isELIgnored()) {
                Iterator<ELNode> iterator = ELParser.parse(string, this.pageInfo.isDeferredSyntaxAllowedAsLiteral()).iterator();
                while (iterator.hasNext()) {
                    ELNode eLNode = iterator.next();
                    if (!(eLNode instanceof ELNode.Root)) continue;
                    if (((ELNode.Root)eLNode).getType() == '$') {
                        bl3 = true;
                        break;
                    }
                    if (!bl || this.pageInfo.isDeferredSyntaxAllowedAsLiteral() || ((ELNode.Root)eLNode).getType() != '#') continue;
                    bl3 = true;
                    break;
                }
            }
            return bl2 || bl3;
        }

        private void throwErrorIfExpression(Node node, String string, String string2) throws JasperException {
            if (node.getAttributes() != null && node.getAttributes().getValue(string) != null && this.isExpression(node, node.getAttributes().getValue(string), true)) {
                this.err.jspError(node, "jsp.error.attribute.standard.non_rt_with_expr", string, string2);
            }
        }

        private String findUri(String string, Node node) {
            for (Node node2 = node; node2 != null; node2 = node2.getParent()) {
                Attributes attributes = node2.getTaglibAttributes();
                if (attributes == null) continue;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string2 = attributes.getQName(i);
                    int n = string2.indexOf(58);
                    if (string == null && n < 0) {
                        return attributes.getValue(i);
                    }
                    if (string == null || n < 0 || !string.equals(string2.substring(n + 1))) continue;
                    return attributes.getValue(i);
                }
            }
            return null;
        }

        private void validateFunctions(ELNode.Nodes nodes, Node node) throws JasperException {
            class FVVisitor
            extends ELNode.Visitor {
                Node n;

                FVVisitor(Node node) {
                    this.n = node;
                }

                @Override
                public void visit(ELNode.Function function) throws JasperException {
                    String string = function.getPrefix();
                    String string2 = function.getName();
                    String string3 = null;
                    if (this.n.getRoot().isXmlSyntax()) {
                        string3 = ValidateVisitor.this.findUri(string, this.n);
                    } else if (string != null) {
                        string3 = ValidateVisitor.this.pageInfo.getURI(string);
                    }
                    if (string3 == null) {
                        if (string == null) {
                            ValidateVisitor.this.err.jspError(this.n, "jsp.error.noFunctionPrefix", string2);
                        } else {
                            ValidateVisitor.this.err.jspError(this.n, "jsp.error.attribute.invalidPrefix", string);
                        }
                    }
                    TagLibraryInfo tagLibraryInfo = ValidateVisitor.this.pageInfo.getTaglib(string3);
                    FunctionInfo functionInfo = null;
                    if (tagLibraryInfo != null) {
                        functionInfo = tagLibraryInfo.getFunction(string2);
                    }
                    if (functionInfo == null) {
                        ValidateVisitor.this.err.jspError(this.n, "jsp.error.noFunction", string2);
                    }
                    function.setUri(string3);
                    function.setFunctionInfo(functionInfo);
                    ValidateVisitor.this.processSignature(function);
                }
            }
            nodes.visit(new FVVisitor(node));
        }

        private void prepareExpression(ELNode.Nodes nodes, Node node, String string) throws JasperException {
            this.validateFunctions(nodes, node);
            ELContextImpl eLContextImpl = new ELContextImpl();
            eLContextImpl.setFunctionMapper(this.getFunctionMapper(nodes));
            ExpressionFactory expressionFactory = this.pageInfo.getExpressionFactory();
            try {
                expressionFactory.createValueExpression((ELContext)eLContextImpl, string, Object.class);
            }
            catch (ELException eLException) {
                throw new JasperException(eLException);
            }
        }

        private void processSignature(ELNode.Function function) throws JasperException {
            function.setMethodName(this.getMethod(function));
            function.setParameters(this.getParameters(function));
        }

        private String getMethod(ELNode.Function function) throws JasperException {
            FunctionInfo functionInfo = function.getFunctionInfo();
            String string = functionInfo.getFunctionSignature();
            Matcher matcher = METHOD_NAME_PATTERN.matcher(string);
            if (!matcher.matches()) {
                this.err.jspError("jsp.error.tld.fn.invalid.signature", function.getPrefix(), function.getName());
            }
            return matcher.group(1);
        }

        private String[] getParameters(ELNode.Function function) throws JasperException {
            FunctionInfo functionInfo = function.getFunctionInfo();
            String string = functionInfo.getFunctionSignature();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = string.indexOf(40) + 1;
            boolean bl = false;
            while (true) {
                String string2;
                int n2;
                if ((n2 = string.indexOf(44, n)) < 0) {
                    n2 = string.indexOf(41, n);
                    if (n2 < 0) {
                        this.err.jspError("jsp.error.tld.fn.invalid.signature", function.getPrefix(), function.getName());
                    }
                    bl = true;
                }
                if (!"".equals(string2 = string.substring(n, n2).trim())) {
                    arrayList.add(string2);
                }
                if (bl) break;
                n = n2 + 1;
            }
            return arrayList.toArray(new String[0]);
        }

        private FunctionMapper getFunctionMapper(ELNode.Nodes nodes) throws JasperException {
            class ValidateFunctionMapper
            extends FunctionMapper {
                private HashMap<String, Method> fnmap = new HashMap();

                ValidateFunctionMapper() {
                }

                public void mapFunction(String string, Method method) {
                    this.fnmap.put(string, method);
                }

                public Method resolveFunction(String string, String string2) {
                    return this.fnmap.get(string + ":" + string2);
                }
            }
            ValidateFunctionMapper validateFunctionMapper = new ValidateFunctionMapper();
            class MapperELVisitor
            extends ELNode.Visitor {
                ValidateFunctionMapper fmapper;

                MapperELVisitor(ValidateFunctionMapper validateFunctionMapper) {
                    this.fmapper = validateFunctionMapper;
                }

                @Override
                public void visit(ELNode.Function function) throws JasperException {
                    Class<?> clazz = null;
                    Method method = null;
                    try {
                        clazz = ValidateVisitor.this.loader.loadClass(function.getFunctionInfo().getFunctionClass());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ValidateVisitor.this.err.jspError("jsp.error.function.classnotfound", function.getFunctionInfo().getFunctionClass(), function.getPrefix() + ':' + function.getName(), classNotFoundException.getMessage());
                    }
                    String[] stringArray = function.getParameters();
                    int n = stringArray.length;
                    Class[] classArray = new Class[n];
                    int n2 = 0;
                    try {
                        for (n2 = 0; n2 < n; ++n2) {
                            classArray[n2] = JspUtil.toClass(stringArray[n2], ValidateVisitor.this.loader);
                        }
                        method = clazz.getDeclaredMethod(function.getMethodName(), classArray);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ValidateVisitor.this.err.jspError("jsp.error.signature.classnotfound", stringArray[n2], function.getPrefix() + ':' + function.getName(), classNotFoundException.getMessage());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        ValidateVisitor.this.err.jspError("jsp.error.noFunctionMethod", function.getMethodName(), function.getName(), clazz.getName());
                    }
                    this.fmapper.mapFunction(function.getPrefix() + ':' + function.getName(), method);
                }
            }
            nodes.visit(new MapperELVisitor(validateFunctionMapper));
            return validateFunctionMapper;
        }

        private static class NamedAttributeVisitor
        extends Node.Visitor {
            private boolean hasDynamicContent;

            private NamedAttributeVisitor() {
            }

            @Override
            public void doVisit(Node node) throws JasperException {
                if (!(node instanceof Node.JspText) && !(node instanceof Node.TemplateText)) {
                    this.hasDynamicContent = true;
                }
                this.visitBody(node);
            }

            public boolean hasDynamicContent() {
                return this.hasDynamicContent;
            }
        }

        private static class XmlEscapeNonELVisitor
        extends ELParser.TextBuilder {
            protected XmlEscapeNonELVisitor(boolean bl) {
                super(bl);
            }

            @Override
            public void visit(ELNode.Text text) throws JasperException {
                this.output.append(ELParser.escapeLiteralExpression(Validator.xmlEscape(text.getText()), this.isDeferredSyntaxAllowedAsLiteral));
            }
        }
    }

    static class DirectiveVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;
        private static final JspUtil.ValidAttribute[] pageDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("extends"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("session"), new JspUtil.ValidAttribute("buffer"), new JspUtil.ValidAttribute("autoFlush"), new JspUtil.ValidAttribute("isThreadSafe"), new JspUtil.ValidAttribute("info"), new JspUtil.ValidAttribute("errorPage"), new JspUtil.ValidAttribute("isErrorPage"), new JspUtil.ValidAttribute("contentType"), new JspUtil.ValidAttribute("pageEncoding"), new JspUtil.ValidAttribute("isELIgnored"), new JspUtil.ValidAttribute("deferredSyntaxAllowedAsLiteral"), new JspUtil.ValidAttribute("trimDirectiveWhitespaces")};
        private boolean pageEncodingSeen = false;

        DirectiveVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
        }

        @Override
        public void visit(Node.IncludeDirective includeDirective) throws JasperException {
            boolean bl = this.pageEncodingSeen;
            this.pageEncodingSeen = false;
            this.visitBody(includeDirective);
            this.pageEncodingSeen = bl;
        }

        @Override
        public void visit(Node.PageDirective pageDirective) throws JasperException {
            JspUtil.checkAttributes("Page directive", pageDirective, pageDirectiveAttrs, this.err);
            Attributes attributes = pageDirective.getAttributes();
            for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
                String string = attributes.getQName(i);
                String string2 = attributes.getValue(i);
                if ("language".equals(string)) {
                    if (this.pageInfo.getLanguage(false) == null) {
                        this.pageInfo.setLanguage(string2, pageDirective, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getLanguage(false).equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.language", this.pageInfo.getLanguage(false), string2);
                    continue;
                }
                if ("extends".equals(string)) {
                    if (this.pageInfo.getExtends(false) == null) {
                        this.pageInfo.setExtends(string2);
                        continue;
                    }
                    if (this.pageInfo.getExtends(false).equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.extends", this.pageInfo.getExtends(false), string2);
                    continue;
                }
                if ("contentType".equals(string)) {
                    if (this.pageInfo.getContentType() == null) {
                        this.pageInfo.setContentType(string2);
                        continue;
                    }
                    if (this.pageInfo.getContentType().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.contenttype", this.pageInfo.getContentType(), string2);
                    continue;
                }
                if ("session".equals(string)) {
                    if (this.pageInfo.getSession() == null) {
                        this.pageInfo.setSession(string2, pageDirective, this.err);
                        continue;
                    }
                    if (this.pageInfo.getSession().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.session", this.pageInfo.getSession(), string2);
                    continue;
                }
                if ("buffer".equals(string)) {
                    if (this.pageInfo.getBufferValue() == null) {
                        this.pageInfo.setBufferValue(string2, pageDirective, this.err);
                        continue;
                    }
                    if (this.pageInfo.getBufferValue().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.buffer", this.pageInfo.getBufferValue(), string2);
                    continue;
                }
                if ("autoFlush".equals(string)) {
                    if (this.pageInfo.getAutoFlush() == null) {
                        this.pageInfo.setAutoFlush(string2, pageDirective, this.err);
                        continue;
                    }
                    if (this.pageInfo.getAutoFlush().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.autoflush", this.pageInfo.getAutoFlush(), string2);
                    continue;
                }
                if ("isThreadSafe".equals(string)) {
                    if (this.pageInfo.getIsThreadSafe() == null) {
                        this.pageInfo.setIsThreadSafe(string2, pageDirective, this.err);
                        continue;
                    }
                    if (this.pageInfo.getIsThreadSafe().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.isthreadsafe", this.pageInfo.getIsThreadSafe(), string2);
                    continue;
                }
                if ("isELIgnored".equals(string)) {
                    if (this.pageInfo.getIsELIgnored() == null) {
                        this.pageInfo.setIsELIgnored(string2, pageDirective, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getIsELIgnored().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.iselignored", this.pageInfo.getIsELIgnored(), string2);
                    continue;
                }
                if ("isErrorPage".equals(string)) {
                    if (this.pageInfo.getIsErrorPage() == null) {
                        this.pageInfo.setIsErrorPage(string2, pageDirective, this.err);
                        continue;
                    }
                    if (this.pageInfo.getIsErrorPage().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.iserrorpage", this.pageInfo.getIsErrorPage(), string2);
                    continue;
                }
                if ("errorPage".equals(string)) {
                    if (this.pageInfo.getErrorPage() == null) {
                        this.pageInfo.setErrorPage(string2);
                        continue;
                    }
                    if (this.pageInfo.getErrorPage().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.errorpage", this.pageInfo.getErrorPage(), string2);
                    continue;
                }
                if ("info".equals(string)) {
                    if (this.pageInfo.getInfo() == null) {
                        this.pageInfo.setInfo(string2);
                        continue;
                    }
                    if (this.pageInfo.getInfo().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.info", this.pageInfo.getInfo(), string2);
                    continue;
                }
                if ("pageEncoding".equals(string)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError(pageDirective, "jsp.error.page.multi.pageencoding");
                    }
                    this.pageEncodingSeen = true;
                    String string3 = this.comparePageEncodings(string2, pageDirective);
                    pageDirective.getRoot().setPageEncoding(string3);
                    continue;
                }
                if ("deferredSyntaxAllowedAsLiteral".equals(string)) {
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral() == null) {
                        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(string2, pageDirective, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral().equals(string2)) continue;
                    this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.deferredsyntaxallowedasliteral", this.pageInfo.getDeferredSyntaxAllowedAsLiteral(), string2);
                    continue;
                }
                if (!"trimDirectiveWhitespaces".equals(string)) continue;
                if (this.pageInfo.getTrimDirectiveWhitespaces() == null) {
                    this.pageInfo.setTrimDirectiveWhitespaces(string2, pageDirective, this.err, true);
                    continue;
                }
                if (this.pageInfo.getTrimDirectiveWhitespaces().equals(string2)) continue;
                this.err.jspError((Node)pageDirective, "jsp.error.page.conflict.trimdirectivewhitespaces", this.pageInfo.getTrimDirectiveWhitespaces(), string2);
            }
            if (this.pageInfo.getBuffer() == 0 && !this.pageInfo.isAutoFlush()) {
                this.err.jspError(pageDirective, "jsp.error.page.badCombo");
            }
            this.pageInfo.addImports(pageDirective.getImports());
        }

        @Override
        public void visit(Node.TagDirective tagDirective) throws JasperException {
            Attributes attributes = tagDirective.getAttributes();
            for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
                String string = attributes.getQName(i);
                String string2 = attributes.getValue(i);
                if ("language".equals(string)) {
                    if (this.pageInfo.getLanguage(false) == null) {
                        this.pageInfo.setLanguage(string2, tagDirective, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getLanguage(false).equals(string2)) continue;
                    this.err.jspError((Node)tagDirective, "jsp.error.tag.conflict.language", this.pageInfo.getLanguage(false), string2);
                    continue;
                }
                if ("isELIgnored".equals(string)) {
                    if (this.pageInfo.getIsELIgnored() == null) {
                        this.pageInfo.setIsELIgnored(string2, tagDirective, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getIsELIgnored().equals(string2)) continue;
                    this.err.jspError((Node)tagDirective, "jsp.error.tag.conflict.iselignored", this.pageInfo.getIsELIgnored(), string2);
                    continue;
                }
                if ("pageEncoding".equals(string)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError(tagDirective, "jsp.error.tag.multi.pageencoding");
                    }
                    this.pageEncodingSeen = true;
                    this.compareTagEncodings(string2, tagDirective);
                    tagDirective.getRoot().setPageEncoding(string2);
                    continue;
                }
                if ("deferredSyntaxAllowedAsLiteral".equals(string)) {
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral() == null) {
                        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(string2, tagDirective, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral().equals(string2)) continue;
                    this.err.jspError((Node)tagDirective, "jsp.error.tag.conflict.deferredsyntaxallowedasliteral", this.pageInfo.getDeferredSyntaxAllowedAsLiteral(), string2);
                    continue;
                }
                if (!"trimDirectiveWhitespaces".equals(string)) continue;
                if (this.pageInfo.getTrimDirectiveWhitespaces() == null) {
                    this.pageInfo.setTrimDirectiveWhitespaces(string2, tagDirective, this.err, false);
                    continue;
                }
                if (this.pageInfo.getTrimDirectiveWhitespaces().equals(string2)) continue;
                this.err.jspError((Node)tagDirective, "jsp.error.tag.conflict.trimdirectivewhitespaces", this.pageInfo.getTrimDirectiveWhitespaces(), string2);
            }
            this.pageInfo.addImports(tagDirective.getImports());
        }

        @Override
        public void visit(Node.AttributeDirective attributeDirective) throws JasperException {
        }

        @Override
        public void visit(Node.VariableDirective variableDirective) throws JasperException {
        }

        private String comparePageEncodings(String string, Node.PageDirective pageDirective) throws JasperException {
            Node.Root root = pageDirective.getRoot();
            String string2 = root.getJspConfigPageEncoding();
            String string3 = string.toUpperCase(Locale.ENGLISH);
            if (string2 != null) {
                if (!(string3.equals(string2 = string2.toUpperCase(Locale.ENGLISH)) || string3.startsWith("UTF-16") && string2.startsWith("UTF-16"))) {
                    this.err.jspError((Node)pageDirective, "jsp.error.config_pagedir_encoding_mismatch", string2, string3);
                } else {
                    return string2;
                }
            }
            if (root.isXmlSyntax() && root.isEncodingSpecifiedInProlog() || root.isBomPresent()) {
                String string4 = root.getPageEncoding().toUpperCase(Locale.ENGLISH);
                if (!(string3.equals(string4) || string3.startsWith("UTF-16") && string4.startsWith("UTF-16"))) {
                    this.err.jspError((Node)pageDirective, "jsp.error.prolog_pagedir_encoding_mismatch", string4, string3);
                } else {
                    return string4;
                }
            }
            return string3;
        }

        private void compareTagEncodings(String string, Node.TagDirective tagDirective) throws JasperException {
            String string2;
            Node.Root root = tagDirective.getRoot();
            String string3 = string.toUpperCase(Locale.ENGLISH);
            if ((root.isXmlSyntax() && root.isEncodingSpecifiedInProlog() || root.isBomPresent()) && !string3.equals(string2 = root.getPageEncoding().toUpperCase(Locale.ENGLISH)) && (!string3.startsWith("UTF-16") || !string2.startsWith("UTF-16"))) {
                this.err.jspError((Node)tagDirective, "jsp.error.prolog_pagedir_encoding_mismatch", string2, string3);
            }
        }
    }
}

