/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class SerializablePrincipal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SerializablePrincipal.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.ha.session");
    protected String name = null;
    protected String password = null;
    protected transient Realm realm = null;
    protected String[] roles = new String[0];
    protected Principal userPrincipal = null;

    public SerializablePrincipal() {
    }

    public SerializablePrincipal(String string, String string2) {
        this(string, string2, null);
    }

    public SerializablePrincipal(String string, String string2, List<String> list) {
        this(string, string2, list, null);
    }

    public SerializablePrincipal(String string, String string2, List<String> list, Principal principal) {
        this.name = string;
        this.password = string2;
        if (list != null) {
            this.roles = new String[list.size()];
            this.roles = list.toArray(this.roles);
            if (this.roles.length > 1) {
                Arrays.sort(this.roles);
            }
        }
        if (principal instanceof Serializable) {
            this.userPrincipal = principal;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SerializablePrincipal[");
        stringBuilder.append(this.name);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static SerializablePrincipal createPrincipal(GenericPrincipal genericPrincipal) {
        if (genericPrincipal == null) {
            return null;
        }
        return new SerializablePrincipal(genericPrincipal.getName(), genericPrincipal.getPassword(), genericPrincipal.getRoles() != null ? Arrays.asList(genericPrincipal.getRoles()) : null, genericPrincipal.getUserPrincipal() != genericPrincipal ? genericPrincipal.getUserPrincipal() : null);
    }

    public GenericPrincipal getPrincipal() {
        return new GenericPrincipal(this.name, this.password, this.getRoles() != null ? Arrays.asList(this.getRoles()) : null, this.userPrincipal);
    }

    public static GenericPrincipal readPrincipal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        boolean bl = objectInput.readBoolean();
        String string2 = null;
        if (bl) {
            string2 = objectInput.readUTF();
        }
        int n = objectInput.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = objectInput.readUTF();
        }
        Principal principal = null;
        boolean bl2 = objectInput.readBoolean();
        if (bl2) {
            try {
                principal = (Principal)objectInput.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error((Object)sm.getString("serializablePrincipal.readPrincipal.cnfe"), (Throwable)classNotFoundException);
                throw classNotFoundException;
            }
        }
        return new GenericPrincipal(string, string2, Arrays.asList(stringArray), principal);
    }

    public static void writePrincipal(GenericPrincipal genericPrincipal, ObjectOutput objectOutput) throws IOException {
        boolean bl;
        String[] stringArray;
        objectOutput.writeUTF(genericPrincipal.getName());
        objectOutput.writeBoolean(genericPrincipal.getPassword() != null);
        if (genericPrincipal.getPassword() != null) {
            objectOutput.writeUTF(genericPrincipal.getPassword());
        }
        if ((stringArray = genericPrincipal.getRoles()) == null) {
            stringArray = new String[]{};
        }
        objectOutput.writeInt(stringArray.length);
        for (bl = false; bl < stringArray.length; bl += 1) {
            objectOutput.writeUTF(stringArray[bl]);
        }
        bl = genericPrincipal != genericPrincipal.getUserPrincipal() && genericPrincipal.getUserPrincipal() instanceof Serializable;
        objectOutput.writeBoolean(bl);
        if (bl) {
            objectOutput.writeObject(genericPrincipal.getUserPrincipal());
        }
    }
}

