/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class NioChannel
implements ByteChannel,
ScatteringByteChannel,
GatheringByteChannel {
    protected static final StringManager sm = StringManager.getManager(NioChannel.class);
    protected static final ByteBuffer emptyBuf = ByteBuffer.allocate(0);
    protected SocketChannel sc = null;
    protected SocketWrapperBase<NioChannel> socketWrapper = null;
    protected final SocketBufferHandler bufHandler;
    protected NioEndpoint.Poller poller;
    private ApplicationBufferHandler appReadBufHandler;

    public NioChannel(SocketChannel socketChannel, SocketBufferHandler socketBufferHandler) {
        this.sc = socketChannel;
        this.bufHandler = socketBufferHandler;
    }

    public void reset() throws IOException {
        this.bufHandler.reset();
    }

    void setSocketWrapper(SocketWrapperBase<NioChannel> socketWrapperBase) {
        this.socketWrapper = socketWrapperBase;
    }

    public void free() {
        this.bufHandler.free();
    }

    public boolean flush(boolean bl, Selector selector, long l) throws IOException {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.getIOChannel().socket().close();
        this.getIOChannel().close();
    }

    public void close(boolean bl) throws IOException {
        if (this.isOpen() || bl) {
            this.close();
        }
    }

    @Override
    public boolean isOpen() {
        return this.sc.isOpen();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.checkInterruptStatus();
        return this.sc.write(byteBuffer);
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.write(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        this.checkInterruptStatus();
        return this.sc.write(byteBufferArray, n, n2);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.sc.read(byteBuffer);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.read(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.sc.read(byteBufferArray, n, n2);
    }

    public Object getAttachment() {
        NioEndpoint.Poller poller = this.getPoller();
        Selector selector = poller != null ? poller.getSelector() : null;
        SelectionKey selectionKey = selector != null ? this.getIOChannel().keyFor(selector) : null;
        Object object = selectionKey != null ? selectionKey.attachment() : null;
        return object;
    }

    public SocketBufferHandler getBufHandler() {
        return this.bufHandler;
    }

    public NioEndpoint.Poller getPoller() {
        return this.poller;
    }

    public SocketChannel getIOChannel() {
        return this.sc;
    }

    public boolean isClosing() {
        return false;
    }

    public boolean isHandshakeComplete() {
        return true;
    }

    public int handshake(boolean bl, boolean bl2) throws IOException {
        return 0;
    }

    public void setPoller(NioEndpoint.Poller poller) {
        this.poller = poller;
    }

    public void setIOChannel(SocketChannel socketChannel) {
        this.sc = socketChannel;
    }

    public String toString() {
        return super.toString() + ":" + this.sc.toString();
    }

    public int getOutboundRemaining() {
        return 0;
    }

    public boolean flushOutbound() throws IOException {
        return false;
    }

    protected void checkInterruptStatus() throws IOException {
        if (Thread.interrupted()) {
            throw new IOException(sm.getString("channel.nio.interrupted"));
        }
    }

    public void setAppReadBufHandler(ApplicationBufferHandler applicationBufferHandler) {
        this.appReadBufHandler = applicationBufferHandler;
    }

    protected ApplicationBufferHandler getAppReadBufHandler() {
        return this.appReadBufHandler;
    }
}

