/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.Writer;

public class XMLWriter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuilder buffer = new StringBuilder();
    protected final Writer writer;

    public XMLWriter() {
        this(null);
    }

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void writeProperty(String string, String string2, String string3) {
        this.writeElement(string, string2, 0);
        this.buffer.append(string3);
        this.writeElement(string, string2, 1);
    }

    public void writeElement(String string, String string2, int n) {
        this.writeElement(string, null, string2, n);
    }

    public void writeElement(String string, String string2, String string3, int n) {
        if (string != null && string.length() > 0) {
            switch (n) {
                case 0: {
                    if (string2 != null) {
                        this.buffer.append("<" + string + ":" + string3 + " xmlns:" + string + "=\"" + string2 + "\">");
                        break;
                    }
                    this.buffer.append("<" + string + ":" + string3 + ">");
                    break;
                }
                case 1: {
                    this.buffer.append("</" + string + ":" + string3 + ">\n");
                    break;
                }
                default: {
                    if (string2 != null) {
                        this.buffer.append("<" + string + ":" + string3 + " xmlns:" + string + "=\"" + string2 + "\"/>");
                        break;
                    }
                    this.buffer.append("<" + string + ":" + string3 + "/>");
                    break;
                }
            }
        } else {
            switch (n) {
                case 0: {
                    this.buffer.append("<" + string3 + ">");
                    break;
                }
                case 1: {
                    this.buffer.append("</" + string3 + ">\n");
                    break;
                }
                default: {
                    this.buffer.append("<" + string3 + "/>");
                }
            }
        }
    }

    public void writeText(String string) {
        this.buffer.append(string);
    }

    public void writeData(String string) {
        this.buffer.append("<![CDATA[" + string + "]]>");
    }

    public void writeXMLHeader() {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void sendData() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.buffer.toString());
            this.buffer = new StringBuilder();
        }
    }
}

