/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import java.util.Hashtable;
import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.OC;
import jspecview.common.ColorParameters;
import jspecview.common.Coordinate;
import jspecview.common.ExportType;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.export.FormExporter;
import org.jmol.util.Logger;

public class SVGExporter
extends FormExporter {
    private static int svgWidth = 850;
    private static int svgHeight = 400;
    private static int leftInset = 100;
    private static int rightInset = 200;
    private static int bottomInset = 80;
    private static int topInset = 20;

    @Override
    public String exportTheSpectrum(JSViewer viewer, ExportType mode, OC out, Spectrum spec, int startIndex, int endIndex, PanelData pd, boolean asBase64) throws IOException {
        double secondTranslateY;
        double secondTranslateX;
        double scaleY;
        double scaleX;
        double firstTranslateY;
        double firstTranslateX;
        Hashtable<String, String> hash;
        double i;
        Hashtable<String, String> hash2;
        String yStr;
        String xStr;
        double yPt;
        double xPt;
        double i2;
        GenericColor plotAreaColor;
        GenericColor backgroundColor;
        GenericColor plotColor;
        GenericColor gridColor;
        GenericColor titleColor;
        GenericColor scaleColor;
        GenericColor unitsColor;
        this.initForm(viewer, out);
        if (pd == null) {
            scaleColor = unitsColor = ColorParameters.BLACK;
            titleColor = unitsColor;
            gridColor = unitsColor;
            plotColor = unitsColor;
            backgroundColor = unitsColor;
            plotAreaColor = unitsColor;
        } else {
            plotAreaColor = pd.getColor(ScriptToken.PLOTAREACOLOR);
            backgroundColor = pd.bgcolor;
            plotColor = pd.getCurrentPlotColor(0);
            gridColor = pd.getColor(ScriptToken.GRIDCOLOR);
            titleColor = pd.getColor(ScriptToken.TITLECOLOR);
            scaleColor = pd.getColor(ScriptToken.SCALECOLOR);
            unitsColor = pd.getColor(ScriptToken.UNITSCOLOR);
        }
        Coordinate[] xyCoords = spec.getXYCoords();
        ScaleData scaleData = new ScaleData(xyCoords, startIndex, endIndex, spec.isContinuous(), spec.isInverted());
        double maxXOnScale = scaleData.maxXOnScale;
        double minXOnScale = scaleData.minXOnScale;
        double maxYOnScale = scaleData.maxYOnScale;
        double minYOnScale = scaleData.minYOnScale;
        double xStep = scaleData.steps[0];
        double yStep = scaleData.steps[1];
        int plotAreaWidth = svgWidth - leftInset - rightInset;
        int plotAreaHeight = svgHeight - topInset - bottomInset;
        double xScaleFactor = (double)plotAreaWidth / (maxXOnScale - minXOnScale);
        double yScaleFactor = (double)plotAreaHeight / (maxYOnScale - minYOnScale);
        int leftPlotArea = leftInset;
        int rightPlotArea = leftInset + plotAreaWidth;
        int topPlotArea = topInset;
        int bottomPlotArea = topInset + plotAreaHeight;
        int titlePosition = bottomPlotArea + 60;
        this.context.put("titlePosition", new Integer(titlePosition));
        Lst vertGridCoords = new Lst();
        Lst horizGridCoords = new Lst();
        for (i2 = minXOnScale; i2 < maxXOnScale + xStep / 2.0; i2 += xStep) {
            xPt = (double)leftPlotArea + (i2 - minXOnScale) * xScaleFactor;
            yPt = topPlotArea;
            xStr = DF.formatDecimalTrimmed(xPt, 6);
            yStr = DF.formatDecimalTrimmed(yPt, 6);
            hash2 = new Hashtable<String, String>();
            hash2.put("xVal", xStr);
            hash2.put("yVal", yStr);
            vertGridCoords.addLast(hash2);
        }
        for (i2 = minYOnScale; i2 < maxYOnScale + yStep / 2.0; i2 += yStep) {
            xPt = leftPlotArea;
            yPt = (double)topPlotArea + (i2 - minYOnScale) * yScaleFactor;
            xStr = DF.formatDecimalTrimmed(xPt, 6);
            yStr = DF.formatDecimalTrimmed(yPt, 6);
            hash2 = new Hashtable();
            hash2.put("xVal", xStr);
            hash2.put("yVal", yStr);
            horizGridCoords.addLast(hash2);
        }
        Lst xScaleList = new Lst();
        Lst xScaleListReversed = new Lst();
        Lst yScaleList = new Lst();
        int precisionX = scaleData.precision[0];
        int precisionY = scaleData.precision[1];
        for (i = minXOnScale; i < maxXOnScale + xStep / 2.0; i += xStep) {
            xPt = (double)leftPlotArea + (i - minXOnScale) * xScaleFactor;
            yPt = bottomPlotArea + 15;
            xStr = DF.formatDecimalTrimmed(xPt -= 10.0, 6);
            yStr = DF.formatDecimalTrimmed(yPt, 6);
            String iStr = DF.formatDecimalDbl(i, precisionX);
            hash = new Hashtable<String, String>();
            hash.put("xVal", xStr);
            hash.put("yVal", yStr);
            hash.put("number", iStr);
            xScaleList.addLast(hash);
        }
        i = minXOnScale;
        double j = maxXOnScale;
        while (i < maxXOnScale + xStep / 2.0) {
            xPt = (double)leftPlotArea + (j - minXOnScale) * xScaleFactor;
            yPt = bottomPlotArea + 15;
            xStr = DF.formatDecimalTrimmed(xPt -= 10.0, 6);
            yStr = DF.formatDecimalTrimmed(yPt, 6);
            String iStr = DF.formatDecimalDbl(i, precisionX);
            Hashtable<String, String> hash3 = new Hashtable<String, String>();
            hash3.put("xVal", xStr);
            hash3.put("yVal", yStr);
            hash3.put("number", iStr);
            xScaleListReversed.addLast(hash3);
            i += xStep;
            j -= xStep;
        }
        for (i = minYOnScale; i < maxYOnScale + yStep / 2.0; i += yStep) {
            xPt = leftPlotArea - 55;
            yPt = (double)bottomPlotArea - (i - minYOnScale) * yScaleFactor;
            xStr = DF.formatDecimalTrimmed(xPt, 6);
            yStr = DF.formatDecimalTrimmed(yPt += 3.0, 6);
            String iStr = DF.formatDecimalDbl(i, precisionY);
            hash = new Hashtable();
            hash.put("xVal", xStr);
            hash.put("yVal", yStr);
            hash.put("number", iStr);
            yScaleList.addLast(hash);
        }
        boolean increasing = spec.isXIncreasing();
        if (increasing) {
            firstTranslateX = leftPlotArea;
            firstTranslateY = bottomPlotArea;
            scaleX = xScaleFactor;
            scaleY = -yScaleFactor;
            secondTranslateX = -1.0 * minXOnScale;
            secondTranslateY = -1.0 * minYOnScale;
        } else {
            firstTranslateX = rightPlotArea;
            firstTranslateY = bottomPlotArea;
            scaleX = -xScaleFactor;
            scaleY = -yScaleFactor;
            secondTranslateX = -minXOnScale;
            secondTranslateY = -minYOnScale;
        }
        double yTickA = minYOnScale - yStep / 2.0;
        double yTickB = yStep / 5.0;
        this.context.put("plotAreaColor", CU.toRGBHexString(plotAreaColor));
        this.context.put("backgroundColor", CU.toRGBHexString(backgroundColor));
        this.context.put("plotColor", CU.toRGBHexString(plotColor));
        this.context.put("gridColor", CU.toRGBHexString(gridColor));
        this.context.put("titleColor", CU.toRGBHexString(titleColor));
        this.context.put("scaleColor", CU.toRGBHexString(scaleColor));
        this.context.put("unitsColor", CU.toRGBHexString(unitsColor));
        this.context.put("svgHeight", new Integer(svgHeight));
        this.context.put("svgWidth", new Integer(svgWidth));
        this.context.put("leftPlotArea", new Integer(leftPlotArea));
        this.context.put("rightPlotArea", new Integer(rightPlotArea));
        this.context.put("topPlotArea", new Integer(topPlotArea));
        this.context.put("bottomPlotArea", new Integer(bottomPlotArea));
        this.context.put("plotAreaHeight", new Integer(plotAreaHeight));
        this.context.put("plotAreaWidth", new Integer(plotAreaWidth));
        this.context.put("minXOnScale", new Double(minXOnScale));
        this.context.put("maxXOnScale", new Double(maxXOnScale));
        this.context.put("minYOnScale", new Double(minYOnScale));
        this.context.put("maxYOnScale", new Double(maxYOnScale));
        this.context.put("yTickA", new Double(yTickA));
        this.context.put("yTickB", new Double(yTickB));
        this.context.put("xScaleFactor", new Double(xScaleFactor));
        this.context.put("yScaleFactor", new Double(yScaleFactor));
        this.context.put("increasing", new Boolean(increasing));
        this.context.put("verticalGridCoords", vertGridCoords);
        this.context.put("horizontalGridCoords", horizGridCoords);
        Lst<Coordinate> newXYCoords = new Lst<Coordinate>();
        for (int i3 = startIndex; i3 <= endIndex; ++i3) {
            newXYCoords.addLast(xyCoords[i3]);
        }
        double firstX = xyCoords[startIndex].getXVal();
        double firstY = xyCoords[startIndex].getYVal();
        double lastX = xyCoords[endIndex].getXVal();
        this.context.put("title", titleColor);
        this.context.put("xyCoords", newXYCoords);
        this.context.put("continuous", new Boolean(spec.isContinuous()));
        this.context.put("firstTranslateX", new Double(firstTranslateX));
        this.context.put("firstTranslateY", new Double(firstTranslateY));
        this.context.put("scaleX", new Double(scaleX));
        this.context.put("scaleY", new Double(scaleY));
        this.context.put("secondTranslateX", new Double(secondTranslateX));
        this.context.put("secondTranslateY", new Double(secondTranslateY));
        if (increasing) {
            this.context.put("xScaleList", xScaleList);
            this.context.put("xScaleListReversed", xScaleListReversed);
        } else {
            this.context.put("xScaleList", xScaleListReversed);
            this.context.put("xScaleListReversed", xScaleList);
        }
        this.context.put("yScaleList", yScaleList);
        this.context.put("xUnits", spec.getXUnits());
        this.context.put("yUnits", spec.getYUnits());
        this.context.put("firstX", firstX);
        this.context.put("firstY", firstY);
        this.context.put("lastX", lastX);
        int xUnitLabelX = rightPlotArea - 50;
        int xUnitLabelY = bottomPlotArea + 30;
        int yUnitLabelX = leftPlotArea - 80;
        int yUnitLabelY = bottomPlotArea / 2;
        int tempX = yUnitLabelX;
        yUnitLabelX = -yUnitLabelY;
        yUnitLabelY = tempX;
        this.context.put("xUnitLabelX", "" + xUnitLabelX);
        this.context.put("xUnitLabelY", "" + xUnitLabelY);
        this.context.put("yUnitLabelX", "" + yUnitLabelX);
        this.context.put("yUnitLabelY", "" + yUnitLabelY);
        this.context.put("numDecimalPlacesX", new Integer(Math.abs(scaleData.exportPrecision[0])));
        this.context.put("numDecimalPlacesY", new Integer(Math.abs(scaleData.exportPrecision[1])));
        String vm = mode == ExportType.SVGI ? "plot_ink.vm" : "plot.vm";
        Logger.info("SVGExporter using " + vm);
        return this.writeForm(vm);
    }
}

