/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.deletebydate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.DataPoint;
import tim.prune.function.compress.MarkAndDeleteFunction;
import tim.prune.function.deletebydate.DateInfo;
import tim.prune.function.deletebydate.DateInfoList;
import tim.prune.function.deletebydate.DeletionTableModel;

public class DeleteByDateFunction
extends MarkAndDeleteFunction {
    private JDialog _dialog = null;
    private JButton _okButton = null;
    private DateInfoList _infoList = new DateInfoList();

    public DeleteByDateFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.deletebydate";
    }

    @Override
    public void begin() {
        DateInfo.setTimezone(TimezoneHelper.getSelectedTimezone());
        this._infoList.clearAll();
        int n = this._app.getTrackInfo().getTrack().getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n2);
            if (dataPoint != null) {
                if (dataPoint.hasTimestamp()) {
                    this._infoList.addPoint(dataPoint.getTimestamp().getCalendar(TimezoneHelper.getSelectedTimezone()).getTime());
                } else {
                    this._infoList.addPoint(null);
                }
            }
            ++n2;
        }
        if (this._infoList.getNumEntries() < 2) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.deletebydate.onlyonedate");
        } else {
            if (this._dialog == null) {
                this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
                this._dialog.setLocationRelativeTo(this._parentFrame);
                this._dialog.setDefaultCloseOperation(2);
                this._dialog.getContentPane().add(this.makeDialogComponents());
                this._dialog.pack();
            }
            this._dialog.setVisible(true);
        }
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.deletebydate.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    DeleteByDateFunction.this._dialog.dispose();
                }
            }
        };
        JTable jTable = new JTable(new DeletionTableModel(this._infoList));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(300, 80));
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(2, 50, 2, 50));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteByDateFunction.this.performDelete();
            }
        });
        jPanel2.add(this._okButton);
        this._okButton.addKeyListener(keyAdapter);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteByDateFunction.this._dialog.dispose();
            }
        });
        jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    DeleteByDateFunction.this._dialog.dispose();
                }
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void performDelete() {
        int n = 0;
        int n2 = this._app.getTrackInfo().getTrack().getNumPoints();
        int n3 = this._infoList.getNumEntries();
        int n4 = 0;
        while (n4 < n2) {
            DataPoint dataPoint = this._app.getTrackInfo().getTrack().getPoint(n4);
            if (dataPoint != null) {
                Date date = dataPoint.hasTimestamp() ? dataPoint.getTimestamp().getCalendar(TimezoneHelper.getSelectedTimezone()).getTime() : null;
                boolean bl = false;
                int n5 = 0;
                while (n5 < n3) {
                    DateInfo dateInfo = this._infoList.getDateInfo(n5);
                    if (dateInfo.isDateless() && date == null || !dateInfo.isDateless() && date != null && dateInfo.isSameDate(date)) {
                        bl = dateInfo.getDeleteFlag();
                        break;
                    }
                    ++n5;
                }
                dataPoint.setMarkedForDeletion(bl);
                if (bl) {
                    ++n;
                }
            }
            ++n4;
        }
        if (n > 0) {
            this.optionallyDeleteMarkedPoints(n);
        } else {
            UpdateMessageBroker.informSubscribers((byte)4);
        }
        this._dialog.dispose();
    }
}

