/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.gui.AboutDialog;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.CloseDialog;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.DockingFrameworkProvider;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.gui.ToolBarManager;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.input.InputHandlerProvider;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.jedit.manager.ViewManager;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchBar;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.jedit.options.CombinedOptions;

public class View
extends JFrame
implements InputHandlerProvider {
    public static final EditPane[] EMPTY_EDIT_PANES_ARRAY = new EditPane[0];
    public static final String VIEW_DOCKING_FRAMEWORK_PROPERTY = "view.docking.framework";
    private static final String ORIGINAL_DOCKING_FRAMEWORK = "Original";
    public static final String DOCKING_FRAMEWORK_PROVIDER_SERVICE = "org.gjt.sp.jedit.gui.DockingFrameworkProvider";
    private static DockingFrameworkProvider dockingFrameworkProvider;
    public static final int TOP_GROUP = 0;
    public static final int BOTTOM_GROUP = 1;
    public static final int DEFAULT_GROUP = 0;
    public static final int TOP_LAYER = Integer.MAX_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int BOTTOM_LAYER = Integer.MIN_VALUE;
    public static final int ABOVE_SYSTEM_BAR_LAYER = 150;
    public static final int SYSTEM_BAR_LAYER = 100;
    public static final int BELOW_SYSTEM_BAR_LAYER = 75;
    public static final int SEARCH_BAR_LAYER = 75;
    public static final int BELOW_SEARCH_BAR_LAYER = 50;
    public static final int ACTION_BAR_LAYER = -75;
    public static final int STATUS_BAR_LAYER = -100;
    public static final int BELOW_STATUS_BAR_LAYER = -150;
    public static final int VIEW = 0;
    public static final int TEXT_AREA = 1;
    public static final int ACTION_BAR = 2;
    View prev;
    View next;
    private boolean closed;
    private final DockableWindowManager dockableWindowManager;
    private final JPanel mainPanel;
    private final JPanel topToolBars;
    private final JPanel bottomToolBars;
    private ToolBarManager toolBarManager;
    private Container toolBar;
    private SearchBar searchBar;
    private ActionBar actionBar;
    private EditPane editPane;
    private JSplitPane splitPane;
    private String lastSplitConfig;
    private final StatusBar status;
    private InputHandler inputHandler;
    private Macros.Recorder recorder;
    private Component prefixFocusOwner;
    private int waitCount;
    private boolean showFullPath;
    private final boolean plainView;
    private Socket waitSocket;
    private Component mainContent;
    private boolean fullScreenMode = false;
    private Rectangle windowedBounds;
    private JMenuBar menuBar = null;
    private String userTitle;

    public DockableWindowManager getDockableWindowManager() {
        return this.dockableWindowManager;
    }

    public static String getDockingFrameworkName() {
        String string = jEdit.getProperty(VIEW_DOCKING_FRAMEWORK_PROPERTY, ORIGINAL_DOCKING_FRAMEWORK);
        return string;
    }

    public static DockingFrameworkProvider getDockingFrameworkProvider() {
        String string;
        if (dockingFrameworkProvider == null && (dockingFrameworkProvider = (DockingFrameworkProvider)ServiceManager.getService(DOCKING_FRAMEWORK_PROVIDER_SERVICE, string = View.getDockingFrameworkName())) == null) {
            Log.log(9, View.class, "No docking framework " + string + " available, using the original one");
            dockingFrameworkProvider = (DockingFrameworkProvider)ServiceManager.getService(DOCKING_FRAMEWORK_PROVIDER_SERVICE, ORIGINAL_DOCKING_FRAMEWORK);
        }
        return dockingFrameworkProvider;
    }

    public Container getToolBar() {
        return this.toolBar;
    }

    public void addToolBar(Component component) {
        this.addToolBar(0, 0, component);
    }

    public void addToolBar(int n, Component component) {
        this.addToolBar(n, 0, component);
    }

    public void addToolBar(int n, int n2, Component component) {
        this.toolBarManager.addToolBar(n, n2, component);
        this.getRootPane().revalidate();
    }

    public void removeToolBar(Component component) {
        if (this.toolBarManager == null) {
            return;
        }
        if (component == null) {
            return;
        }
        this.toolBarManager.removeToolBar(component);
        this.getRootPane().revalidate();
    }

    public synchronized void showWaitCursor() {
        if (this.waitCount++ == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor);
            this.visit(new SetCursorVisitor(cursor));
        }
    }

    public synchronized void hideWaitCursor() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        if (this.waitCount == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            this.visit(new SetCursorVisitor(cursor));
        }
    }

    public final SearchBar getSearchBar() {
        return this.searchBar;
    }

    public final ActionBar getActionBar() {
        return this.actionBar;
    }

    public StatusBar getStatus() {
        return this.status;
    }

    public void quickIncrementalSearch(boolean bl) {
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(false);
        JEditTextArea jEditTextArea = this.getTextArea();
        if (bl) {
            String string = jEditTextArea.getSelectedText();
            if (string == null) {
                jEditTextArea.selectWord();
                string = jEditTextArea.getSelectedText();
            } else if (string.indexOf(10) != -1) {
                string = null;
            }
            if (string != null && SearchAndReplace.getRegexp()) {
                string = SearchAndReplace.escapeRegexp(string, false);
            }
            this.searchBar.getField().setText(string);
        }
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void quickHyperSearch(boolean bl) {
        JEditTextArea jEditTextArea = this.getTextArea();
        if (bl) {
            String string = jEditTextArea.getSelectedText();
            if (string == null) {
                jEditTextArea.selectWord();
                string = jEditTextArea.getSelectedText();
            }
            if (string != null && string.indexOf(10) == -1) {
                if (SearchAndReplace.getRegexp()) {
                    string = SearchAndReplace.escapeRegexp(string, false);
                }
                HistoryModel.getModel("find").addItem(string);
                SearchAndReplace.setSearchString(string);
                SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
                SearchAndReplace.hyperSearch(this);
                return;
            }
        }
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(true);
        this.searchBar.getField().setText(null);
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void actionBar() {
        if (this.actionBar == null) {
            this.actionBar = new ActionBar(this, true);
        }
        if (this.actionBar.getParent() == null) {
            this.addToolBar(1, -75, this.actionBar);
        }
        this.actionBar.goToActionBar();
    }

    public KeyListener getKeyEventInterceptor() {
        return this.inputHandler.getKeyEventInterceptor();
    }

    public void setKeyEventInterceptor(KeyListener keyListener) {
        this.inputHandler.setKeyEventInterceptor(keyListener);
    }

    @Override
    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public Macros.Recorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(Macros.Recorder recorder) {
        this.recorder = recorder;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        this.inputHandler.processKeyEvent(keyEvent, 0, false);
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent, boolean bl) {
        this.processKeyEvent(keyEvent, bl ? 1 : 0);
    }

    public void processKeyEvent(KeyEvent keyEvent, int n) {
        this.inputHandler.processKeyEvent(keyEvent, n, false);
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public EditPane splitHorizontally() {
        return this.split(0);
    }

    public EditPane splitVertically() {
        return this.split(1);
    }

    public EditPane split(int n) {
        PerspectiveManager.setPerspectiveDirty(true);
        this.editPane.saveCaretInfo();
        EditPane editPane = this.editPane;
        EditPane editPane2 = this.createEditPane(editPane.getBufferSet(), editPane.getBuffer());
        editPane2.loadCaretInfo();
        JComponent jComponent = (JComponent)editPane.getParent();
        JSplitPane jSplitPane = new JSplitPane(n);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setBorder(null);
        jSplitPane.setMinimumSize(new Dimension(0, 0));
        jSplitPane.setResizeWeight(0.5);
        int n2 = n == 0 ? editPane.getHeight() : editPane.getWidth();
        int n3 = (int)((double)(n2 - jSplitPane.getDividerSize()) * 0.5);
        jSplitPane.setDividerLocation(n3);
        if (jComponent instanceof JSplitPane) {
            JSplitPane jSplitPane2 = (JSplitPane)jComponent;
            int n4 = jSplitPane2.getDividerLocation();
            Component component = jSplitPane2.getLeftComponent();
            if (component == editPane) {
                jSplitPane2.setLeftComponent(jSplitPane);
            } else {
                jSplitPane2.setRightComponent(jSplitPane);
            }
            jSplitPane.setLeftComponent(editPane);
            jSplitPane.setRightComponent(editPane2);
            jSplitPane2.setDividerLocation(n4);
        } else {
            this.splitPane = jSplitPane;
            jSplitPane.setLeftComponent(editPane);
            jSplitPane.setRightComponent(editPane2);
            this.setMainContent(jSplitPane);
        }
        EventQueue.invokeLater(() -> jSplitPane.setDividerLocation(n3));
        editPane2.focusOnTextArea();
        return editPane2;
    }

    public void unsplit() {
        if (this.splitPane != null) {
            this.lastSplitConfig = this.getSplitConfig();
            PerspectiveManager.setPerspectiveDirty(true);
            BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
            for (EditPane editPane : this.getEditPanes()) {
                if (this.editPane == editPane) continue;
                if (scope == BufferSet.Scope.editpane) {
                    View.mergeBufferSets(this.editPane, editPane);
                }
                editPane.close();
            }
            this.setMainContent(this.editPane);
            this.splitPane = null;
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        }
    }

    public void unsplitCurrent() {
        if (this.splitPane != null) {
            int n;
            Container container;
            this.lastSplitConfig = this.getSplitConfig();
            PerspectiveManager.setPerspectiveDirty(true);
            for (container = this.editPane; !(container instanceof JSplitPane) && container != null; container = container.getParent()) {
            }
            BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
            EditPane[] editPaneArray = this.getEditPanes();
            int n2 = editPaneArray.length;
            for (n = 0; n < n2; ++n) {
                EditPane editPane = editPaneArray[n];
                if (!GenericGUIUtilities.isAncestorOf(container, editPane) || editPane == this.editPane) continue;
                if (scope == BufferSet.Scope.editpane) {
                    View.mergeBufferSets(this.editPane, editPane);
                }
                editPane.close();
            }
            EditPane[] editPaneArray2 = editPaneArray = container == null ? null : (EditPane[])container.getParent();
            if (editPaneArray instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)editPaneArray;
                n = jSplitPane.getDividerLocation();
                if (jSplitPane.getLeftComponent() == container) {
                    jSplitPane.setLeftComponent(this.editPane);
                } else {
                    jSplitPane.setRightComponent(this.editPane);
                }
                jSplitPane.setDividerLocation(n);
                editPaneArray.revalidate();
            } else {
                this.setMainContent(this.editPane);
                this.splitPane = null;
            }
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        }
    }

    public void resplit() {
        if (this.lastSplitConfig == null) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        } else {
            this.setSplitConfig(null, this.lastSplitConfig);
        }
    }

    public String getSplitConfig() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.splitPane != null) {
            View.getSplitConfig(this.splitPane, stringBuilder);
        } else {
            View.appendToSplitConfig(stringBuilder, this.editPane);
        }
        return stringBuilder.toString();
    }

    public void setSplitConfig(Buffer buffer, String string) {
        try {
            Component component = this.restoreSplitConfig(buffer, string);
            this.setMainContent(component);
            this.updateTitle();
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
    }

    public void nextTextArea() {
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            if (this.editPane != editPaneArray[i]) continue;
            if (i == editPaneArray.length - 1) {
                editPaneArray[0].focusOnTextArea();
                break;
            }
            editPaneArray[i + 1].focusOnTextArea();
            break;
        }
    }

    public void prevTextArea() {
        EditPane[] editPaneArray = this.getEditPanes();
        for (int i = 0; i < editPaneArray.length; ++i) {
            if (this.editPane != editPaneArray[i]) continue;
            if (i == 0) {
                editPaneArray[editPaneArray.length - 1].focusOnTextArea();
                break;
            }
            editPaneArray[i - 1].focusOnTextArea();
            break;
        }
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public Buffer getBuffer() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getBuffer();
    }

    public Buffer[] getBuffers() {
        BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
        AbstractSet abstractSet = null;
        for (EditPane editPane : this.getEditPanes()) {
            BufferSet bufferSet = editPane.getBufferSet();
            if (abstractSet == null) {
                Comparator<Buffer> comparator = bufferSet.getSorter();
                abstractSet = comparator == null ? new LinkedHashSet() : new TreeSet<Buffer>(comparator);
            }
            Collections.addAll(abstractSet, bufferSet.getAllBuffers());
            if (bufferSetManager.getScope() != BufferSet.Scope.editpane) break;
        }
        Object[] objectArray = new Buffer[abstractSet.size()];
        abstractSet.toArray(objectArray);
        return objectArray;
    }

    public void setBuffer(Buffer buffer) {
        this.editPane.setBuffer(buffer);
    }

    public EditPane goToBuffer(Buffer buffer) {
        return this.showBuffer(buffer, true);
    }

    public EditPane showBuffer(Buffer buffer) {
        return this.showBuffer(buffer, false);
    }

    public JEditTextArea getTextArea() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getTextArea();
    }

    public EditPane getEditPane() {
        return this.editPane;
    }

    public EditPane[] getEditPanes() {
        ArrayList arrayList = new ArrayList();
        this.forEachEditPane(arrayList::add);
        return arrayList.toArray(EMPTY_EDIT_PANES_ARRAY);
    }

    public void forEachEditPane(Consumer<? super EditPane> consumer) {
        Objects.requireNonNull(consumer);
        if (this.splitPane == null) {
            if (this.editPane != null) {
                consumer.accept(this.editPane);
            }
        } else {
            View.performAction(this.splitPane, consumer);
        }
    }

    public ViewConfig getViewConfig() {
        ViewConfig viewConfig = new ViewConfig();
        viewConfig.plainView = this.isPlainView();
        viewConfig.splitConfig = this.getSplitConfig();
        viewConfig.extState = this.getExtendedState();
        viewConfig.docking = this.dockableWindowManager.getDockingLayout(viewConfig);
        viewConfig.title = this.userTitle;
        String string = viewConfig.plainView ? "plain-view" : "view";
        switch (viewConfig.extState) {
            case 1: 
            case 6: {
                viewConfig.x = jEdit.getIntegerProperty(string + ".x", this.getX());
                viewConfig.y = jEdit.getIntegerProperty(string + ".y", this.getY());
                viewConfig.width = jEdit.getIntegerProperty(string + ".width", this.getWidth());
                viewConfig.height = jEdit.getIntegerProperty(string + ".height", this.getHeight());
                break;
            }
            case 4: {
                viewConfig.x = this.getX();
                viewConfig.y = jEdit.getIntegerProperty(string + ".y", this.getY());
                viewConfig.width = this.getWidth();
                viewConfig.height = jEdit.getIntegerProperty(string + ".height", this.getHeight());
                break;
            }
            case 2: {
                viewConfig.x = jEdit.getIntegerProperty(string + ".x", this.getX());
                viewConfig.y = this.getY();
                viewConfig.width = jEdit.getIntegerProperty(string + ".width", this.getWidth());
                viewConfig.height = this.getHeight();
                break;
            }
            default: {
                viewConfig.x = this.getX();
                viewConfig.y = this.getY();
                viewConfig.width = this.getWidth();
                viewConfig.height = this.getHeight();
            }
        }
        return viewConfig;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPlainView() {
        return this.plainView;
    }

    public View getNext() {
        return this.next;
    }

    public View getPrev() {
        return this.prev;
    }

    public void setPrev(View view) {
        this.prev = view;
    }

    public void setNext(View view) {
        this.next = view;
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleSearchSettingsChanged(SearchSettingsChanged searchSettingsChanged) {
        if (this.searchBar != null) {
            this.searchBar.update();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setWaitSocket(Socket socket) {
        this.waitSocket = socket;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + (jEdit.getActiveView() == this ? "active" : "inactive") + "]";
    }

    public void updateTitle() {
        ArrayList<Buffer> arrayList = new ArrayList<Buffer>();
        EditPane[] editPaneArray = this.getEditPanes();
        for (EditPane editPane : editPaneArray) {
            Buffer buffer = editPane.getBuffer();
            if (arrayList.contains(buffer)) continue;
            arrayList.add(buffer);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!OperatingSystem.isMacOS()) {
            if (this.userTitle != null) {
                stringBuilder.append(this.userTitle);
            } else {
                stringBuilder.append(jEdit.getProperty("view.title"));
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            Buffer buffer = (Buffer)arrayList.get(i);
            stringBuilder.append(this.showFullPath && !buffer.isNewFile() ? buffer.getPath(true) : buffer.getName());
            if (!buffer.isDirty()) continue;
            stringBuilder.append(jEdit.getProperty("view.title.dirty"));
        }
        this.setTitle(stringBuilder.toString());
    }

    public void setUserTitle(String string) {
        this.userTitle = string + " - ";
        this.updateTitle();
    }

    public void showUserTitleDialog() {
        String string = JOptionPane.showInputDialog(this, (Object)jEdit.getProperty("view.title.select"));
        if (string == null) {
            return;
        }
        this.setUserTitle(string);
    }

    public Component getPrefixFocusOwner() {
        return this.prefixFocusOwner;
    }

    public void setPrefixFocusOwner(Component component) {
        this.prefixFocusOwner = component;
    }

    public void visit(JEditVisitor jEditVisitor) {
        EditPane[] editPaneArray;
        for (EditPane editPane : editPaneArray = this.getEditPanes()) {
            jEditVisitor.visit(editPane);
            jEditVisitor.visit(editPane.getTextArea());
        }
    }

    public void closeAllMenus() {
        MenuSelectionManager.defaultManager().clearSelectedPath();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
    }

    View(Buffer buffer, ViewConfig viewConfig) {
        this.plainView = viewConfig.plainView;
        this.enableEvents(8L);
        if (!OperatingSystem.isMacOS()) {
            this.setIconImage(GUIUtilities.getEditorIcon());
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.dockableWindowManager = View.getDockingFrameworkProvider().create(this, DockableWindowFactory.getInstance(), viewConfig);
        this.userTitle = viewConfig.title;
        this.dockableWindowManager.setMainPanel(this.mainPanel);
        this.topToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.bottomToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.toolBarManager = new ToolBarManager(this.topToolBars, this.bottomToolBars);
        this.status = new StatusBar(this);
        this.inputHandler = new DefaultInputHandler(this, (DefaultInputHandler)jEdit.getInputHandler());
        this.setSplitConfig(buffer, viewConfig.splitConfig);
        this.getContentPane().add("Center", this.dockableWindowManager);
        this.dockableWindowManager.init();
        this.propertiesChanged();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        EditBus.addToBus(this);
        GUIUtilities.addSizeSaver(this, null, this.plainView ? "plain-view" : "view");
    }

    public void updateFullScreenProps() {
        boolean bl = jEdit.getBooleanProperty("view.toolbar.alternateLayout");
        boolean bl2 = jEdit.getBooleanProperty("fullScreenIncludesMenu");
        boolean bl3 = jEdit.getBooleanProperty("fullScreenIncludesToolbar");
        boolean bl4 = jEdit.getBooleanProperty("fullScreenIncludesStatus");
        if (!bl2) {
            this.menuBar = this.getJMenuBar();
            this.setJMenuBar(null);
        } else if (this.menuBar != null) {
            this.setJMenuBar(this.menuBar);
        }
        this.loadToolBars();
        if (bl) {
            if (!bl4) {
                this.removeToolBar(this.status);
            } else {
                this.addToolBar(1, -100, this.status);
            }
        } else if (!bl4) {
            this.getContentPane().remove(this.status);
        } else {
            this.getContentPane().add("South", this.status);
        }
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public void toggleFullScreen() {
        this.fullScreenMode = !this.fullScreenMode;
        GraphicsDevice graphicsDevice = this.getGraphicsConfiguration().getDevice();
        this.dispose();
        if (this.fullScreenMode) {
            this.updateFullScreenProps();
            this.windowedBounds = this.getBounds();
            this.setUndecorated(true);
            this.setBounds(graphicsDevice.getDefaultConfiguration().getBounds());
            this.validate();
        } else {
            boolean bl;
            boolean bl2 = bl = this.plainView ? jEdit.getBooleanProperty("view.status.plainview.visible") : jEdit.getBooleanProperty("view.status.visible");
            if (this.menuBar != null && this.getJMenuBar() != this.menuBar) {
                this.setJMenuBar(this.menuBar);
            }
            boolean bl3 = jEdit.getBooleanProperty("view.toolbar.alternateLayout");
            this.loadToolBars();
            if (bl) {
                if (bl3) {
                    this.addToolBar(1, -100, this.status);
                } else {
                    this.getContentPane().add("South", this.status);
                }
            }
            this.setUndecorated(false);
            this.setBounds(this.windowedBounds);
        }
        this.setVisible(true);
        this.toFront();
        this.closeAllMenus();
        this.editPane.getTextArea().requestFocus();
        EditBus.send(new ViewUpdate(this, ViewUpdate.FULL_SCREEN_TOGGLED));
    }

    boolean confirmToCloseDirty() {
        boolean bl = jEdit.getBooleanProperty("autosaveUntitled");
        boolean bl2 = jEdit.getBooleanProperty("suppressNotSavedConfirmUntitled") || bl;
        Set<Buffer> set = this.getOpenBuffers();
        ViewManager viewManager = jEdit.getViewManager();
        viewManager.getViews().stream().filter(view -> view != this).forEach(view -> set.removeAll(view.getOpenBuffers()));
        for (Buffer buffer : set) {
            if (!buffer.isDirty() || buffer.isUntitled() && bl2) continue;
            return new CloseDialog(this, set).isOK();
        }
        return true;
    }

    void close() {
        EditPane[] editPaneArray;
        EditBus.send(new ViewUpdate(this, ViewUpdate.CLOSED));
        this.closed = true;
        this.dockableWindowManager.close();
        EditBus.removeFromBus(this);
        this.dispose();
        for (EditPane editPane : editPaneArray = this.getEditPanes()) {
            editPane.close();
        }
        this.toolBarManager = null;
        this.toolBar = null;
        this.searchBar = null;
        this.splitPane = null;
        this.inputHandler = null;
        this.recorder = null;
        this.getContentPane().removeAll();
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setMainContent(Component component) {
        if (this.mainContent != null) {
            this.mainPanel.remove(this.mainContent);
        }
        this.mainContent = component;
        this.mainPanel.add(this.mainContent, "Center");
        if (component instanceof JSplitPane) {
            this.splitPane = (JSplitPane)component;
        } else {
            this.splitPane = null;
            this.editPane = (EditPane)component;
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    private static void performAction(Component component, Consumer<? super EditPane> consumer) {
        if (component instanceof EditPane) {
            consumer.accept((EditPane)component);
        } else if (component instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)component;
            View.performAction(jSplitPane.getLeftComponent(), consumer);
            View.performAction(jSplitPane.getRightComponent(), consumer);
        }
    }

    private EditPane showBuffer(Buffer buffer, boolean bl) {
        EditPane[] editPaneArray;
        if (this.editPane.getBuffer() == buffer && this.editPane.getTextArea().getVisibleLines() > 1) {
            if (bl) {
                this.editPane.focusOnTextArea();
            }
            return this.editPane;
        }
        for (EditPane editPane : editPaneArray = this.getEditPanes()) {
            if (editPane.getBuffer() != buffer || editPane.getTextArea().getVisibleLines() <= 1) continue;
            this.setEditPane(editPane);
            if (bl) {
                editPane.focusOnTextArea();
            }
            return editPane;
        }
        this.editPane.setBuffer(buffer, bl);
        return this.editPane;
    }

    private static void getSplitConfig(JSplitPane jSplitPane, StringBuilder stringBuilder) {
        Component component = jSplitPane.getRightComponent();
        View.appendToSplitConfig(stringBuilder, component);
        stringBuilder.append(' ');
        Component component2 = jSplitPane.getLeftComponent();
        View.appendToSplitConfig(stringBuilder, component2);
        stringBuilder.append(' ');
        stringBuilder.append(jSplitPane.getDividerLocation());
        stringBuilder.append(' ');
        stringBuilder.append(jSplitPane.getOrientation() == 0 ? "vertical" : "horizontal");
    }

    private static void appendToSplitConfig(StringBuilder stringBuilder, Component component) {
        if (component instanceof JSplitPane) {
            View.getSplitConfig((JSplitPane)component, stringBuilder);
        } else {
            Buffer[] bufferArray;
            boolean bl = jEdit.getBooleanProperty("autosaveUntitled");
            EditPane editPane = (EditPane)component;
            stringBuilder.append('\"');
            Buffer buffer = editPane.getBuffer();
            stringBuilder.append(StandardUtilities.charsToEscapes(buffer.getPath()));
            stringBuilder.append("\" buffer");
            BufferSet bufferSet = editPane.getBufferSet();
            for (Buffer buffer2 : bufferArray = bufferSet.getAllBuffers()) {
                if (buffer2.isNewFile() && (!buffer2.isUntitled() || !bl)) continue;
                stringBuilder.append(" \"");
                stringBuilder.append(StandardUtilities.charsToEscapes(buffer2.getPath()));
                stringBuilder.append("\" buff");
            }
            stringBuilder.append(" \"");
            stringBuilder.append((Object)jEdit.getBufferSetManager().getScope());
            stringBuilder.append("\" bufferset");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Component restoreSplitConfig(Buffer buffer, String string) throws IOException {
        void var8_15;
        BufferManager bufferManager = jEdit.getBufferManager();
        if (buffer != null) {
            this.editPane = this.createEditPane(buffer);
            return this.editPane;
        }
        if (string == null || string.trim().length() == 0) {
            Buffer buffer2 = bufferManager.getFirst();
            if (buffer2 == null) {
                buffer2 = BufferSetManager.createUntitledBuffer();
            }
            this.editPane = this.createEditPane(buffer2);
            return this.editPane;
        }
        List<Buffer> list = bufferManager.getBuffers();
        Stack<Object> stack = new Stack<Object>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(35, 126);
        streamTokenizer.commentChar(33);
        streamTokenizer.quoteChar(34);
        streamTokenizer.eolIsSignificant(false);
        ArrayList<Buffer> arrayList = new ArrayList<Buffer>();
        block6: while (true) {
            switch (streamTokenizer.nextToken()) {
                case -1: {
                    break block6;
                }
                case -3: {
                    Object object;
                    int n;
                    if ("vertical".equals(streamTokenizer.sval) || "horizontal".equals(streamTokenizer.sval)) {
                        void var11_23;
                        Buffer buffer3;
                        int n2 = "vertical".equals(streamTokenizer.sval) ? 0 : 1;
                        n = (Integer)stack.pop();
                        object = stack.pop();
                        Object e = stack.pop();
                        if (object instanceof Buffer) {
                            buffer3 = buffer = (Buffer)object;
                            this.editPane = this.createEditPane(buffer3);
                            object = this.editPane;
                        }
                        if (e instanceof Buffer) {
                            buffer3 = (Buffer)e;
                            EditPane editPane = this.createEditPane(buffer3);
                        }
                        this.splitPane = new JSplitPane(n2, (Component)object, (Component)var11_23);
                        stack.push(this.splitPane);
                        this.splitPane.setOneTouchExpandable(true);
                        this.splitPane.setBorder(null);
                        this.splitPane.setMinimumSize(new Dimension(0, 0));
                        this.splitPane.setDividerLocation(n);
                        break;
                    }
                    if ("buffer".equals(streamTokenizer.sval)) {
                        Object e = stack.pop();
                        if (e instanceof Integer) {
                            n = (Integer)e;
                            if (n >= 0 && n < list.size()) {
                                buffer = list.get(n);
                            }
                        } else if (e instanceof String) {
                            String string2 = (String)e;
                            object = bufferManager.getBuffer(string2);
                            buffer = ((Optional)object).orElseGet(() -> {
                                Buffer buffer = jEdit.openTemporary(jEdit.getActiveView(), null, string2, true, null, true);
                                jEdit.commitTemporary(buffer);
                                return buffer;
                            });
                        }
                        if (buffer == null) {
                            buffer = bufferManager.getFirst();
                        }
                        stack.push(buffer);
                        arrayList.add(buffer);
                        break;
                    }
                    if ("buff".equals(streamTokenizer.sval)) {
                        String string3 = (String)stack.pop();
                        Optional<Buffer> optional = bufferManager.getBuffer(string3);
                        if (optional.isEmpty()) {
                            Log.log(7, this, "Buffer " + string3 + " doesn't exist");
                            break;
                        }
                        buffer = optional.get();
                        arrayList.add(buffer);
                        break;
                    }
                    if (!"bufferset".equals(streamTokenizer.sval)) break;
                    stack.pop();
                    buffer = (Buffer)stack.pop();
                    this.editPane = this.createEditPane(buffer);
                    stack.push(this.editPane);
                    BufferSet bufferSet = this.editPane.getBufferSet();
                    n = 0;
                    for (Buffer buffer4 : arrayList) {
                        bufferSet.addBufferAt(buffer4, n);
                        ++n;
                    }
                    arrayList.clear();
                    break;
                }
                case -2: {
                    stack.push((int)streamTokenizer.nval);
                    break;
                }
                case 34: {
                    stack.push(streamTokenizer.sval);
                }
            }
        }
        Object e = stack.peek();
        if (e instanceof Buffer) {
            EditPane editPane = this.editPane = this.createEditPane((Buffer)e);
        }
        this.updateGutterBorders();
        return (Component)var8_15;
    }

    private void propertiesChanged() {
        int n;
        JMenuBar jMenuBar = GUIUtilities.loadMenuBar("view.mbar");
        for (n = 0; n < jMenuBar.getMenuCount(); ++n) {
            Object object;
            int n2;
            JMenu jMenu = jMenuBar.getMenu(n);
            if (jMenu == null || (n2 = jMenu.getMnemonic()) == 0 || (object = this.inputHandler.getKeyBinding("A+" + Character.toLowerCase((char)n2))) == null) continue;
            jMenu.setMnemonic(0);
        }
        this.setJMenuBar(jMenuBar);
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
                desktop.setQuitHandler((quitEvent, quitResponse) -> {
                    jEdit.exit(jEdit.getActiveView(), true);
                    quitResponse.cancelQuit();
                });
            }
            if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
                desktop.setAboutHandler(aboutEvent -> new AboutDialog(jEdit.getActiveView()));
            }
            if (desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
                desktop.setPreferencesHandler(preferencesEvent -> new CombinedOptions((Frame)jEdit.getActiveView(), 0));
            }
        }
        this.loadToolBars();
        this.showFullPath = jEdit.getBooleanProperty("view.showFullPath");
        this.updateTitle();
        this.status.propertiesChanged();
        this.removeToolBar(this.status);
        this.getContentPane().remove(this.status);
        n = (this.plainView ? jEdit.getBooleanProperty("view.status.plainview.visible") : jEdit.getBooleanProperty("view.status.visible")) ? 1 : 0;
        if (jEdit.getBooleanProperty("view.toolbar.alternateLayout")) {
            this.getContentPane().add("North", this.topToolBars);
            this.getContentPane().add("South", this.bottomToolBars);
            if (n != 0) {
                this.addToolBar(1, -100, this.status);
            }
        } else {
            this.mainPanel.add((Component)this.topToolBars, "North");
            this.mainPanel.add((Component)this.bottomToolBars, "South");
            if (n != 0) {
                this.getContentPane().add("South", this.status);
            }
        }
        this.updateBufferSwitcherStates();
        this.getRootPane().revalidate();
        if (this.fullScreenMode) {
            this.updateFullScreenProps();
        }
    }

    public void updateBufferSwitcherStates() {
        Component component;
        int n;
        boolean bl = jEdit.getBooleanProperty("view.showBufferSwitcher");
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        String string = jEdit.getProperty("view.label");
        string = string.replace("$", "");
        String string2 = jEdit.getProperty("focus-buffer-switcher.label");
        string2 = string2.replace("$", "");
        JMenu jMenu = null;
        for (n = 0; n < jMenuBar.getMenuCount(); ++n) {
            component = jMenuBar.getMenu(n);
            if (!((AbstractButton)component).getText().equals(string)) continue;
            jMenu = component;
            break;
        }
        if (jMenu != null) {
            for (n = 0; n < jMenu.getMenuComponentCount(); ++n) {
                component = jMenu.getMenuComponent(n);
                if (!(component instanceof JMenuItem) || !((JMenuItem)component).getText().equals(string2)) continue;
                component.setEnabled(bl);
            }
        }
        jEdit.getViewManager().forEach(view -> {
            for (EditPane editPane : view.getEditPanes()) {
                editPane.loadBufferSwitcher();
            }
        });
    }

    private void loadToolBars() {
        if (!this.plainView && (this.fullScreenMode ? jEdit.getBooleanProperty("fullScreenIncludesToolbar") : jEdit.getBooleanProperty("view.showToolbar"))) {
            if (this.toolBar != null) {
                this.toolBarManager.removeToolBar(this.toolBar);
            }
            this.toolBar = GUIUtilities.loadToolBar("view.toolbar");
            this.addToolBar(0, 100, this.toolBar);
        } else if (this.toolBar != null) {
            this.removeToolBar(this.toolBar);
            this.toolBar = null;
        }
        if (this.searchBar != null) {
            this.searchBar.propertiesChanged();
            this.removeToolBar(this.searchBar);
        }
        if (jEdit.getBooleanProperty("view.showSearchbar") && !this.plainView) {
            if (this.searchBar == null) {
                this.searchBar = new SearchBar(this, false);
            }
            this.addToolBar(0, 75, this.searchBar);
        }
    }

    private EditPane createEditPane(@Nonnull Buffer buffer) {
        return this.createEditPane(null, buffer);
    }

    private EditPane createEditPane(@Nullable BufferSet bufferSet, @Nonnull Buffer buffer) {
        EditPane editPane = new EditPane(this, bufferSet, buffer);
        JEditTextArea jEditTextArea = editPane.getTextArea();
        jEditTextArea.addFocusListener(new FocusHandler());
        jEditTextArea.addCaretListener(new CaretHandler());
        jEditTextArea.addScrollListener(new ScrollHandler());
        EditBus.send(new EditPaneUpdate(editPane, EditPaneUpdate.CREATED));
        return editPane;
    }

    private void setEditPane(EditPane editPane) {
        this.editPane = editPane;
        this.status.updateCaretStatus();
        this.status.updateBufferStatus();
        this.status.updateMiscStatus();
        this.updateGutterBorders();
        EditBus.send(new ViewUpdate(this, ViewUpdate.EDIT_PANE_CHANGED));
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bufferUpdate) {
        Buffer buffer = bufferUpdate.getBuffer();
        if (bufferUpdate.getWhat() == BufferUpdate.DIRTY_CHANGED || bufferUpdate.getWhat() == BufferUpdate.LOADED) {
            EditPane[] editPaneArray;
            for (EditPane editPane : editPaneArray = this.getEditPanes()) {
                if (editPane.getBuffer() != buffer) continue;
                this.updateTitle();
                break;
            }
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        EditPane editPane = editPaneUpdate.getEditPane();
        if (editPane != null && editPane.getView() == this && editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED && editPane.getBuffer().isLoaded()) {
            this.closeDuplicateBuffers(editPaneUpdate);
            this.status.updateCaretStatus();
            this.status.updateBufferStatus();
            this.status.updateMiscStatus();
        }
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate viewUpdate) {
        if (viewUpdate.getView() == null || viewUpdate.getView() != this) {
            return;
        }
        int n = jEdit.getIntegerProperty("checkFileStatus");
        if (n == 0 || !jEdit.isStartupDone()) {
            return;
        }
        if ((viewUpdate.getWhat() == ViewUpdate.EDIT_PANE_CHANGED || viewUpdate.getWhat() == ViewUpdate.ACTIVATED) && (n & 2) > 0) {
            jEdit.checkBufferStatus(this, true);
        } else if (viewUpdate.getWhat() == ViewUpdate.ACTIVATED && (n & 1) > 0) {
            jEdit.checkBufferStatus(this, n != 1);
        }
    }

    private void closeDuplicateBuffers(EditPaneUpdate editPaneUpdate) {
        if (!jEdit.getBooleanProperty("buffersets.exclusive")) {
            return;
        }
        final BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
        if (scope == BufferSet.Scope.global) {
            return;
        }
        final EditPane editPane = editPaneUpdate.getEditPane();
        final View view = editPane.getView();
        if (view != this) {
            return;
        }
        final Buffer buffer = editPane.getBuffer();
        if (buffer.isDirty()) {
            return;
        }
        jEdit.visit(new JEditVisitorAdapter(){

            @Override
            public void visit(EditPane editPane2) {
                if (editPane2 == editPane || scope == BufferSet.Scope.view && editPane2.getView() == view) {
                    return;
                }
                if (editPane2.getBufferSet().indexOf(buffer) < 0) {
                    return;
                }
                jEdit.getBufferSetManager().removeBuffer(editPane2, buffer);
            }
        });
    }

    private void updateGutterBorders() {
        EditPane[] editPaneArray;
        for (EditPane editPane : editPaneArray = this.getEditPanes()) {
            editPane.getTextArea().getGutter().updateBorder();
        }
    }

    private Set<Buffer> getOpenBuffers() {
        LinkedHashSet<Buffer> linkedHashSet = new LinkedHashSet<Buffer>();
        for (EditPane editPane : this.getEditPanes()) {
            linkedHashSet.addAll(Arrays.asList(editPane.getBufferSet().getAllBuffers()));
        }
        return linkedHashSet;
    }

    private static void mergeBufferSets(EditPane editPane, EditPane editPane2) {
        BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
        for (Buffer buffer : editPane2.getBufferSet().getAllBuffers()) {
            bufferSetManager.addBuffer(editPane, buffer);
        }
    }

    private static boolean isInsideScreen(View view, Rectangle rectangle) {
        Rectangle rectangle2 = view == null ? GenericGUIUtilities.getScreenBounds() : view.getGraphicsConfiguration().getBounds();
        int n = jEdit.getIntegerProperty("view.minStartupWidth");
        int n2 = jEdit.getIntegerProperty("view.minStartupHeight");
        return rectangle.x + rectangle.width > rectangle2.x + n && rectangle.x < rectangle2.x + rectangle2.width - n && rectangle.y + rectangle.height > rectangle2.y + n2 && rectangle.y < rectangle2.y + rectangle2.height - n2;
    }

    public void adjust(View view, ViewConfig viewConfig) {
        if (viewConfig.width != 0 && viewConfig.height != 0) {
            Rectangle rectangle = new Rectangle(viewConfig.x, viewConfig.y, viewConfig.width, viewConfig.height);
            if (!View.isInsideScreen(view, rectangle)) {
                this.setLocationRelativeTo(view);
            } else if (OperatingSystem.isX11() && Debug.GEOMETRY_WORKAROUND) {
                new GUIUtilities.UnixWorkaround(this, "view", rectangle, viewConfig.extState);
            } else {
                this.setBounds(rectangle);
                this.setExtendedState(viewConfig.extState);
            }
        } else {
            this.setLocationRelativeTo(view);
        }
    }

    private static class SetCursorVisitor
    extends JEditVisitorAdapter {
        private final Cursor cursor;

        SetCursorVisitor(Cursor cursor) {
            this.cursor = cursor;
        }

        @Override
        public void visit(EditPane editPane) {
            editPane.setCursor(this.cursor);
        }
    }

    private static class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return GUIUtilities.getView(container).getTextArea();
        }
    }

    public static class ViewConfig {
        public int x;
        public int y;
        public int width;
        public int height;
        public int extState;
        public boolean plainView;
        public String splitConfig;
        public DockableWindowManager.DockingLayout docking;
        public String title;

        public ViewConfig() {
        }

        public ViewConfig(boolean bl) {
            this.plainView = bl;
            String string = bl ? "plain-view" : "view";
            this.x = jEdit.getIntegerProperty(string + ".x", 0);
            this.y = jEdit.getIntegerProperty(string + ".y", 0);
            this.width = jEdit.getIntegerProperty(string + ".width", 0);
            this.height = jEdit.getIntegerProperty(string + ".height", 0);
            this.extState = jEdit.getIntegerProperty(string + ".extendedState", 0);
        }

        public ViewConfig(boolean bl, String string, int n, int n2, int n3, int n4, int n5) {
            this.plainView = bl;
            this.splitConfig = string;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.extState = n5;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            boolean bl = false;
            boolean bl2 = false;
            View view = jEdit.getActiveViewInternal();
            if (view != View.this) {
                bl2 = true;
            }
            if (windowEvent.getOppositeWindow() == null) {
                bl = true;
            }
            jEdit.setActiveView(View.this);
            if (bl || bl2) {
                EditBus.send(new ViewUpdate(View.this, ViewUpdate.ACTIVATED));
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            jEdit.closeView(View.this);
        }
    }

    private class ScrollHandler
    implements ScrollListener {
        private ScrollHandler() {
        }

        @Override
        public void scrolledVertically(TextArea textArea) {
            if (View.this.getTextArea() == textArea) {
                View.this.status.updateCaretStatus();
            }
        }

        @Override
        public void scrolledHorizontally(TextArea textArea) {
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = (Component)focusEvent.getSource();
            while (!(component instanceof EditPane)) {
                if (component == null) {
                    return;
                }
                component = component.getParent();
            }
            if (component != View.this.editPane) {
                View.this.setEditPane((EditPane)component);
            } else {
                View.this.updateGutterBorders();
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (caretEvent.getSource() == View.this.getTextArea()) {
                View.this.status.updateCaretStatus();
            }
        }
    }
}

