/**
 * SECTION:abstract-field-details
 * @short_description: Object representing any type of value that can have some vCard-like parameters associated with it.
 * 
 * <para>Some contact details, like phone numbers or URLs, can have some extra details associated with them. For instance, a phone number expressed in vcard notation as <code>tel;type=work,voice:(111) 555-1234</code> would be represented as a AbstractFieldDetails with value &quot;(111) 555-1234&quot; and with parameters <code>[&apos;type&apos;: (&apos;work&apos;, &apos;voice&apos;)]</code>.</para><para>The parameter name &quot;type&quot; with values &quot;work&quot;, &quot;home&quot;, or &quot;other&quot; are common amongst most vCard attributes (and thus most AbstractFieldDetails-derived classes). A &quot;type&quot; of &quot;pref&quot; may be used to indicate a preferred <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link> amongst many. See specific classes for information on additional parameters and values specific to that class.</para><para>See <ulink url="http://www.ietf.org/rfc/rfc2426.txt">RFC2426</ulink> for more details on pre-defined parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_ABSTRACT_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link>.
 */
/**
 * folks_abstract_field_details_get_parameter_values:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance
 * @parameter_name: (in): &nbsp;.  <para>the parameter name </para>
 * 
 * Get the values for a parameter
 * 
 * Returns: <para>a collection of values for <code>parameter_name</code> or <code>null</code> (i.e. no collection) if there are no such parameters. </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_add_parameter:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance
 * @parameter_name: (in): &nbsp;.  <para>the name of the parameter </para>
 * @parameter_value: (in): &nbsp;.  <para>the value to add </para>
 * 
 * Add a new value for a parameter.
 * 
 * <para>If there is already a parameter called <code>parameter_name</code> then <code>parameter_value</code> is added to the existing ones.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_set_parameter:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance
 * @parameter_name: (in): &nbsp;.  <para>the name of the parameter </para>
 * @parameter_value: (in): &nbsp;.  <para>the value to add </para>
 * 
 * Set the value of a parameter.
 * 
 * <para>Sets the parameter called <code>parameter_name</code> to be <code>parameter_value</code>. If there were already parameters with the same name they are replaced.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_extend_parameters:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance
 * @additional: (in): &nbsp;.  <para>the parameters to add </para>
 * 
 * Extend the existing parameters.
 * 
 * <para>Merge the parameters from <code>additional</code> into the existing ones.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_remove_parameter_all:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance
 * @parameter_name: (in): &nbsp;.  <para>the name of the parameter </para>
 * 
 * Remove all instances of a parameter.
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_equal:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance
 * @that: (in): &nbsp;.  <para>another <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> </para>
 * 
 * A fairly-strict equality function for <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link>.
 * 
 * <para>This function compares:</para><itemizedlist><listitem><para><link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>s</para></listitem><listitem><para><link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link></para></listitem></itemizedlist><para>And does not compare:</para><itemizedlist><listitem><para><link linkend="FolksAbstractFieldDetails--id"><type>"id"</type></link>s</para></listitem></itemizedlist><para>See the description of <link linkend="folks-abstract-field-details-values-equal"><function>folks_abstract_field_details_values_equal()</function></link> for details on the value comparison.</para><para>To check equality not including the parameters, see <link linkend="folks-abstract-field-details-values-equal"><function>folks_abstract_field_details_values_equal()</function></link>.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-abstract-field-details-parameters-equal"><function>folks_abstract_field_details_parameters_equal()</function></link>, <link linkend="folks-abstract-field-details-values-equal"><function>folks_abstract_field_details_values_equal()</function></link>
 * 
 * Returns: <para>whether the elements are equal </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_parameters_equal:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance
 * @that: (in): &nbsp;.  <para>another <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> </para>
 * 
 * An equality function which only considers parameters.
 * 
 * <para>This function compares:</para><itemizedlist><listitem><para><link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link></para></listitem></itemizedlist><para>And does not compare:</para><itemizedlist><listitem><para><link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>s</para></listitem><listitem><para><link linkend="FolksAbstractFieldDetails--id"><type>"id"</type></link>s</para></listitem></itemizedlist>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-abstract-field-details-equal"><function>folks_abstract_field_details_equal()</function></link>, <link linkend="folks-abstract-field-details-values-equal"><function>folks_abstract_field_details_values_equal()</function></link>
 * 
 * Returns: <para>whether the elements&apos; <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>s are equal. </para>
 *
 * Since: 0.6.5
 */
/**
 * folks_abstract_field_details_values_equal:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance
 * @that: (in): &nbsp;.  <para>another <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> </para>
 * 
 * An equality function which does not consider parameters.
 * 
 * <para>Specific classes may override this function to provide &quot;smart&quot; value comparisons (eg, considering the phone number values &quot;+1 555 123 4567&quot; and &quot;123-4567&quot; equal). If you wish to do strict comparisons, simply compare the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>s directly.</para><para>This function compares:</para><itemizedlist><listitem><para><link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>s</para></listitem></itemizedlist><para>And does not compare:</para><itemizedlist><listitem><para><link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link></para></listitem><listitem><para><link linkend="FolksAbstractFieldDetails--id"><type>"id"</type></link>s</para></listitem></itemizedlist><para>This defaults to string comparison of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>s if the generic type is string; otherwise, direct pointer comparison of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>s.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-abstract-field-details-equal"><function>folks_abstract_field_details_equal()</function></link>, <link linkend="folks-abstract-field-details-parameters-equal"><function>folks_abstract_field_details_parameters_equal()</function></link>
 * 
 * Returns: <para>whether the elements&apos; <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>s are equal. </para>
 *
 * Since: 0.6.5
 */
/**
 * folks_abstract_field_details_hash:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance
 * 
 * A hash function for the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link>.
 * 
 * <para>This defaults to a string hash of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link> if the generic type is string; otherwise, direct hash of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>.</para>
 * 
 * Returns: <para>the hash value </para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE:
 * 
 * Parameter name for classifying the type of value this field contains.
 * 
 * <para>For example, the value could be relevant to the contact&apos;s home life, or to their work life; values of <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE-HOME:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE_HOME</literal></link> and <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE-WORK:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE_WORK</literal></link> would be used for the <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE</literal></link> parameter, respectively, in those cases.</para>
 *
 * Since: 0.6.3
 */
/**
 * FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE_HOME:
 * 
 * Parameter value for home-related field values.
 * 
 * <para>Value for a parameter with name <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE</literal></link>.</para>
 *
 * Since: 0.6.3
 */
/**
 * FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE_WORK:
 * 
 * Parameter value for work-related field values.
 * 
 * <para>Value for a parameter with name <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE</literal></link>.</para>
 *
 * Since: 0.6.3
 */
/**
 * FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE_OTHER:
 * 
 * Parameter value for miscellaneous field values.
 * 
 * <para>Value for a parameter with name <link linkend="FOLKS-ABSTRACT-FIELD-DETAILS-PARAM-TYPE:CAPS"><literal>FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE</literal></link>.</para>
 *
 * Since: 0.6.3
 */
/**
 * FolksAbstractFieldDetails:value:
 * 
 * The value of the field.
 * 
 * <para>Holds a value from type #FolksAbstractFieldDetails:t-type.</para>.  <para>The value of the field, the exact type and content of which depends on what the structure is used for.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_get_value:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link> property.
 * 
 * The value of the field.
 * 
 * <para>The value of the field, the exact type and content of which depends on what the structure is used for.</para>
 * 
 * Returns: the value of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link> property of type #FolksAbstractFieldDetails:t-type
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_set_value:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link> property of type #FolksAbstractFieldDetails:t-type
 * 
 * Set the value of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link> property to @value.
 * 
 * The value of the field.
 * 
 * <para>The value of the field, the exact type and content of which depends on what the structure is used for.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksAbstractFieldDetails:value-type:
 * 
 * The <link linkend="GType"><type>GType</type></link> of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>.
 * 
 * <para>This is particularly useful for treating collections of different types of <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> in a uniform way without needing to name them explicitly.</para>
 *
 * Since: 0.6.5
 */
/**
 * folks_abstract_field_details_get_value_type:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksAbstractFieldDetails--value-type"><type>"value-type"</type></link> property.
 * 
 * The <link linkend="GType"><type>GType</type></link> of the <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>.
 * 
 * <para>This is particularly useful for treating collections of different types of <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> in a uniform way without needing to name them explicitly.</para>
 * 
 * Returns: the value of the <link linkend="FolksAbstractFieldDetails--value-type"><type>"value-type"</type></link> property
 *
 * Since: 0.6.5
 */
/**
 * FolksAbstractFieldDetails:id:
 * 
 * A unique ID (if any) for this specific detail.
 * 
 * <para>This is primarily intended for <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s which need to track specific instances of details (because their backing store is wacky).</para><para>In most cases, this will be an empty string.</para><para>The content of this is opaque to all but the package which set it.</para>
 *
 * Since: 0.6.5
 */
/**
 * folks_abstract_field_details_get_id:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksAbstractFieldDetails--id"><type>"id"</type></link> property.
 * 
 * A unique ID (if any) for this specific detail.
 * 
 * <para>This is primarily intended for <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s which need to track specific instances of details (because their backing store is wacky).</para><para>In most cases, this will be an empty string.</para><para>The content of this is opaque to all but the package which set it.</para>
 * 
 * Returns: the value of the <link linkend="FolksAbstractFieldDetails--id"><type>"id"</type></link> property
 *
 * Since: 0.6.5
 */
/**
 * folks_abstract_field_details_set_id:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksAbstractFieldDetails--id"><type>"id"</type></link> property
 * 
 * Set the value of the <link linkend="FolksAbstractFieldDetails--id"><type>"id"</type></link> property to @value.
 * 
 * A unique ID (if any) for this specific detail.
 * 
 * <para>This is primarily intended for <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s which need to track specific instances of details (because their backing store is wacky).</para><para>In most cases, this will be an empty string.</para><para>The content of this is opaque to all but the package which set it.</para>
 *
 * Since: 0.6.5
 */
/**
 * FolksAbstractFieldDetails:parameters:
 * 
 * The parameters associated with the value.
 * 
 * <para>A multi-map of the parameters associated with <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>. The keys are the names of the parameters, while the values are a list of strings.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_get_parameters:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link> property.
 * 
 * The parameters associated with the value.
 * 
 * <para>A multi-map of the parameters associated with <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>. The keys are the names of the parameters, while the values are a list of strings.</para>
 * 
 * Returns: the value of the <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_set_parameters:
 * @self: the <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link> property
 * 
 * Set the value of the <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link> property to @value.
 * 
 * The parameters associated with the value.
 * 
 * <para>A multi-map of the parameters associated with <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>. The keys are the names of the parameters, while the values are a list of strings.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_abstract_field_details_equal_static:
 * @left: (in): &nbsp;.  <para>one <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> to compare </para>
 * @right: (in): &nbsp;.  <para>another <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> to compare </para>
 * 
 * Same as <link linkend="folks-abstract-field-details-equal"><function>folks_abstract_field_details_equal()</function></link>, but static, so we can use libgee 0.8 without an API break.
 * 
 * <para>See <ulink url="https://bugzilla.gnome.org/show_bug.cgi?id=673918">673918</ulink> This can and should be removed next time we break the API. Note: This uses Gee.EqualDataFunc signature, to avoid having to cast.</para>
 * 
 * Returns: <para>whether the elemants are equal </para>
 *
 * Since: 0.9.0
 */
/**
 * folks_abstract_field_details_hash_static:
 * @value: (in): &nbsp;.  <para>the value to hash </para>
 * 
 * Same as <link linkend="folks-abstract-field-details-hash"><function>folks_abstract_field_details_hash()</function></link>, but static, so we can use libgee 0.8 without an API break.
 * 
 * <para>See <ulink url="https://bugzilla.gnome.org/show_bug.cgi?id=673918">673918</ulink> This can and should be removed next time we break the API. Note: This uses Gee.HashDataFunc signature, to avoid having to cast.</para>
 * 
 * Returns: <para>the hash value </para>
 *
 * Since: 0.9.0
 */
/**
 * FolksAbstractFieldDetails:
 * 
 * Object representing any type of value that can have some vCard-like parameters associated with it.
 * 
 * <para>Some contact details, like phone numbers or URLs, can have some extra details associated with them. For instance, a phone number expressed in vcard notation as <code>tel;type=work,voice:(111) 555-1234</code> would be represented as a AbstractFieldDetails with value &quot;(111) 555-1234&quot; and with parameters <code>[&apos;type&apos;: (&apos;work&apos;, &apos;voice&apos;)]</code>.</para><para>The parameter name &quot;type&quot; with values &quot;work&quot;, &quot;home&quot;, or &quot;other&quot; are common amongst most vCard attributes (and thus most AbstractFieldDetails-derived classes). A &quot;type&quot; of &quot;pref&quot; may be used to indicate a preferred <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link> amongst many. See specific classes for information on additional parameters and values specific to that class.</para><para>See <ulink url="http://www.ietf.org/rfc/rfc2426.txt">RFC2426</ulink> for more details on pre-defined parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksAbstractFieldDetailsClass:
 * @equal: virtual method called by <link linkend="folks-abstract-field-details-equal"><function>folks_abstract_field_details_equal()</function></link>
 * @parameters_equal: virtual method called by <link linkend="folks-abstract-field-details-parameters-equal"><function>folks_abstract_field_details_parameters_equal()</function></link>
 * @values_equal: virtual method called by <link linkend="folks-abstract-field-details-values-equal"><function>folks_abstract_field_details_values_equal()</function></link>
 * @hash: virtual method called by <link linkend="folks-abstract-field-details-hash"><function>folks_abstract_field_details_hash()</function></link>
 * @get_value: getter method for the abstract property <link linkend="FolksAbstractFieldDetails--value"><type>"value"</type></link>
 * @get_id: getter method for the abstract property <link linkend="FolksAbstractFieldDetails--id"><type>"id"</type></link>
 * @set_id: setter method for the abstract property <link linkend="FolksAbstractFieldDetails--id"><type>"id"</type></link>
 * @get_parameters: getter method for the abstract property <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-ABSTRACT-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_ABSTRACT_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
