/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.StringRefAddr;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextHandler;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.ContextTransaction;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.AbstractRef;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;
import org.apache.naming.EjbRef;
import org.apache.naming.HandlerRef;
import org.apache.naming.LookupRef;
import org.apache.naming.NamingContext;
import org.apache.naming.ResourceEnvRef;
import org.apache.naming.ResourceLinkRef;
import org.apache.naming.ResourceRef;
import org.apache.naming.ServiceRef;
import org.apache.naming.TransactionRef;
import org.apache.naming.factory.ResourceLinkFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class NamingContextListener
implements LifecycleListener,
ContainerListener,
PropertyChangeListener {
    private static final Log log = LogFactory.getLog(NamingContextListener.class);
    protected Log logger = log;
    protected String name = "/";
    protected Object container = null;
    protected boolean initialized = false;
    protected NamingResources namingResources = null;
    protected NamingContext namingContext = null;
    protected javax.naming.Context compCtx = null;
    protected javax.naming.Context envCtx = null;
    protected HashMap<String, ObjectName> objectNames = new HashMap();
    private boolean exceptionOnFailedWrite = true;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");

    public boolean getExceptionOnFailedWrite() {
        return this.exceptionOnFailedWrite;
    }

    public void setExceptionOnFailedWrite(boolean bl) {
        this.exceptionOnFailedWrite = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Deprecated
    public javax.naming.Context getCompContext() {
        return this.compCtx;
    }

    public javax.naming.Context getEnvContext() {
        return this.envCtx;
    }

    @Deprecated
    public NamingContext getNamingContext() {
        return this.namingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        this.container = lifecycleEvent.getLifecycle();
        if (this.container instanceof Context) {
            this.namingResources = ((Context)this.container).getNamingResources();
            this.logger = log;
        } else {
            if (!(this.container instanceof Server)) return;
            this.namingResources = ((Server)this.container).getGlobalNamingResources();
        }
        if ("configure_start".equals(lifecycleEvent.getType())) {
            if (this.initialized) {
                return;
            }
            try {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                try {
                    this.namingContext = new NamingContext(hashtable, this.getName());
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                ContextAccessController.setSecurityToken(this.getName(), this.container);
                ContextAccessController.setSecurityToken(this.container, this.container);
                ContextBindings.bindContext(this.container, this.namingContext, this.container);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Bound " + this.container));
                }
                this.namingContext.setExceptionOnFailedWrite(this.getExceptionOnFailedWrite());
                ContextAccessController.setWritable(this.getName(), this.container);
                try {
                    this.createNamingContext();
                }
                catch (NamingException namingException) {
                    this.logger.error((Object)sm.getString("naming.namingContextCreationFailed", new Object[]{namingException}));
                }
                this.namingResources.addPropertyChangeListener(this);
                if (this.container instanceof Context) {
                    ContextAccessController.setReadOnly(this.getName());
                    try {
                        ContextBindings.bindClassLoader(this.container, this.container, ((Container)this.container).getLoader().getClassLoader());
                    }
                    catch (NamingException namingException) {
                        this.logger.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
                    }
                }
                if (!(this.container instanceof Server)) return;
                ResourceLinkFactory.setGlobalContext(this.namingContext);
                try {
                    ContextBindings.bindClassLoader(this.container, this.container, this.getClass().getClassLoader());
                }
                catch (NamingException namingException) {
                    this.logger.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
                }
                if (!(this.container instanceof StandardServer)) return;
                ((StandardServer)this.container).setGlobalNamingContext(this.namingContext);
                return;
            }
            finally {
                this.initialized = true;
            }
        }
        if (!"configure_stop".equals(lifecycleEvent.getType())) return;
        if (!this.initialized) {
            return;
        }
        try {
            Object object;
            ContextAccessController.setWritable(this.getName(), this.container);
            ContextBindings.unbindContext(this.container, this.container);
            if (this.container instanceof Context) {
                ContextBindings.unbindClassLoader(this.container, this.container, ((Container)this.container).getLoader().getClassLoader());
            }
            if (this.container instanceof Server) {
                ContextBindings.unbindClassLoader(this.container, this.container, this.getClass().getClassLoader());
            }
            this.namingResources.removePropertyChangeListener(this);
            ContextAccessController.unsetSecurityToken(this.getName(), this.container);
            ContextAccessController.unsetSecurityToken(this.container, this.container);
            if (!this.objectNames.isEmpty()) {
                object = this.objectNames.values();
                Registry registry = Registry.getRegistry(null, null);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    registry.unregisterComponent(objectName);
                }
            }
            if ((object = this.getGlobalNamingContext()) == null) return;
            ResourceLinkFactory.deregisterGlobalResourceAccess((javax.naming.Context)object);
            return;
        }
        finally {
            this.objectNames.clear();
            this.namingContext = null;
            this.envCtx = null;
            this.compCtx = null;
            this.initialized = false;
        }
    }

    @Override
    @Deprecated
    public void containerEvent(ContainerEvent containerEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.initialized) {
            return;
        }
        Object object = propertyChangeEvent.getSource();
        if (object == this.namingResources) {
            ContextAccessController.setWritable(this.getName(), this.container);
            this.processGlobalResourcesChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            ContextAccessController.setReadOnly(this.getName());
        }
    }

    private void processGlobalResourcesChange(String string, Object object, Object object2) {
        if (string.equals("ejb")) {
            ContextEjb contextEjb;
            if (object != null && (contextEjb = (ContextEjb)object).getName() != null) {
                this.removeEjb(contextEjb.getName());
            }
            if (object2 != null && (contextEjb = (ContextEjb)object2).getName() != null) {
                this.addEjb(contextEjb);
            }
        } else if (string.equals("environment")) {
            ContextEnvironment contextEnvironment;
            if (object != null && (contextEnvironment = (ContextEnvironment)object).getName() != null) {
                this.removeEnvironment(contextEnvironment.getName());
            }
            if (object2 != null && (contextEnvironment = (ContextEnvironment)object2).getName() != null) {
                this.addEnvironment(contextEnvironment);
            }
        } else if (string.equals("localEjb")) {
            ContextLocalEjb contextLocalEjb;
            if (object != null && (contextLocalEjb = (ContextLocalEjb)object).getName() != null) {
                this.removeLocalEjb(contextLocalEjb.getName());
            }
            if (object2 != null && (contextLocalEjb = (ContextLocalEjb)object2).getName() != null) {
                this.addLocalEjb(contextLocalEjb);
            }
        } else if (string.equals("messageDestinationRef")) {
            MessageDestinationRef messageDestinationRef;
            if (object != null && (messageDestinationRef = (MessageDestinationRef)object).getName() != null) {
                this.removeMessageDestinationRef(messageDestinationRef.getName());
            }
            if (object2 != null && (messageDestinationRef = (MessageDestinationRef)object2).getName() != null) {
                this.addMessageDestinationRef(messageDestinationRef);
            }
        } else if (string.equals("resource")) {
            ContextResource contextResource;
            if (object != null && (contextResource = (ContextResource)object).getName() != null) {
                this.removeResource(contextResource.getName());
            }
            if (object2 != null && (contextResource = (ContextResource)object2).getName() != null) {
                this.addResource(contextResource);
            }
        } else if (string.equals("resourceEnvRef")) {
            ContextResourceEnvRef contextResourceEnvRef;
            if (object != null && (contextResourceEnvRef = (ContextResourceEnvRef)object).getName() != null) {
                this.removeResourceEnvRef(contextResourceEnvRef.getName());
            }
            if (object2 != null && (contextResourceEnvRef = (ContextResourceEnvRef)object2).getName() != null) {
                this.addResourceEnvRef(contextResourceEnvRef);
            }
        } else if (string.equals("resourceLink")) {
            ContextResourceLink contextResourceLink;
            if (object != null && (contextResourceLink = (ContextResourceLink)object).getName() != null) {
                this.removeResourceLink(contextResourceLink.getName());
            }
            if (object2 != null && (contextResourceLink = (ContextResourceLink)object2).getName() != null) {
                this.addResourceLink(contextResourceLink);
            }
        } else if (string.equals("service")) {
            ContextService contextService;
            if (object != null && (contextService = (ContextService)object).getName() != null) {
                this.removeService(contextService.getName());
            }
            if (object2 != null && (contextService = (ContextService)object2).getName() != null) {
                this.addService(contextService);
            }
        }
    }

    private void createNamingContext() throws NamingException {
        int n;
        if (this.container instanceof Server) {
            this.compCtx = this.namingContext;
            this.envCtx = this.namingContext;
        } else {
            this.compCtx = this.namingContext.createSubcontext("comp");
            this.envCtx = this.compCtx.createSubcontext("env");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating JNDI naming context");
        }
        if (this.namingResources == null) {
            this.namingResources = new NamingResources();
            this.namingResources.setContainer(this.container);
        }
        ContextResourceLink[] contextResourceLinkArray = this.namingResources.findResourceLinks();
        for (n = 0; n < contextResourceLinkArray.length; ++n) {
            this.addResourceLink(contextResourceLinkArray[n]);
        }
        ContextResource[] contextResourceArray = this.namingResources.findResources();
        for (n = 0; n < contextResourceArray.length; ++n) {
            this.addResource(contextResourceArray[n]);
        }
        ContextResourceEnvRef[] contextResourceEnvRefArray = this.namingResources.findResourceEnvRefs();
        for (n = 0; n < contextResourceEnvRefArray.length; ++n) {
            this.addResourceEnvRef(contextResourceEnvRefArray[n]);
        }
        ContextEnvironment[] contextEnvironmentArray = this.namingResources.findEnvironments();
        for (n = 0; n < contextEnvironmentArray.length; ++n) {
            this.addEnvironment(contextEnvironmentArray[n]);
        }
        ContextEjb[] contextEjbArray = this.namingResources.findEjbs();
        for (n = 0; n < contextEjbArray.length; ++n) {
            this.addEjb(contextEjbArray[n]);
        }
        MessageDestinationRef[] messageDestinationRefArray = this.namingResources.findMessageDestinationRefs();
        for (n = 0; n < messageDestinationRefArray.length; ++n) {
            this.addMessageDestinationRef(messageDestinationRefArray[n]);
        }
        ContextService[] contextServiceArray = this.namingResources.findServices();
        for (n = 0; n < contextServiceArray.length; ++n) {
            this.addService(contextServiceArray[n]);
        }
        if (this.container instanceof Context) {
            try {
                TransactionRef transactionRef = new TransactionRef();
                this.compCtx.bind("UserTransaction", (Object)transactionRef);
                ContextTransaction contextTransaction = this.namingResources.getTransaction();
                if (contextTransaction != null) {
                    Iterator<String> iterator = contextTransaction.listProperties();
                    while (iterator.hasNext()) {
                        String string = iterator.next();
                        String string2 = (String)contextTransaction.getProperty(string);
                        StringRefAddr stringRefAddr = new StringRefAddr(string, string2);
                        transactionRef.add(stringRefAddr);
                    }
                }
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
            }
            catch (NamingException namingException) {
                this.logger.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
            }
        }
        if (this.container instanceof Context) {
            try {
                this.compCtx.bind("Resources", (Object)((Container)this.container).getResources());
            }
            catch (NamingException namingException) {
                this.logger.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
            }
        }
    }

    protected ObjectName createObjectName(ContextResource contextResource) throws MalformedObjectNameException {
        String string = null;
        if (this.container instanceof StandardServer) {
            string = ((StandardServer)this.container).getDomain();
        } else if (this.container instanceof ContainerBase) {
            string = ((ContainerBase)this.container).getDomain();
        }
        if (string == null) {
            string = "Catalina";
        }
        ObjectName objectName = null;
        String string2 = ObjectName.quote(contextResource.getName());
        if (this.container instanceof Server) {
            objectName = new ObjectName(string + ":type=DataSource,class=" + contextResource.getType() + ",name=" + string2);
        } else if (this.container instanceof Context) {
            String string3 = ((Context)this.container).getName();
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            Host host = (Host)((Context)this.container).getParent();
            objectName = new ObjectName(string + ":type=DataSource,context=" + string3 + ",host=" + host.getName() + ",class=" + contextResource.getType() + ",name=" + string2);
        }
        return objectName;
    }

    public void addEjb(ContextEjb contextEjb) {
        AbstractRef abstractRef = this.lookForLookupRef(contextEjb);
        if (abstractRef == null) {
            abstractRef = new EjbRef(contextEjb.getType(), contextEjb.getHome(), contextEjb.getRemote(), contextEjb.getLink());
            Iterator<String> iterator = contextEjb.listProperties();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = (String)contextEjb.getProperty(string);
                StringRefAddr stringRefAddr = new StringRefAddr(string, string2);
                abstractRef.add(stringRefAddr);
            }
        }
        try {
            this.createSubcontexts(this.envCtx, contextEjb.getName());
            this.envCtx.bind(contextEjb.getName(), (Object)abstractRef);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEnvironment(ContextEnvironment contextEnvironment) {
        Object object = this.lookForLookupRef(contextEnvironment);
        if (object == null) {
            String string = contextEnvironment.getType();
            try {
                if (string.equals("java.lang.String")) {
                    object = contextEnvironment.getValue();
                } else if (string.equals("java.lang.Byte")) {
                    object = contextEnvironment.getValue() == null ? Byte.valueOf((byte)0) : Byte.decode(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Short")) {
                    object = contextEnvironment.getValue() == null ? Short.valueOf((short)0) : Short.decode(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Integer")) {
                    object = contextEnvironment.getValue() == null ? Integer.valueOf(0) : Integer.decode(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Long")) {
                    object = contextEnvironment.getValue() == null ? Long.valueOf(0L) : Long.decode(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Boolean")) {
                    object = Boolean.valueOf(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Double")) {
                    object = contextEnvironment.getValue() == null ? Double.valueOf(0.0) : Double.valueOf(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Float")) {
                    object = contextEnvironment.getValue() == null ? Float.valueOf(0.0f) : Float.valueOf(contextEnvironment.getValue());
                } else if (string.equals("java.lang.Character")) {
                    if (contextEnvironment.getValue() == null) {
                        object = Character.valueOf('\u0000');
                    } else {
                        if (contextEnvironment.getValue().length() != 1) throw new IllegalArgumentException();
                        object = Character.valueOf(contextEnvironment.getValue().charAt(0));
                    }
                } else {
                    object = this.constructEnvEntry(contextEnvironment.getType(), contextEnvironment.getValue());
                    if (object == null) {
                        log.error((Object)sm.getString("naming.invalidEnvEntryType", new Object[]{contextEnvironment.getName()}));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)sm.getString("naming.invalidEnvEntryValue", new Object[]{contextEnvironment.getName()}));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error((Object)sm.getString("naming.invalidEnvEntryValue", new Object[]{contextEnvironment.getName()}));
            }
        }
        if (object == null) return;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("naming.addEnvEntry", new Object[]{contextEnvironment.getName()}));
            }
            this.createSubcontexts(this.envCtx, contextEnvironment.getName());
            this.envCtx.bind(contextEnvironment.getName(), object);
            return;
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.invalidEnvEntryValue", new Object[]{namingException}));
        }
    }

    private Object constructEnvEntry(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(string2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (string2.length() != 1) {
                    return null;
                }
                try {
                    constructor = clazz.getConstructor(Character.TYPE);
                    return constructor.newInstance(Character.valueOf(string2.charAt(0)));
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addLocalEjb(ContextLocalEjb contextLocalEjb) {
    }

    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
    }

    public void addService(ContextService contextService) {
        AbstractRef abstractRef = this.lookForLookupRef(contextService);
        if (abstractRef == null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (contextService.getWsdlfile() != null) {
                object4 = null;
                try {
                    object4 = new URL(contextService.getWsdlfile());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (object4 == null) {
                    try {
                        object4 = ((Context)this.container).getServletContext().getResource(contextService.getWsdlfile());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (object4 == null) {
                    try {
                        object4 = ((Context)this.container).getServletContext().getResource("/" + contextService.getWsdlfile());
                        log.debug((Object)("  Changing service ref wsdl file for /" + contextService.getWsdlfile()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("naming.wsdlFailed", new Object[]{malformedURLException}));
                    }
                }
                if (object4 == null) {
                    contextService.setWsdlfile(null);
                } else {
                    contextService.setWsdlfile(((URL)object4).toString());
                }
            }
            if (contextService.getJaxrpcmappingfile() != null) {
                object4 = null;
                try {
                    object4 = new URL(contextService.getJaxrpcmappingfile());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (object4 == null) {
                    try {
                        object4 = ((Context)this.container).getServletContext().getResource(contextService.getJaxrpcmappingfile());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (object4 == null) {
                    try {
                        object4 = ((Context)this.container).getServletContext().getResource("/" + contextService.getJaxrpcmappingfile());
                        log.debug((Object)("  Changing service ref jaxrpc file for /" + contextService.getJaxrpcmappingfile()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("naming.wsdlFailed", new Object[]{malformedURLException}));
                    }
                }
                if (object4 == null) {
                    contextService.setJaxrpcmappingfile(null);
                } else {
                    contextService.setJaxrpcmappingfile(((URL)object4).toString());
                }
            }
            abstractRef = new ServiceRef(contextService.getName(), contextService.getInterface(), contextService.getServiceqname(), contextService.getWsdlfile(), contextService.getJaxrpcmappingfile());
            object4 = contextService.getServiceendpoints();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object2 = new StringRefAddr("serviceendpointinterface", (String)object3);
                abstractRef.add((RefAddr)object2);
                object = contextService.getPortlink((String)object3);
                object2 = new StringRefAddr("portcomponentlink", (String)object);
                abstractRef.add((RefAddr)object2);
            }
            object3 = contextService.getHandlers();
            while (object3.hasNext()) {
                int n;
                String string;
                Object object5;
                object2 = (String)object3.next();
                object = contextService.getHandler((String)object2);
                HandlerRef handlerRef = new HandlerRef((String)object2, ((ContextHandler)object).getHandlerclass());
                Iterator<String> iterator = ((ContextHandler)object).getLocalparts();
                while (iterator.hasNext()) {
                    object5 = iterator.next();
                    string = ((ContextHandler)object).getNamespaceuri((String)object5);
                    handlerRef.add(new StringRefAddr("handlerlocalpart", (String)object5));
                    handlerRef.add(new StringRefAddr("handlernamespace", string));
                }
                object5 = ((ResourceBase)object).listProperties();
                while (object5.hasNext()) {
                    string = (String)object5.next();
                    String string2 = (String)((ResourceBase)object).getProperty(string);
                    handlerRef.add(new StringRefAddr("handlerparamname", string));
                    handlerRef.add(new StringRefAddr("handlerparamvalue", string2));
                }
                for (n = 0; n < ((ContextHandler)object).getSoapRolesSize(); ++n) {
                    handlerRef.add(new StringRefAddr("handlersoaprole", ((ContextHandler)object).getSoapRole(n)));
                }
                for (n = 0; n < ((ContextHandler)object).getPortNamesSize(); ++n) {
                    handlerRef.add(new StringRefAddr("handlerportname", ((ContextHandler)object).getPortName(n)));
                }
                ((ServiceRef)abstractRef).addHandler(handlerRef);
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Adding service ref " + contextService.getName() + "  " + abstractRef));
            }
            this.createSubcontexts(this.envCtx, contextService.getName());
            this.envCtx.bind(contextService.getName(), (Object)abstractRef);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
    }

    public void addResource(ContextResource contextResource) {
        Object object;
        Object object2;
        AbstractRef abstractRef = this.lookForLookupRef(contextResource);
        if (abstractRef == null) {
            abstractRef = new ResourceRef(contextResource.getType(), contextResource.getDescription(), contextResource.getScope(), contextResource.getAuth(), contextResource.getSingleton());
            object2 = contextResource.listProperties();
            while (object2.hasNext()) {
                object = object2.next();
                String string = (String)contextResource.getProperty((String)object);
                StringRefAddr stringRefAddr = new StringRefAddr((String)object, string);
                abstractRef.add(stringRefAddr);
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Adding resource ref " + contextResource.getName() + "  " + abstractRef));
            }
            this.createSubcontexts(this.envCtx, contextResource.getName());
            this.envCtx.bind(contextResource.getName(), (Object)abstractRef);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
        if (("javax.sql.DataSource".equals(abstractRef.getClassName()) || "javax.sql.XADataSource".equals(abstractRef.getClassName())) && contextResource.getSingleton()) {
            try {
                object2 = this.createObjectName(contextResource);
                object = this.envCtx.lookup(contextResource.getName());
                Registry.getRegistry(null, null).registerComponent(object, (ObjectName)object2, null);
                this.objectNames.put(contextResource.getName(), (ObjectName)object2);
            }
            catch (Exception exception) {
                this.logger.warn((Object)sm.getString("naming.jmxRegistrationFailed", new Object[]{exception}));
            }
        }
    }

    public void addResourceEnvRef(ContextResourceEnvRef contextResourceEnvRef) {
        AbstractRef abstractRef = this.lookForLookupRef(contextResourceEnvRef);
        if (abstractRef == null) {
            abstractRef = new ResourceEnvRef(contextResourceEnvRef.getType());
            Iterator<String> iterator = contextResourceEnvRef.listProperties();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = (String)contextResourceEnvRef.getProperty(string);
                StringRefAddr stringRefAddr = new StringRefAddr(string, string2);
                abstractRef.add(stringRefAddr);
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("naming.addResourceEnvRef", new Object[]{contextResourceEnvRef.getName()}));
            }
            this.createSubcontexts(this.envCtx, contextResourceEnvRef.getName());
            this.envCtx.bind(contextResourceEnvRef.getName(), (Object)abstractRef);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
    }

    public void addResourceLink(ContextResourceLink contextResourceLink) {
        Object object;
        ResourceLinkRef resourceLinkRef = new ResourceLinkRef(contextResourceLink.getType(), contextResourceLink.getGlobal(), contextResourceLink.getFactory(), null);
        Iterator<String> iterator = contextResourceLink.listProperties();
        while (iterator.hasNext()) {
            object = iterator.next();
            Object object2 = contextResourceLink.getProperty((String)object);
            if (object2 == null) continue;
            StringRefAddr stringRefAddr = new StringRefAddr((String)object, object2.toString());
            resourceLinkRef.add(stringRefAddr);
        }
        object = "UserTransaction".equals(contextResourceLink.getName()) ? this.compCtx : this.envCtx;
        try {
            if (this.logger.isDebugEnabled()) {
                log.debug((Object)("  Adding resource link " + contextResourceLink.getName()));
            }
            this.createSubcontexts(this.envCtx, contextResourceLink.getName());
            object.bind(contextResourceLink.getName(), (Object)resourceLinkRef);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.bindFailed", new Object[]{namingException}));
        }
        ResourceLinkFactory.registerGlobalResourceAccess(this.getGlobalNamingContext(), contextResourceLink.getName(), contextResourceLink.getGlobal());
    }

    private javax.naming.Context getGlobalNamingContext() {
        Engine engine;
        Server server;
        if (this.container instanceof Context && (server = (engine = (Engine)((Context)this.container).getParent().getParent()).getService().getServer()) != null) {
            return server.getGlobalNamingContext();
        }
        return null;
    }

    public void removeEjb(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{namingException}));
        }
    }

    public void removeEnvironment(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{namingException}));
        }
    }

    public void removeLocalEjb(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{namingException}));
        }
    }

    public void removeMessageDestinationRef(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("naming.unbindFailed", new Object[]{namingException}));
        }
    }

    public void removeService(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{namingException}));
        }
    }

    public void removeResource(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{namingException}));
        }
        ObjectName objectName = this.objectNames.get(string);
        if (objectName != null) {
            Registry.getRegistry(null, null).unregisterComponent(objectName);
        }
    }

    public void removeResourceEnvRef(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{namingException}));
        }
    }

    public void removeResourceLink(String string) {
        try {
            this.envCtx.unbind(string);
        }
        catch (NamingException namingException) {
            this.logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{namingException}));
        }
        ResourceLinkFactory.deregisterGlobalResourceAccess(this.getGlobalNamingContext(), string);
    }

    private void createSubcontexts(javax.naming.Context context, String string) throws NamingException {
        javax.naming.Context context2 = context;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("") || !stringTokenizer.hasMoreTokens()) continue;
            try {
                context2 = context2.createSubcontext(string2);
            }
            catch (NamingException namingException) {
                context2 = (javax.naming.Context)context2.lookup(string2);
            }
        }
    }

    private LookupRef lookForLookupRef(ResourceBase resourceBase) {
        String string = resourceBase.getLookupName();
        if (string != null && !string.equals("")) {
            return new LookupRef(resourceBase.getType(), string);
        }
        return null;
    }
}

