/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.goal.Goal;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.MissionaryMission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.UnitWanderMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class AIUnit
extends TransportableAIObject {
    private static final Logger logger = Logger.getLogger(AIUnit.class.getName());
    private Unit unit;
    private Mission mission;
    private Goal goal = null;
    private static final String TILE_IMPROVEMENT_PLAN_MISSION_TAG = "tileImprovementPlanMission";
    private static final String IDLE_AT_COLONY_MISSION_TAG = "idleAtColonyMission";

    public AIUnit(AIMain aiMain, String id) {
        super(aiMain, id);
        this.unit = null;
        this.mission = null;
        this.goal = null;
    }

    public AIUnit(AIMain aiMain, Unit unit) {
        this(aiMain, unit.getId());
        this.unit = unit;
        this.mission = null;
        this.goal = null;
        this.uninitialized = unit == null;
    }

    public AIUnit(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.getUnit() == null;
    }

    public AIUnit(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.uninitialized = this.getUnit() == null;
    }

    public final Unit getUnit() {
        return this.unit;
    }

    public final boolean hasMission() {
        return this.mission != null;
    }

    public final Mission getMission() {
        return this.mission;
    }

    public final void setMission(Mission mission) {
        this.mission = mission;
    }

    public final Goal getGoal() {
        return this.goal;
    }

    public final void setGoal(Goal goal) {
        this.goal = goal;
    }

    private void requestLocalRearrange() {
        AIColony aiColony;
        Colony colony;
        Location loc;
        if (this.unit != null && (loc = this.unit.getLocation()) != null && (colony = loc.getColony()) != null && (aiColony = this.getAIMain().getAIColony(colony)) != null) {
            aiColony.requestRearrange();
        }
    }

    private void takeTransport() {
        Unit carrier = this.getUnit().getCarrier();
        AIUnit aiCarrier = carrier == null ? null : this.getAIMain().getAIUnit(carrier);
        AIUnit transport = this.getTransport();
        if (transport != aiCarrier) {
            if (transport != null) {
                logger.warning("Taking different transport: " + aiCarrier);
                this.dropTransport();
            }
            this.setTransport(aiCarrier);
        }
    }

    public AIPlayer getAIOwner() {
        return this.unit == null ? null : (this.unit.getOwner() == null ? null : this.getAIMain().getAIPlayer(this.unit.getOwner()));
    }

    public Random getAIRandom() {
        return this.unit == null ? null : this.getAIOwner().getAIRandom();
    }

    public Location getTrivialTarget() {
        PathNode path = this.unit.getTrivialPath();
        return path == null ? null : Location.upLoc(path.getLastNode().getLocation());
    }

    public final boolean hasCargo() {
        return this.unit == null ? false : this.unit.hasCargo();
    }

    public <T extends Mission> boolean hasMission(Class<T> returnClass) {
        return this.getMission(returnClass) != null;
    }

    public <T extends Mission> T getMission(Class<T> returnClass) {
        try {
            return (T)((Mission)returnClass.cast(this.mission));
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public void doMission(LogBuilder lb) {
        if (this.mission != null) {
            this.mission.doMission(lb);
        }
    }

    public Mission changeMission(Mission mission) {
        if (this.mission == mission) {
            return this.mission;
        }
        if (this.mission != null) {
            this.mission.dispose();
            this.mission = null;
        }
        this.setMission(mission);
        if (mission != null) {
            this.setTransportPriority(mission.getBaseTransportPriority());
        }
        return this.mission;
    }

    public boolean moveToAmerica() {
        return AIMessage.askMoveTo(this, this.unit.getOwner().getGame().getMap());
    }

    public boolean moveToEurope() {
        return AIMessage.askMoveTo(this, this.unit.getOwner().getEurope());
    }

    public boolean move(Direction direction) {
        Tile start = this.unit.getTile();
        return this.unit.getMoveType(direction).isProgress() && AIMessage.askMove(this, direction) && this.unit.getTile() != start;
    }

    public boolean equipForRole(Role role) {
        Specification spec = this.getSpecification();
        Player player = this.unit.getOwner();
        Location loc = Location.upLoc(this.unit.getLocation());
        if (!(loc instanceof UnitLocation)) {
            return false;
        }
        int count = role.getMaximumCount();
        if (count > 0) {
            List<AbstractGoods> req;
            int price;
            while (!(count <= 0 || (price = ((UnitLocation)loc).priceGoods(req = this.unit.getGoodsDifference(role, count))) >= 0 && player.checkGold(price))) {
                --count;
            }
            if (count <= 0) {
                return false;
            }
        }
        return AIMessage.askEquipForRole(this, role, count) && this.unit.getRole() == role && this.unit.getRoleCount() == count;
    }

    @Override
    public int getTransportPriority() {
        return this.hasMission() ? super.getTransportPriority() : 0;
    }

    @Override
    public Locatable getTransportLocatable() {
        return this.unit;
    }

    @Override
    public Location getTransportSource() {
        return this.getUnit() == null || this.getUnit().isDisposed() ? null : this.getUnit().getLocation();
    }

    @Override
    public Location getTransportDestination() {
        return this.getUnit() == null || this.getUnit().isDisposed() || !this.hasMission() ? null : this.mission.getTransportDestination();
    }

    @Override
    public PathNode getDeliveryPath(Unit carrier, Location dst) {
        PathNode path;
        if (dst == null && (dst = this.getTransportDestination()) == null) {
            return null;
        }
        dst = Location.upLoc(dst);
        if (this.unit.getLocation() == carrier) {
            path = this.unit.findPath(carrier.getLocation(), dst, carrier, null);
            if (path == null && dst.getTile() != null) {
                path = this.unit.findPathToNeighbour(carrier.getLocation(), dst.getTile(), carrier, null);
            }
        } else {
            if (this.unit.getLocation() instanceof Unit) {
                return null;
            }
            path = this.unit.findPath(this.unit.getLocation(), dst, carrier, null);
            if (path == null && dst.getTile() != null) {
                path = this.unit.findPathToNeighbour(this.unit.getLocation(), dst.getTile(), carrier, null);
            }
        }
        if (path != null) {
            path.ensureDisembark();
        }
        return path;
    }

    @Override
    public PathNode getIntermediatePath(Unit carrier, Location dst) {
        return null;
    }

    @Override
    public void setTransportDestination(Location destination) {
        throw new RuntimeException("AI unit transport destination set by mission.");
    }

    @Override
    public boolean carriableBy(Unit carrier) {
        return carrier.couldCarry(this.getUnit());
    }

    @Override
    public boolean canMove() {
        return this.getUnit().getMovesLeft() > 0;
    }

    @Override
    public boolean leaveTransport() {
        Location target;
        Unit unit = this.getUnit();
        if (!unit.isOnCarrier()) {
            return true;
        }
        if (unit.isInEurope()) {
            return this.leaveTransport(null);
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return false;
        }
        Mission mission = this.getMission();
        Location location = target = mission == null || !mission.isValid() ? null : mission.getTarget();
        if (target != null) {
            Direction direction;
            if (Map.isSameLocation(target, tile)) {
                return this.leaveTransport(null);
            }
            if (target.getTile() != null && (direction = tile.getDirection(target.getTile())) != null) {
                return this.leaveTransport(direction);
            }
            PathNode path = unit.findPath(target);
            if (path != null && (direction = tile.getDirection(path.next.getTile())) != null) {
                try {
                    return this.leaveTransport(direction);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Leave transport crash for " + this + "/" + unit.getMovesLeft(), e);
                }
            }
        }
        if (tile.isLand()) {
            return this.leaveTransport(null);
        }
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (t.isBlocked(unit)) continue;
            if (t.getSettlement() != null) {
                return this.leaveTransport(tile.getDirection(t));
            }
            tiles.add(t);
        }
        if (tiles.isEmpty()) {
            return false;
        }
        Player player = unit.getOwner();
        Tile safe = (Tile)tiles.get(0);
        Tile best = null;
        int bestTurns = 10000;
        Settlement settlement = null;
        for (Tile t : tiles) {
            int turns;
            if (settlement == null || t.isConnectedTo(settlement.getTile())) {
                settlement = t.getNearestSettlement(player, 10, true);
            }
            if (settlement != null && bestTurns > (turns = unit.getTurnsToReach(t, settlement))) {
                bestTurns = turns;
                best = t;
            }
            if (!(safe.getDefenceValue() < t.getDefenceValue())) continue;
            safe = t;
        }
        return this.leaveTransport(tile.getDirection(best != null ? best : safe));
    }

    @Override
    public boolean leaveTransport(Direction direction) {
        boolean result;
        if (!this.unit.isOnCarrier()) {
            return false;
        }
        Unit carrier = this.unit.getCarrier();
        boolean bl = direction == null ? AIMessage.askDisembark(this) && this.unit.getLocation() == carrier.getLocation() : (result = this.move(direction));
        if (result) {
            this.requestLocalRearrange();
            this.dropTransport();
        }
        return result;
    }

    @Override
    public boolean joinTransport(Unit carrier, Direction direction) {
        boolean result;
        AIUnit aiCarrier = this.getAIMain().getAIUnit(carrier);
        if (aiCarrier == null) {
            return false;
        }
        boolean bl = result = AIMessage.askEmbark(aiCarrier, this.unit, direction) && this.unit.getLocation() == carrier;
        if (result) {
            this.requestLocalRearrange();
            this.takeTransport();
        }
        return result;
    }

    @Override
    public String invalidReason() {
        String reason = Mission.invalidTransportableReason(this);
        return reason != null ? reason : (this.hasMission() ? this.getMission().invalidReason() : null);
    }

    @Override
    public void dispose() {
        this.dropTransport();
        AIPlayer aiOwner = this.getAIOwner();
        if (aiOwner != null) {
            aiOwner.removeAIUnit(this);
        } else {
            logger.warning("Disposing of " + this.getId() + " but owner is null!");
        }
        if (this.mission != null) {
            this.mission.dispose();
            this.mission = null;
        }
        super.dispose();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (this.unit == null || this.unit.isDisposed()) {
            result = -1;
        }
        return result;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.mission != null && !this.mission.isOneTime() && this.mission.isValid()) {
            this.mission.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        this.unit = xr.findFreeColGameObject(aiMain.getGame(), "id", Unit.class, null, true);
        if (this.unit.isUninitialized()) {
            xr.nextTag();
            throw new XMLStreamException("AIUnit for uninitialized Unit: " + this.unit.getId());
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        if (this.getUnit() != null) {
            this.uninitialized = false;
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        AIMain aiMain = this.getAIMain();
        String tag = xr.getLocalName();
        this.mission = null;
        if (BuildColonyMission.getXMLElementTagName().equals(tag)) {
            this.mission = new BuildColonyMission(aiMain, this, xr);
        } else if (CashInTreasureTrainMission.getXMLElementTagName().equals(tag)) {
            this.mission = new CashInTreasureTrainMission(aiMain, this, xr);
        } else if (DefendSettlementMission.getXMLElementTagName().equals(tag)) {
            this.mission = new DefendSettlementMission(aiMain, this, xr);
        } else if (IdleAtSettlementMission.getXMLElementTagName().equals(tag) || IDLE_AT_COLONY_MISSION_TAG.equals(tag)) {
            this.mission = new IdleAtSettlementMission(aiMain, this, xr);
        } else if (IndianBringGiftMission.getXMLElementTagName().equals(tag)) {
            this.mission = new IndianBringGiftMission(aiMain, this, xr);
        } else if (IndianDemandMission.getXMLElementTagName().equals(tag)) {
            this.mission = new IndianDemandMission(aiMain, this, xr);
        } else if (MissionaryMission.getXMLElementTagName().equals(tag)) {
            this.mission = new MissionaryMission(aiMain, this, xr);
        } else if (PioneeringMission.getXMLElementTagName().equals(tag) || TILE_IMPROVEMENT_PLAN_MISSION_TAG.equals(tag)) {
            this.mission = new PioneeringMission(aiMain, this, xr);
        } else if (PrivateerMission.getXMLElementTagName().equals(tag)) {
            this.mission = new PrivateerMission(aiMain, this, xr);
        } else if (ScoutingMission.getXMLElementTagName().equals(tag)) {
            this.mission = new ScoutingMission(aiMain, this, xr);
        } else if (TransportMission.getXMLElementTagName().equals(tag)) {
            this.mission = new TransportMission(aiMain, this, xr);
        } else if (UnitSeekAndDestroyMission.getXMLElementTagName().equals(tag)) {
            this.mission = new UnitSeekAndDestroyMission(aiMain, this, xr);
        } else if (UnitWanderHostileMission.getXMLElementTagName().equals(tag)) {
            this.mission = new UnitWanderHostileMission(aiMain, this, xr);
        } else if (UnitWanderMission.getXMLElementTagName().equals(tag)) {
            this.mission = new UnitWanderMission(aiMain, this, xr);
        } else if (WishRealizationMission.getXMLElementTagName().equals(tag)) {
            this.mission = new WishRealizationMission(aiMain, this, xr);
        } else if (WorkInsideColonyMission.getXMLElementTagName().equals(tag)) {
            this.mission = new WorkInsideColonyMission(aiMain, this, xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        return this.unit == null ? "AIUnit-null" : this.unit.toString("AIUnit ");
    }

    @Override
    public String getXMLTagName() {
        return AIUnit.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "aiUnit";
    }
}

