// -*- c++ -*-
// Generated by gmmproc 2.46.1 -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_BUFFER_H
#define _GTKSOURCEVIEWMM_BUFFER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* buffer.h
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2006 Dodji Seketeli
 * Copyright (C) 2009, 2010, 2011 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <vector>

#include <gtkmm/textbuffer.h>
#include <gtksourceviewmm/language.h>
#include <gtksourceviewmm/mark.h>
#include <gtksourceviewmm/undomanager.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceBuffer GtkSourceBuffer;
typedef struct _GtkSourceBufferClass GtkSourceBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gsv
{ class Buffer_Class; } // namespace Gsv
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gsv
{

/** @addtogroup gtksourceviewmmEnums gtksourceviewmm Enums and Flags */

/**  Describes result of matching brackets.
 *
 * @newin{3,0}
 *
 * @ingroup gtksourceviewmmEnums
 */
enum BracketMatchType
{
  BRACKET_MATCH_NONE,
  BRACKET_MATCH_OUT_OF_RANGE,
  BRACKET_MATCH_NOT_FOUND,
  BRACKET_MATCH_FOUND
};

} // namespace Gsv


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gsv::BracketMatchType> : public Glib::Value_Enum<Gsv::BracketMatchType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gsv
{

/** @var BracketMatchType BRACKET_MATCH_NONE
 * There was no bracket to match.
 */
/** @var BracketMatchType BRACKET_MATCH_OUT_OF_RANGE
 * Matching a bracket failed because the maximum range was reached.
 */
/** @var BracketMatchType BRACKET_MATCH_NOT_FOUND
 * A matching bracket was not found.
 */
/** @var BracketMatchType BRACKET_MATCH_FOUND
 * A matching bracket was found.
 */

/** Buffer object for View.
 *
 * The Buffer class is the model for View widgets. It extends the
 * Gtk::TextBuffer class by adding features useful to display and edit source
 * code as syntax highlighting and bracket matching. It also implements support
 * for undo/redo operations.
 *
 * To create a Buffer use Buffer::create(). A convenience overload
 * for initial setting a Language is also provided.
 *
 * By default highlighting is enabled, but you can disable it with
 * Buffer::set_highlight_syntax().
 */

class Buffer : public Gtk::TextBuffer
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Buffer CppObjectType;
  typedef Buffer_Class CppClassType;
  typedef GtkSourceBuffer BaseObjectType;
  typedef GtkSourceBufferClass BaseClassType;

  // noncopyable
  Buffer(const Buffer&) = delete;
  Buffer& operator=(const Buffer&) = delete;

private:  friend class Buffer_Class;
  static CppClassType buffer_class_;

protected:
  explicit Buffer(const Glib::ConstructParams& construct_params);
  explicit Buffer(GtkSourceBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Buffer(Buffer&& src) noexcept;
  Buffer& operator=(Buffer&& src) noexcept;

  virtual ~Buffer() noexcept;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceBuffer*       gobj()       { return reinterpret_cast<GtkSourceBuffer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceBuffer* gobj() const { return reinterpret_cast<GtkSourceBuffer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceBuffer* gobj_copy();

private:


protected:

  explicit Buffer () ;
  explicit Buffer (const Glib::RefPtr<Gtk::TextTagTable>& tag_table) ;
  explicit Buffer (const Glib::RefPtr<Language> &language) ;

public:

  /** Create a new source buffer.
   *
   * Internally it will create a new Gtk::TextTagTable also.
   *
   * @return A new Buffer.
   *
   * @newin{2,10}
   */
  
  static Glib::RefPtr<Buffer> create();


  /** Create a new source buffer.
   *
   * @param tag_table A Gtk::TextTagTable or empty Glib::RefPtr, to create new.
   *
   * @return A new Buffer.
   */
  
  static Glib::RefPtr<Buffer> create(const Glib::RefPtr<Gtk::TextTagTable>& tag_table);


  /** Creates a new source buffer using the highlighting patterns
   *  in @a language.
   *
   * @param language A Language.
   *
   * @return A new Buffer
   */
  
  static Glib::RefPtr<Buffer> create(const Glib::RefPtr<Language>& language);


  /** Determines whether bracket match highlighting is activated for the
   * source buffer.
   * 
   * @return <tt>true</tt> if the source buffer will highlight matching
   * brackets.
   */
  bool get_highlight_matching_brackets() const;

  
  /** Controls the bracket match highlighting function in the buffer.  If
   * activated, when you position your cursor over a bracket character
   * (a parenthesis, a square bracket, etc.) the matching opening or
   * closing bracket character will be highlighted.  You can specify the
   * style with the gtk_source_buffer_set_bracket_match_style()
   * function.
   * 
   * @param highlight <tt>true</tt> if you want matching brackets highlighted.
   */
  void set_highlight_matching_brackets(bool highlight = true);

  
  /** Determines whether syntax highlighting is activated in the source
   * buffer.
   * 
   * @return <tt>true</tt> if syntax highlighting is enabled, <tt>false</tt> otherwise.
   */
  bool get_highlight_syntax() const;

  
  /** Controls whether syntax is highlighted in the buffer.
   *
   * If highlight is @c true, the text will be highlighted according to
   * the syntax patterns specified in the language set with set_language(). If
   * highlight is @c false, syntax highlighting is disabled and all
   * the Gtk::TextTag objects that have been added by the syntax highlighting
   * engine are removed from the buffer.
   *
   * @param highlight @c true to enable syntax highlighting, @c false to disable
   * it.
   */
  void set_highlight_syntax(bool highlight =  true);

  
  /** Determines the number of undo levels the buffer will track for
   * buffer edits.
   * 
   * @return The maximum number of possible undo levels or
   * -1 if no limit is set.
   */
  int get_max_undo_levels() const;

  
  /** Sets the number of undo levels for user actions the buffer will track.
   *
   * If the number of user actions exceeds the limit set by this function, older
   * actions will be discarded.
   *
   * If max_undo_levels is -1, no limit is set.
   *
   * A new action is started whenever the method
   * Gtk::TextBuffer::begin_user_action() is called. In general, this happens
   * whenever the user presses any key which modifies the buffer, but the undo
   * manager will try to merge similar consecutive actions, such as multiple
   * character insertions into one action. But, inserting a newline does start
   * a new action.
   *
   * @param max_undo_levels The desired maximum number of undo levels.
   */
  void set_max_undo_levels(int max_undo_levels);

  
  /** Returns the Language associated with the buffer.
   *
   * @return A Language associated with the buffer, or empty Glib::RefPtr.
   */
  Glib::RefPtr<Language> get_language();

  
  /** Returns the Language associated with the buffer.
   *
   * @return A Language associated with the buffer, or empty Glib::RefPtr.
   */
  Glib::RefPtr<const Language> get_language() const;

  
  /** Associate a Language with the source buffer.
   *
   * If language is not empty and syntax highlighting is enabled, the syntax
   * patterns defined in language will be used to highlight the text contained
   * in the buffer. If language is empty, the text contained in the buffer is
   * not highlighted.
   *
   * The buffer holds a reference to language.
   *
   * @param language A Language to set, or empty Glib::RefPtr.
   */
  void set_language(const Glib::RefPtr<Language>& language);

  
  /** Determines whether a source buffer can undo the last action.
   * 
   * @return <tt>true</tt> if it's possible to undo the last action.
   */
  bool can_undo() const;

  
  /** Determines whether a source buffer can redo the last action
   * (i.e.\ if the last operation was an undo).
   * 
   * @return <tt>true</tt> if a redo is possible.
   */
  bool can_redo() const;

  
  /** Undoes the last user action which modified the buffer.
   *
   * Use can_undo() to check whether a call to this function will have any effect.
   *
   * Actions are defined as groups of operations between a call to
   * Gtk::TextBuffer::begin_user_action()
   * and Gtk::TextBuffer::end_user_action(), or sequences of similar edits
   * (inserts or deletes) on the same line.
   */
  void undo();

  
  /** Redoes the last undo operation.  Use can_redo()
   * to check whether a call to this function will have any effect.
   */
  void redo();

  
  /** Marks the beginning of a not undoable action on the buffer,
   * disabling the undo manager.  Typically you would call this function
   * before initially setting the contents of the buffer (e.g. when
   * loading a file in a text editor).
   * 
   * You may nest begin_not_undoable_action() /
   * end_not_undoable_action() blocks.
   */
  void begin_not_undoable_action();

  
  /** Marks the end of a not undoable action on the buffer.  When the
   * last not undoable block is closed through the call to this
   * function, the list of undo actions is cleared and the undo manager
   * is re-enabled.
   */
  void end_not_undoable_action();

 
  /** Moves iter to the position of the previous Mark of the given
   *  category.
   *
   * @param iter An iterator.
   * @param category Category to search.
   *
   * @return @c true if iter was moved.
   */
  bool backward_iter_to_source_mark(Gtk::TextIter& iter, const Glib::ustring& category);

  /** Moves iter to the position of the previous Mark of any category.
   *
   * @param iter An iterator.
   *
   * @return @c true if iter was moved.
   */
  bool backward_iter_to_source_mark(Gtk::TextIter& iter);

  
  /** Moves iter to the position of the next Mark of the given
   *  category.
   *
   * @param iter An iterator.
   * @param category Category to search.
   *
   * @return @c true if iter was moved.
   */
  bool forward_iter_to_source_mark(Gtk::TextIter& iter, const Glib::ustring& category);

  /** Moves iter to the position of the next Mark of the given
   *  category.
   *
   * @param iter An iterator.
   *
   * @return @c true if iter was moved.
   */
  bool forward_iter_to_source_mark(Gtk::TextIter& iter);

 
  /** Forces buffer to analyze and highlight the given area synchronously.
   *
   * @note This is a potentially slow operation and should be used only when you
   * need to make sure that some text not currently visible is highlighted, for
   * instance before printing.
   *
   * @param start Start of the area to highlight.
   * @param end End of the area to highlight.
   */
  void ensure_highlight(const Gtk::TextIter& start, const Gtk::TextIter& end);

  
  /** Returns the StyleScheme currently used in buffer.
   *
   * @return The StyleScheme set by set_style_scheme(), or empty
   * Glib::RefPtr.
   */
  Glib::RefPtr<StyleScheme> get_style_scheme();

  
  /** Returns the StyleScheme currently used in buffer.
   *
   * @return The StyleScheme set by set_style_scheme(), or empty
   * Glib::RefPtr.
   */
  Glib::RefPtr<const StyleScheme> get_style_scheme() const;

  
  /** Sets style scheme used by the buffer.
   *
   * If scheme is empty no style scheme is used.
   *
   * @param scheme Style scheme.
   */
  void set_style_scheme(const Glib::RefPtr<StyleScheme>& scheme);

  /** Unsets style scheme used by the buffer.
   *
   * It is the same like calling set_style_scheme() with empty pointer.
   */
  void unset_style_scheme();

  
  /** Creates a source mark in the buffer of category category.
   *
   * A source mark is a Gtk::TextMark but organised into categories. Depending
   * on the category a pixbuf can be specified that will be displayed along the
   * line of the mark.
   *
   * Marks always have left gravity and are moved to the beginning of the line
   * when the user deletes the line they were in.
   *
   * Typical uses for a source mark are bookmarks, breakpoints, current
   * executing instruction indication in a source file, etc.
   *
   * @param name The name of the mark.
   * @param category A string defining the mark category.
   * @param where Location to place the mark.
   *
   * @return A new Mark.
   */
  Glib::RefPtr<Gsv::Mark> create_source_mark(const Glib::ustring& name, const Glib::ustring& category, const Gtk::TextIter& where);

  /** Creates an anonymous source mark in the buffer of category category.
   *
   * A source mark is a Gtk::TextMark but organised into categories. Depending
   * on the category a pixbuf can be specified that will be displayed along the
   * line of the mark.
   *
   * Like a Gtk::TextMark, a Mark can be anonymous.
   *
   * Marks always have left gravity and are moved to the beginning of the line
   * when the user deletes the line they were in.
   *
   * Typical uses for a source mark are bookmarks, breakpoints, current
   * executing instruction indication in a source file, etc.
   *
   * @param category A string defining the mark category.
   * @param where Location to place the mark.
   *
   * @return A new Mark.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<Gsv::Mark> create_source_mark(const Glib::ustring& category, const Gtk::TextIter& where);

 
  /** Returns the list of marks of the given @a category at @a line.
   *
   * @param line A line number.
   * @param category Category to search for.
   *
   * @return A list of source marks.
   */
  std::vector<Glib::RefPtr<Gsv::Mark> > get_source_marks_at_line(int line, const Glib::ustring& category) const;

  /** Returns the list of marks of any category at @a line.
   *
   * @param line A line number.
   *
   * @return A list of source marks.
   */
  std::vector<Glib::RefPtr<Gsv::Mark> > get_source_marks_at_line(int line) const;

  
  /** Returns the list of marks of the given @a category at @a iter.
   *
   * @param iter An iterator.
   * @param category Category to search for.
   *
   * @return A list of source marks.
   */
  std::vector<Glib::RefPtr<Gsv::Mark> > get_source_marks_at_iter(Gtk::TextIter& iter, const Glib::ustring& category) const;

  /** Returns the list of marks of any category at @a iter.
   *
   * @param iter An iterator.
   *
   * @return A list of source marks.
   */
  std::vector<Glib::RefPtr<Gsv::Mark> > get_source_marks_at_iter(Gtk::TextIter& iter) const;

  
  /** Remove all marks of @a category between start and end from the buffer.
   *
   * @param start A Gtk::TextIter.
   * @param end A Gtk::TextIter.
   * @param category Category to search for.
   */
  void remove_source_marks(const Gtk::TextIter& start, const Gtk::TextIter& end, const Glib::ustring& category);

  /** Remove all marks of any category between start and end from the buffer.
   *
   * @param start A Gtk::TextIter.
   * @param end A Gtk::TextIter.
   *
   * @newin{2,10}
   */
  void remove_source_marks(const Gtk::TextIter& start, const Gtk::TextIter& end);

  
  /** Check if the class @a context_class is set on @c iter.
   *
   * @param iter A Gtk::TextIter.
   * @param context_class Class to search for.
   *
   * @return @c true if @a context_class is set on @c iter.
   *
   * @newin{2,10}
   */
  bool iter_has_context_class(const Gtk::TextIter& iter, const Glib::ustring& context_class) const;

  
  /** Moves backward to the next toggle (on or off) of the context class.
   *
   * If no matching context class toggles are found, returns @c false, otherwise
   * @c true. Does not return toggles located at @a iter, only toggles after
   * @a iter. Sets @a iter to the location of the toggle, or to the end of the
   * buffer if no toggle is found.
   *
   * @param iter A Gtk::TextIter.
   * @param context_class The context class.
   *
   * @return Whether we found a context class toggle before @a iter.
   *
   * @newin{2,10}
   */
  bool iter_backward_to_context_class_toggle(Gtk::TextIter& iter, const Glib::ustring& context_class) const;

  
  /** Moves forward to the next toggle (on or off) of the context class.
   *
   * If no matching context class toggles are found, returns @c false, otherwise
   * @c true. Does not return toggles located at @a iter, only toggles after
   * @a iter. Sets @a iter to the location of the toggle, or to the end of the
   * buffer if no toggle is found.
   *
   * @param iter A Gtk::TextIter.
   * @param context_class The context class.
   *
   * @return Whether we found a context class toggle after @a iter.
   *
   * @newin{2,10}
   */
  bool iter_forward_to_context_class_toggle(Gtk::TextIter& iter, const Glib::ustring& context_class) const;

 
  /** Get all defined context classes at iter.
   *
   * @param iter A Gtk::TextIter.
   *
   * @return An array of context class names.
   *
   * @newin{2,10}
   */
  std::vector<Glib::ustring> get_context_classes_at_iter(const Gtk::TextIter& iter) const;

  
  /** Get the undo manager associated with the buffer.
   * @return A UndoManager.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<UndoManager> get_undo_manager();

  
  /** Get the undo manager associated with the buffer.
   * @return A UndoManager.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<const UndoManager> get_undo_manager() const;

  
  /** Set the buffer undo manager.
   *
   * @param undo_manager A UndoManager.
   *
   * @newin{2,10}
   */
  void set_undo_manager(const Glib::RefPtr<const UndoManager>& undo_manager);

  /** Set the default buffer undo manager.
   *
   * @newin{2,10}
   */
  void set_default_undo_manager();

  /** Whether to highlight syntax in the buffer.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_highlight_syntax() ;

/** Whether to highlight syntax in the buffer.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_highlight_syntax() const;

  /** Whether to highlight matching brackets.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_highlight_matching_brackets() ;

/** Whether to highlight matching brackets.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_highlight_matching_brackets() const;

  /** Number of undo levels for the buffer.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_max_undo_levels() ;

/** Number of undo levels for the buffer.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_max_undo_levels() const;

  /** Language object to get highlighting patterns from.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Language> > property_language() ;

/** Language object to get highlighting patterns from.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Language> > property_language() const;

  /** Whether Undo operation is possible.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_can_undo() const;


  /** Whether Redo operation is possible.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_can_redo() const;


  /** Style scheme.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<StyleScheme> > property_style_scheme() ;

/** Style scheme.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<StyleScheme> > property_style_scheme() const;

  /** The buffer undo manager.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<UndoManager> > property_undo_manager() ;

/** The buffer undo manager.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<UndoManager> > property_undo_manager() const;


  /** Emitted whenever the syntax highlighting information has been updated,
   *  so that views can request a redraw if the region changed is visible.
   *
   * Usually only view widgets displaying this buffer will be interested in this signal.
   *
   * @par Handler parameters:
   * start An iterator at the start of the updated region.
   * end An iterator at the end of the updated region.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%highlight_updated(Gtk::TextIter& start, Gtk::TextIter& end)</tt>
   *
   */

  Glib::SignalProxy2< void,Gtk::TextIter&,Gtk::TextIter& > signal_highlight_updated();


  /** Emitted whenever a marker of sourcebuffer has changed and needs to be redisplayed by the view.
   *
   * A change in a marker's type or location can trigger this signal.
   * Note that moving a marker causes the emission of this signal twice: one for the old location and one for the new.
   *
   * @par Handler parameters:
   * where An iterator at the location where the change occurred.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%source_mark_updated(const Glib::RefPtr<Gtk::TextMark>& where)</tt>
   *
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gtk::TextMark>& > signal_source_mark_updated();

 
  /** Emitted whenever undo is requested.
   *
   * In fact, it is emitted when undo() is called.
   *
   * @newin{2,10}
   *
   * @par Slot Prototype:
   * <tt>void on_my_%undo()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_undo();


  /** Emitted whenever redo is requested.
   *
   * In fact, it is emitted when redo() is called.
   *
   * @newin{2,10}
   *
   * @par Slot Prototype:
   * <tt>void on_my_%redo()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_redo();


  /** Sets iter to a valid iterator pointing to the matching bracket if state is BracketMatchType::BRACKET_MATCH_FOUND.
   *
   * @par Handler parameters:
   * iter Iterator to initialize.
   * state State of bracket matching.
   *
   * @newin{3,0}
   *
   * @par Slot Prototype:
   * <tt>void on_my_%bracket_matched(Gtk::TextIter& iter, BracketMatchType state)</tt>
   *
   */

  Glib::SignalProxy2< void,Gtk::TextIter&,BracketMatchType > signal_bracket_matched();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_undo().
  virtual void on_undo();
  /// This is a default handler for the signal signal_redo().
  virtual void on_redo();
  /// This is a default handler for the signal signal_bracket_matched().
  virtual void on_bracket_matched(Gtk::TextIter& iter, BracketMatchType state);


};

} /* namespace Gsv */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::Buffer
   */
  Glib::RefPtr<Gsv::Buffer> wrap(GtkSourceBuffer* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_BUFFER_H */

