/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.darwin;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum SocketMessage implements Constant
{
    MSG_DONTWAIT(128L),
    MSG_OOB(1L),
    MSG_PEEK(2L),
    MSG_DONTROUTE(4L),
    MSG_EOR(8L),
    MSG_TRUNC(16L),
    MSG_CTRUNC(32L),
    MSG_WAITALL(64L),
    MSG_EOF(256L),
    MSG_FLUSH(1024L),
    MSG_HOLD(2048L),
    MSG_SEND(4096L),
    MSG_HAVEMORE(8192L),
    MSG_RCVMORE(16384L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 16384L;

    private SocketMessage(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<SocketMessage, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<SocketMessage, String> generateTable() {
            EnumMap<SocketMessage, String> map2 = new EnumMap<SocketMessage, String>(SocketMessage.class);
            map2.put(MSG_DONTWAIT, "MSG_DONTWAIT");
            map2.put(MSG_OOB, "MSG_OOB");
            map2.put(MSG_PEEK, "MSG_PEEK");
            map2.put(MSG_DONTROUTE, "MSG_DONTROUTE");
            map2.put(MSG_EOR, "MSG_EOR");
            map2.put(MSG_TRUNC, "MSG_TRUNC");
            map2.put(MSG_CTRUNC, "MSG_CTRUNC");
            map2.put(MSG_WAITALL, "MSG_WAITALL");
            map2.put(MSG_EOF, "MSG_EOF");
            map2.put(MSG_FLUSH, "MSG_FLUSH");
            map2.put(MSG_HOLD, "MSG_HOLD");
            map2.put(MSG_SEND, "MSG_SEND");
            map2.put(MSG_HAVEMORE, "MSG_HAVEMORE");
            map2.put(MSG_RCVMORE, "MSG_RCVMORE");
            return map2;
        }
    }
}

